/*
 * Decompiled with CFR 0.152.
 */
package am2.worldgen;

import am2.blocks.BlocksCommonProxy;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public class WitchwoodTreeSmall
extends WorldGenAbstractTree {
    private final int minTreeHeight = 4;
    private final Block logBlock = BlocksCommonProxy.witchwoodLog;
    private final int logMeta = 0;
    private final Block leafBlock = BlocksCommonProxy.witchwoodLeaves;
    private final int leafMeta = 0;

    public boolean func_76484_a(World world, Random random, int x, int y, int z) {
        int height = random.nextInt(3) + this.minTreeHeight;
        boolean isValidPlantingSpot = true;
        if (y >= 1 && y + height + 1 <= 256) {
            Block block;
            int leafMaxRadius;
            for (int j = y; j <= y + 1 + height; ++j) {
                leafMaxRadius = 1;
                if (j == y) {
                    leafMaxRadius = 0;
                }
                if (j >= y + 1 + height - 2) {
                    leafMaxRadius = 2;
                }
                for (int i = x - leafMaxRadius; i <= x + leafMaxRadius && isValidPlantingSpot; ++i) {
                    for (int k = z - leafMaxRadius; k <= z + leafMaxRadius && isValidPlantingSpot; ++k) {
                        if (j >= 0 && j < 256) {
                            block = world.func_147439_a(i, j, k);
                            if (this.isReplaceable(world, i, j, k)) continue;
                            isValidPlantingSpot = false;
                            continue;
                        }
                        isValidPlantingSpot = false;
                    }
                }
            }
            if (!isValidPlantingSpot) {
                return false;
            }
            Block block2 = world.func_147439_a(x, y - 1, z);
            boolean isSoil = block2.canSustainPlant((IBlockAccess)world, x, y - 1, z, ForgeDirection.UP, (IPlantable)((BlockSapling)Blocks.field_150345_g));
            if (isSoil && y < 256 - height - 1) {
                int j;
                block2.onPlantGrow(world, x, y - 1, z, x, y, z);
                leafMaxRadius = 3;
                int b1 = 0;
                for (j = y - leafMaxRadius + height; j <= y + height; ++j) {
                    int treeHeightLayer = j - (y + height);
                    int leafGenRadius = b1 + 1 - treeHeightLayer / 2;
                    for (int i = x - leafGenRadius; i <= x + leafGenRadius; ++i) {
                        int leafGenDeltaX = i - x;
                        for (int k = z - leafGenRadius; k <= z + leafGenRadius; ++k) {
                            Block block1;
                            int leafGenDeltaZ = k - z;
                            if (Math.abs(leafGenDeltaX) == leafGenRadius && Math.abs(leafGenDeltaZ) == leafGenRadius && (random.nextInt(2) == 0 || treeHeightLayer == 0) || !(block1 = world.func_147439_a(i, j, k)).isAir((IBlockAccess)world, i, j, k) && !block1.isLeaves((IBlockAccess)world, i, j, k)) continue;
                            this.func_150516_a(world, i, j, k, this.leafBlock, 0);
                        }
                    }
                }
                for (j = 0; j < height; ++j) {
                    block = world.func_147439_a(x, y + j, z);
                    if (!block.isAir((IBlockAccess)world, x, y + j, z) && !block.isLeaves((IBlockAccess)world, x, y + j, z)) continue;
                    this.func_150516_a(world, x, y + j, z, this.logBlock, 0);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public WitchwoodTreeSmall(boolean par1) {
        super(par1);
    }
}

