/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.shapes;

import am2.api.spell.ItemSpellBase;
import am2.api.spell.component.interfaces.ISpellShape;
import am2.api.spell.enums.Affinity;
import am2.api.spell.enums.SpellCastResult;
import am2.api.spell.enums.SpellModifiers;
import am2.blocks.BlocksCommonProxy;
import am2.items.ItemsCommonProxy;
import am2.spell.SpellUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class Rune
implements ISpellShape {
    @Override
    public int getID() {
        return 6;
    }

    @Override
    public SpellCastResult beginStackStage(ItemSpellBase item, ItemStack stack, EntityLivingBase caster, EntityLivingBase target, World world, double x, double y, double z, int side, boolean consumeMBR, int useCount) {
        int procs = SpellUtils.instance.getModifiedInt_Add(1, stack, caster, (Entity)target, world, 0, SpellModifiers.PROCS);
        boolean targetWater = SpellUtils.instance.modifierIsPresent(SpellModifiers.TARGET_NONSOLID_BLOCKS, stack, 0);
        MovingObjectPosition mop = item.getMovingObjectPosition(caster, world, 8.0, true, targetWater);
        if (mop == null || mop.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY) {
            return SpellCastResult.EFFECT_FAILED;
        }
        if (!BlocksCommonProxy.spellRune.placeAt(world, mop.field_72311_b, mop.field_72312_c + 1, mop.field_72309_d, SpellUtils.instance.mainAffinityFor(stack).ordinal())) {
            return SpellCastResult.EFFECT_FAILED;
        }
        if (!world.field_72995_K) {
            world.func_147455_a(mop.field_72311_b, mop.field_72312_c + 1, mop.field_72309_d, BlocksCommonProxy.spellRune.createTileEntity(world, 0));
            BlocksCommonProxy.spellRune.setSpellStack(world, mop.field_72311_b, mop.field_72312_c + 1, mop.field_72309_d, SpellUtils.instance.popStackStage(stack));
            BlocksCommonProxy.spellRune.setPlacedBy(world, mop.field_72311_b, mop.field_72312_c + 1, mop.field_72309_d, caster);
            int meta = world.func_72805_g(mop.field_72311_b, mop.field_72312_c + 1, mop.field_72309_d);
            BlocksCommonProxy.spellRune.setNumTriggers(world, mop.field_72311_b, mop.field_72312_c + 1, mop.field_72309_d, meta, procs);
        }
        return SpellCastResult.SUCCESS;
    }

    @Override
    public boolean isChanneled() {
        return false;
    }

    @Override
    public Object[] getRecipeItems() {
        Object[] objectArray = new Object[7];
        objectArray[0] = new ItemStack((Item)ItemsCommonProxy.rune, 1, 2);
        objectArray[1] = new ItemStack((Item)ItemsCommonProxy.rune, 1, 14);
        objectArray[2] = new ItemStack((Item)ItemsCommonProxy.rune, 1, 15);
        objectArray[3] = new ItemStack((Item)ItemsCommonProxy.rune, 1, 0);
        objectArray[4] = new ItemStack((Item)ItemsCommonProxy.rune, 1, 11);
        objectArray[5] = new ItemStack((Item)ItemsCommonProxy.rune, 1, 13);
        objectArray[6] = new ItemStack((Item)ItemsCommonProxy.rune, 1, 16);
        return objectArray;
    }

    @Override
    public float manaCostMultiplier(ItemStack spellStack) {
        return 1.8f;
    }

    @Override
    public boolean isTerminusShape() {
        return false;
    }

    @Override
    public boolean isPrincipumShape() {
        return true;
    }

    @Override
    public String getSoundForAffinity(Affinity affinity, ItemStack stack, World world) {
        return "arsmagica2:spell.rune.cast";
    }
}

