/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.components;

import am2.AMCore;
import am2.RitualShapeHelper;
import am2.api.blocks.MultiblockStructureDefinition;
import am2.api.spell.component.interfaces.IRitualInteraction;
import am2.api.spell.component.interfaces.ISpellComponent;
import am2.api.spell.enums.Affinity;
import am2.api.spell.enums.SpellModifiers;
import am2.buffs.BuffEffectFury;
import am2.items.ItemsCommonProxy;
import am2.particles.AMParticle;
import am2.particles.ParticleFloatUpward;
import am2.particles.ParticleOrbitEntity;
import am2.spell.SpellUtils;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;

public class Fury
implements ISpellComponent,
IRitualInteraction {
    @Override
    public Object[] getRecipeItems() {
        Object[] objectArray = new Object[15];
        objectArray[0] = Items.field_151115_aP;
        objectArray[1] = Items.field_151115_aP;
        objectArray[2] = Items.field_151115_aP;
        objectArray[3] = Items.field_151115_aP;
        objectArray[4] = Items.field_151115_aP;
        objectArray[5] = Items.field_151115_aP;
        objectArray[6] = Items.field_151115_aP;
        objectArray[7] = Items.field_151115_aP;
        objectArray[8] = Items.field_151115_aP;
        objectArray[9] = Items.field_151115_aP;
        objectArray[10] = Items.field_151115_aP;
        objectArray[11] = Items.field_151115_aP;
        objectArray[12] = Items.field_151115_aP;
        objectArray[13] = Items.field_151115_aP;
        objectArray[14] = new ItemStack((Item)ItemsCommonProxy.itemOre, 1, 6);
        return objectArray;
    }

    @Override
    public int getID() {
        return 72;
    }

    @Override
    public boolean applyEffectBlock(ItemStack stack, World world, int blockx, int blocky, int blockz, int blockFace, double impactX, double impactY, double impactZ, EntityLivingBase caster) {
        return false;
    }

    @Override
    public boolean applyEffectEntity(ItemStack stack, World world, EntityLivingBase caster, Entity target) {
        if (target instanceof EntityLivingBase) {
            int z;
            int y;
            int duration = SpellUtils.instance.getModifiedInt_Mul(600, stack, caster, target, world, 0, SpellModifiers.DURATION);
            duration = SpellUtils.instance.modifyDurationBasedOnArmor(caster, duration);
            int x = (int)Math.floor(target.field_70165_t);
            if (RitualShapeHelper.instance.checkForRitual(this, world, x, y = (int)Math.floor(target.field_70163_u), z = (int)Math.floor(target.field_70161_v)) != null) {
                duration += 3600 * (SpellUtils.instance.countModifiers(SpellModifiers.BUFF_POWER, stack, 0) + 1);
                RitualShapeHelper.instance.consumeRitualReagents(this, world, x, y, z);
            }
            if (!world.field_72995_K) {
                ((EntityLivingBase)target).func_70690_d((PotionEffect)new BuffEffectFury(duration, 0));
            }
            return true;
        }
        return false;
    }

    @Override
    public float manaCost(EntityLivingBase caster) {
        return 261.0f;
    }

    @Override
    public float burnout(EntityLivingBase caster) {
        return 1000.0f;
    }

    @Override
    public ItemStack[] reagents(EntityLivingBase caster) {
        return null;
    }

    @Override
    public void spawnParticles(World world, double x, double y, double z, EntityLivingBase caster, Entity target, Random rand, int colorModifier) {
        for (int i = 0; i < 5 * AMCore.config.getGFXLevel(); ++i) {
            AMParticle particle = (AMParticle)((Object)AMCore.proxy.particleManager.spawn(world, "pulse", x, y, z));
            if (particle == null) continue;
            particle.addRandomOffset(1.0, 1.0, 1.0);
            particle.setRGBColorF(1.0f, 0.0f, 0.0f);
            particle.AddParticleController(new ParticleOrbitEntity(particle, target, 0.15f, 1, false).SetTargetDistance(world.field_73012_v.nextDouble() + 1.0).setIgnoreYCoordinate(true));
            particle.AddParticleController(new ParticleFloatUpward(particle, 0.0f, 0.1f, 1, false));
            particle.setMaxAge(10);
        }
    }

    @Override
    public EnumSet<Affinity> getAffinity() {
        return EnumSet.of(Affinity.FIRE, Affinity.LIGHTNING);
    }

    @Override
    public float getAffinityShift(Affinity affinity) {
        return 0.01f;
    }

    @Override
    public MultiblockStructureDefinition getRitualShape() {
        return RitualShapeHelper.instance.hourglass;
    }

    @Override
    public ItemStack[] getReagents() {
        return new ItemStack[]{new ItemStack((Item)Items.field_151068_bn, 1, 8194), new ItemStack((Item)Items.field_151068_bn, 1, 8201)};
    }

    @Override
    public int getReagentSearchRadius() {
        return 3;
    }
}

