/*
 * Decompiled with CFR 0.152.
 */
package am2.playerextensions;

import am2.AMCore;
import am2.LogHelper;
import am2.api.ISkillData;
import am2.api.SkillTreeEntry;
import am2.api.events.SkillLearnedEvent;
import am2.api.spell.component.interfaces.ISkillTreeEntry;
import am2.api.spell.component.interfaces.ISpellComponent;
import am2.api.spell.component.interfaces.ISpellModifier;
import am2.api.spell.component.interfaces.ISpellShape;
import am2.api.spell.enums.LearnStates;
import am2.api.spell.enums.SkillPointTypes;
import am2.api.spell.enums.SkillTrees;
import am2.network.AMDataReader;
import am2.network.AMDataWriter;
import am2.network.AMNetHandler;
import am2.spell.SkillManager;
import am2.spell.SkillTreeManager;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;
import net.minecraftforge.common.MinecraftForge;

public class SkillData
implements IExtendedEntityProperties,
ISkillData {
    private Entity entity;
    private static final byte SPELL_LEARNED = 1;
    private static final byte CLIENT_SYNC = 2;
    private static final byte KNOWN_SHAPE_UPDATE = 1;
    private static final byte KNOWN_COMPONENT_UPDATE = 2;
    private static final byte KNOWN_MODIFIER_UPDATE = 4;
    private static final byte NUM_SPELL_POINTS = 8;
    private static final byte KNOWN_TALENTS_UPDATE = 16;
    private boolean hasDoneFullSync = false;
    private int updateFlags = 0;
    private boolean forcingSync = false;
    private int ticksToSync = 0;
    private final int syncTickDelay = 2400;
    private ArrayList<Integer> shapesKnown = new ArrayList();
    private ArrayList<Integer> componentsKnown = new ArrayList();
    private ArrayList<Integer> modifiersKnown = new ArrayList();
    private ArrayList<Integer> talentsKnown = new ArrayList();
    private SkillTrees primaryTree;
    private final EntityPlayer player;
    private int[] spellPoints = new int[]{3, 0, 0, 0};
    public static final String identifier = "SpellKnowledgeData";

    public static SkillData For(EntityPlayer player) {
        return (SkillData)player.getExtendedProperties(identifier);
    }

    public SkillData(EntityPlayer player) {
        this.primaryTree = SkillTrees.None;
        this.player = player;
    }

    private boolean isShapeKnown(int shapeID) {
        return this.shapesKnown.contains(shapeID);
    }

    private boolean isComponentKnown(int componentID) {
        return this.componentsKnown.contains(componentID);
    }

    private boolean isModifierKnown(int modifierID) {
        return this.modifiersKnown.contains(modifierID);
    }

    private boolean isTalentKnown(int skillID) {
        return this.talentsKnown.contains(skillID);
    }

    public SkillTrees getPrimaryTree() {
        return this.primaryTree;
    }

    @Override
    public boolean isEntryKnown(SkillTreeEntry entry) {
        if (this.player.field_71075_bZ.field_75098_d) {
            return true;
        }
        if (entry.registeredItem instanceof ISpellShape) {
            return this.isShapeKnown(((ISpellShape)entry.registeredItem).getID());
        }
        if (entry.registeredItem instanceof ISpellComponent) {
            return this.isComponentKnown(((ISpellComponent)entry.registeredItem).getID() + 1000);
        }
        if (entry.registeredItem instanceof ISpellModifier) {
            return this.isModifierKnown(((ISpellModifier)entry.registeredItem).getID() + 5000);
        }
        if (entry.registeredItem instanceof ISkillTreeEntry) {
            return this.isTalentKnown(entry.registeredItem.getID() + 6000);
        }
        return false;
    }

    @Override
    public int getSpellPoints(SkillPointTypes type) {
        return this.spellPoints[type.ordinal()];
    }

    @Override
    public void setSpellPoints(int spellPoints, SkillPointTypes type) {
        this.spellPoints[type.ordinal()] = spellPoints;
        if (this.spellPoints[type.ordinal()] < 0) {
            this.spellPoints[type.ordinal()] = 0;
        }
        this.updateFlags |= 8;
    }

    @Override
    public void setSpellPoints(int spellPoints_blue, int spellPoints_green, int spellPoints_red) {
        this.setSpellPoints(spellPoints_blue, SkillPointTypes.BLUE);
        this.setSpellPoints(spellPoints_green, SkillPointTypes.GREEN);
        this.setSpellPoints(spellPoints_red, SkillPointTypes.RED);
    }

    @Override
    public void incrementSpellPoints(SkillPointTypes type) {
        int n = type.ordinal();
        this.spellPoints[n] = this.spellPoints[n] + 1;
        this.updateFlags |= 8;
    }

    @Override
    public void decrementSpellPoints(SkillPointTypes type) {
        int n = type.ordinal();
        this.spellPoints[n] = this.spellPoints[n] - 1;
        if (this.spellPoints[type.ordinal()] < 0) {
            this.spellPoints[type.ordinal()] = 0;
        }
        this.updateFlags |= 8;
    }

    private void setShapeKnown(int shapeID) {
        if (!this.isShapeKnown(shapeID)) {
            ISkillTreeEntry part;
            SkillTreeEntry ste;
            this.shapesKnown.add(shapeID);
            if (this.primaryTree == SkillTrees.None && (ste = SkillTreeManager.instance.getSkillTreeEntry(part = SkillManager.instance.getSkill(shapeID))) != null && ste.tree != SkillTrees.Talents && ste.tree != SkillTrees.None) {
                this.primaryTree = ste.tree;
            }
        }
    }

    private void setComponentKnown(int componentID) {
        if (!this.isComponentKnown(componentID)) {
            ISkillTreeEntry part;
            SkillTreeEntry ste;
            this.componentsKnown.add(componentID);
            if (this.primaryTree == SkillTrees.None && (ste = SkillTreeManager.instance.getSkillTreeEntry(part = SkillManager.instance.getSkill(componentID))) != null && ste.tree != SkillTrees.Talents && ste.tree != SkillTrees.None) {
                this.primaryTree = ste.tree;
            }
        }
    }

    private void setModifierKnown(int modifierID) {
        if (!this.isModifierKnown(modifierID)) {
            ISkillTreeEntry part;
            SkillTreeEntry ste;
            this.modifiersKnown.add(modifierID);
            if (this.primaryTree == SkillTrees.None && (ste = SkillTreeManager.instance.getSkillTreeEntry(part = SkillManager.instance.getSkill(modifierID))) != null && ste.tree != SkillTrees.Talents && ste.tree != SkillTrees.None) {
                this.primaryTree = ste.tree;
            }
        }
    }

    private void setTalentKnown(int talentID) {
        if (!this.isTalentKnown(talentID)) {
            this.talentsKnown.add(talentID);
        }
    }

    private void learnInternal(ISkillTreeEntry entry) {
        if (entry instanceof ISpellShape) {
            this.setShapeKnown(((ISpellShape)entry).getID());
        } else if (entry instanceof ISpellComponent) {
            this.setComponentKnown(((ISpellComponent)entry).getID());
        } else if (entry instanceof ISpellModifier) {
            this.setModifierKnown(((ISpellModifier)entry).getID());
        } else if (entry instanceof ISkillTreeEntry) {
            this.setTalentKnown(entry.getID());
        }
    }

    @Override
    public void learn(ISkillTreeEntry entry) {
        if (this.entity.field_70170_p.field_72995_K) {
            AMDataWriter writer = new AMDataWriter();
            writer.add((byte)1);
            writer.add(this.entity.func_145782_y());
            int id = entry.getID();
            if (entry instanceof ISpellComponent) {
                id += 1000;
            } else if (entry instanceof ISpellModifier) {
                id += 5000;
            } else if (!(entry instanceof ISpellShape)) {
                id += 6000;
            }
            writer.add(id);
            if (entry instanceof ISpellShape) {
                writer.add(0);
            } else if (entry instanceof ISpellComponent) {
                writer.add(1);
            } else if (entry instanceof ISpellModifier) {
                writer.add(2);
            } else {
                writer.add(3);
            }
            AMNetHandler.INSTANCE.sendPacketToServer((byte)27, writer.generate());
        } else {
            int id = entry.getID();
            if (entry instanceof ISpellComponent) {
                id += 1000;
            } else if (entry instanceof ISpellModifier) {
                id += 5000;
            } else if (!(entry instanceof ISpellShape)) {
                id += 6000;
            }
            int type = 3;
            if (entry instanceof ISpellShape) {
                type = 0;
            } else if (entry instanceof ISpellComponent) {
                type = 1;
            } else if (entry instanceof ISpellModifier) {
                type = 2;
            }
            this.learn(id, type);
            MinecraftForge.EVENT_BUS.post((Event)new SkillLearnedEvent(this.player, entry));
        }
    }

    public void learn(int id, int type) {
        if (this.entity.field_70170_p.field_72995_K) {
            AMDataWriter writer = new AMDataWriter();
            writer.add((byte)1);
            writer.add(this.entity.func_145782_y());
            writer.add(id);
            writer.add(type);
            AMNetHandler.INSTANCE.sendPacketToServer((byte)27, writer.generate());
            MinecraftForge.EVENT_BUS.post((Event)new SkillLearnedEvent(this.player, SkillManager.instance.getSkill(id)));
        } else {
            SkillPointTypes skillType = SkillTreeManager.instance.getSkillPointTypeForPart(id);
            boolean learned = false;
            switch (type) {
                case 0: {
                    if (!this.isShapeKnown(id) && this.getSpellPoints(skillType) > 0) {
                        this.setShapeKnown(id);
                        this.decrementSpellPoints(skillType);
                        learned = true;
                    }
                    this.updateFlags |= 1;
                    break;
                }
                case 1: {
                    if (!this.isComponentKnown(id) && this.getSpellPoints(skillType) > 0) {
                        this.setComponentKnown(id);
                        this.decrementSpellPoints(skillType);
                        learned = true;
                    }
                    this.updateFlags |= 2;
                    break;
                }
                case 2: {
                    if (!this.isModifierKnown(id) && this.getSpellPoints(skillType) > 0) {
                        this.setModifierKnown(id);
                        this.decrementSpellPoints(skillType);
                        learned = true;
                    }
                    this.updateFlags |= 4;
                    break;
                }
                case 3: {
                    if (!this.isTalentKnown(id) && this.getSpellPoints(skillType) > 0) {
                        this.setTalentKnown(id);
                        this.decrementSpellPoints(skillType);
                        learned = true;
                    }
                    this.updateFlags |= 0x10;
                }
            }
            if (this.entity instanceof EntityPlayerMP && learned && skillType == SkillPointTypes.SILVER) {
                AMNetHandler.INSTANCE.sendSilverSkillPointPacket((EntityPlayerMP)this.entity);
            }
        }
    }

    @Override
    public Integer[] getKnownShapes() {
        if (this.entity instanceof EntityPlayer && ((EntityPlayer)this.entity).field_71075_bZ.field_75098_d) {
            ArrayList<Integer> allKnownShapes = SkillManager.instance.getAllShapes();
            return allKnownShapes.toArray(new Integer[allKnownShapes.size()]);
        }
        return this.shapesKnown.toArray(new Integer[this.shapesKnown.size()]);
    }

    @Override
    public Integer[] getKnownComponents() {
        if (this.entity instanceof EntityPlayer && ((EntityPlayer)this.entity).field_71075_bZ.field_75098_d) {
            ArrayList<Integer> allKnownComponents = SkillManager.instance.getAllComponents();
            return allKnownComponents.toArray(new Integer[allKnownComponents.size()]);
        }
        return this.componentsKnown.toArray(new Integer[this.componentsKnown.size()]);
    }

    @Override
    public Integer[] getKnownModifiers() {
        if (this.entity instanceof EntityPlayer && ((EntityPlayer)this.entity).field_71075_bZ.field_75098_d) {
            ArrayList<Integer> allKnownModifiers = SkillManager.instance.getAllModifiers();
            return allKnownModifiers.toArray(new Integer[allKnownModifiers.size()]);
        }
        return this.modifiersKnown.toArray(new Integer[this.modifiersKnown.size()]);
    }

    @Override
    public Integer[] getKnownTalents() {
        if (this.entity instanceof EntityPlayer && ((EntityPlayer)this.entity).field_71075_bZ.field_75098_d) {
            ArrayList<Integer> allKnownTalents = SkillManager.instance.getAllTalents();
            return allKnownTalents.toArray(new Integer[allKnownTalents.size()]);
        }
        return this.talentsKnown.toArray(new Integer[this.talentsKnown.size()]);
    }

    public boolean handlePacketData(byte[] data) {
        try {
            AMDataReader rdr = new AMDataReader(data, false);
            byte subID = rdr.getByte();
            int entityID = rdr.getInt();
            switch (subID) {
                case 1: {
                    int id = rdr.getInt();
                    int type = rdr.getInt();
                    this.learn(id, type);
                    if (this.entity.field_70170_p.field_72995_K) break;
                    this.forceSync();
                    break;
                }
                case 2: {
                    int i;
                    int flags = rdr.getInt();
                    if (rdr.getBoolean()) {
                        this.primaryTree = SkillTrees.values()[rdr.getInt()];
                    }
                    if ((flags & 1) == 1) {
                        this.shapesKnown.clear();
                        int numShapes = rdr.getInt();
                        for (i = 0; i < numShapes; ++i) {
                            this.setShapeKnown(rdr.getInt());
                        }
                    }
                    if ((flags & 2) == 2) {
                        this.componentsKnown.clear();
                        int numComponents = rdr.getInt();
                        for (i = 0; i < numComponents; ++i) {
                            this.setComponentKnown(rdr.getInt());
                        }
                    }
                    if ((flags & 4) == 4) {
                        this.modifiersKnown.clear();
                        int numModifiers = rdr.getInt();
                        for (i = 0; i < numModifiers; ++i) {
                            this.setModifierKnown(rdr.getInt());
                        }
                    }
                    if ((flags & 0x10) == 16) {
                        this.talentsKnown.clear();
                        int numTalents = rdr.getInt();
                        for (i = 0; i < numTalents; ++i) {
                            this.setTalentKnown(rdr.getInt());
                        }
                    }
                    if ((flags & 8) != 8) break;
                    this.setSpellPoints(rdr.getInt(), rdr.getInt(), rdr.getInt());
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean HasDoneFullSync() {
        return this.hasDoneFullSync;
    }

    public void setFullSync() {
        this.ticksToSync = 0;
        this.updateFlags = this.updateFlags | 1 | 2 | 4 | 0x10 | 8;
        this.hasDoneFullSync = true;
        this.forcingSync = true;
    }

    public void setDelayedSync(int delay) {
        this.setFullSync();
        this.ticksToSync = delay;
    }

    @Override
    public void forceSync() {
        this.forcingSync = true;
        this.ticksToSync = 0;
    }

    public boolean hasUpdate() {
        if (!(this.entity instanceof EntityPlayer) && !this.forcingSync) {
            return false;
        }
        --this.ticksToSync;
        if (this.ticksToSync <= 0) {
            this.ticksToSync = this.syncTickDelay;
        }
        return (this.updateFlags != 0 || this.forcingSync) && this.ticksToSync == this.syncTickDelay;
    }

    private byte[] getUpdateData() {
        AMDataWriter writer = new AMDataWriter();
        writer.add((byte)2);
        writer.add(this.entity.func_145782_y());
        writer.add(this.updateFlags);
        writer.add(this.primaryTree != null);
        if (this.primaryTree != null) {
            writer.add(this.primaryTree.ordinal());
        }
        if ((this.updateFlags & 1) == 1) {
            writer.add(this.shapesKnown.size());
            for (Integer i : this.shapesKnown) {
                writer.add(i);
            }
        }
        if ((this.updateFlags & 2) == 2) {
            writer.add(this.componentsKnown.size());
            for (Integer i : this.componentsKnown) {
                writer.add(i);
            }
        }
        if ((this.updateFlags & 4) == 4) {
            writer.add(this.modifiersKnown.size());
            for (Integer i : this.modifiersKnown) {
                writer.add(i);
            }
        }
        if ((this.updateFlags & 0x10) == 16) {
            writer.add(this.talentsKnown.size());
            for (Integer i : this.talentsKnown) {
                writer.add(i);
            }
        }
        if ((this.updateFlags & 8) == 8) {
            writer.add(this.spellPoints[0]);
            writer.add(this.spellPoints[1]);
            writer.add(this.spellPoints[2]);
            writer.add(this.spellPoints[3]);
        }
        this.updateFlags = 0;
        this.forcingSync = false;
        return writer.generate();
    }

    public void handleExtendedPropertySync() {
        if (!this.HasDoneFullSync()) {
            this.setFullSync();
        }
        if (!this.entity.field_70170_p.field_72995_K && this.hasUpdate()) {
            byte[] data = this.getUpdateData();
            AMNetHandler.INSTANCE.sendPacketToAllClientsNear(this.entity.field_71093_bK, this.entity.field_70165_t, this.entity.field_70163_u, this.entity.field_70161_v, 32.0, (byte)27, data);
        }
    }

    private int[] arrayListToIntArray(ArrayList<Integer> source) {
        int[] newArr = new int[source.size()];
        int count = 0;
        for (Integer i : source) {
            if (i == null) {
                newArr[count++] = 0;
                continue;
            }
            newArr[count++] = i;
        }
        return newArr;
    }

    private void addAllIntsToArrayList(ArrayList<Integer> list, int[] array) {
        if (array == null) {
            return;
        }
        for (int i : array) {
            list.add(i);
        }
    }

    public void saveNBTData(NBTTagCompound compound) {
        NBTTagCompound spellKnowledgeData = new NBTTagCompound();
        spellKnowledgeData.func_74783_a("KnownShapes", this.arrayListToIntArray(this.shapesKnown));
        spellKnowledgeData.func_74783_a("KnownComponents", this.arrayListToIntArray(this.componentsKnown));
        spellKnowledgeData.func_74783_a("KnownModifiers", this.arrayListToIntArray(this.modifiersKnown));
        spellKnowledgeData.func_74783_a("KnownTalents", this.arrayListToIntArray(this.talentsKnown));
        spellKnowledgeData.func_74783_a("SpellPoints", this.spellPoints);
        spellKnowledgeData.func_74768_a("PrimarySkillTree", this.primaryTree != null ? this.primaryTree.ordinal() : -1);
        compound.func_74782_a("SpellKnowledge", (NBTBase)spellKnowledgeData);
    }

    public void loadNBTData(NBTTagCompound compound) {
        this.shapesKnown = new ArrayList();
        this.componentsKnown = new ArrayList();
        this.modifiersKnown = new ArrayList();
        this.talentsKnown = new ArrayList();
        NBTTagCompound spellKnowledgeData = compound.func_74775_l("SpellKnowledge");
        if (spellKnowledgeData != null) {
            int ordinal;
            this.addAllIntsToArrayList(this.shapesKnown, spellKnowledgeData.func_74759_k("KnownShapes"));
            this.addAllIntsToArrayList(this.componentsKnown, spellKnowledgeData.func_74759_k("KnownComponents"));
            this.addAllIntsToArrayList(this.modifiersKnown, spellKnowledgeData.func_74759_k("KnownModifiers"));
            this.addAllIntsToArrayList(this.talentsKnown, spellKnowledgeData.func_74759_k("KnownTalents"));
            this.spellPoints = spellKnowledgeData.func_74759_k("SpellPoints");
            if (this.spellPoints.length != 4) {
                this.spellPoints = new int[]{3, 0, 0, 0};
            }
            if ((ordinal = spellKnowledgeData.func_74762_e("PrimarySkillTree")) > -1) {
                this.primaryTree = SkillTrees.values()[ordinal];
            }
        }
    }

    public void init(Entity entity, World world) {
        this.entity = entity;
    }

    @Override
    public void clearAllKnowledge() {
        this.shapesKnown.clear();
        this.componentsKnown.clear();
        this.modifiersKnown.clear();
        this.talentsKnown.clear();
        this.primaryTree = SkillTrees.None;
        this.spellPoints = new int[]{0, 0, 0, 0};
        this.setFullSync();
    }

    private boolean RecursivePrerequisiteCheck(SkillData sk, SkillTreeEntry entry) {
        for (SkillTreeEntry prereq : entry.prerequisites) {
            if (!(prereq.enabled ? !sk.isEntryKnown(prereq) : !this.RecursivePrerequisiteCheck(sk, prereq))) continue;
            return false;
        }
        return true;
    }

    @Override
    public LearnStates getLearnState(SkillTreeEntry entry, EntityPlayer player) {
        LearnStates state;
        SkillData sk = SkillData.For(player);
        if (sk.isEntryKnown(entry)) {
            return LearnStates.LEARNED;
        }
        SkillPointTypes pointType = SkillTreeManager.instance.getSkillPointTypeForPart(entry.registeredItem);
        LearnStates learnStates = entry.enabled ? (sk.getSpellPoints(pointType) > 0 ? LearnStates.CAN_LEARN : LearnStates.CANNOT_LEARN) : (state = LearnStates.DISABLED);
        if (state == LearnStates.CAN_LEARN && !this.RecursivePrerequisiteCheck(sk, entry)) {
            state = LearnStates.CANNOT_LEARN;
        }
        if (sk.getPrimaryTree() != SkillTrees.None && entry.tree != SkillTrees.Talents && sk.getPrimaryTree() != entry.tree && entry.tier >= AMCore.config.getSkillTreeSecondaryTierCap()) {
            state = LearnStates.LOCKED;
        }
        return state;
    }

    public void respec() {
        SkillPointTypes type;
        LogHelper.info("Respeccing %s", this.player.func_70005_c_());
        int[] addPoints = new int[]{this.spellPoints[0], this.spellPoints[1], this.spellPoints[2], this.spellPoints[3]};
        for (Integer i : this.shapesKnown) {
            type = SkillTreeManager.instance.getSkillPointTypeForPart(SkillManager.instance.getSkill(i));
            int n = type.ordinal();
            addPoints[n] = addPoints[n] + 1;
        }
        for (Integer i : this.componentsKnown) {
            type = SkillTreeManager.instance.getSkillPointTypeForPart(SkillManager.instance.getSkill(i));
            int n = type.ordinal();
            addPoints[n] = addPoints[n] + 1;
        }
        for (Integer i : this.modifiersKnown) {
            type = SkillTreeManager.instance.getSkillPointTypeForPart(SkillManager.instance.getSkill(i));
            int n = type.ordinal();
            addPoints[n] = addPoints[n] + 1;
        }
        for (Integer i : this.talentsKnown) {
            type = SkillTreeManager.instance.getSkillPointTypeForPart(SkillManager.instance.getSkill(i));
            int n = type.ordinal();
            addPoints[n] = addPoints[n] + 1;
        }
        this.clearAllKnowledge();
        this.spellPoints[0] = addPoints[0];
        this.spellPoints[1] = addPoints[1];
        this.spellPoints[2] = addPoints[2];
    }
}

