/*
 * Decompiled with CFR 0.152.
 */
package am2.playerextensions;

import am2.AMCore;
import am2.api.ArsMagicaApi;
import am2.api.IExtendedProperties;
import am2.api.events.PlayerMagicLevelChangeEvent;
import am2.api.math.AMVector2;
import am2.api.math.AMVector3;
import am2.api.spell.enums.ContingencyTypes;
import am2.api.spell.enums.SkillPointTypes;
import am2.armor.ArmorHelper;
import am2.armor.ArsMagicaArmorMaterial;
import am2.armor.infusions.ImbuementRegistry;
import am2.bosses.EntityLifeGuardian;
import am2.buffs.BuffList;
import am2.guis.AMGuiHelper;
import am2.items.ItemsCommonProxy;
import am2.network.AMDataReader;
import am2.network.AMDataWriter;
import am2.network.AMNetHandler;
import am2.particles.AMLineArc;
import am2.playerextensions.SkillData;
import am2.spell.SkillManager;
import am2.spell.SkillTreeManager;
import am2.spell.SpellHelper;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;
import net.minecraftforge.common.MinecraftForge;

public class ExtendedProperties
implements IExtendedProperties,
IExtendedEntityProperties {
    private EntityLivingBase entity;
    public static final String identifier = "ArsMagicaExProps";
    public static final int maxMagicLevel = 99;
    private static float magicRegenPerLevelPerTick = 0.15f;
    private static float entityMagicPerLevelBase = 0.2f;
    private static int baseTicksForFullRegen = 2400;
    private int ticksForFullRegen = baseTicksForFullRegen;
    private ArrayList<Integer> summon_ent_ids = new ArrayList();
    private double markX;
    private double markY;
    private double markZ;
    private int markDimension;
    private int healCooldown;
    private float flipRotation;
    private float prevFlipRotation;
    private float shrinkPct;
    private float prevShrinkPct;
    public float shrinkAmount = 0.0f;
    public AMVector2 originalSize;
    public float yOffsetOrig = 0.75f;
    private float currentMana;
    private float maxMana;
    private float currentFatigue;
    private float maxFatigue;
    private int magicLevel;
    private float magicXP;
    private int numSummons;
    private ArrayList<ManaLinkEntry> manaLinks;
    private byte bitFlag;
    private boolean hasDoneFullSync = false;
    public int sprintTimer = 0;
    public int sneakTimer = 0;
    public int itemUseTimer = 0;
    private int fallProtection = 0;
    private int previousBreath = 300;
    private ContingencyTypes contingencyType = ContingencyTypes.NONE;
    private ItemStack contingencyStack = null;
    public float TK_Distance = 8.0f;
    public float bankedInfusionHelm = 0.0f;
    public float bankedInfusionChest = 0.0f;
    public float bankedInfusionLegs = 0.0f;
    public float bankedInfusionBoots = 0.0f;
    private Entity inanimateTarget;
    public int[] armorProcCooldowns = new int[4];
    private int ticksSinceLastRegen = 0;
    private int ticksToRegen = 0;
    private boolean needsArmorTickCounterSync = false;
    private int AuraIndex = 15;
    private int AuraBehaviour = 0;
    private float AuraScale = 0.5f;
    private int AuraColor = 0xFFFFFF;
    private float AuraAlpha = 1.0f;
    private boolean AuraColorRandomize = true;
    private boolean AuraColorDefault = true;
    private int AuraDelay = 1;
    private int AuraQuantity = 2;
    private float AuraSpeed = 0.5f;
    private boolean hasInitialized = false;
    public boolean astralBarrierBlocked = false;
    private boolean forcingSync = false;
    private boolean isCritical;
    public boolean isRecoveringKeystone = false;
    public boolean hadFlight = false;
    private boolean disableGravity = false;
    private static final int UPD_CURRENT_MANA_FATIGUE = 1;
    private static final int UPD_MAX_MANA_FATIGUE = 2;
    private static final int UPD_MAGIC_LEVEL = 4;
    private static final int UPD_DISABLE_GRAVITY = 8;
    private static final int UPD_NUM_SUMMONS = 16;
    private static final int UPD_MARK = 32;
    private static final int UPD_CONTINGENCY = 64;
    private static final int UPD_BITFLAG = 128;
    private static final int UPD_BETA_PARTICLES = 256;
    private static final int UPD_TK_DISTANCE = 512;
    private static final int UPD_MANALINK = 1024;
    private static final int BIT_MARK_SET = 2;
    private static final int BIT_FLIPPED = 4;
    private static final int BIT_SHRUNK = 8;
    private int updateFlags;
    private static final int syncTickDelay = 200;
    private int ticksToSync;

    public ExtendedProperties() {
        this.manaLinks = new ArrayList();
    }

    public static ExtendedProperties For(EntityLivingBase living) {
        return (ExtendedProperties)living.getExtendedProperties(identifier);
    }

    public boolean getHasDoneFullSync() {
        return this.hasDoneFullSync;
    }

    @Override
    public boolean getHasUnlockedAugmented() {
        if (this.entity instanceof EntityPlayer) {
            return SkillData.For((EntityPlayer)this.entity).isEntryKnown(SkillTreeManager.instance.getSkillTreeEntry(SkillManager.instance.getSkill("AugmentedCasting")));
        }
        return true;
    }

    public int getBreathAmount() {
        return this.previousBreath;
    }

    @Override
    public int getNumSummons() {
        return this.numSummons;
    }

    @Override
    public AMVector3 getMarkLocation() {
        return new AMVector3(this.markX, this.markY, this.markZ);
    }

    @Override
    public boolean getMarkSet() {
        return (this.bitFlag & 2) == 2;
    }

    public int getAuraBehaviour() {
        return this.AuraBehaviour;
    }

    public int getAuraIndex() {
        return this.AuraIndex;
    }

    public float getAuraScale() {
        return this.AuraScale;
    }

    public float getAuraAlpha() {
        return this.AuraAlpha;
    }

    public boolean getAuraColorDefault() {
        return this.AuraColorDefault;
    }

    public boolean getAuraColorRandomize() {
        return this.AuraColorRandomize;
    }

    public int getAuraColor() {
        return this.AuraColor;
    }

    public int getAuraDelay() {
        return this.AuraDelay;
    }

    public int getAuraQuantity() {
        return this.AuraQuantity;
    }

    public float getAuraSpeed() {
        return this.AuraSpeed;
    }

    public ContingencyTypes getContingencyType() {
        return this.contingencyType;
    }

    public ItemStack getContingencyEffect() {
        return this.contingencyStack;
    }

    public int getFallProtection() {
        return this.fallProtection;
    }

    @Override
    public int getMarkDimension() {
        return this.markDimension;
    }

    public double getMarkX() {
        return this.markX;
    }

    public double getMarkY() {
        return this.markY;
    }

    public double getMarkZ() {
        return this.markZ;
    }

    public float getCurrentFatigue() {
        return this.currentFatigue;
    }

    public float getMaxFatigue() {
        return (float)((double)this.maxFatigue + this.entity.func_110140_aT().func_111151_a(ArsMagicaApi.maxBurnoutBonus).func_111126_e());
    }

    @Override
    public float getCurrentMana() {
        return this.currentMana;
    }

    @Override
    public float getMaxMana() {
        float max = this.maxMana;
        if (this.entity.func_70644_a((Potion)BuffList.manaBoost)) {
            max = (float)((double)max * (1.0 + 0.25 * (double)(this.entity.func_70660_b((Potion)BuffList.manaBoost).func_76458_c() + 1)));
        }
        return (float)((double)max + this.entity.func_110140_aT().func_111151_a(ArsMagicaApi.maxManaBonus).func_111126_e());
    }

    public void setMaxMana(float maxMana) {
        this.maxMana = AMCore.config.getManaCap() > 0.0 ? (float)Math.min((double)maxMana, AMCore.config.getManaCap()) : maxMana;
        this.setUpdateFlag(2);
    }

    public byte[] getUpdateData() {
        AMDataWriter writer = new AMDataWriter();
        writer.add(this.entity.func_145782_y());
        writer.add(this.updateFlags);
        if ((this.updateFlags & 0x80) == 128) {
            writer.add(this.bitFlag);
        }
        if ((this.updateFlags & 1) == 1) {
            writer.add(this.currentMana);
            writer.add(this.currentFatigue);
        }
        if ((this.updateFlags & 4) == 4) {
            writer.add(this.magicLevel);
            writer.add(this.magicXP);
        }
        if ((this.updateFlags & 0x20) == 32) {
            writer.add(this.markX);
            writer.add(this.markY);
            writer.add(this.markZ);
            writer.add(this.markDimension);
            writer.add(this.getMarkSet());
        }
        if ((this.updateFlags & 2) == 2) {
            writer.add(this.maxMana);
            writer.add(this.maxFatigue);
        }
        if ((this.updateFlags & 0x10) == 16) {
            writer.add(this.numSummons);
        }
        if ((this.updateFlags & 0x100) == 256 && this.entity instanceof EntityPlayer && AMCore.proxy.playerTracker.hasAA((EntityPlayer)this.entity)) {
            writer.add(this.getAuraIndex());
            writer.add(this.getAuraBehaviour());
            writer.add(this.getAuraScale());
            writer.add(this.getAuraAlpha());
            writer.add(this.getAuraColorRandomize());
            writer.add(this.getAuraColorDefault());
            writer.add(this.getAuraColor());
            writer.add(this.getAuraDelay());
            writer.add(this.getAuraQuantity());
            writer.add(this.getAuraSpeed());
        }
        if ((this.updateFlags & 0x40) == 64) {
            writer.add(this.contingencyType.ordinal());
            if (this.contingencyType != ContingencyTypes.NONE) {
                writer.add(this.contingencyStack);
            }
        }
        if ((this.updateFlags & 0x400) == 1024) {
            writer.add(this.manaLinks.size());
            for (ManaLinkEntry entry : this.manaLinks) {
                writer.add(entry.entityID);
            }
        }
        if ((this.updateFlags & 8) == 8) {
            writer.add(this.disableGravity);
        }
        this.updateFlags = 0;
        this.forcingSync = false;
        return writer.generate();
    }

    @Override
    public int getMagicLevel() {
        return this.magicLevel;
    }

    public float getXPToNextLevel() {
        return (float)Math.pow((float)this.magicLevel * 0.25f, 1.5);
    }

    public float getMagicXP() {
        return this.magicXP;
    }

    public Entity getInanimateTarget() {
        return this.inanimateTarget;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean getHasUpdate() {
        if (!(this.entity instanceof EntityPlayer) && !this.forcingSync) {
            return false;
        }
        --this.ticksToSync;
        if (this.ticksToSync <= 0) {
            this.ticksToSync = 200;
        }
        if (this.updateFlags == 0) return false;
        if (this.ticksToSync != 200) return false;
        return true;
    }

    public boolean getCanHaveMoreSummons() {
        if (this.entity instanceof EntityLifeGuardian) {
            return true;
        }
        int maxSummons = 1;
        if (this.entity instanceof EntityPlayer && SkillData.For((EntityPlayer)this.entity).isEntryKnown(SkillTreeManager.instance.getSkillTreeEntry(SkillManager.instance.getSkill("ExtraSummon")))) {
            ++maxSummons;
        }
        this.verifySummons();
        return this.numSummons < maxSummons;
    }

    public boolean getIsFlipped() {
        return (this.bitFlag & 4) == 4;
    }

    public boolean getIsShrunk() {
        return (this.bitFlag & 8) == 8;
    }

    public float getFlipRotation() {
        return this.flipRotation;
    }

    public float getPrevFlipRotation() {
        return this.prevFlipRotation;
    }

    public float getShrinkPct() {
        return this.shrinkPct;
    }

    public float getPrevShrinkPct() {
        return this.prevShrinkPct;
    }

    public void setShrinkPct(float pct) {
        this.prevShrinkPct = this.shrinkPct;
        this.shrinkPct = pct;
    }

    public boolean shouldReverseInput() {
        return this.getFlipRotation() > 0.0f || this.entity.func_82165_m(BuffList.scrambleSynapses.field_76415_H);
    }

    public AMVector2 getOriginalSize() {
        return this.originalSize;
    }

    public boolean getCanHeal() {
        return this.healCooldown <= 0;
    }

    public void setMarkLocation(double x, double y, double z, int dimension) {
        this.setMarkX(x);
        this.setMarkY(y);
        this.setMarkZ(z);
        this.setMarkDimension(dimension);
        this.setMarkSet(true);
        this.setUpdateFlag(32);
    }

    public void setNoMarkLocation() {
        this.setMarkSet(false);
        this.setUpdateFlag(32);
    }

    public void setBreathAmount(int breath) {
        this.previousBreath = breath;
    }

    @Override
    public boolean setMagicLevelWithMana(int level) {
        if (level > 99) {
            level = 99;
        }
        if (level < 0) {
            level = 0;
        }
        this.setMagicLevel(level);
        this.setMaxMana((float)(Math.pow(level, 1.5) * (double)(85.0f * ((float)level / 99.0f)) + 500.0));
        this.setCurrentMana(this.getMaxMana());
        this.setCurrentFatigue(0.0f);
        this.setMaxFatigue(level * 10 + 1);
        return true;
    }

    public void setInanimateTarget(Entity ent) {
        if (ent instanceof EntityLivingBase) {
            return;
        }
        this.inanimateTarget = ent;
    }

    public void setMarkY(double markY) {
        this.markY = markY;
    }

    public void setMarkZ(double markZ) {
        this.markZ = markZ;
    }

    public void setCurrentFatigue(float currentFatigue) {
        if (currentFatigue < 0.0f) {
            currentFatigue = 0.0f;
        }
        if (currentFatigue > this.getMaxFatigue()) {
            currentFatigue = this.getMaxFatigue();
        }
        this.currentFatigue = currentFatigue;
        this.setUpdateFlag(1);
    }

    public void setMaxFatigue(float maxFatigue) {
        this.maxFatigue = maxFatigue;
        this.setUpdateFlag(2);
    }

    @Override
    public void setCurrentMana(float currentMana) {
        if (currentMana < 0.0f) {
            currentMana = 0.0f;
        }
        if (currentMana > this.getMaxMana()) {
            currentMana = this.getMaxMana();
        }
        this.currentMana = currentMana;
        this.setUpdateFlag(1);
    }

    public void setMagicLevel(int magicLevel) {
        if (magicLevel < 0) {
            magicLevel = 0;
        }
        if (magicLevel > 99) {
            magicLevel = 99;
        }
        if (this.entity instanceof EntityPlayer) {
            MinecraftForge.EVENT_BUS.post((Event)new PlayerMagicLevelChangeEvent(this.entity, magicLevel));
        }
        this.ticksForFullRegen = (int)Math.round((double)baseTicksForFullRegen * (0.75 - 0.25 * (double)(this.getMagicLevel() / 99)));
        this.magicLevel = magicLevel;
        this.setUpdateFlag(4);
    }

    public void setFallProtection(int protection) {
        this.fallProtection = protection;
    }

    public void setContingency(ContingencyTypes type, ItemStack effect) {
        this.contingencyType = type;
        this.contingencyStack = effect;
        this.setUpdateFlag(64);
    }

    public void setFullSync() {
        this.ticksToSync = 0;
        this.setUpdateFlag(64);
        this.setUpdateFlag(128);
        this.setUpdateFlag(1);
        this.setUpdateFlag(4);
        this.setUpdateFlag(32);
        this.setUpdateFlag(2);
        this.setUpdateFlag(16);
        this.setUpdateFlag(256);
        this.hasDoneFullSync = true;
        this.forcingSync = true;
    }

    public void updateManaLink(EntityLivingBase entity) {
        ManaLinkEntry mle;
        if (!entity.field_70170_p.field_72995_K) {
            this.updateFlags |= 0x400;
        }
        if (!this.manaLinks.contains(mle = new ManaLinkEntry(entity.func_145782_y(), 20))) {
            this.manaLinks.add(mle);
        } else {
            this.manaLinks.remove(mle);
        }
    }

    public float getBonusCurrentMana() {
        float bonus = 0.0f;
        for (ManaLinkEntry entry : this.manaLinks) {
            bonus += entry.getAdditionalCurrentMana(this.entity.field_70170_p, this.entity);
        }
        return bonus;
    }

    public float getBonusMaxMana() {
        float bonus = 0.0f;
        for (ManaLinkEntry entry : this.manaLinks) {
            bonus += entry.getAdditionalMaxMana(this.entity.field_70170_p, this.entity);
        }
        return bonus;
    }

    public void setIsFlipped(boolean flipped) {
        this.bitFlag = flipped ? (byte)(this.bitFlag | 4) : (byte)(this.bitFlag & 0xFFFFFFFB);
        if (!this.entity.field_70170_p.field_72995_K) {
            this.setUpdateFlag(128);
        }
    }

    public void setIsShrunk(boolean shrunk) {
        this.bitFlag = shrunk ? (byte)(this.bitFlag | 8) : (byte)(this.bitFlag & 0xFFFFFFF7);
        if (!this.entity.field_70170_p.field_72995_K) {
            this.setUpdateFlag(128);
            this.forceSync();
        }
    }

    public void setDisableGravity(boolean disabled) {
        this.disableGravity = disabled;
        if (!this.entity.field_70170_p.field_72995_K) {
            this.setUpdateFlag(8);
            this.forceSync();
        }
    }

    public void setOriginalSize(AMVector2 size) {
        this.originalSize = size;
    }

    public void setHealCooldown(int length) {
        this.healCooldown = length;
    }

    private void setMarkSet(boolean markSet) {
        byte curValue = this.bitFlag;
        curValue = markSet ? (byte)(curValue | 2) : (byte)(curValue & 0xFFFFFFFD);
        this.bitFlag = curValue;
        this.setUpdateFlag(128);
    }

    private void setMarkDimension(int markDimension) {
        this.markDimension = markDimension;
    }

    private void setMarkX(double markX) {
        this.markX = markX;
    }

    private void setNumSummons(int numSummons) {
        if (this.entity == null || this.entity.field_70170_p == null) {
            return;
        }
        this.numSummons = numSummons;
    }

    private void setUpdateFlag(int flag) {
        this.updateFlags |= flag;
    }

    private void clearUpdateFlag(int flag) {
        this.updateFlags &= ~flag;
    }

    public void setEntityReference(EntityLivingBase entity) {
        this.entity = entity;
        this.setOriginalSize(new AMVector2(entity.field_70130_N, entity.field_70131_O));
        this.hasInitialized = true;
        this.isCritical = entity instanceof EntityPlayerMP;
        this.yOffsetOrig = entity.field_70129_M;
        this.ticksToRegen = this.isCritical ? 5 : 20;
        if (this.isCritical) {
            if (this.armorProcCooldowns[3] > 0) {
                AMCore.proxy.blackoutArmorPiece((EntityPlayerMP)entity, 3, this.armorProcCooldowns[3]);
            }
            if (this.armorProcCooldowns[1] > 0) {
                AMCore.proxy.blackoutArmorPiece((EntityPlayerMP)entity, 1, this.armorProcCooldowns[1]);
            }
            if (this.armorProcCooldowns[2] > 0) {
                AMCore.proxy.blackoutArmorPiece((EntityPlayerMP)entity, 2, this.armorProcCooldowns[2]);
            }
            if (this.armorProcCooldowns[0] > 0) {
                AMCore.proxy.blackoutArmorPiece((EntityPlayerMP)entity, 0, this.armorProcCooldowns[0]);
            }
        }
        if (entity.field_70170_p != null && entity.field_70170_p.field_72995_K && entity instanceof EntityPlayer && AMCore.proxy.playerTracker.hasAA((EntityPlayer)entity)) {
            EntityPlayer localPlayer = AMCore.proxy.getLocalPlayer();
            if (entity != localPlayer) {
                AMNetHandler.INSTANCE.requestAuras((EntityPlayer)entity);
            }
        }
    }

    public void handleSpecialSyncData() {
        if (this.needsArmorTickCounterSync && this.entity instanceof EntityPlayerMP) {
            this.needsArmorTickCounterSync = false;
            if (this.armorProcCooldowns[3] > 0) {
                AMCore.proxy.blackoutArmorPiece((EntityPlayerMP)this.entity, 3, this.armorProcCooldowns[3]);
            }
            if (this.armorProcCooldowns[1] > 0) {
                AMCore.proxy.blackoutArmorPiece((EntityPlayerMP)this.entity, 1, this.armorProcCooldowns[1]);
            }
            if (this.armorProcCooldowns[2] > 0) {
                AMCore.proxy.blackoutArmorPiece((EntityPlayerMP)this.entity, 2, this.armorProcCooldowns[2]);
            }
            if (this.armorProcCooldowns[0] > 0) {
                AMCore.proxy.blackoutArmorPiece((EntityPlayerMP)this.entity, 0, this.armorProcCooldowns[0]);
            }
        }
    }

    private void verifySummons() {
        for (int i = 0; i < this.summon_ent_ids.size(); ++i) {
            int id = this.summon_ent_ids.get(i);
            Entity e = this.entity.field_70170_p.func_73045_a(id);
            if (e != null && e instanceof EntityLivingBase) continue;
            this.summon_ent_ids.remove(i);
            --i;
            this.removeSummon();
        }
    }

    public boolean addSummon(EntityLivingBase entity) {
        if (!entity.field_70170_p.field_72995_K) {
            this.summon_ent_ids.add(entity.func_145782_y());
            this.setNumSummons(this.getNumSummons() + 1);
            this.setUpdateFlag(16);
        }
        return true;
    }

    public boolean removeSummon() {
        if (this.getNumSummons() == 0) {
            return false;
        }
        if (!this.entity.field_70170_p.field_72995_K) {
            this.setNumSummons(this.getNumSummons() - 1);
            this.setUpdateFlag(16);
        }
        return true;
    }

    public void setSyncAuras() {
        if (this.entity instanceof EntityPlayer && AMCore.proxy.playerTracker.hasAA((EntityPlayer)this.entity)) {
            this.setUpdateFlag(256);
        }
    }

    public boolean handleDataPacket(byte[] data) {
        AMDataReader rdr = new AMDataReader(data, false);
        int entID = rdr.getInt();
        if (entID != this.entity.func_145782_y()) {
            return false;
        }
        int flags = rdr.getInt();
        if ((flags & 0x80) == 128) {
            this.bitFlag = rdr.getByte();
        }
        if ((flags & 1) == 1) {
            this.currentMana = rdr.getFloat();
            this.currentFatigue = rdr.getFloat();
        }
        if ((flags & 4) == 4) {
            this.magicLevel = rdr.getInt();
            float newMagicXP = rdr.getFloat();
            if (this.entity.field_70170_p.field_72995_K && newMagicXP != this.magicXP) {
                AMGuiHelper.instance.showMagicXPBar();
            }
            this.magicXP = newMagicXP;
        }
        if ((flags & 0x20) == 32) {
            this.markX = rdr.getDouble();
            this.markY = rdr.getDouble();
            this.markZ = rdr.getDouble();
            this.markDimension = rdr.getInt();
            this.setMarkSet(rdr.getBoolean());
        }
        if ((flags & 2) == 2) {
            this.maxMana = rdr.getFloat();
            this.maxFatigue = rdr.getFloat();
        }
        if ((flags & 0x10) == 16) {
            this.numSummons = rdr.getInt();
        }
        if ((flags & 0x100) == 256 && this.entity instanceof EntityPlayer && AMCore.proxy.playerTracker.hasAA((EntityPlayer)this.entity)) {
            this.AuraIndex = rdr.getInt();
            this.AuraBehaviour = rdr.getInt();
            this.AuraScale = rdr.getFloat();
            this.AuraAlpha = rdr.getFloat();
            this.AuraColorRandomize = rdr.getBoolean();
            this.AuraColorDefault = rdr.getBoolean();
            this.AuraColor = rdr.getInt();
            this.AuraDelay = rdr.getInt();
            this.AuraQuantity = rdr.getInt();
            this.AuraSpeed = rdr.getFloat();
        }
        if ((flags & 0x40) == 64) {
            this.contingencyType = ContingencyTypes.values()[rdr.getInt()];
            if (this.contingencyType != ContingencyTypes.NONE) {
                this.contingencyStack = rdr.getItemStack();
            }
        }
        if ((flags & 0x400) == 1024) {
            this.manaLinks.clear();
            int numLinks = rdr.getInt();
            for (int i = 0; i < numLinks; ++i) {
                Entity e = this.entity.field_70170_p.func_73045_a(rdr.getInt());
                if (e == null || !(e instanceof EntityLivingBase)) continue;
                this.updateManaLink((EntityLivingBase)e);
            }
        }
        if ((flags & 8) == 8) {
            this.disableGravity = rdr.getBoolean();
        }
        return true;
    }

    public void setDelayedSync(int delay) {
        this.setFullSync();
        this.ticksToSync = delay;
    }

    public void forceSync() {
        this.ticksToSync = 0;
        this.forcingSync = true;
    }

    public void updateAuraData(int index, int behaviour, float scale, float alpha, boolean colorRandom, boolean colorDefault, int color, int delay, int quantity, float speed) {
        this.AuraIndex = index;
        this.AuraBehaviour = behaviour;
        this.AuraScale = scale;
        this.AuraAlpha = alpha;
        this.AuraColorRandomize = colorRandom;
        this.AuraColorDefault = colorDefault;
        this.AuraColor = color;
        this.AuraDelay = delay;
        this.AuraQuantity = quantity;
        this.AuraSpeed = speed;
        this.setUpdateFlag(256);
    }

    public byte[] getAuraData() {
        AMDataWriter writer = new AMDataWriter();
        writer.add(this.AuraIndex);
        writer.add(this.AuraBehaviour);
        writer.add(this.AuraScale);
        writer.add(this.AuraAlpha);
        writer.add(this.AuraColorRandomize);
        writer.add(this.AuraColorDefault);
        writer.add(this.AuraColor);
        writer.add(this.AuraDelay);
        writer.add(this.AuraQuantity);
        writer.add(this.AuraSpeed);
        return writer.generate();
    }

    public void readAuraData(byte[] data) {
        AMDataReader rdr = new AMDataReader(data, false);
        this.AuraIndex = rdr.getInt();
        this.AuraBehaviour = rdr.getInt();
        this.AuraScale = rdr.getFloat();
        this.AuraAlpha = rdr.getFloat();
        this.AuraColorRandomize = rdr.getBoolean();
        this.AuraColorDefault = rdr.getBoolean();
        this.AuraColor = rdr.getInt();
        this.AuraDelay = rdr.getInt();
        this.AuraQuantity = rdr.getInt();
        this.AuraSpeed = rdr.getFloat();
    }

    public void handleWaterMovement() {
        if (this.entity.func_82165_m(BuffList.swiftSwim.field_76415_H)) {
            this.entity.field_70159_w *= 0.96;
            this.entity.field_70181_x *= 0.96;
            this.entity.field_70179_y *= 0.96;
        }
    }

    public boolean detectPossibleDesync() {
        return false;
    }

    public void saveNBTData(NBTTagCompound compound) {
        compound.func_74776_a("curMana", this.getCurrentMana());
        compound.func_74776_a("curFatigue", this.getCurrentFatigue());
        compound.func_74777_a("magicLevel", (short)this.getMagicLevel());
        compound.func_74757_a("hasUnlockedAugmented", this.getHasUnlockedAugmented());
        compound.func_74783_a("armorCooldowns", this.armorProcCooldowns);
        compound.func_74757_a("isShrunk", this.getIsShrunk());
        compound.func_74757_a("isCritical", this.isCritical);
        compound.func_74776_a("magicXP", this.magicXP);
        if (this.contingencyType != ContingencyTypes.NONE) {
            compound.func_74768_a("contingency_type", this.contingencyType.ordinal());
            NBTTagCompound effectSave = this.contingencyStack.func_77955_b(new NBTTagCompound());
            compound.func_74782_a("contingency_effect", (NBTBase)effectSave);
        }
        if (this.getMarkSet()) {
            compound.func_74780_a("marklocationx", this.getMarkX());
            compound.func_74780_a("marklocationy", this.getMarkY());
            compound.func_74780_a("marklocationz", this.getMarkZ());
            compound.func_74768_a("markdimension", this.getMarkDimension());
        }
    }

    public void loadNBTData(NBTTagCompound compound) {
        this.setMagicLevelWithMana(compound.func_74765_d("magicLevel"));
        this.setCurrentMana(compound.func_74760_g("curMana"));
        this.setCurrentFatigue(compound.func_74760_g("curFatigue"));
        this.armorProcCooldowns = compound.func_74759_k("armorCooldowns");
        if (this.armorProcCooldowns == null) {
            this.armorProcCooldowns = new int[4];
        } else if (this.armorProcCooldowns.length != 4) {
            int[] tmp = this.armorProcCooldowns;
            this.armorProcCooldowns = new int[4];
            for (int i = 0; i < Math.min(tmp.length, 4); ++i) {
                this.armorProcCooldowns[i] = tmp[i];
            }
        }
        this.setIsShrunk(compound.func_74767_n("isShrunk"));
        this.isCritical = compound.func_74767_n("isCritical");
        this.magicXP = compound.func_74760_g("magicXP");
        for (int i = 0; i < 4; ++i) {
            if (this.armorProcCooldowns[i] <= 0) continue;
            this.needsArmorTickCounterSync = true;
            break;
        }
        if (compound.func_74764_b("marklocationx")) {
            this.setMarkX(compound.func_74769_h("marklocationx"));
            this.setMarkY(compound.func_74769_h("marklocationy"));
            this.setMarkZ(compound.func_74769_h("marklocationz"));
            this.setMarkDimension(compound.func_74762_e("markdimension"));
            this.setMarkSet(true);
        }
        if (compound.func_74764_b("contingency_type")) {
            this.contingencyType = ContingencyTypes.values()[compound.func_74762_e("contingency_type")];
            this.contingencyStack = ItemStack.func_77949_a((NBTTagCompound)((NBTTagCompound)compound.func_74781_a("contingency_effect")));
        }
    }

    public void init(Entity entity, World world) {
        if (world == null || entity == null || !(entity instanceof EntityLivingBase)) {
            return;
        }
        this.setEntityReference((EntityLivingBase)entity);
        if (entity instanceof EntityPlayer) {
            this.maxMana = 0.0f;
            this.currentMana = 0.0f;
            this.magicLevel = 0;
            this.maxFatigue = 1.0f;
            this.currentFatigue = 0.0f;
        } else {
            this.maxMana = 100.0f;
            this.currentMana = 100.0f;
            this.magicLevel = 1;
            this.maxFatigue = 1.0f;
            this.currentFatigue = 0.0f;
        }
        this.numSummons = 0;
        this.armorProcCooldowns = new int[4];
        this.markX = 0.0;
        this.markY = 0.0;
        this.markZ = 0.0;
        this.markDimension = -512;
        this.updateFlags = 0;
        this.ticksToSync = world.field_73012_v.nextInt(200);
        this.hasInitialized = true;
    }

    public void deductMana(float manaCost) {
        block1: {
            float leftOver = manaCost - this.currentMana;
            this.setCurrentMana(this.currentMana - manaCost);
            if (!(leftOver > 0.0f)) break block1;
            for (ManaLinkEntry entry : this.manaLinks) {
                if ((leftOver -= entry.deductMana(this.entity.field_70170_p, this.entity, leftOver)) <= 0.0f) break;
            }
        }
    }

    public void toggleFlipped() {
        if (this.entity.field_70170_p.field_72995_K) {
            AMNetHandler.INSTANCE.sendExPropCommandToServer(4);
        }
        if (this.getIsFlipped()) {
            this.setIsFlipped(false);
        } else {
            this.setIsFlipped(true);
        }
    }

    public void spawnManaLinkParticles() {
        if (this.entity.field_70170_p != null && this.entity.field_70170_p.field_72995_K) {
            for (ManaLinkEntry entry : this.manaLinks) {
                AMLineArc arc;
                Entity e = this.entity.field_70170_p.func_73045_a(entry.entityID);
                if (e == null || !(e.func_70068_e((Entity)this.entity) < (double)entry.range) || e.field_70173_aa % 90 != 0 || (arc = (AMLineArc)((Object)AMCore.proxy.particleManager.spawn(this.entity.field_70170_p, "textures/blocks/oreblockbluetopaz.png", e, (Entity)this.entity))) == null) continue;
                arc.setIgnoreAge(false);
                arc.func_70538_b(0.17f, 0.88f, 0.88f);
            }
        }
    }

    public void addBurnout(float burnout) {
        if (this.entity.func_70644_a((Potion)BuffList.burnoutReduction)) {
            burnout *= 0.75f;
        }
        this.setCurrentFatigue(this.currentFatigue + burnout);
    }

    public String toString() {
        try {
            return this.hashCode() + " " + this.entity;
        }
        catch (Exception exception) {
            return this.hashCode() + " (error)";
        }
    }

    public void handleExtendedPropertySync() {
        if (!this.entity.field_70170_p.field_72995_K && !this.getHasDoneFullSync()) {
            this.setFullSync();
        }
        if (!this.entity.field_70170_p.field_72995_K && this.getHasUpdate()) {
            byte[] data = this.getUpdateData();
            AMNetHandler.INSTANCE.sendPacketToAllClientsNear(this.entity.field_71093_bK, this.entity.field_70165_t, this.entity.field_70163_u, this.entity.field_70161_v, 32.0, (byte)16, data);
        }
        if (this.entity.field_70170_p.field_72995_K && this.detectPossibleDesync()) {
            AMNetHandler.INSTANCE.sendPacketToServer((byte)29, new AMDataWriter().add(this.entity.func_145782_y()).generate());
        }
    }

    public void syncTKDistance() {
        AMDataWriter writer = new AMDataWriter();
        writer.add(this.TK_Distance);
        AMNetHandler.INSTANCE.sendPacketToServer((byte)39, writer.generate());
    }

    public void addMagicXP(float amt) {
        if (this.magicLevel == 99 || !(this.entity instanceof EntityPlayer)) {
            return;
        }
        this.magicXP += amt;
        float xpToLevel = this.getXPToNextLevel();
        if (this.magicXP >= xpToLevel) {
            this.magicXP = 0.0f;
            this.setMagicLevelWithMana(this.magicLevel + 1);
            if (this.entity instanceof EntityPlayer && this.magicLevel % 2 == 0) {
                EntityPlayer ent = (EntityPlayer)this.entity;
                if (this.magicLevel <= 20) {
                    SkillData.For(ent).incrementSpellPoints(SkillPointTypes.BLUE);
                } else if (this.magicLevel <= 40) {
                    SkillData.For(ent).incrementSpellPoints(SkillPointTypes.GREEN);
                } else if (this.magicLevel <= 50) {
                    SkillData.For(ent).incrementSpellPoints(SkillPointTypes.RED);
                }
            }
            this.entity.field_70170_p.func_72956_a((Entity)this.entity, "arsmagica2:misc.event.magic_level_up", 1.0f, 1.0f);
        }
        this.setUpdateFlag(4);
        this.forceSync();
    }

    public void procContingency() {
        SpellHelper.instance.applyStackStage(this.contingencyStack, this.entity, this.entity, this.entity.field_70165_t, this.entity.field_70163_u, this.entity.field_70161_v, 0, this.entity.field_70170_p, false, false, 0);
        AMNetHandler.INSTANCE.sendSpellApplyEffectToAllAround(this.entity, (Entity)this.entity, this.entity.field_70165_t, this.entity.field_70163_u, this.entity.field_70161_v, this.entity.field_70170_p, this.contingencyStack);
        this.setContingency(ContingencyTypes.NONE, null);
        this.forceSync();
    }

    public void manaBurnoutTick() {
        ++this.ticksSinceLastRegen;
        --this.healCooldown;
        if (this.disableGravity) {
            this.entity.field_70181_x = 0.0;
        }
        if (this.ticksSinceLastRegen >= this.ticksToRegen) {
            float actualMaxMana = this.getMaxMana();
            if (this.getCurrentMana() < actualMaxMana) {
                if (this.entity instanceof EntityPlayer && ((EntityPlayer)this.entity).field_71075_bZ.field_75098_d) {
                    this.setCurrentMana(actualMaxMana);
                } else {
                    if (this.getCurrentMana() < 0.0f) {
                        this.setCurrentMana(0.0f);
                    }
                    int regenTicks = (int)Math.ceil((double)this.ticksForFullRegen * this.entity.func_110140_aT().func_111151_a(ArsMagicaApi.manaRegenTimeModifier).func_111126_e());
                    if (this.entity.func_82165_m(BuffList.manaRegen.field_76415_H)) {
                        PotionEffect pe = this.entity.func_70660_b((Potion)BuffList.manaRegen);
                        regenTicks = (int)((double)regenTicks * (1.0 - Math.max((double)0.9f, 0.25 * (double)(pe.func_76458_c() + 1))));
                    }
                    if (this.entity instanceof EntityPlayer) {
                        EntityPlayer player = (EntityPlayer)this.entity;
                        int armorSet = ArmorHelper.getFullArsMagicaArmorSet(player);
                        if (armorSet == ArsMagicaArmorMaterial.MAGE.getMaterialID()) {
                            regenTicks = (int)((double)regenTicks * 0.8);
                        } else if (armorSet == ArsMagicaArmorMaterial.BATTLEMAGE.getMaterialID()) {
                            regenTicks = (int)((double)regenTicks * 0.95);
                        } else if (armorSet == ArsMagicaArmorMaterial.ARCHMAGE.getMaterialID()) {
                            regenTicks = (int)((double)regenTicks * 0.5);
                        }
                        if (SkillData.For(player).isEntryKnown(SkillTreeManager.instance.getSkillTreeEntry(SkillManager.instance.getSkill("ManaRegenIII")))) {
                            regenTicks = (int)((float)regenTicks * 0.7f);
                        } else if (SkillData.For(player).isEntryKnown(SkillTreeManager.instance.getSkillTreeEntry(SkillManager.instance.getSkill("ManaRegenII")))) {
                            regenTicks = (int)((float)regenTicks * 0.85f);
                        } else if (SkillData.For(player).isEntryKnown(SkillTreeManager.instance.getSkillTreeEntry(SkillManager.instance.getSkill("ManaRegenI")))) {
                            regenTicks = (int)((float)regenTicks * 0.95f);
                        }
                        int numArmorPieces = 0;
                        for (int i = 0; i < 4; ++i) {
                            ItemStack stack = player.field_71071_by.func_70440_f(i);
                            if (!ImbuementRegistry.instance.isImbuementPresent(stack, "mn_reg")) continue;
                            ++numArmorPieces;
                        }
                        regenTicks = (int)((float)regenTicks * (1.0f - 0.15f * (float)numArmorPieces));
                    }
                    float manaToAdd = actualMaxMana / (float)regenTicks * (float)this.ticksSinceLastRegen;
                    this.setCurrentMana(this.getCurrentMana() + manaToAdd);
                }
            }
            if (this.getCurrentFatigue() > 0.0f) {
                int numArmorPieces = 0;
                if (this.entity instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)this.entity;
                    for (int i = 0; i < 4; ++i) {
                        ItemStack stack = player.field_71071_by.func_70440_f(i);
                        if (!ImbuementRegistry.instance.isImbuementPresent(stack, "bn_red")) continue;
                        ++numArmorPieces;
                    }
                }
                float factor = (float)((double)(0.01f + 0.015f * (float)numArmorPieces) * this.entity.func_110140_aT().func_111151_a(ArsMagicaApi.burnoutReductionRate).func_111126_e());
                float decreaseamt = factor * (float)this.getMagicLevel() * (float)this.ticksSinceLastRegen;
                this.setCurrentFatigue(this.getCurrentFatigue() - decreaseamt);
                if (this.getCurrentFatigue() < 0.0f) {
                    this.setCurrentFatigue(0.0f);
                }
            }
            this.ticksSinceLastRegen = 0;
        }
    }

    public void flipTick() {
        boolean flipped = this.getIsFlipped();
        ItemStack boots = ((EntityPlayer)this.entity).field_71071_by.field_70460_b[0];
        if (boots == null || boots.func_77973_b() != ItemsCommonProxy.enderBoots) {
            this.setIsFlipped(false);
        }
        this.prevFlipRotation = this.flipRotation;
        if (flipped && this.flipRotation < 180.0f) {
            this.flipRotation += 15.0f;
        } else if (!flipped && this.flipRotation > 0.0f) {
            this.flipRotation -= 15.0f;
        }
    }

    public void cleanupManaLinks() {
        Iterator<ManaLinkEntry> it = this.manaLinks.iterator();
        while (it.hasNext()) {
            ManaLinkEntry entry = it.next();
            Entity e = this.entity.field_70170_p.func_73045_a(entry.entityID);
            if (e != null) continue;
            it.remove();
        }
    }

    public boolean isManaLinkedTo(EntityLivingBase entity) {
        for (ManaLinkEntry entry : this.manaLinks) {
            if (entry.entityID != entity.func_145782_y()) continue;
            return true;
        }
        return false;
    }

    public void performRemoteOp(int mask) {
        if (this.entity.field_70170_p.field_72995_K) {
            return;
        }
        switch (mask) {
            case 4: {
                this.toggleFlipped();
                this.forceSync();
            }
        }
    }

    private class ManaLinkEntry {
        private final int entityID;
        private final int range;

        public ManaLinkEntry(int entityID, int range) {
            this.entityID = entityID;
            this.range = range * range;
        }

        private EntityLivingBase getEntity(World world) {
            Entity e = world.func_73045_a(this.entityID);
            if (e == null || !(e instanceof EntityLivingBase)) {
                return null;
            }
            return (EntityLivingBase)e;
        }

        public float getAdditionalCurrentMana(World world, EntityLivingBase host) {
            EntityLivingBase e = this.getEntity(world);
            if (e == null || e.func_70068_e((Entity)host) > (double)this.range) {
                return 0.0f;
            }
            return ExtendedProperties.For(e).getCurrentMana();
        }

        public float getAdditionalMaxMana(World world, EntityLivingBase host) {
            EntityLivingBase e = this.getEntity(world);
            if (e == null || e.func_70068_e((Entity)host) > (double)this.range) {
                return 0.0f;
            }
            return ExtendedProperties.For(e).getMaxMana();
        }

        public float deductMana(World world, EntityLivingBase host, float amt) {
            EntityLivingBase e = this.getEntity(world);
            if (e == null || e.func_70068_e((Entity)host) > (double)this.range) {
                return 0.0f;
            }
            amt = Math.min(ExtendedProperties.For(e).getCurrentMana(), amt);
            ExtendedProperties.For(e).deductMana(amt);
            if (!world.field_72995_K) {
                ExtendedProperties.For(e).forceSync();
            }
            return amt;
        }

        public int hashCode() {
            return this.entityID;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ManaLinkEntry) {
                return ((ManaLinkEntry)obj).entityID == this.entityID;
            }
            return false;
        }
    }
}

