/*
 * Decompiled with CFR 0.152.
 */
package am2.network;

import am2.LogHelper;
import am2.api.math.AMVector3;
import am2.api.power.IPowerNode;
import am2.blocks.tileentities.TileEntityArmorImbuer;
import am2.blocks.tileentities.TileEntityCalefactor;
import am2.blocks.tileentities.TileEntityObelisk;
import am2.bosses.IArsMagicaBoss;
import am2.entities.EntityHecate;
import am2.network.AMDataWriter;
import am2.network.AMPacketProcessorServer;
import am2.power.PowerNodeRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.FMLEventChannel;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.Unpooled;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class AMNetHandler {
    private static final String ChannelLabel = "AM2DataTunnel";
    private static FMLEventChannel Channel;
    private boolean registeredChannels = false;
    public static final AMNetHandler INSTANCE;

    private AMNetHandler() {
    }

    public void init() {
        Channel = NetworkRegistry.INSTANCE.newEventDrivenChannel(ChannelLabel);
    }

    public void registerChannels(AMPacketProcessorServer proc) {
        if (!this.registeredChannels) {
            this.registeredChannels = true;
            Channel.register((Object)proc);
            FMLCommonHandler.instance().bus().register((Object)proc);
        } else {
            LogHelper.info("Redundant call to register channels.", new Object[0]);
        }
    }

    public void sendPacketToClientPlayer(EntityPlayerMP player, byte packetID, byte[] data) {
        byte[] pkt_data = new byte[data.length + 1];
        pkt_data[0] = packetID;
        for (int i = 0; i < data.length; ++i) {
            pkt_data[i + 1] = data[i];
        }
        FMLProxyPacket packet = new FMLProxyPacket(Unpooled.copiedBuffer((byte[])pkt_data), ChannelLabel);
        packet.setTarget(Side.CLIENT);
        Channel.sendTo(packet, player);
    }

    public void sendPacketToServer(byte packetID, byte[] data) {
        byte[] pkt_data = new byte[data.length + 1];
        pkt_data[0] = packetID;
        for (int i = 0; i < data.length; ++i) {
            pkt_data[i + 1] = data[i];
        }
        FMLProxyPacket packet = new FMLProxyPacket(Unpooled.copiedBuffer((byte[])pkt_data), ChannelLabel);
        packet.setTarget(Side.SERVER);
        Channel.sendToServer(packet);
    }

    public void sendPacketToAllClientsNear(int dimension, double ox, double oy, double oz, double radius, byte packetID, byte[] data) {
        byte[] pkt_data = new byte[data.length + 1];
        pkt_data[0] = packetID;
        for (int i = 0; i < data.length; ++i) {
            pkt_data[i + 1] = data[i];
        }
        FMLProxyPacket packet = new FMLProxyPacket(Unpooled.copiedBuffer((byte[])pkt_data), ChannelLabel);
        packet.setTarget(Side.CLIENT);
        Channel.sendToAllAround(packet, new NetworkRegistry.TargetPoint(dimension, ox, oy, oz, radius));
    }

    public void sendVelocityAddPacket(World world, EntityLivingBase target, double velX, double velY, double velZ) {
        if (world.field_72995_K) {
            return;
        }
        byte[] data = new AMDataWriter().add(target.func_145782_y()).add(velX).add(velY).add(velZ).generate();
        this.sendPacketToAllClientsNear(world.field_73011_w.field_76574_g, target.field_70165_t, target.field_70163_u, target.field_70161_v, 50.0, (byte)7, data);
    }

    @SideOnly(value=Side.CLIENT)
    public void requestAuras(EntityPlayer player) {
        AMDataWriter writer = new AMDataWriter();
        EntityClientPlayerMP localPlayer = Minecraft.func_71410_x().field_71439_g;
        if (localPlayer == null) {
            return;
        }
        writer.add(localPlayer.func_145782_y());
        writer.add(player.func_145782_y());
        this.sendPacketToServer((byte)31, writer.generate());
    }

    public void requestClientAuras(EntityPlayerMP player) {
        this.sendPacketToClientPlayer(player, (byte)17, new byte[0]);
    }

    public void syncWorldName(EntityPlayerMP player, String name) {
        this.sendPacketToClientPlayer(player, (byte)47, new AMDataWriter().add(name).generate());
    }

    public void syncLoginData(EntityPlayerMP player, byte[] data) {
        this.sendPacketToClientPlayer(player, (byte)42, data);
    }

    public void sendSpellbookSlotChange(EntityPlayer player, int inventoryIndex, byte subID) {
        this.sendPacketToServer((byte)14, new AMDataWriter().add(subID).add(player.func_145782_y()).add(inventoryIndex).generate());
    }

    public void sendShapeGroupChangePacket(int newCastingMode, int entityid) {
        byte[] packetData = new AMDataWriter().add(newCastingMode).add(entityid).generate();
        this.sendPacketToServer((byte)1, packetData);
    }

    public <T extends EntityLivingBase> void sendActionUpdateToAllAround(T boss) {
        if (boss.field_70170_p != null && !boss.field_70170_p.field_72995_K) {
            AMDataWriter writer = new AMDataWriter();
            writer.add(boss.func_145782_y());
            writer.add(((IArsMagicaBoss)boss).getCurrentAction().ordinal());
            this.sendPacketToAllClientsNear(boss.field_70170_p.field_73011_w.field_76574_g, boss.field_70165_t, boss.field_70163_u, boss.field_70161_v, 64.0, (byte)38, writer.generate());
        }
    }

    public void sendStarImpactToClients(double x, double y, double z, World world, ItemStack spellStack) {
        AMDataWriter writer = new AMDataWriter().add(x).add(y).add(z);
        if (spellStack != null) {
            writer.add(true).add(spellStack);
        } else {
            writer.add(false);
        }
        this.sendPacketToAllClientsNear(world.field_73011_w.field_76574_g, x, y, z, 64.0, (byte)48, writer.generate());
    }

    public void sendSilverSkillPointPacket(EntityPlayerMP player) {
        this.sendPacketToClientPlayer(player, (byte)49, new byte[0]);
    }

    public void sendSpellApplyEffectToAllAround(EntityLivingBase caster, Entity target, double x, double y, double z, World world, ItemStack spellStack) {
        AMDataWriter writer = new AMDataWriter().add(x).add(y).add(z);
        if (spellStack != null) {
            writer.add(true).add(spellStack);
        } else {
            writer.add(false);
        }
        writer.add(caster.func_145782_y());
        writer.add(target.func_145782_y());
        this.sendPacketToAllClientsNear(world.field_73011_w.field_76574_g, x, y, z, 64.0, (byte)44, writer.generate());
    }

    public void sendHecateDeathToAllAround(EntityHecate hecate) {
        AMDataWriter writer = new AMDataWriter();
        writer.add(hecate.field_70165_t).add(hecate.field_70163_u).add(hecate.field_70161_v);
        this.sendPacketToAllClientsNear(hecate.field_70170_p.field_73011_w.field_76574_g, hecate.field_70165_t, hecate.field_70163_u, hecate.field_70161_v, 32.0, (byte)50, writer.generate());
    }

    public void syncPowerPaths(IPowerNode node, EntityPlayerMP player) {
        AMDataWriter writer = new AMDataWriter();
        if (((TileEntity)node).func_145831_w().field_72995_K) {
            writer.add((byte)0);
            writer.add(((TileEntity)node).func_145831_w().field_73011_w.field_76574_g);
            writer.add(((TileEntity)node).field_145851_c);
            writer.add(((TileEntity)node).field_145848_d);
            writer.add(((TileEntity)node).field_145849_e);
            this.sendPacketToServer((byte)53, writer.generate());
        } else {
            NBTTagCompound compound = PowerNodeRegistry.For(((TileEntity)node).func_145831_w()).getDataCompoundForNode(node);
            if (compound != null) {
                writer.add((byte)0);
                writer.add(compound);
                this.sendPacketToClientPlayer(player, (byte)53, writer.generate());
            }
        }
    }

    public void sendImbueToServer(TileEntityArmorImbuer tileEntity, String hoveredID) {
        AMDataWriter writer = new AMDataWriter();
        writer.add(tileEntity.field_145851_c);
        writer.add(tileEntity.field_145848_d);
        writer.add(tileEntity.field_145849_e);
        writer.add(hoveredID);
        this.sendPacketToServer((byte)54, writer.generate());
    }

    public void sendPowerRequestToServer(AMVector3 location) {
        AMDataWriter writer = new AMDataWriter();
        writer.add((byte)1);
        writer.add(location.x);
        writer.add(location.y);
        writer.add(location.z);
        this.sendPacketToServer((byte)53, writer.generate());
    }

    public void sendPowerResponseToClient(NBTTagCompound powerData, EntityPlayerMP player, TileEntity te) {
        AMDataWriter writer = new AMDataWriter();
        writer.add((byte)1);
        writer.add(powerData);
        writer.add(te.field_145851_c);
        writer.add(te.field_145848_d);
        writer.add(te.field_145849_e);
        this.sendPacketToClientPlayer(player, (byte)53, writer.generate());
    }

    public void sendCapabilityChangePacket(EntityPlayerMP player, int capability, boolean state) {
        AMDataWriter writer = new AMDataWriter();
        writer.add(capability);
        writer.add(state);
        this.sendPacketToClientPlayer(player, (byte)55, writer.generate());
    }

    public void sendExPropCommandToServer(int flag) {
        AMDataWriter writer = new AMDataWriter();
        writer.add(flag);
        this.sendPacketToServer((byte)16, writer.generate());
    }

    public void sendCompendiumUnlockPacket(EntityPlayerMP player, String id, boolean isCategory) {
        AMDataWriter writer = new AMDataWriter();
        writer.add(id);
        writer.add(isCategory);
        this.sendPacketToClientPlayer(player, (byte)46, writer.generate());
    }

    public void sendCalefactorCookUpdate(TileEntityCalefactor calefactor, byte[] data) {
        AMDataWriter writer = new AMDataWriter();
        writer.add(calefactor.field_145851_c);
        writer.add(calefactor.field_145848_d);
        writer.add(calefactor.field_145849_e);
        writer.add(data);
        this.sendPacketToAllClientsNear(calefactor.func_145831_w().field_73011_w.field_76574_g, calefactor.field_145851_c, calefactor.field_145848_d, calefactor.field_145849_e, 32.0, (byte)57, writer.generate());
    }

    public void sendObeliskUpdate(TileEntityObelisk obelisk, byte[] data) {
        AMDataWriter writer = new AMDataWriter();
        writer.add(obelisk.field_145851_c);
        writer.add(obelisk.field_145848_d);
        writer.add(obelisk.field_145849_e);
        writer.add(data);
        this.sendPacketToAllClientsNear(obelisk.func_145831_w().field_73011_w.field_76574_g, obelisk.field_145851_c, obelisk.field_145848_d, obelisk.field_145849_e, 32.0, (byte)58, writer.generate());
    }

    public void sendAffinityActivate() {
        this.sendPacketToServer((byte)59, new byte[0]);
    }

    static {
        INSTANCE = new AMNetHandler();
    }
}

