/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks.tileentities.flickers;

import am2.api.flickers.IFlickerController;
import am2.api.flickers.IFlickerFunctionality;
import am2.api.math.AMVector3;
import am2.api.spell.enums.Affinity;
import am2.blocks.BlocksCommonProxy;
import am2.items.ItemsCommonProxy;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class FlickerOperatorMoonstoneAttractor
implements IFlickerFunctionality {
    private static final ArrayList<AMVector3> attractors = new ArrayList();

    public static AMVector3 getMeteorAttractor(AMVector3 target) {
        for (AMVector3 attractor : attractors.toArray(new AMVector3[attractors.size()])) {
            if (!(attractor.distanceSqTo(target) <= 16384.0)) continue;
            return attractor.copy();
        }
        return null;
    }

    @Override
    public boolean RequiresPower() {
        return true;
    }

    @Override
    public int PowerPerOperation() {
        return 10;
    }

    @Override
    public boolean DoOperation(World worldObj, IFlickerController habitat, boolean powered) {
        AMVector3 vec = new AMVector3((TileEntity)habitat);
        if (powered) {
            if (!attractors.contains(vec)) {
                attractors.add(vec);
            }
            return true;
        }
        attractors.remove(vec);
        return false;
    }

    @Override
    public boolean DoOperation(World worldObj, IFlickerController habitat, boolean powered, Affinity[] flickers) {
        return this.DoOperation(worldObj, habitat, powered);
    }

    @Override
    public void RemoveOperator(World worldObj, IFlickerController habitat, boolean powered) {
        AMVector3 vec = new AMVector3((TileEntity)habitat);
        attractors.remove(vec);
    }

    @Override
    public int TimeBetweenOperation(boolean powered, Affinity[] flickers) {
        return 100;
    }

    @Override
    public void RemoveOperator(World worldObj, IFlickerController habitat, boolean powered, Affinity[] flickers) {
        this.RemoveOperator(worldObj, habitat, powered);
    }

    @Override
    public Object[] getRecipe() {
        Object[] objectArray = new Object[17];
        objectArray[0] = "RLR";
        objectArray[1] = "AME";
        objectArray[2] = "I T";
        objectArray[3] = Character.valueOf('R');
        objectArray[4] = new ItemStack((Item)ItemsCommonProxy.rune, 1, 11);
        objectArray[5] = Character.valueOf('L');
        objectArray[6] = new ItemStack((Item)ItemsCommonProxy.flickerJar, 1, Affinity.LIGHTNING.ordinal());
        objectArray[7] = Character.valueOf('A');
        objectArray[8] = new ItemStack((Item)ItemsCommonProxy.flickerJar, 1, Affinity.ARCANE.ordinal());
        objectArray[9] = Character.valueOf('E');
        objectArray[10] = new ItemStack((Item)ItemsCommonProxy.flickerJar, 1, Affinity.EARTH.ordinal());
        objectArray[11] = Character.valueOf('M');
        objectArray[12] = new ItemStack((Block)BlocksCommonProxy.AMOres, 1, 5);
        objectArray[13] = Character.valueOf('I');
        objectArray[14] = new ItemStack((Item)ItemsCommonProxy.essence, 1, 2);
        objectArray[15] = Character.valueOf('T');
        objectArray[16] = new ItemStack((Item)ItemsCommonProxy.essence, 1, 1);
        return objectArray;
    }
}

