/*
 * Decompiled with CFR 0.152.
 */
package am2.api.blocks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.world.World;

public class MultiblockStructureDefinition {
    private StructureGroup mainGroup;
    private ArrayList<StructureGroup> blockGroups = new ArrayList();
    private ArrayList<Integer> mutexCache = new ArrayList();
    public static final int MAINGROUP_MUTEX = 1;
    private String id;
    private int maxX = 0;
    private int minX = 0;
    private int maxY = 0;
    private int minY = 0;
    private int maxZ = 0;
    private int minZ = 0;

    public MultiblockStructureDefinition(String id) {
        this.id = id;
        this.mainGroup = this.createGroup("main", 1);
    }

    public String getID() {
        return this.id;
    }

    public ArrayList<Integer> getMutexList() {
        return this.mutexCache;
    }

    public ArrayList<StructureGroup> getGroupsForMutex(int mutex) {
        ArrayList<StructureGroup> toReturn = new ArrayList<StructureGroup>();
        for (StructureGroup group : this.blockGroups) {
            if (group.mutex != mutex) continue;
            toReturn.add(group);
        }
        return toReturn;
    }

    public ArrayList<BlockDec> getAllowedBlocksAt(StructureGroup group, BlockCoord coord) {
        return group.getAllowedBlocksAt(coord);
    }

    public ArrayList<BlockDec> getAllowedBlocksAt(BlockCoord coord) {
        return this.mainGroup.getAllowedBlocksAt(coord);
    }

    public void addAllowedBlock(int offsetX, int offsetY, int offsetZ, Block block, int meta) {
        if (offsetY > this.maxY) {
            this.maxY = offsetY;
        } else if (offsetY < this.minY) {
            this.minY = offsetY;
        }
        if (offsetX > this.maxX) {
            this.maxX = offsetX;
        } else if (offsetX < this.minX) {
            this.minX = offsetX;
        }
        if (offsetZ > this.maxZ) {
            this.maxZ = offsetZ;
        } else if (offsetZ < this.minZ) {
            this.minZ = offsetZ;
        }
        this.mainGroup.addAllowedBlock(offsetX, offsetY, offsetZ, block, meta);
    }

    public void addAllowedBlock(int offsetX, int offsetY, int offsetZ, Block block) {
        this.addAllowedBlock(offsetX, offsetY, offsetZ, block, -1);
    }

    public void addAllowedBlock(StructureGroup group, int offsetX, int offsetY, int offsetZ, Block block, int meta) {
        if (!this.blockGroups.contains(group)) {
            this.blockGroups.add(group);
        }
        if (offsetY > this.maxY) {
            this.maxY = offsetY;
        } else if (offsetY < this.minY) {
            this.minY = offsetY;
        }
        if (offsetX > this.maxX) {
            this.maxX = offsetX;
        } else if (offsetX < this.minX) {
            this.minX = offsetX;
        }
        if (offsetZ > this.maxZ) {
            this.maxZ = offsetZ;
        } else if (offsetZ < this.minZ) {
            this.minZ = offsetZ;
        }
        group.addAllowedBlock(offsetX, offsetY, offsetZ, block, meta);
    }

    public void addAllowedBlock(StructureGroup group, int offsetX, int offsetY, int offsetZ, Block block) {
        this.addAllowedBlock(group, offsetX, offsetY, offsetZ, block, -1);
    }

    public StructureGroup createGroup(String name, int mutex) {
        if (!this.mutexCache.contains(mutex)) {
            this.mutexCache.add(mutex);
        }
        StructureGroup group = new StructureGroup(name, mutex);
        this.blockGroups.add(group);
        return group;
    }

    public StructureGroup copyGroup(String originalName, String destinationName, int newMutex) {
        StructureGroup copyGroup = null;
        for (StructureGroup group : this.blockGroups) {
            if (!group.name.equals(originalName)) continue;
            copyGroup = group;
            break;
        }
        if (copyGroup == null) {
            return null;
        }
        StructureGroup newGroup = newMutex > -1 ? new StructureGroup(destinationName, newMutex) : new StructureGroup(destinationName, copyGroup.mutex);
        for (BlockCoord bc : copyGroup.allowedBlocks.keySet()) {
            for (BlockDec bd : copyGroup.allowedBlocks.get(bc)) {
                newGroup.addAllowedBlock(bc.x, bc.y, bc.z, bd.block, bd.meta);
            }
        }
        this.blockGroups.add(newGroup);
        return newGroup;
    }

    public StructureGroup copyGroup(String originalName, String destinationName) {
        return this.copyGroup(originalName, destinationName, -1);
    }

    public ArrayList<StructureGroup> getMatchedGroups(int mutex, World world, int originX, int originY, int originZ) {
        ArrayList<StructureGroup> toReturn = new ArrayList<StructureGroup>();
        for (StructureGroup group : this.blockGroups) {
            if ((group.mutex & mutex) != group.mutex || !group.matchGroup(world, originX, originY, originZ)) continue;
            toReturn.add(group);
        }
        return toReturn;
    }

    private boolean matchMutex(int mutex, World world, int originX, int originY, int originZ) {
        for (StructureGroup group : this.blockGroups) {
            if ((group.mutex & mutex) != group.mutex || !group.matchGroup(world, originX, originY, originZ)) continue;
            return true;
        }
        return false;
    }

    public boolean checkStructure(World world, int originX, int originY, int originZ) {
        int i;
        boolean valid = true;
        Iterator<Integer> iterator = this.mutexCache.iterator();
        while (iterator.hasNext() && (valid &= this.matchMutex(i = iterator.next().intValue(), world, originX, originY, originZ))) {
        }
        return valid;
    }

    public int getMinLayer() {
        return this.minY;
    }

    public int getMaxLayer() {
        return this.maxY;
    }

    public int getHeight() {
        return this.maxY - this.minY;
    }

    public int getWidth() {
        return this.maxX - this.minX;
    }

    public int getLength() {
        return this.maxZ - this.minZ;
    }

    public HashMap<BlockCoord, ArrayList<BlockDec>> getStructureLayer(int layer) {
        return this.mainGroup.getStructureLayer(layer);
    }

    public HashMap<BlockCoord, ArrayList<BlockDec>> getStructureLayer(StructureGroup group, int layer) {
        return group.getStructureLayer(layer);
    }

    public void removeMutex(int mutex, World world, int x, int y, int z) {
        for (StructureGroup group : this.blockGroups) {
            if (group.mutex != mutex) continue;
            group.deleteBlocksFromWorld(world, x, y, z);
        }
    }

    public class StructureGroup {
        String name;
        int mutex;
        HashMap<BlockCoord, ArrayList<BlockDec>> allowedBlocks;

        public StructureGroup(String name, int mutex) {
            this.name = name;
            this.mutex = mutex;
            this.allowedBlocks = new HashMap();
        }

        void addAllowedBlock(int offsetX, int offsetY, int offsetZ, Block block, int meta) {
            BlockCoord originOffset = new BlockCoord(offsetX, offsetY, offsetZ);
            if (!this.allowedBlocks.containsKey(originOffset)) {
                this.allowedBlocks.put(originOffset, new ArrayList());
            }
            ArrayList<BlockDec> positionReplacements = this.allowedBlocks.get(originOffset);
            positionReplacements.add(new BlockDec(block, meta));
        }

        ArrayList<BlockDec> getAllowedBlocksAt(BlockCoord coord) {
            return this.allowedBlocks.get(coord);
        }

        boolean matchGroup(World world, int originX, int originY, int originZ) {
            for (BlockCoord offset : this.allowedBlocks.keySet()) {
                Block block = world.func_147439_a(originX + offset.x, originY + offset.y, originZ + offset.z);
                int meta = world.func_72805_g(originX + offset.x, originY + offset.y, originZ + offset.z);
                ArrayList<BlockDec> positionReplacements = this.allowedBlocks.get(offset);
                boolean valid = false;
                for (BlockDec bd : positionReplacements) {
                    if (bd.block != block || bd.meta != -1 && bd.meta != meta) continue;
                    valid = true;
                }
                if (valid) continue;
                return false;
            }
            return true;
        }

        HashMap<BlockCoord, ArrayList<BlockDec>> getStructureLayer(int layer) {
            HashMap<BlockCoord, ArrayList<BlockDec>> toReturn = new HashMap<BlockCoord, ArrayList<BlockDec>>();
            if (layer > MultiblockStructureDefinition.this.getMaxLayer() || layer < MultiblockStructureDefinition.this.getMinLayer()) {
                return toReturn;
            }
            for (BlockCoord bc : this.allowedBlocks.keySet()) {
                if (bc.y != layer) continue;
                toReturn.put(bc, this.allowedBlocks.get(bc));
            }
            return toReturn;
        }

        public void replaceAllBlocksOfType(Block originalBlock, Block newBlock) {
            this.replaceAllBlocksOfType(originalBlock, -1, newBlock, -1);
        }

        public void replaceAllBlocksOfType(Block originalBlock, int originalMeta, Block newBlock, int newMeta) {
            for (BlockCoord bc : this.allowedBlocks.keySet()) {
                for (BlockDec bd : this.allowedBlocks.get(bc)) {
                    if (bd.block != originalBlock || bd.meta != originalMeta && originalMeta != -1) continue;
                    bd.block = newBlock;
                    if (newMeta == -1) continue;
                    bd.meta = newMeta;
                }
            }
        }

        public HashMap<BlockCoord, ArrayList<BlockDec>> getAllowedBlocks() {
            return (HashMap)this.allowedBlocks.clone();
        }

        public void deleteBlocksFromWorld(World world, int x, int y, int z) {
            for (BlockCoord offset : this.allowedBlocks.keySet()) {
                world.func_147468_f(x + offset.x, y + offset.y, z + offset.z);
            }
        }
    }

    public class BlockCoord
    implements Comparable<BlockCoord> {
        public int x;
        public int y;
        public int z;

        public BlockCoord(int offsetX, int offsetY, int offsetZ) {
            this.x = offsetX;
            this.y = offsetY;
            this.z = offsetZ;
        }

        public boolean equals(Object obj) {
            if (obj instanceof BlockCoord) {
                return this.x == ((BlockCoord)obj).x && this.y == ((BlockCoord)obj).y && this.z == ((BlockCoord)obj).z;
            }
            return false;
        }

        public int hashCode() {
            return this.x + this.y + this.z;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getZ() {
            return this.z;
        }

        public String toString() {
            return String.format("BlockCoord: %d, %d, %d", this.x, this.y, this.z);
        }

        @Override
        public int compareTo(BlockCoord o) {
            return this.z > o.z ? 1 : (this.z < o.z ? -1 : (this.x > o.x ? 1 : (this.x < o.x ? -1 : (this.y > o.y ? 1 : (this.y < o.y ? -1 : 0)))));
        }
    }

    public class BlockDec {
        Block block;
        int meta;

        public BlockDec(Block block, int meta) {
            this.block = block;
            this.meta = meta;
        }

        public Block getBlock() {
            return this.block;
        }

        public int getMeta() {
            return this.meta;
        }

        public String toString() {
            String blockName = "";
            blockName = this.block != null ? this.block.func_149732_F() : "Unknown";
            return String.format("Block: %s, meta: %d", blockName, this.meta);
        }

        public boolean equals(Object obj) {
            if (obj instanceof BlockDec) {
                return this.block == ((BlockDec)obj).block && (this.meta == -1 || ((BlockDec)obj).meta == -1 || this.meta == ((BlockDec)obj).meta);
            }
            return false;
        }

        public int hashCode() {
            return Block.func_149682_b((Block)this.block);
        }
    }
}

