/*
 * Decompiled with CFR 0.152.
 */
package am2;

import am2.AMCore;
import am2.blocks.BlocksCommonProxy;
import am2.items.ItemsCommonProxy;
import am2.particles.AMParticle;
import am2.particles.ParticleArcToEntity;
import am2.particles.ParticleColorShift;
import am2.particles.ParticleHoldPosition;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBook;
import net.minecraft.item.ItemStack;

public class ItemFrameWatcher {
    private final HashMap<EntityItemFrameComparator, Integer> watchedFrames = new HashMap();
    private final ArrayList<EntityItemFrameComparator> queuedAddFrames = new ArrayList();
    private final ArrayList<EntityItemFrameComparator> queuedRemoveFrames = new ArrayList();
    private static final int processTime = 800;

    public void checkWatchedFrames() {
        ArrayList<EntityItemFrameComparator> toRemove = new ArrayList<EntityItemFrameComparator>();
        this.updateQueuedChanges();
        for (EntityItemFrameComparator frameComp : this.watchedFrames.keySet()) {
            Integer time = this.watchedFrames.get(frameComp);
            if (time == null) {
                time = 0;
            }
            if (frameComp == null || frameComp.frame == null || ((EntityItemFrameComparator)frameComp).frame.field_70170_p == null) continue;
            if (!((EntityItemFrameComparator)frameComp).frame.field_70170_p.field_72995_K || time >= 800) {
                toRemove.add(frameComp);
            }
            if (this.frameIsValid(frameComp.frame)) {
                if (this.checkFrameRadius(frameComp)) continue;
                toRemove.remove(frameComp);
                continue;
            }
            Integer n = time;
            Integer n2 = time = Integer.valueOf(time + 1);
            this.watchedFrames.put(frameComp, time);
        }
        for (EntityItemFrameComparator frame : toRemove) {
            this.stopWatchingFrame(frame.frame);
        }
    }

    private boolean checkFrameRadius(EntityItemFrameComparator frameComp) {
        int radius = 2;
        boolean shouldRemove = true;
        EntityItemFrame frame = frameComp.frame;
        for (int i = -radius; i <= radius; ++i) {
            for (int j = -radius; j <= radius; ++j) {
                for (int k = -radius; k <= radius; ++k) {
                    if (frame.field_70170_p.func_147439_a((int)frame.field_70165_t + i, (int)frame.field_70163_u + j, (int)frame.field_70161_v + k) != BlocksCommonProxy.liquidEssence) continue;
                    Integer time = this.watchedFrames.get(frameComp);
                    if (time == null) {
                        time = 0;
                    }
                    Integer n = time;
                    Integer n2 = time = Integer.valueOf(time + 1);
                    this.watchedFrames.put(frameComp, time);
                    if (time >= 800) {
                        if (frame.field_70170_p.field_72995_K) continue;
                        frame.func_82334_a(new ItemStack((Item)ItemsCommonProxy.arcaneCompendium));
                        return true;
                    }
                    shouldRemove = false;
                    if (!frame.field_70170_p.field_72995_K) continue;
                    this.spawnCompendiumProgressParticles(frame, (int)frame.field_70165_t + i, (int)frame.field_70163_u + j, (int)frame.field_70161_v + k);
                }
            }
        }
        return shouldRemove;
    }

    private boolean frameIsValid(EntityItemFrame frame) {
        return frame != null && !frame.field_70128_L && frame.func_82335_i() != null && frame.func_82335_i().func_77973_b() instanceof ItemBook;
    }

    private void updateQueuedChanges() {
        EntityItemFrameComparator[] toAdd = this.queuedAddFrames.toArray(new EntityItemFrameComparator[this.queuedAddFrames.size()]);
        this.queuedAddFrames.clear();
        for (EntityItemFrameComparator comp : toAdd) {
            if (comp.frame.func_82335_i() != null && comp.frame.func_82335_i().func_77973_b() == ItemsCommonProxy.arcaneCompendium) continue;
            this.watchedFrames.put(comp, 0);
        }
        EntityItemFrameComparator[] toRemove = this.queuedRemoveFrames.toArray(new EntityItemFrameComparator[this.queuedRemoveFrames.size()]);
        this.queuedRemoveFrames.clear();
        for (EntityItemFrameComparator comp : toRemove) {
            Integer time = this.watchedFrames.get(comp);
            if (time != null && time >= 800 && comp.frame != null && !((EntityItemFrameComparator)comp).frame.field_70128_L && ((EntityItemFrameComparator)comp).frame.field_70170_p.field_72995_K && comp.frame.func_82335_i() != null && (comp.frame.func_82335_i().func_77973_b() == Items.field_151122_aG || comp.frame.func_82335_i().func_77973_b() == ItemsCommonProxy.arcaneCompendium)) {
                this.spawnCompendiumCompleteParticles(comp.frame);
            }
            this.watchedFrames.remove(comp);
        }
    }

    public void startWatchingFrame(EntityItemFrame frame) {
        this.queuedAddFrames.add(new EntityItemFrameComparator(frame));
    }

    public void stopWatchingFrame(EntityItemFrame frame) {
        this.queuedRemoveFrames.add(new EntityItemFrameComparator(frame));
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnCompendiumProgressParticles(EntityItemFrame frame, int x, int y, int z) {
        AMParticle particle = (AMParticle)((Object)AMCore.proxy.particleManager.spawn(frame.field_70170_p, "symbols", (double)x + 0.5, (double)y + 0.5, (double)z + 0.5));
        if (particle != null) {
            particle.setIgnoreMaxAge(true);
            particle.AddParticleController(new ParticleArcToEntity(particle, 1, (Entity)frame, false).SetSpeed(0.02f).setKillParticleOnFinish(true));
            particle.setRandomScale(0.05f, 0.12f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnCompendiumCompleteParticles(EntityItemFrame frame) {
        AMParticle particle = (AMParticle)((Object)AMCore.proxy.particleManager.spawn(frame.field_70170_p, "radiant", frame.field_70165_t, frame.field_70163_u, frame.field_70161_v));
        if (particle != null) {
            particle.setIgnoreMaxAge(false);
            particle.setMaxAge(40);
            particle.setParticleScale(0.3f);
            particle.AddParticleController(new ParticleHoldPosition(particle, 40, 1, false));
            particle.AddParticleController(new ParticleColorShift(particle, 1, false).SetShiftSpeed(0.2f));
        }
    }

    private class EntityItemFrameComparator {
        private final EntityItemFrame frame;

        public EntityItemFrameComparator(EntityItemFrame frame) {
            this.frame = frame;
        }

        public boolean equals(Object obj) {
            if (this.frame == null) {
                return false;
            }
            if (obj instanceof EntityItemFrame) {
                return ((EntityItemFrame)obj).func_145782_y() == this.frame.func_145782_y() && ((EntityItemFrame)obj).field_70170_p.field_72995_K == this.frame.field_70170_p.field_72995_K;
            }
            if (obj instanceof EntityItemFrameComparator) {
                return ((EntityItemFrameComparator)obj).frame.func_145782_y() == this.frame.func_145782_y() && ((EntityItemFrameComparator)obj).frame.field_70170_p.field_72995_K == this.frame.field_70170_p.field_72995_K;
            }
            return false;
        }

        public int hashCode() {
            if (this.frame == null || this.frame.field_70170_p == null) {
                return 0;
            }
            return this.frame.func_145782_y() + (this.frame.field_70170_p.field_72995_K ? 1 : 2);
        }
    }
}

