/*
 * Decompiled with CFR 0.152.
 */
package am2;

import am2.AMChunkLoader;
import am2.LogHelper;
import am2.ObeliskFuelHelper;
import am2.api.ArsMagicaApi;
import am2.api.flickers.IFlickerFunctionality;
import am2.api.spell.enums.Affinity;
import am2.armor.infusions.ImbuementRegistry;
import am2.blocks.RecipesEssenceRefiner;
import am2.blocks.liquid.BlockLiquidEssence;
import am2.blocks.tileentities.flickers.FlickerOperatorButchery;
import am2.blocks.tileentities.flickers.FlickerOperatorContainment;
import am2.blocks.tileentities.flickers.FlickerOperatorFelledOak;
import am2.blocks.tileentities.flickers.FlickerOperatorFishing;
import am2.blocks.tileentities.flickers.FlickerOperatorFlatLands;
import am2.blocks.tileentities.flickers.FlickerOperatorGentleRains;
import am2.blocks.tileentities.flickers.FlickerOperatorInterdiction;
import am2.blocks.tileentities.flickers.FlickerOperatorItemTransport;
import am2.blocks.tileentities.flickers.FlickerOperatorLight;
import am2.blocks.tileentities.flickers.FlickerOperatorMoonstoneAttractor;
import am2.blocks.tileentities.flickers.FlickerOperatorNaturesBounty;
import am2.blocks.tileentities.flickers.FlickerOperatorPackedEarth;
import am2.blocks.tileentities.flickers.FlickerOperatorProgeny;
import am2.blocks.tileentities.flickers.FlickerOperatorRegistry;
import am2.buffs.BuffList;
import am2.commands.ClearKnownSpellParts;
import am2.commands.DumpNBT;
import am2.commands.Explosions;
import am2.commands.FillManaBarCommand;
import am2.commands.GiveSkillPoints;
import am2.commands.RecoverKeystoneCommand;
import am2.commands.RegisterTeamHostilityCommand;
import am2.commands.ReloadSkillTree;
import am2.commands.Respec;
import am2.commands.SetAffinityCommand;
import am2.commands.SetMagicLevelCommand;
import am2.commands.ShiftAffinityCommand;
import am2.commands.TakeSkillPoints;
import am2.commands.UnlockAugmentedCastingCommand;
import am2.commands.UnlockCompendiumEntry;
import am2.configuration.AMConfig;
import am2.configuration.SkillConfiguration;
import am2.enchantments.AMEnchantmentHelper;
import am2.entities.EntityManager;
import am2.entities.SpawnBlacklists;
import am2.interop.TC4Interop;
import am2.items.ItemsCommonProxy;
import am2.network.AMNetHandler;
import am2.network.SeventhSanctum;
import am2.power.PowerNodeCache;
import am2.proxy.CommonProxy;
import am2.spell.SkillManager;
import am2.spell.SkillTreeManager;
import am2.spell.SpellUtils;
import am2.utility.KeystoneUtilities;
import am2.worldgen.BiomeWitchwoodForest;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import java.io.File;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandManager;
import net.minecraft.command.ServerCommandManager;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;

@Mod(modid="arsmagica2", modLanguage="java", name="Ars Magica 2", version="1.4.0.009", dependencies="required-after:AnimationAPI")
public class AMCore {
    @Mod.Instance(value="arsmagica2")
    public static AMCore instance;
    @SidedProxy(clientSide="am2.proxy.ClientProxy", serverSide="am2.proxy.CommonProxy")
    public static CommonProxy proxy;
    public static AMConfig config;
    public static SkillConfiguration skillConfig;
    public static final int ANY_META = Short.MAX_VALUE;
    private String compendiumBase;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        String configBase = event.getSuggestedConfigurationFile().getAbsolutePath();
        configBase = this.popPathFolder(configBase);
        this.compendiumBase = this.popPathFolder(configBase);
        configBase = configBase + File.separatorChar + "AM2" + File.separatorChar;
        config = new AMConfig(new File(configBase + File.separatorChar + "AM2.cfg"));
        skillConfig = new SkillConfiguration(new File(configBase + "SkillConf.cfg"));
        AMNetHandler.INSTANCE.init();
        proxy.InitializeAndRegisterHandlers();
        proxy.preinit();
    }

    private String popPathFolder(String path) {
        int lastIndex = path.lastIndexOf(File.separatorChar);
        if (lastIndex == -1) {
            lastIndex = path.length() - 1;
        }
        return path.substring(0, lastIndex);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        FMLInterModComms.sendMessage((String)"Waila", (String)"register", (String)"am2.interop.WailaSupport.callbackRegister");
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)this, (ForgeChunkManager.LoadingCallback)AMChunkLoader.INSTANCE);
        proxy.init();
        this.initAPI();
        if (config.getEnableWitchwoodForest()) {
            BiomeDictionary.registerBiomeType((BiomeGenBase)BiomeWitchwoodForest.instance, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.MAGICAL});
            BiomeManager.warmBiomes.add(new BiomeManager.BiomeEntry(BiomeWitchwoodForest.instance, 6));
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        this.registerFlickerOperators();
        proxy.setCompendiumSaveBase(this.compendiumBase);
        proxy.postinit();
        if (config.retroactiveWorldgen()) {
            LogHelper.info("Retroactive Worldgen is enabled", new Object[0]);
        }
        FluidContainerRegistry.registerFluidContainer((FluidContainerRegistry.FluidContainerData)new FluidContainerRegistry.FluidContainerData(FluidRegistry.getFluidStack((String)BlockLiquidEssence.liquidEssenceFluid.getName(), (int)1000), new ItemStack((Item)ItemsCommonProxy.itemAMBucket), FluidContainerRegistry.EMPTY_BUCKET));
        SeventhSanctum.instance.init();
        if (Loader.isModLoaded((String)"Thaumcraft")) {
            TC4Interop.initialize();
        }
    }

    private void registerFlickerOperators() {
        FlickerOperatorRegistry.instance.registerFlickerOperator((IFlickerFunctionality)new FlickerOperatorItemTransport(), Affinity.AIR);
        FlickerOperatorRegistry.instance.registerFlickerOperator((IFlickerFunctionality)new FlickerOperatorButchery(), Affinity.FIRE, Affinity.LIFE);
        FlickerOperatorRegistry.instance.registerFlickerOperator((IFlickerFunctionality)new FlickerOperatorContainment(), Affinity.AIR, Affinity.ENDER);
        FlickerOperatorRegistry.instance.registerFlickerOperator((IFlickerFunctionality)new FlickerOperatorFelledOak(), Affinity.NATURE, Affinity.LIGHTNING);
        FlickerOperatorRegistry.instance.registerFlickerOperator((IFlickerFunctionality)new FlickerOperatorFlatLands(), Affinity.EARTH, Affinity.ICE);
        FlickerOperatorRegistry.instance.registerFlickerOperator((IFlickerFunctionality)new FlickerOperatorGentleRains(), Affinity.WATER);
        FlickerOperatorRegistry.instance.registerFlickerOperator((IFlickerFunctionality)new FlickerOperatorInterdiction(), Affinity.AIR, Affinity.ARCANE);
        FlickerOperatorRegistry.instance.registerFlickerOperator((IFlickerFunctionality)new FlickerOperatorLight(), Affinity.FIRE, Affinity.LIGHTNING);
        FlickerOperatorRegistry.instance.registerFlickerOperator((IFlickerFunctionality)new FlickerOperatorMoonstoneAttractor(), Affinity.LIGHTNING, Affinity.ARCANE, Affinity.EARTH);
        FlickerOperatorRegistry.instance.registerFlickerOperator((IFlickerFunctionality)new FlickerOperatorNaturesBounty(), Affinity.NATURE, Affinity.WATER, Affinity.LIFE);
        FlickerOperatorRegistry.instance.registerFlickerOperator((IFlickerFunctionality)new FlickerOperatorPackedEarth(), Affinity.EARTH);
        FlickerOperatorRegistry.instance.registerFlickerOperator((IFlickerFunctionality)new FlickerOperatorProgeny(), Affinity.LIFE);
        FlickerOperatorRegistry.instance.registerFlickerOperator((IFlickerFunctionality)new FlickerOperatorFishing(), Affinity.WATER, Affinity.NATURE);
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        ICommandManager commandManager = event.getServer().func_71187_D();
        ServerCommandManager serverCommandManager = (ServerCommandManager)commandManager;
        serverCommandManager.func_71560_a((ICommand)new SetMagicLevelCommand());
        serverCommandManager.func_71560_a((ICommand)new UnlockAugmentedCastingCommand());
        serverCommandManager.func_71560_a((ICommand)new SetAffinityCommand());
        serverCommandManager.func_71560_a((ICommand)new ShiftAffinityCommand());
        serverCommandManager.func_71560_a((ICommand)new RecoverKeystoneCommand());
        serverCommandManager.func_71560_a((ICommand)new RegisterTeamHostilityCommand());
        serverCommandManager.func_71560_a((ICommand)new FillManaBarCommand());
        serverCommandManager.func_71560_a((ICommand)new ReloadSkillTree());
        serverCommandManager.func_71560_a((ICommand)new GiveSkillPoints());
        serverCommandManager.func_71560_a((ICommand)new TakeSkillPoints());
        serverCommandManager.func_71560_a((ICommand)new ClearKnownSpellParts());
        serverCommandManager.func_71560_a((ICommand)new Explosions());
        serverCommandManager.func_71560_a((ICommand)new DumpNBT());
        serverCommandManager.func_71560_a((ICommand)new Respec());
        serverCommandManager.func_71560_a((ICommand)new UnlockCompendiumEntry());
    }

    @Mod.EventHandler
    public void serverStopping(FMLServerStoppingEvent event) {
        for (WorldServer ws : MinecraftServer.func_71276_C().field_71305_c) {
            PowerNodeCache.instance.saveWorldToFile((World)ws);
        }
    }

    @Mod.EventHandler
    public void onIMCReceived(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage msg : event.getMessages()) {
            String[] split;
            if (msg.key == "dsb") {
                LogHelper.info("Received dimension spawn blacklist IMC!  Processing.", new Object[0]);
                split = msg.getStringValue().split("|");
                if (split.length != 2) {
                    LogHelper.warn("Could not parse dsb IMC - malformed identifiers!  Syntax is 'ClassName|DimensionID', for example:  EntityDryad|22", new Object[0]);
                    continue;
                }
                try {
                    SpawnBlacklists.addBlacklistedDimensionSpawn(split[0], Integer.parseInt(split[1]));
                }
                catch (NumberFormatException nex) {
                    LogHelper.warn("Could not parse dsb IMC - improper dimension ID (not a number)!  Syntax is 'ClassName|DimensionID', for example:  EntityDryad|22", new Object[0]);
                }
                continue;
            }
            if (msg.key == "bsb") {
                LogHelper.info("Received biome spawn blacklist IMC!  Processing.", new Object[0]);
                split = msg.getStringValue().split("|");
                if (split.length != 2) {
                    LogHelper.warn("Could not parse bsb IMC - malformed identifiers!  Syntax is 'ClassName|BiomeID', for example:  EntityDryad|22", new Object[0]);
                    continue;
                }
                try {
                    SpawnBlacklists.addBlacklistedBiomeSpawn(split[0], Integer.parseInt(split[1]));
                }
                catch (NumberFormatException nex) {
                    LogHelper.warn("Could not parse bsb IMC - improper biome ID (not a number)!  Syntax is 'ClassName|BiomeID', for example:  EntityDryad|22", new Object[0]);
                }
                continue;
            }
            if (msg.key == "dwg") {
                LogHelper.info("Received dimension worldgen blacklist IMC!  Processing.", new Object[0]);
                try {
                    SpawnBlacklists.addBlacklistedDimensionForWorldgen(Integer.parseInt(msg.getStringValue()));
                }
                catch (NumberFormatException nex) {
                    LogHelper.warn("Could not parse dwg IMC - improper dimension ID (not a number)!  Syntax is 'dimensionID', for example:  2", new Object[0]);
                }
                continue;
            }
            if (msg.key != "adb") continue;
            LogHelper.info("Received dispel blacklist IMC!  Processing.", new Object[0]);
            try {
                BuffList.instance.addDispelExclusion(Integer.parseInt(msg.getStringValue()));
            }
            catch (NumberFormatException nex) {
                LogHelper.warn("Could not parse adb IMC - improper potion ID (not a number)!  Syntax is 'potionID', for example:  10", new Object[0]);
            }
        }
    }

    public void initAPI() {
        LogHelper.info("Initializing API Hooks...", new Object[0]);
        ArsMagicaApi.instance.setSpellPartManager(SkillManager.instance);
        ArsMagicaApi.instance.setEnchantmentHelper(new AMEnchantmentHelper());
        ArsMagicaApi.instance.setSkillTreeManager(SkillTreeManager.instance);
        ArsMagicaApi.instance.setKeystoneHelper(KeystoneUtilities.instance);
        ArsMagicaApi.instance.setEntityManager(EntityManager.instance);
        ArsMagicaApi.instance.setObeliskFuelHelper(ObeliskFuelHelper.instance);
        ArsMagicaApi.instance.setFlickerOperatorRegistry(FlickerOperatorRegistry.instance);
        ArsMagicaApi.instance.setInfusionRegistry(ImbuementRegistry.instance);
        ArsMagicaApi.instance.setEssenceRecipeHandler(RecipesEssenceRefiner.essenceRefinement());
        ArsMagicaApi.instance.setColourblindMode(config.colourblindMode());
        ArsMagicaApi.instance.setBuffHelper(BuffList.instance);
        ArsMagicaApi.instance.setSpellUtils(SpellUtils.instance);
        ArsMagicaApi.instance.setAffinityDataID("AffinityData");
        ArsMagicaApi.instance.setSkillDataID("SpellKnowledgeData");
        ArsMagicaApi.instance.setExtendedPropertiesID("ArsMagicaExProps");
        ArsMagicaApi.instance.setRiftStorageID("ArsMagicaVoidStorage");
        LogHelper.info("Finished API Initialization", new Object[0]);
    }

    public String getVersion() {
        Mod modclass = this.getClass().getAnnotation(Mod.class);
        return modclass.version();
    }
}

