/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.planets.venus.worldgen.blazepit;

import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.core.world.gen.StructureComponentGC;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import stevekung.mods.moreplanets.planets.venus.blocks.VenusBlocks;

public class ComponentVenusianBlazePitRoom
extends StructureComponentGC {
    public int corridorCount;
    public int originalFourCorridorLength;
    public int bossEntryCorridor;
    public int bossEntryCount;
    private int averageGroundLevel = -1;
    private final int height;
    private final int width;

    public ComponentVenusianBlazePitRoom(int type, World world, Random par2Random, int x, int y, int z, int height, int width, int cbm) {
        super(type);
        this.setCoordBaseMode(cbm);
        this.height = height;
        this.width = width;
        this.field_74887_e = StructureComponentGC.getComponentToAddBoundingBox((int)x, (int)(78 - this.height), (int)z, (int)0, (int)0, (int)0, (int)7, (int)this.height, (int)7, (int)cbm);
    }

    public void func_74861_a(StructureComponent par1StructureComponent, List par2List, Random par3Random) {
        for (int var4 = 0; var4 < 4; ++var4) {
            int[] var5 = this.getValidOpening(par3Random, var4);
            this.makeCorridor(par2List, par3Random, 1, var5[0], var5[1], var5[2], this.width, 7, var4);
        }
    }

    public int[] getValidOpening(Random var1, int var2) {
        if (var2 == 0) {
            return new int[]{this.width - 1, 0, 1};
        }
        if (var2 == 1) {
            return new int[]{1, 0, this.width - 1};
        }
        if (var2 == 2) {
            return new int[]{0, 0, 1};
        }
        if (var2 == 3) {
            return new int[]{1, 0, 0};
        }
        return new int[]{0, 0, 0};
    }

    public boolean makeCorridor(List list, Random random, int type, int x, int y, int z, int width, int height, int cbm) {
        int var10 = (this.getCoordBaseMode() + cbm) % 4;
        this.offsetCorridorCoords(x, y, z, width, var10);
        return true;
    }

    protected int[] offsetCorridorCoords(int x, int y, int z, int width, int cbm) {
        int[] nArray;
        int var6 = this.func_74865_a(x, z);
        int var7 = this.func_74862_a(y);
        int var8 = this.func_74873_b(x, z);
        if (cbm == 0) {
            int[] nArray2 = new int[3];
            nArray2[0] = var6 + 1;
            nArray2[1] = var7 - 1;
            nArray = nArray2;
            nArray2[2] = var8 - width / 2;
        } else if (cbm == 1) {
            int[] nArray3 = new int[3];
            nArray3[0] = var6 + width / 2;
            nArray3[1] = var7 - 1;
            nArray = nArray3;
            nArray3[2] = var8 + 1;
        } else if (cbm == 2) {
            int[] nArray4 = new int[3];
            nArray4[0] = var6 - 1;
            nArray4[1] = var7 - 1;
            nArray = nArray4;
            nArray4[2] = var8 + width / 2;
        } else if (cbm == 3) {
            int[] nArray5 = new int[3];
            nArray5[0] = var6 - width / 2;
            nArray5[1] = var7 - 1;
            nArray = nArray5;
            nArray5[2] = var8 - 1;
        } else {
            int[] nArray6 = new int[3];
            nArray6[0] = x;
            nArray6[1] = y;
            nArray = nArray6;
            nArray6[2] = z;
        }
        return nArray;
    }

    public boolean func_74875_a(World world, Random rand, StructureBoundingBox box) {
        if (this.averageGroundLevel < 0) {
            this.averageGroundLevel = this.getAverageGroundLevel(world, box);
            if (this.averageGroundLevel < 0) {
                return true;
            }
            this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78894_e + 3, 0);
        }
        this.makeWallsDown(world);
        this.makePlatforms(world, rand);
        this.makeWallsFlat(world);
        return true;
    }

    public void makeWallsDown(World world) {
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < 7; ++x) {
                for (int z = 0; z < 7; ++z) {
                    if (!(x != 0 && x != 6 && z != 0 && z != 6 || y != 0 && y <= 0)) {
                        this.func_151550_a(world, VenusBlocks.venus_block, 14, x, y, z, this.func_74874_b());
                        continue;
                    }
                    this.func_151550_a(world, Blocks.field_150350_a, 0, x, y, z, this.func_74874_b());
                }
            }
        }
    }

    public void makeWallsFlat(World world) {
        for (int y = 0; y > -1; --y) {
            for (int x = 0; x < 1; ++x) {
                for (int z = 0; z < 1; ++z) {
                    for (int i = -2; i < 7; ++i) {
                        for (int j = -2; j < 7; ++j) {
                            if (world.func_147439_a(this.func_74874_b().field_78897_a + x + i, this.func_74874_b().field_78895_b + y, this.func_74874_b().field_78896_c + z + j) != Blocks.field_150350_a) continue;
                            this.func_151550_a(world, VenusBlocks.venus_block, 14, x + i, y, z + j, this.func_74874_b());
                        }
                    }
                }
            }
        }
    }

    public void makePlatforms(World world, Random rand) {
        for (int y = this.height - 1; y > 0; --y) {
            for (int x = 0; x < this.width; ++x) {
                for (int z = 0; z < this.width; ++z) {
                    if (y % 4 != 0 || rand.nextInt(20) != 0) continue;
                    for (int i = -2; i < 2; ++i) {
                        for (int j = -2; j < 2; ++j) {
                            if (world.func_147439_a(this.func_74874_b().field_78897_a + x + i, this.func_74874_b().field_78895_b + y, this.func_74874_b().field_78896_c + z + j) == Blocks.field_150350_a) {
                                this.func_151550_a(world, VenusBlocks.venus_block, 14, x + i, y, z + j, this.func_74874_b());
                            }
                            if (y > 0) {
                                this.func_151550_a(world, Blocks.field_150350_a, 0, x - 2, y, z - 2, this.func_74874_b());
                                this.func_151550_a(world, Blocks.field_150350_a, 0, x + 1, y, z - 2, this.func_74874_b());
                                this.func_151550_a(world, Blocks.field_150350_a, 0, x - 2, y, z + 1, this.func_74874_b());
                                this.func_151550_a(world, Blocks.field_150350_a, 0, x + 1, y, z + 1, this.func_74874_b());
                            }
                            if (rand.nextInt(5) != 0 || world.func_147439_a(this.func_74874_b().field_78897_a + x + i, this.func_74874_b().field_78895_b + y + 1, this.func_74874_b().field_78896_c + z + j) != Blocks.field_150350_a || world.func_147439_a(this.func_74874_b().field_78897_a + x + i, this.func_74874_b().field_78895_b + y, this.func_74874_b().field_78896_c + z + j) != VenusBlocks.venus_block) continue;
                            this.func_151550_a(world, VenusBlocks.venusian_blaze_egg, 0, x + i, y + 1, z + j, this.func_74874_b());
                        }
                    }
                    if (rand.nextInt(10) != 0 || x <= 0 || x >= 7 || z <= 0 || z >= 7 || world.func_147439_a(this.func_74874_b().field_78897_a + x, this.func_74874_b().field_78895_b + y + 1, this.func_74874_b().field_78896_c + z) != Blocks.field_150350_a) continue;
                    this.func_151550_a(world, VenusBlocks.venusian_blaze_egg, 0, x, y + 2, z, this.func_74874_b());
                }
            }
        }
    }

    protected int getAverageGroundLevel(World par1World, StructureBoundingBox par2StructureBoundingBox) {
        int var3 = 0;
        int var4 = 0;
        for (int var5 = this.field_74887_e.field_78896_c; var5 <= this.field_74887_e.field_78892_f; ++var5) {
            for (int var6 = this.field_74887_e.field_78897_a; var6 <= this.field_74887_e.field_78893_d; ++var6) {
                if (!par2StructureBoundingBox.func_78890_b(var6, 64, var5)) continue;
                var3 += Math.max(par1World.func_72825_h(var6, var5), par1World.field_73011_w.func_76557_i());
                ++var4;
            }
        }
        if (var4 == 0) {
            return -1;
        }
        return var3 / var4;
    }

    protected void func_143012_a(NBTTagCompound nbttagcompound) {
    }

    protected void func_143011_b(NBTTagCompound nbttagcompound) {
    }
}

