/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.planets.venus.items;

import cpw.mods.fml.common.versioning.ArtifactVersion;
import cpw.mods.fml.common.versioning.DefaultArtifactVersion;
import cpw.mods.fml.common.versioning.VersionParser;
import cpw.mods.fml.relauncher.FMLInjectionData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.IElectricItemManager;
import java.util.List;
import micdoodle8.mods.galacticraft.api.item.ElectricItemHelper;
import micdoodle8.mods.galacticraft.api.item.IItemElectric;
import micdoodle8.mods.galacticraft.core.energy.EnergyConfigHandler;
import micdoodle8.mods.galacticraft.core.energy.EnergyDisplayHelper;
import micdoodle8.mods.galacticraft.core.energy.item.ElectricItemManagerIC2;
import micdoodle8.mods.galacticraft.core.energy.item.ElectricItemManagerIC2_1710;
import micdoodle8.mods.galacticraft.core.items.ItemBatteryInfinite;
import micdoodle8.mods.galacticraft.core.proxy.ClientProxyCore;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import stevekung.mods.moreplanets.core.MorePlanetsCore;

public abstract class ItemElectricArmorMP
extends ItemArmor
implements IItemElectric {
    private static Object itemManagerIC2;
    public float transferMax;
    private DefaultArtifactVersion mcVersion = null;

    public ItemElectricArmorMP(ItemArmor.ArmorMaterial material, int render, int type) {
        super(material, render, type);
        this.func_77625_d(1);
        this.func_77656_e(100);
        this.setNoRepair();
        this.setMaxTransfer();
        this.mcVersion = new DefaultArtifactVersion((String)FMLInjectionData.data()[4]);
        if (EnergyConfigHandler.isIndustrialCraft2Loaded()) {
            itemManagerIC2 = VersionParser.parseRange((String)"[1.7.2]").containsVersion((ArtifactVersion)this.mcVersion) ? new ElectricItemManagerIC2() : new ElectricItemManagerIC2_1710();
        }
    }

    protected void setMaxTransfer() {
        this.transferMax = 200.0f;
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean advanced) {
        EnumChatFormatting color = null;
        float joules = this.getElectricityStored(itemStack);
        color = joules <= this.getMaxElectricityStored(itemStack) / 3.0f ? EnumChatFormatting.DARK_RED : (joules > this.getMaxElectricityStored(itemStack) * 2.0f / 3.0f ? EnumChatFormatting.DARK_GREEN : EnumChatFormatting.GOLD);
        list.add(color + EnergyDisplayHelper.getEnergyDisplayS((float)joules) + "/" + EnergyDisplayHelper.getEnergyDisplayS((float)this.getMaxElectricityStored(itemStack)));
    }

    public void func_77622_d(ItemStack itemStack, World par2World, EntityPlayer par3EntityPlayer) {
        this.setElectricity(itemStack, 0.0f);
    }

    public CreativeTabs func_77640_w() {
        return MorePlanetsCore.mpArmorTab;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack itemStack) {
        return ClientProxyCore.galacticraftItem;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a(this.func_77658_a().replace("item.", this.getTextureLocation() + ":"));
    }

    public boolean func_82789_a(ItemStack itemStack, ItemStack itemStack2) {
        if (this.getRepairItems() == null && this.getRepairItemsMetadata() == -1) {
            return false;
        }
        return itemStack2.func_77973_b() == this.getRepairItems() && itemStack2.func_77960_j() == this.getRepairItemsMetadata();
    }

    public float recharge(ItemStack itemStack, float energy, boolean doReceive) {
        float rejectedElectricity = Math.max(this.getElectricityStored(itemStack) + energy - this.getMaxElectricityStored(itemStack), 0.0f);
        float energyToReceive = energy - rejectedElectricity;
        if (energyToReceive > this.transferMax) {
            rejectedElectricity += energyToReceive - this.transferMax;
            energyToReceive = this.transferMax;
        }
        if (doReceive) {
            this.setElectricity(itemStack, this.getElectricityStored(itemStack) + energyToReceive);
        }
        return energyToReceive;
    }

    public float discharge(ItemStack itemStack, float energy, boolean doTransfer) {
        float energyToTransfer = Math.min(Math.min(this.getElectricityStored(itemStack), energy), this.transferMax);
        if (doTransfer) {
            this.setElectricity(itemStack, this.getElectricityStored(itemStack) - energyToTransfer);
        }
        return energyToTransfer;
    }

    public int getTierGC(ItemStack itemStack) {
        return 1;
    }

    public void setElectricity(ItemStack itemStack, float joules) {
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        float electricityStored = Math.max(Math.min(joules, this.getMaxElectricityStored(itemStack)), 0.0f);
        itemStack.func_77978_p().func_74776_a("electricity", electricityStored);
        itemStack.func_77964_b((int)(100.0f - electricityStored / this.getMaxElectricityStored(itemStack) * 100.0f));
    }

    public float getTransfer(ItemStack itemStack) {
        return Math.min(this.transferMax, this.getMaxElectricityStored(itemStack) - this.getElectricityStored(itemStack));
    }

    public float getElectricityStored(ItemStack itemStack) {
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        float energyStored = 0.0f;
        if (itemStack.func_77978_p().func_74764_b("electricity")) {
            NBTBase obj = itemStack.func_77978_p().func_74781_a("electricity");
            if (obj instanceof NBTTagDouble) {
                energyStored = ((NBTTagDouble)obj).func_150288_h();
            } else if (obj instanceof NBTTagFloat) {
                energyStored = ((NBTTagFloat)obj).func_150288_h();
            }
        }
        itemStack.func_77964_b((int)(100.0f - energyStored / this.getMaxElectricityStored(itemStack) * 100.0f));
        return energyStored;
    }

    public void func_150895_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        par3List.add(ElectricItemHelper.getUncharged((ItemStack)new ItemStack((Item)this)));
        par3List.add(ElectricItemHelper.getWithCharge((ItemStack)new ItemStack((Item)this), (float)this.getMaxElectricityStored(new ItemStack((Item)this))));
    }

    @Annotations.RuntimeInterface(clazz="mekanism.api.energy.IEnergizedItem", modID="Mekanism")
    public double getEnergy(ItemStack itemStack) {
        return this.getElectricityStored(itemStack) * EnergyConfigHandler.TO_MEKANISM_RATIO;
    }

    @Annotations.RuntimeInterface(clazz="mekanism.api.energy.IEnergizedItem", modID="Mekanism")
    public void setEnergy(ItemStack itemStack, double amount) {
        this.setElectricity(itemStack, (float)amount * EnergyConfigHandler.MEKANISM_RATIO);
    }

    @Annotations.RuntimeInterface(clazz="mekanism.api.energy.IEnergizedItem", modID="Mekanism")
    public double getMaxEnergy(ItemStack itemStack) {
        return this.getMaxElectricityStored(itemStack) * EnergyConfigHandler.TO_MEKANISM_RATIO;
    }

    @Annotations.RuntimeInterface(clazz="mekanism.api.energy.IEnergizedItem", modID="Mekanism")
    public double getMaxTransfer(ItemStack itemStack) {
        return this.transferMax * EnergyConfigHandler.TO_MEKANISM_RATIO;
    }

    @Annotations.RuntimeInterface(clazz="mekanism.api.energy.IEnergizedItem", modID="Mekanism")
    public boolean canReceive(ItemStack itemStack) {
        return itemStack != null && !(itemStack.func_77973_b() instanceof ItemBatteryInfinite);
    }

    @Annotations.RuntimeInterface(clazz="ic2.api.item.ISpecialElectricItem", modID="IC2")
    public IElectricItemManager getManager(ItemStack itemstack) {
        return (IElectricItemManager)itemManagerIC2;
    }

    @Annotations.RuntimeInterface(clazz="ic2.api.item.ISpecialElectricItem", modID="IC2")
    public boolean canProvideEnergy(ItemStack itemStack) {
        return true;
    }

    @Annotations.RuntimeInterface(clazz="ic2.api.item.ISpecialElectricItem", modID="IC2")
    public Item getChargedItem(ItemStack itemStack) {
        return itemStack.func_77973_b();
    }

    @Annotations.RuntimeInterface(clazz="ic2.api.item.ISpecialElectricItem", modID="IC2")
    public Item getEmptyItem(ItemStack itemStack) {
        return itemStack.func_77973_b();
    }

    @Annotations.RuntimeInterface(clazz="ic2.api.item.ISpecialElectricItem", modID="IC2")
    public int getTier(ItemStack itemStack) {
        return 1;
    }

    @Annotations.VersionSpecific(version="[1.7.10]")
    @Annotations.RuntimeInterface(clazz="ic2.api.item.ISpecialElectricItem", modID="IC2")
    public double getMaxCharge(ItemStack itemStack) {
        return this.getMaxElectricityStored(itemStack) / EnergyConfigHandler.IC2_RATIO;
    }

    @Annotations.AltForVersion(version="[1.7.2]")
    @Annotations.RuntimeInterface(clazz="ic2.api.item.ISpecialElectricItem", modID="IC2")
    public int getMaxChargeB(ItemStack itemStack) {
        return (int)(this.getMaxElectricityStored(itemStack) / EnergyConfigHandler.IC2_RATIO);
    }

    @Annotations.VersionSpecific(version="[1.7.10]")
    @Annotations.RuntimeInterface(clazz="ic2.api.item.ISpecialElectricItem", modID="IC2")
    public double getTransferLimit(ItemStack itemStack) {
        return this.transferMax * EnergyConfigHandler.TO_IC2_RATIO;
    }

    @Annotations.VersionSpecific(version="[1.7.2]")
    @Annotations.RuntimeInterface(clazz="ic2.api.item.ISpecialElectricItem", modID="IC2")
    public int getTransferLimitB(ItemStack itemStack) {
        return (int)(this.transferMax * EnergyConfigHandler.TO_IC2_RATIO);
    }

    public abstract String getTextureLocation();

    public abstract Item getRepairItems();

    public abstract int getRepairItemsMetadata();
}

