/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.planets.venus.entities;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import micdoodle8.mods.galacticraft.api.entity.IEntityBreathable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import stevekung.mods.moreplanets.core.init.MPItems;

public class EntityVenusianSlime
extends EntityLiving
implements IMob,
IEntityBreathable {
    public float squishAmount;
    public float squishFactor;
    public float prevSquishFactor;
    private int slimeJumpDelay;

    public EntityVenusianSlime(World par1World) {
        super(par1World);
        int i = 1 << this.field_70146_Z.nextInt(3);
        this.field_70129_M = 0.0f;
        this.field_70178_ae = true;
        this.slimeJumpDelay = this.field_70146_Z.nextInt(30) + 20;
        this.setSlimeSize(i);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)new Byte(1));
    }

    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K && this.func_70026_G()) {
            this.func_70097_a(DamageSource.field_76369_e, 1.0f);
        }
        super.func_70636_d();
    }

    public ItemStack getPickedResult(MovingObjectPosition target) {
        return new ItemStack(MPItems.spawn_egg_mp, 1, 1035);
    }

    public void setSlimeSize(int par1) {
        this.field_70180_af.func_75692_b(16, (Object)new Byte((byte)par1));
        this.func_70105_a(0.6f * (float)par1, 0.6f * (float)par1);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)(par1 * par1));
        this.func_70606_j(this.func_110138_aP());
        this.field_70728_aV = par1;
    }

    public int getSlimeSize() {
        return this.field_70180_af.func_75683_a(16);
    }

    public void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70014_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74768_a("Size", this.getSlimeSize() - 1);
    }

    public void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70037_a(par1NBTTagCompound);
        this.setSlimeSize(par1NBTTagCompound.func_74762_e("Size") + 1);
    }

    protected String getJumpSound() {
        return "mob.slime." + (this.getSlimeSize() > 1 ? "big" : "small");
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b(float par1) {
        return 0xF000F0;
    }

    public float func_70013_c(float par1) {
        return 1.0f;
    }

    public boolean func_70652_k(Entity entity) {
        if (super.func_70652_k(entity)) {
            if (entity instanceof EntityLivingBase) {
                ((EntityLivingBase)entity).func_70015_d(5);
            }
            return true;
        }
        return false;
    }

    public void func_70071_h_() {
        int i;
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.field_73013_u == EnumDifficulty.PEACEFUL && this.getSlimeSize() > 0) {
            this.field_70128_L = true;
        }
        this.squishFactor += (this.squishAmount - this.squishFactor) * 0.5f;
        this.prevSquishFactor = this.squishFactor;
        boolean flag = this.field_70122_E;
        super.func_70071_h_();
        if (this.field_70122_E && !flag) {
            i = this.getSlimeSize();
            for (int j = 0; j < i * 8; ++j) {
                float f = this.field_70146_Z.nextFloat() * (float)Math.PI * 2.0f;
                float f1 = this.field_70146_Z.nextFloat() * 0.5f + 0.5f;
                float f2 = MathHelper.func_76126_a((float)f) * (float)i * 0.5f * f1;
                float f3 = MathHelper.func_76134_b((float)f) * (float)i * 0.5f * f1;
                this.field_70170_p.func_72869_a("flame", this.field_70165_t + (double)f2, this.field_70121_D.field_72338_b, this.field_70161_v + (double)f3, 0.0, 0.0, 0.0);
            }
            if (this.makesSoundOnLand()) {
                this.func_85030_a(this.getJumpSound(), this.func_70599_aP(), ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f) / 0.8f);
            }
            this.squishAmount = -0.5f;
        } else if (!this.field_70122_E && flag) {
            this.squishAmount = 1.0f;
        }
        this.alterSquishAmount();
        if (this.field_70170_p.field_72995_K) {
            i = this.getSlimeSize();
            this.func_70105_a(0.6f * (float)i, 0.6f * (float)i);
        }
    }

    protected void func_70626_be() {
        this.func_70623_bb();
        EntityPlayer entityplayer = this.field_70170_p.func_72856_b((Entity)this, 16.0);
        if (entityplayer != null) {
            this.func_70625_a((Entity)entityplayer, 10.0f, 20.0f);
        }
        if (this.field_70122_E && this.slimeJumpDelay-- <= 0) {
            this.slimeJumpDelay = this.getJumpDelay();
            if (entityplayer != null) {
                this.slimeJumpDelay /= 3;
            }
            this.field_70703_bu = true;
            if (this.makesSoundOnJump()) {
                this.func_85030_a(this.getJumpSound(), this.func_70599_aP(), ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f) * 0.8f);
            }
            this.field_70702_br = 1.0f - this.field_70146_Z.nextFloat() * 2.0f;
            this.field_70701_bs = 1 * this.getSlimeSize();
        } else {
            this.field_70703_bu = false;
            if (this.field_70122_E) {
                this.field_70701_bs = 0.0f;
                this.field_70702_br = 0.0f;
            }
        }
    }

    protected void alterSquishAmount() {
        this.squishAmount *= 0.6f;
    }

    protected int getJumpDelay() {
        return this.field_70146_Z.nextInt(30) + 20;
    }

    protected EntityVenusianSlime createInstance() {
        return new EntityVenusianSlime(this.field_70170_p);
    }

    public void func_70106_y() {
        int i = this.getSlimeSize();
        if (!this.field_70170_p.field_72995_K && i > 1 && this.func_110143_aJ() <= 0.0f) {
            int j = 2 + this.field_70146_Z.nextInt(3);
            for (int k = 0; k < j; ++k) {
                float f = ((float)(k % 2) - 0.5f) * (float)i / 4.0f;
                float f1 = ((float)(k / 2) - 0.5f) * (float)i / 4.0f;
                EntityVenusianSlime entityslime = this.createInstance();
                entityslime.setSlimeSize(i / 2);
                entityslime.func_70012_b(this.field_70165_t + (double)f, this.field_70163_u + 0.5, this.field_70161_v + (double)f1, this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
                this.field_70170_p.func_72838_d((Entity)entityslime);
            }
        }
        super.func_70106_y();
    }

    public void func_70100_b_(EntityPlayer par1EntityPlayer) {
        if (this.canDamagePlayer()) {
            int i = this.getSlimeSize();
            if (this.func_70685_l((Entity)par1EntityPlayer) && this.func_70068_e((Entity)par1EntityPlayer) < 0.6 * (double)i * 0.6 * (double)i && par1EntityPlayer.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.getAttackStrength())) {
                par1EntityPlayer.func_70015_d(5);
                this.func_85030_a("mob.attack", 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            }
        }
    }

    protected boolean canDamagePlayer() {
        return this.getSlimeSize() > 1;
    }

    protected int getAttackStrength() {
        return this.getSlimeSize();
    }

    protected String func_70621_aR() {
        return "mob.slime." + (this.getSlimeSize() > 1 ? "big" : "small");
    }

    protected String func_70673_aS() {
        return "mob.slime." + (this.getSlimeSize() > 1 ? "big" : "small");
    }

    protected void func_70628_a(boolean par1, int par2) {
        int var3 = this.field_70146_Z.nextInt(3) + this.field_70146_Z.nextInt(1 + par2);
        if (this.getSlimeSize() == 1) {
            for (int var4 = 0; var4 < var3; ++var4) {
                this.func_70099_a(new ItemStack(Items.field_151064_bs, 1), 0.0f);
            }
        }
    }

    public boolean func_70058_J() {
        return false;
    }

    protected float func_70599_aP() {
        return 0.4f * (float)this.getSlimeSize();
    }

    public int func_70646_bf() {
        return 0;
    }

    protected boolean makesSoundOnJump() {
        return this.getSlimeSize() > 0;
    }

    protected boolean makesSoundOnLand() {
        return this.getSlimeSize() > 2;
    }

    public boolean canBreath() {
        return true;
    }
}

