/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.planets.venus.blocks;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import stevekung.mods.moreplanets.core.MorePlanetsCore;
import stevekung.mods.moreplanets.planets.venus.blocks.VenusBlocks;

public class BlockVenusSandstoneSlab
extends BlockSlab {
    private IIcon[] textures;
    private boolean isDoubleSlab;
    private VenusSlabCategory category;

    public BlockVenusSandstoneSlab(String name, boolean par2, Material material, VenusSlabCategory cat) {
        super(par2, material);
        this.isDoubleSlab = par2;
        this.category = cat;
        this.func_149663_c(name);
        this.field_149783_u = true;
    }

    public void func_149651_a(IIconRegister par1IconRegister) {
        this.textures = new IIcon[10];
        this.textures[0] = par1IconRegister.func_94245_a("venus:venus_sandstone");
        this.textures[1] = par1IconRegister.func_94245_a("venus:venus_sandstone_top");
        this.textures[2] = par1IconRegister.func_94245_a("venus:venus_sandstone_bottom");
    }

    public IIcon func_149691_a(int side, int meta) {
        if (this.category == VenusSlabCategory.STONE) {
            return this.textures[meta & 7];
        }
        if (this.category == VenusSlabCategory.WOOD1) {
            if (meta == 0 || meta == 8) {
                switch (side) {
                    case 0: {
                        return this.textures[2];
                    }
                    case 1: {
                        return this.textures[1];
                    }
                    case 2: {
                        return this.textures[0];
                    }
                    case 3: {
                        return this.textures[0];
                    }
                    case 4: {
                        return this.textures[0];
                    }
                    case 5: {
                        return this.textures[0];
                    }
                }
            }
            return this.textures[meta & 7];
        }
        if (this.category == VenusSlabCategory.WOOD2) {
            return this.textures[meta & 7];
        }
        return this.field_149761_L;
    }

    public void func_149666_a(Item block, CreativeTabs creativeTabs, List list) {
        int max = 0;
        if (this.category == VenusSlabCategory.WOOD1) {
            max = 1;
        } else if (this.category == VenusSlabCategory.WOOD2) {
            max = 1;
        } else if (this.category == VenusSlabCategory.STONE) {
            max = 1;
        }
        for (int i = 0; i < max; ++i) {
            list.add(new ItemStack(block, 1, i));
        }
    }

    public String func_150002_b(int meta) {
        return this.getTypes()[this.getWoodType(meta)] + "";
    }

    public int func_149692_a(int meta) {
        return meta & 7;
    }

    public Item func_149650_a(int meta, Random par2Random, int par3) {
        if (this == VenusBlocks.double_venus_sandstone_slab) {
            return Item.func_150898_a((Block)VenusBlocks.half_venus_sandstone_slab);
        }
        return Item.func_150898_a((Block)this);
    }

    public CreativeTabs func_149708_J() {
        if (!this.isDoubleSlab) {
            return MorePlanetsCore.mpBlocksTab;
        }
        return null;
    }

    public float func_149712_f(World world, int x, int y, int z) {
        return 0.8f;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (block == VenusBlocks.double_venus_sandstone_slab) {
            return new ItemStack(VenusBlocks.half_venus_sandstone_slab, 1, meta);
        }
        return new ItemStack((Block)this, 1, meta & 7);
    }

    protected ItemStack func_149644_j(int par1) {
        return new ItemStack((Block)this, 2, par1);
    }

    private int getWoodType(int meta) {
        if ((meta &= 7 + this.category.ordinal() * 8) < this.getTypes().length) {
            return meta;
        }
        return 0;
    }

    private String[] getTypes() {
        return new String[]{"venus"};
    }

    public static enum VenusSlabCategory {
        WOOD1,
        WOOD2,
        STONE;

    }
}

