/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.planets.siriusb.worldgen;

import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.core.perlin.NoiseModule;
import micdoodle8.mods.galacticraft.core.perlin.generator.Gradient;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.MapGenDungeon;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderGenerate;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import stevekung.mods.moreplanets.core.init.MPBlocks;
import stevekung.mods.moreplanets.core.worldgen.MapGenCaveMP;
import stevekung.mods.moreplanets.core.worldgen.dungeon.RoomEmptyMP;
import stevekung.mods.moreplanets.core.worldgen.feature.WorldGenSpaceDungeons;
import stevekung.mods.moreplanets.core.worldgen.feature.WorldGenSplashBlock;
import stevekung.mods.moreplanets.planets.siriusb.blocks.SiriusBBlocks;
import stevekung.mods.moreplanets.planets.siriusb.entities.EntitySiriusBlaze;
import stevekung.mods.moreplanets.planets.siriusb.entities.EntitySiriusCreeper;
import stevekung.mods.moreplanets.planets.siriusb.entities.EntitySiriusMagmaCube;
import stevekung.mods.moreplanets.planets.siriusb.worldgen.BiomeDecoratorSiriusB;
import stevekung.mods.moreplanets.planets.siriusb.worldgen.BiomeGenBaseSiriusB;
import stevekung.mods.moreplanets.planets.siriusb.worldgen.blazepit.MapGenSiriusBlazePit;
import stevekung.mods.moreplanets.planets.siriusb.worldgen.dungeon.RoomBossSiriusB;
import stevekung.mods.moreplanets.planets.siriusb.worldgen.dungeon.RoomChestsSiriusB;
import stevekung.mods.moreplanets.planets.siriusb.worldgen.dungeon.RoomSpawnerSiriusB;
import stevekung.mods.moreplanets.planets.siriusb.worldgen.dungeon.RoomTreasureSiriusB;

public class ChunkProviderSiriusB
extends ChunkProviderGenerate {
    Block topBlockID = SiriusBBlocks.sirius_b_block;
    byte topBlockMeta = 0;
    Block fillBlockID = SiriusBBlocks.sirius_b_block;
    byte fillBlockMeta = 1;
    Block lowerBlockID = SiriusBBlocks.sirius_b_block;
    byte lowerBlockMeta = (byte)2;
    private Random rand;
    private NoiseModule noiseGen1;
    private NoiseModule noiseGen2;
    private NoiseModule noiseGen3;
    private NoiseModule noiseGen4;
    public BiomeDecoratorSiriusB biomedecoratorplanet = new BiomeDecoratorSiriusB();
    private MapGenCaveMP caveGenerator = new MapGenCaveMP(SiriusBBlocks.sirius_b_block);
    private MapGenSiriusBlazePit blazePit = new MapGenSiriusBlazePit();
    private World worldObj;
    private MapGenDungeon dungeonGenerator = new MapGenDungeon(SiriusBBlocks.sirius_b_block, 9, 8, 24, 4);
    private BiomeGenBase[] biomesForGeneration;
    private static int MID_HEIGHT = 64;
    private static int CHUNK_SIZE_X = 16;
    private static int CHUNK_SIZE_Y = 128;
    private static int CHUNK_SIZE_Z = 16;

    public ChunkProviderSiriusB(World par1World, long par2, boolean par4) {
        super(par1World, par2, par4);
        this.dungeonGenerator.otherRooms.add(new RoomEmptyMP(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.otherRooms.add(new RoomSpawnerSiriusB(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.otherRooms.add(new RoomSpawnerSiriusB(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.otherRooms.add(new RoomSpawnerSiriusB(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.otherRooms.add(new RoomSpawnerSiriusB(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.otherRooms.add(new RoomSpawnerSiriusB(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.otherRooms.add(new RoomSpawnerSiriusB(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.otherRooms.add(new RoomSpawnerSiriusB(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.otherRooms.add(new RoomSpawnerSiriusB(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.otherRooms.add(new RoomChestsSiriusB(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.otherRooms.add(new RoomChestsSiriusB(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.bossRooms.add(new RoomBossSiriusB(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.treasureRooms.add(new RoomTreasureSiriusB(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.biomesForGeneration = new BiomeGenBase[]{BiomeGenBaseSiriusB.siriusB};
        this.worldObj = par1World;
        this.rand = new Random(par2);
        this.noiseGen1 = new Gradient(this.rand.nextLong(), 4, 0.25f);
        this.noiseGen2 = new Gradient(this.rand.nextLong(), 4, 0.25f);
        this.noiseGen3 = new Gradient(this.rand.nextLong(), 1, 0.25f);
        this.noiseGen4 = new Gradient(this.rand.nextLong(), 1, 0.25f);
    }

    public void generateTerrain(int chunkX, int chunkZ, Block[] idArray, byte[] metaArray) {
        this.noiseGen1.setFrequency(0.0125f);
        this.noiseGen2.setFrequency(0.015f);
        this.noiseGen3.setFrequency(0.01f);
        this.noiseGen4.setFrequency(0.02f);
        for (int x = 0; x < CHUNK_SIZE_X; ++x) {
            for (int z = 0; z < CHUNK_SIZE_Z; ++z) {
                double d = this.noiseGen1.getNoise((float)(x + chunkX * 16), (float)(z + chunkZ * 16)) * 8.0f;
                double d2 = this.noiseGen2.getNoise((float)(x + chunkX * 16), (float)(z + chunkZ * 16)) * 24.0f;
                double d3 = (double)this.noiseGen3.getNoise((float)(x + chunkX * 16), (float)(z + chunkZ * 16)) - 0.1;
                double yDev = 0.0;
                yDev = d3 < 0.0 ? d : (d3 > 1.0 ? d2 : d + (d2 - d) * (d3 *= 4.0));
                for (int y = 0; y < CHUNK_SIZE_Y; ++y) {
                    if (!((double)y < (double)MID_HEIGHT + yDev)) continue;
                    idArray[this.getIndex((int)x, (int)y, (int)z)] = this.lowerBlockID;
                    metaArray[this.getIndex((int)x, (int)y, (int)z)] = this.lowerBlockMeta;
                }
            }
        }
    }

    public void func_147422_a(int par1, int par2, Block[] arrayOfIDs, byte[] arrayOfMeta, BiomeGenBase[] par4ArrayOfBiomeGenBase) {
        int var5 = 20;
        for (int var8 = 0; var8 < 16; ++var8) {
            for (int var9 = 0; var9 < 16; ++var9) {
                int var12 = (int)((double)this.noiseGen4.getNoise((float)(var8 + par1 * 16), (float)(var9 * par2 * 16)) / 3.0 + 3.0 + this.rand.nextDouble() * 0.25);
                int var13 = -1;
                Block var14 = this.topBlockID;
                byte var14m = this.topBlockMeta;
                Block var15 = this.fillBlockID;
                byte var15m = this.fillBlockMeta;
                for (int var16 = 127; var16 >= 0; --var16) {
                    int index = this.getIndex(var8, var16, var9);
                    arrayOfMeta[index] = 0;
                    if (var16 <= 0 + this.rand.nextInt(5)) {
                        arrayOfIDs[index] = Blocks.field_150357_h;
                        continue;
                    }
                    Block var18 = arrayOfIDs[index];
                    if (Blocks.field_150350_a == var18) {
                        var13 = -1;
                        continue;
                    }
                    if (var18 != this.lowerBlockID) continue;
                    arrayOfMeta[index] = this.lowerBlockMeta;
                    if (var13 == -1) {
                        if (var12 <= 0) {
                            var14 = Blocks.field_150350_a;
                            var14m = 0;
                            var15 = this.lowerBlockID;
                            var15m = this.lowerBlockMeta;
                        } else if (var16 >= var5 - -16 && var16 <= var5 + 1) {
                            var14 = this.topBlockID;
                            var14m = this.topBlockMeta;
                            var14 = this.fillBlockID;
                            var14m = this.fillBlockMeta;
                        }
                        var13 = var12;
                        if (var16 >= var5 - 1) {
                            arrayOfIDs[index] = var14;
                            arrayOfMeta[index] = var14m;
                            continue;
                        }
                        if (var16 >= var5 - 1 || var16 < var5 - 2) continue;
                        arrayOfIDs[index] = var15;
                        arrayOfMeta[index] = var15m;
                        continue;
                    }
                    if (var13 <= 0) continue;
                    --var13;
                    arrayOfIDs[index] = var15;
                    arrayOfMeta[index] = var15m;
                }
            }
        }
    }

    public Chunk func_73154_d(int par1, int par2) {
        this.rand.setSeed((long)par1 * 341873128712L + (long)par2 * 132897987541L);
        Object[] ids = new Block[65536];
        byte[] meta = new byte[65536];
        Arrays.fill(ids, Blocks.field_150350_a);
        this.generateTerrain(par1, par2, (Block[])ids, meta);
        this.biomesForGeneration = this.worldObj.func_72959_q().func_76933_b(this.biomesForGeneration, par1 * 16, par2 * 16, 16, 16);
        this.func_147422_a(par1, par2, (Block[])ids, meta, this.biomesForGeneration);
        this.caveGenerator.generate((IChunkProvider)this, this.worldObj, par1, par2, (Block[])ids, meta);
        this.dungeonGenerator.generateUsingArrays(this.worldObj, this.worldObj.func_72905_C(), par1 * 16, 25, par2 * 16, par1, par2, (Block[])ids, meta);
        this.blazePit.generate((IChunkProvider)this, this.worldObj, par1, par2, (Block[])ids, meta);
        Chunk var4 = new Chunk(this.worldObj, (Block[])ids, meta, par1, par2);
        var4.func_76603_b();
        return var4;
    }

    public boolean func_73149_a(int par1, int par2) {
        return true;
    }

    public boolean func_73156_b() {
        return false;
    }

    public int func_73152_e() {
        return 0;
    }

    private int getIndex(int x, int y, int z) {
        return (x * 16 + z) * 256 + y;
    }

    public void decoratePlanet(World par1World, Random par2Random, int par3, int par4) {
        this.biomedecoratorplanet.decorate(par1World, par2Random, par3, par4);
    }

    public void func_73153_a(IChunkProvider chunk, int par2, int par3) {
        int z;
        int y;
        int x;
        int i;
        BlockFalling.field_149832_M = true;
        int var4 = par2 * 16;
        int var5 = par3 * 16;
        this.worldObj.func_72807_a(var4 + 16, var5 + 16);
        this.rand.setSeed(this.worldObj.func_72905_C());
        long var7 = this.rand.nextLong() / 2L * 2L + 1L;
        long var9 = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)par2 * var7 + (long)par3 * var9 ^ this.worldObj.func_72905_C());
        this.dungeonGenerator.handleTileEntities(this.rand);
        this.blazePit.generateStructuresInChunk(this.worldObj, new Random(), par2, par3);
        this.decoratePlanet(this.worldObj, this.rand, var4, var5);
        for (int i2 = 0; i2 < 8; ++i2) {
            int x2 = var4 + this.rand.nextInt(16) + 8;
            int y2 = this.rand.nextInt(256);
            int z2 = var5 + this.rand.nextInt(16) + 8;
            new WorldGenSpaceDungeons(SiriusBBlocks.sirius_b_ancient_chest, SiriusBBlocks.sirius_b_block, MPBlocks.space_mossy_cobblestone, 5).func_76484_a(this.worldObj, this.rand, x2, y2, z2);
        }
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Pre(chunk, this.worldObj, this.rand, par2, par3, false));
        boolean doGen = TerrainGen.populate((IChunkProvider)chunk, (World)this.worldObj, (Random)this.rand, (int)par2, (int)par3, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.FIRE);
        for (i = 0; doGen && i < 4; ++i) {
            if (this.rand.nextInt(5) != 0) continue;
            x = var4 + this.rand.nextInt(16) + 8;
            y = this.rand.nextInt(96) + 32;
            z = var5 + this.rand.nextInt(16) + 8;
            new WorldGenSplashBlock(SiriusBBlocks.sirius_b_block, 7, SiriusBBlocks.sirius_b_block, 0).func_76484_a(this.worldObj, this.rand, x, y, z);
        }
        for (i = 0; doGen && i < 4; ++i) {
            if (this.rand.nextInt(5) != 0) continue;
            x = var4 + this.rand.nextInt(16) + 8;
            y = this.rand.nextInt(96) + 32;
            z = var5 + this.rand.nextInt(16) + 8;
            new WorldGenSplashBlock(SiriusBBlocks.magma_rock, 0, SiriusBBlocks.sirius_b_block, 0).func_76484_a(this.worldObj, this.rand, x, y, z);
        }
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Post(chunk, this.worldObj, this.rand, par2, par3, false));
        BlockFalling.field_149832_M = false;
    }

    public boolean func_73151_a(boolean par1, IProgressUpdate par2IProgressUpdate) {
        return true;
    }

    public boolean func_73157_c() {
        return true;
    }

    public String func_73148_d() {
        return "SiriusBLevelSource";
    }

    public List func_73155_a(EnumCreatureType par1EnumCreatureType, int i, int j, int k) {
        if (par1EnumCreatureType == EnumCreatureType.monster) {
            ArrayList<BiomeGenBase.SpawnListEntry> monsters = new ArrayList<BiomeGenBase.SpawnListEntry>();
            monsters.add(new BiomeGenBase.SpawnListEntry(EntitySiriusBlaze.class, 100, 4, 4));
            monsters.add(new BiomeGenBase.SpawnListEntry(EntitySiriusCreeper.class, 100, 4, 4));
            monsters.add(new BiomeGenBase.SpawnListEntry(EntitySiriusMagmaCube.class, 100, 4, 4));
            return monsters;
        }
        return null;
    }

    public void func_82695_e(int par1, int par2) {
    }
}

