/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.planets.polongnius.dimension;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import net.minecraft.util.MathHelper;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.chunk.IChunkProvider;
import stevekung.mods.moreplanets.core.MorePlanetsCore;
import stevekung.mods.moreplanets.core.dimension.WorldProviderMP;
import stevekung.mods.moreplanets.core.world.IMeteorType;
import stevekung.mods.moreplanets.planets.polongnius.worldgen.ChunkProviderPolongnius;
import stevekung.mods.moreplanets.planets.polongnius.worldgen.WorldChunkManagerPolongnius;

public class WorldProviderPolongnius
extends WorldProviderMP
implements IMeteorType {
    public Vector3 getFogColor() {
        float f = 0.65f - this.getStarBrightness(1.0f);
        return new Vector3((double)(1.0f * f), (double)(0.75686276f * f), (double)(0.023529412f * f));
    }

    public Vector3 getSkyColor() {
        float f = 0.6f - this.getStarBrightness(1.0f);
        return new Vector3((double)(1.0f * f), (double)(0.8745098f * f), (double)(0.5019608f * f));
    }

    public long getDayLength() {
        return 44000L;
    }

    public Class<? extends IChunkProvider> getChunkProviderClass() {
        return ChunkProviderPolongnius.class;
    }

    public Class<? extends WorldChunkManager> getWorldChunkManagerClass() {
        return WorldChunkManagerPolongnius.class;
    }

    @SideOnly(value=Side.CLIENT)
    public float getStarBrightness(float bright) {
        float f1 = this.field_76579_a.func_72826_c(bright);
        float f2 = 1.0f - (MathHelper.func_76134_b((float)(f1 * (float)Math.PI * 2.0f)) * 2.0f + 0.25f);
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        return f2 * f2 * 0.4f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getSunBrightness(float bright) {
        float f1 = this.field_76579_a.func_72826_c(1.0f);
        float f2 = 0.675f - (MathHelper.func_76134_b((float)(f1 * (float)Math.PI * 2.0f)) * 2.0f + 0.2f);
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        f2 = 0.95f - f2;
        return f2 * 1.0f;
    }

    public double getSolarEnergyMultiplier() {
        return 1.2;
    }

    public float getGravity() {
        return 0.027f;
    }

    public double getMeteorFrequency() {
        return 10.0;
    }

    public boolean canSpaceshipTierPass(int tier) {
        return tier >= 5;
    }

    public float getFallDamageModifier() {
        return 0.72f;
    }

    public float getSoundVolReductionAmount() {
        return 10.0f;
    }

    public CelestialBody getCelestialBody() {
        return MorePlanetsCore.polongnius;
    }

    @Override
    public boolean hasBreathableAtmosphere() {
        return false;
    }

    public float getThermalLevelModifier() {
        if (this.isDaytime()) {
            return 1.75f;
        }
        return -1.5f;
    }

    public float getWindLevel() {
        return 0.9f;
    }

    @Override
    public double getUltraVioletEnergyMultiplie() {
        return 8.5;
    }

    @Override
    public int getMeteorEventType() {
        return 0;
    }

    @Override
    public double getMeteorSpawnFrequency() {
        return 1.25;
    }
}

