/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.planets.pluto.worldgen.dungeon;

import java.util.ArrayList;
import java.util.Random;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.DungeonBoundingBox;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.DungeonRoom;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.MapGenDungeon;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.util.ForgeDirection;
import stevekung.mods.moreplanets.planets.pluto.blocks.PlutoBlocks;
import stevekung.mods.moreplanets.planets.pluto.items.PlutoItems;
import stevekung.mods.moreplanets.planets.pluto.tileentities.TileEntityPlutoTreasureChest;

public class RoomTreasurePluto
extends DungeonRoom {
    int sizeX;
    int sizeY;
    int sizeZ;
    private ArrayList<ChunkCoordinates> chests = new ArrayList();

    public RoomTreasurePluto(MapGenDungeon dungeon, int posX, int posY, int posZ, ForgeDirection entranceDir) {
        super(dungeon, posX, posY, posZ, entranceDir);
        if (this.worldObj != null) {
            Random rand = new Random(this.worldObj.func_72905_C() * (long)posX * (long)posY * 57L * (long)posZ);
            this.sizeX = rand.nextInt(6) + 7;
            this.sizeY = rand.nextInt(2) + 5;
            this.sizeZ = rand.nextInt(6) + 7;
        }
    }

    public void generate(Block[] chunk, byte[] meta, int cx, int cz) {
        for (int i = this.posX - 1; i <= this.posX + this.sizeX; ++i) {
            for (int k = this.posZ - 1; k <= this.posZ + this.sizeZ; ++k) {
                for (int j = this.posY - 1; j <= this.posY + this.sizeY; ++j) {
                    if (i == this.posX - 1 || i == this.posX + this.sizeX || j == this.posY - 1 || j == this.posY + this.sizeY || k == this.posZ - 1 || k == this.posZ + this.sizeZ) {
                        this.placeBlock(chunk, meta, i, j, k, cx, cz, this.dungeonInstance.DUNGEON_WALL_ID, this.dungeonInstance.DUNGEON_WALL_META);
                        continue;
                    }
                    if (!(i != this.posX && i != this.posX + this.sizeX - 1 || k != this.posZ && k != this.posZ + this.sizeZ - 1)) {
                        this.placeBlock(chunk, meta, i, j, k, cx, cz, PlutoBlocks.xeonium_glowstone, 0);
                        continue;
                    }
                    this.placeBlock(chunk, meta, i, j, k, cx, cz, Blocks.field_150350_a, 0);
                }
            }
        }
        int hx = (this.posX + this.posX + this.sizeX) / 2;
        int hz = (this.posZ + this.posZ + this.sizeZ) / 2;
        if (this.placeBlock(chunk, meta, hx, this.posY, hz, cx, cz, PlutoBlocks.pluto_treasure_chest, 0)) {
            this.chests.add(new ChunkCoordinates(hx, this.posY, hz));
        }
    }

    public DungeonBoundingBox getBoundingBox() {
        return new DungeonBoundingBox(this.posX, this.posZ, this.posX + this.sizeX, this.posZ + this.sizeZ);
    }

    private ItemStack getGuaranteedLoot(Random rand) {
        switch (rand.nextInt(2)) {
            case 0: {
                return new ItemStack(PlutoItems.space_potato, rand.nextInt(8) + 1, 0);
            }
        }
        return null;
    }

    protected void handleTileEntities(Random rand) {
        for (ChunkCoordinates chestCoords : this.chests) {
            TileEntity chest = this.worldObj.func_147438_o(chestCoords.field_71574_a, chestCoords.field_71572_b, chestCoords.field_71573_c);
            if (chest == null || !(chest instanceof TileEntityPlutoTreasureChest)) continue;
            ChestGenHooks info = ChestGenHooks.getInfo((String)"dungeonChest");
            WeightedRandomChestContent.func_76293_a((Random)rand, (WeightedRandomChestContent[])info.getItems(rand), (IInventory)((TileEntityPlutoTreasureChest)chest), (int)info.getCount(rand));
            ((TileEntityPlutoTreasureChest)chest).func_70299_a(rand.nextInt(((TileEntityPlutoTreasureChest)chest).func_70302_i_()), this.getGuaranteedLoot(rand));
        }
    }

    protected DungeonRoom makeRoom(MapGenDungeon dungeon, int x, int y, int z, ForgeDirection dir) {
        return new RoomTreasurePluto(dungeon, x, y, z, dir);
    }
}

