/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.planets.pluto.entities;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import micdoodle8.mods.galacticraft.api.entity.IEntityBreathable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import stevekung.mods.moreplanets.planets.pluto.blocks.PlutoBlocks;

public class EntityPlutoAlien
extends EntityMob
implements IEntityBreathable {
    private int lastActiveTime;
    private int timeSinceIgnited;
    private int fuseTime = 20;
    private int explosionRadius = 5;

    public EntityPlutoAlien(World world) {
        super(world);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityPlayer.class, 1.0, false));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
        this.func_70105_a(0.9f, 1.8f);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(64.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(8.0);
    }

    public boolean func_70650_aV() {
        return true;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)-1);
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74777_a("Fuse", (short)this.fuseTime);
        nbt.func_74774_a("ExplosionRadius", (byte)this.explosionRadius);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_150297_b("Fuse", 99)) {
            this.fuseTime = nbt.func_74765_d("Fuse");
        }
        if (nbt.func_150297_b("ExplosionRadius", 99)) {
            this.explosionRadius = nbt.func_74771_c("ExplosionRadius");
        }
    }

    public void func_70071_h_() {
        if (this.func_70089_S()) {
            this.lastActiveTime = this.timeSinceIgnited;
            int i = this.getCreeperState();
            if (i > 0 && this.timeSinceIgnited == 0) {
                this.func_85030_a("creeper.primed", 1.0f, 0.5f);
            }
            this.timeSinceIgnited += i;
            if (this.timeSinceIgnited < 0) {
                this.timeSinceIgnited = 0;
            }
            if (this.timeSinceIgnited >= this.fuseTime) {
                this.timeSinceIgnited = this.fuseTime;
                this.explode();
            }
        }
        super.func_70071_h_();
    }

    public boolean func_70097_a(DamageSource damageSource, float damageAmount) {
        if (this.func_85032_ar()) {
            return false;
        }
        if (super.func_70097_a(damageSource, damageAmount)) {
            if (this.func_110143_aJ() < 10.0f && this.field_70146_Z.nextInt(24) == 0) {
                this.setCreeperState(1);
            }
            return true;
        }
        return false;
    }

    protected String func_70621_aR() {
        this.func_85030_a("mob.creeper.say", 0.7f, 0.5f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
        this.func_85030_a(Block.field_149769_e.func_150495_a(), Block.field_149769_e.func_150497_c(), Block.field_149769_e.func_150494_d());
        return null;
    }

    protected String func_70673_aS() {
        this.func_85030_a("mob.creeper.death", 0.7f, 0.5f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
        this.func_85030_a(Block.field_149769_e.func_150495_a(), Block.field_149769_e.func_150497_c(), 0.6f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.4f);
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public float getCreeperFlashIntensity(float partialTicks) {
        return ((float)this.lastActiveTime + (float)(this.timeSinceIgnited - this.lastActiveTime) * partialTicks) / (float)(this.fuseTime - 2);
    }

    protected void func_70628_a(boolean drop, int fortune) {
        int k;
        int j = this.field_70146_Z.nextInt(3);
        if (fortune > 0) {
            j += this.field_70146_Z.nextInt(fortune + 1);
        }
        for (k = 0; k < j; ++k) {
            int i = 0;
            if (this.field_70146_Z.nextInt(3) == 0) {
                i = 10;
            }
            if (this.field_70146_Z.nextInt(5) == 0) {
                i = 11;
            }
            if (drop && this.field_70146_Z.nextInt(10) == 0) {
                i = 7;
            }
            this.func_70099_a(new ItemStack(PlutoBlocks.pluto_block, k, i), 0.0f);
        }
        for (k = 0; k < j; ++k) {
            this.func_145779_a(Items.field_151016_H, k);
        }
    }

    public int getCreeperState() {
        return this.field_70180_af.func_75683_a(16);
    }

    public void setCreeperState(int state) {
        this.field_70180_af.func_75692_b(16, (Object)((byte)state));
    }

    private void explode() {
        if (!this.field_70170_p.field_72995_K) {
            boolean flag = this.field_70170_p.func_82736_K().func_82766_b("mobGriefing");
            this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, (float)this.explosionRadius, flag);
            this.func_70106_y();
        }
    }

    public boolean canBreath() {
        return true;
    }
}

