/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.planets.pluto.dimension;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import net.minecraft.util.MathHelper;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.chunk.IChunkProvider;
import stevekung.mods.moreplanets.core.MorePlanetsCore;
import stevekung.mods.moreplanets.core.dimension.WorldProviderMP;
import stevekung.mods.moreplanets.planets.pluto.worldgen.ChunkProviderPluto;
import stevekung.mods.moreplanets.planets.pluto.worldgen.WorldChunkManagerPluto;

public class WorldProviderPluto
extends WorldProviderMP {
    public Vector3 getFogColor() {
        float f = 1.0f - this.getStarBrightness(1.0f);
        return new Vector3((double)(0.078431375f * f), (double)(0.105882354f * f), (double)(0.12941177f * f));
    }

    public Vector3 getSkyColor() {
        return new Vector3(0.0, 0.0, 0.0);
    }

    public long getDayLength() {
        return 144000L;
    }

    public Class<? extends IChunkProvider> getChunkProviderClass() {
        return ChunkProviderPluto.class;
    }

    public Class<? extends WorldChunkManager> getWorldChunkManagerClass() {
        return WorldChunkManagerPluto.class;
    }

    @SideOnly(value=Side.CLIENT)
    public float getStarBrightness(float bright) {
        float var2 = this.field_76579_a.func_72826_c(bright);
        float var3 = 1.0f - (MathHelper.func_76134_b((float)(var2 * (float)Math.PI * 2.0f)) * 2.0f + 0.25f);
        if (var3 < 0.0f) {
            var3 = 0.25f;
        }
        if (var3 > 1.0f) {
            var3 = 0.75f;
        }
        return var3 * var3 * 0.5f + 0.2f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getSunBrightness(float bright) {
        float f1 = this.field_76579_a.func_72826_c(1.0f);
        float f2 = 1.0f - (MathHelper.func_76134_b((float)(f1 * (float)Math.PI * 2.0f)) * 2.0f + 0.2f);
        if (f2 < 0.0f) {
            f2 = 0.6f;
        }
        if (f2 < 0.4f) {
            f2 = 0.8f;
        }
        if (f2 > 1.0f) {
            f2 = 0.95f;
        }
        f2 = 0.95f - f2;
        return f2 * 1.0f;
    }

    public double getSolarEnergyMultiplier() {
        return 1.0;
    }

    public float getGravity() {
        return 0.0715f;
    }

    public double getMeteorFrequency() {
        return 2.5;
    }

    public boolean canSpaceshipTierPass(int tier) {
        return tier >= 5;
    }

    public float getFallDamageModifier() {
        return 0.16f;
    }

    public float getSoundVolReductionAmount() {
        return 20.0f;
    }

    public CelestialBody getCelestialBody() {
        return MorePlanetsCore.pluto;
    }

    @Override
    public boolean hasBreathableAtmosphere() {
        return false;
    }

    public float getThermalLevelModifier() {
        if (this.isDaytime()) {
            return 0.0f;
        }
        return -1.5f;
    }

    public float getWindLevel() {
        return 0.0f;
    }

    @Override
    public double getUltraVioletEnergyMultiplie() {
        return 1.25;
    }
}

