/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.planets.pluto.blocks;

import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.oredict.OreDictionary;
import stevekung.mods.moreplanets.core.blocks.BlockStairsMP;
import stevekung.mods.moreplanets.planets.pluto.blocks.BlockBasicPluto;
import stevekung.mods.moreplanets.planets.pluto.blocks.BlockFrozenMethane;
import stevekung.mods.moreplanets.planets.pluto.blocks.BlockFrozenNitrogen;
import stevekung.mods.moreplanets.planets.pluto.blocks.BlockPlutoAncientChest;
import stevekung.mods.moreplanets.planets.pluto.blocks.BlockPlutoTreasureChest;
import stevekung.mods.moreplanets.planets.pluto.blocks.BlockSpacePotato;
import stevekung.mods.moreplanets.planets.pluto.blocks.BlockXeoniumGlowstone;
import stevekung.mods.moreplanets.planets.pluto.blocks.BlockXeoniumTorch;
import stevekung.mods.moreplanets.planets.pluto.fluids.BlockFluidMethane;
import stevekung.mods.moreplanets.planets.pluto.fluids.BlockFluidNitrogen;
import stevekung.mods.moreplanets.planets.pluto.itemblocks.ItemBlockPluto;
import stevekung.mods.stevecore.RegisterHelper;

public class PlutoBlocks {
    public static Block pluto_block;
    public static Block xeonium_glowstone;
    public static Block xeonium_torch;
    public static Block frozen_methane_block;
    public static Block frozen_nitrogen_block;
    public static Block pluto_ancient_chest;
    public static Block pluto_treasure_chest;
    public static Block space_potato_block;
    public static Block liquid_methane;
    public static Block liquid_nitrogen;
    public static Block pluto_cobblestone_stairs;
    public static Block pluto_dungeon_brick_stairs;
    public static Fluid liquid_methane_fluid;
    public static Fluid liquid_nitrogen_fluid;

    public static void init() {
        PlutoBlocks.initBlocks();
        PlutoBlocks.setHarvestLevels();
        PlutoBlocks.registerBlocks();
    }

    private static void initBlocks() {
        pluto_block = new BlockBasicPluto("pluto_block");
        xeonium_glowstone = new BlockXeoniumGlowstone("xeonium_glowstone");
        xeonium_torch = new BlockXeoniumTorch("xeonium_torch");
        frozen_methane_block = new BlockFrozenMethane("frozen_methane_block");
        frozen_nitrogen_block = new BlockFrozenNitrogen("frozen_nitrogen_block");
        pluto_ancient_chest = new BlockPlutoAncientChest("pluto_ancient_chest");
        pluto_treasure_chest = new BlockPlutoTreasureChest("pluto_treasure_chest");
        space_potato_block = new BlockSpacePotato("space_potato_block");
        pluto_cobblestone_stairs = new BlockStairsMP("pluto_cobblestone_stairs", 2.0f, BlockStairsMP.StairsCategory.pluto_cobblestone, Blocks.field_150348_b);
        pluto_dungeon_brick_stairs = new BlockStairsMP("pluto_dungeon_brick_stairs", 2.0f, BlockStairsMP.StairsCategory.pluto_dungeon_brick, Blocks.field_150348_b);
        liquid_methane_fluid = new Fluid("liquid_methane_fluid").setBlock(liquid_methane).setViscosity(3000);
        liquid_nitrogen_fluid = new Fluid("liquid_nitrogen_fluid").setBlock(liquid_nitrogen).setViscosity(3000);
        FluidRegistry.registerFluid((Fluid)liquid_methane_fluid);
        FluidRegistry.registerFluid((Fluid)liquid_nitrogen_fluid);
        liquid_methane = new BlockFluidMethane("liquid_methane_fluid");
        liquid_nitrogen = new BlockFluidNitrogen("liquid_nitrogen_fluid");
    }

    private static void setHarvestLevels() {
        pluto_block.setHarvestLevel("pickaxe", 3);
        frozen_methane_block.setHarvestLevel("pickaxe", 2);
        frozen_nitrogen_block.setHarvestLevel("pickaxe", 2);
        pluto_cobblestone_stairs.setHarvestLevel("pickaxe", 0);
        pluto_dungeon_brick_stairs.setHarvestLevel("pickaxe", 0);
        pluto_ancient_chest.setHarvestLevel("axe", 0);
    }

    private static void registerBlocks() {
        RegisterHelper.registerBlock(pluto_block, ItemBlockPluto.class);
        RegisterHelper.registerBlock(xeonium_glowstone);
        RegisterHelper.registerBlock(frozen_methane_block);
        RegisterHelper.registerBlock(frozen_nitrogen_block);
        RegisterHelper.registerBlock(pluto_ancient_chest);
        RegisterHelper.registerBlock(pluto_treasure_chest);
        RegisterHelper.registerBlock(pluto_cobblestone_stairs);
        RegisterHelper.registerBlock(pluto_dungeon_brick_stairs);
        RegisterHelper.registerBlock(xeonium_torch);
        RegisterHelper.registerBlock(liquid_methane);
        RegisterHelper.registerBlock(liquid_nitrogen);
        RegisterHelper.registerBlock(space_potato_block);
        OreDictionary.registerOre((String)"oreMeteor", (ItemStack)new ItemStack(pluto_block, 1, 4));
        OreDictionary.registerOre((String)"oreFrozenIron", (ItemStack)new ItemStack(pluto_block, 1, 5));
        OreDictionary.registerOre((String)"oreIron", (ItemStack)new ItemStack(pluto_block, 1, 6));
        OreDictionary.registerOre((String)"oreXeonium", (ItemStack)new ItemStack(pluto_block, 1, 7));
    }
}

