/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.planets.nibiru.worldgen;

import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedCreeper;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSkeleton;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSpider;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedZombie;
import micdoodle8.mods.galacticraft.core.perlin.NoiseModule;
import micdoodle8.mods.galacticraft.core.perlin.generator.Gradient;
import micdoodle8.mods.galacticraft.core.world.gen.EnumCraterSize;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.MapGenDungeon;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderGenerate;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import stevekung.mods.moreplanets.core.entities.EntityEvolvedWitch;
import stevekung.mods.moreplanets.core.init.MPBlocks;
import stevekung.mods.moreplanets.core.worldgen.MapGenCaveMP;
import stevekung.mods.moreplanets.core.worldgen.dungeon.RoomEmptyMP;
import stevekung.mods.moreplanets.core.worldgen.feature.WorldGenSpaceDungeons;
import stevekung.mods.moreplanets.core.worldgen.feature.WorldGenSplashBlock;
import stevekung.mods.moreplanets.planets.diona.entities.EntityEvolvedEnderman;
import stevekung.mods.moreplanets.planets.nibiru.blocks.NibiruBlocks;
import stevekung.mods.moreplanets.planets.nibiru.entities.EntityGiantWorm;
import stevekung.mods.moreplanets.planets.nibiru.entities.EntityInfectedZombie;
import stevekung.mods.moreplanets.planets.nibiru.worldgen.BiomeDecoratorNibiru;
import stevekung.mods.moreplanets.planets.nibiru.worldgen.BiomeGenBaseNibiru;
import stevekung.mods.moreplanets.planets.nibiru.worldgen.MapGenCavernNibiru;
import stevekung.mods.moreplanets.planets.nibiru.worldgen.MapGenNibiruRavine;
import stevekung.mods.moreplanets.planets.nibiru.worldgen.dungeon.RoomBossNibiru;
import stevekung.mods.moreplanets.planets.nibiru.worldgen.dungeon.RoomChestsNibiru;
import stevekung.mods.moreplanets.planets.nibiru.worldgen.dungeon.RoomSpawnerNibiru;
import stevekung.mods.moreplanets.planets.nibiru.worldgen.dungeon.RoomTreasureNibiru;
import stevekung.mods.moreplanets.planets.nibiru.worldgen.tree.WorldGenNibiruFruitTree;

public class ChunkProviderNibiru
extends ChunkProviderGenerate {
    Block topBlockID = NibiruBlocks.nibiru_block;
    byte topBlockMeta = 0;
    Block fillBlockID = NibiruBlocks.nibiru_block;
    byte fillBlockMeta = 1;
    Block lowerBlockID = NibiruBlocks.nibiru_block;
    byte lowerBlockMeta = (byte)2;
    private Random rand;
    private Gradient noiseGen1;
    private Gradient noiseGen2;
    private Gradient noiseGen3;
    private Gradient noiseGen4;
    private Gradient noiseGen5;
    private Gradient noiseGen6;
    private Gradient noiseGen7;
    private NoiseModule noiseCraterGen;
    private World worldObj;
    public BiomeDecoratorNibiru biomedecoratorplanet = new BiomeDecoratorNibiru();
    private MapGenCaveMP caveGenerator = new MapGenCaveMP(NibiruBlocks.nibiru_block);
    private MapGenCavernNibiru cavernGenerator = new MapGenCavernNibiru();
    private MapGenNibiruRavine ravineGenerator = new MapGenNibiruRavine();
    private MapGenDungeon dungeonGenerator = new MapGenDungeon(NibiruBlocks.nibiru_block, 12, 8, 24, 4);
    private BiomeGenBase[] biomesForGeneration;
    private static double TERRAIN_HEIGHT_MOD = 18.0;
    private static double SMALL_FEATURE_HEIGHT_MOD = 36.0;
    private static double MOUNTAIN_HEIGHT_MOD = 120.0;
    private static double VALLEY_HEIGHT_MOD = 64.0;
    private static int CRATER_PROB = 300;
    private static int MID_HEIGHT = 86;
    private static int CHUNK_SIZE_X = 16;
    private static int CHUNK_SIZE_Y = 256;
    private static int CHUNK_SIZE_Z = 16;
    private static double MAIN_FEATURE_FILTER_MOD = 8.0;
    private static double LARGE_FEATURE_FILTER_MOD = 12.0;
    private static double SMALL_FEATURE_FILTER_MOD = 12.0;

    public ChunkProviderNibiru(World par1World, long par2, boolean par4) {
        super(par1World, par2, par4);
        this.dungeonGenerator.otherRooms.add(new RoomEmptyMP(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.otherRooms.add(new RoomSpawnerNibiru(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.otherRooms.add(new RoomSpawnerNibiru(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.otherRooms.add(new RoomSpawnerNibiru(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.otherRooms.add(new RoomSpawnerNibiru(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.otherRooms.add(new RoomSpawnerNibiru(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.otherRooms.add(new RoomSpawnerNibiru(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.otherRooms.add(new RoomSpawnerNibiru(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.otherRooms.add(new RoomSpawnerNibiru(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.otherRooms.add(new RoomChestsNibiru(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.otherRooms.add(new RoomChestsNibiru(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.bossRooms.add(new RoomBossNibiru(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.treasureRooms.add(new RoomTreasureNibiru(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.biomesForGeneration = new BiomeGenBase[]{BiomeGenBaseNibiru.nibiru};
        this.worldObj = par1World;
        this.rand = new Random(par2);
        this.noiseGen1 = new Gradient(this.rand.nextLong(), 4, 0.25f);
        this.noiseGen2 = new Gradient(this.rand.nextLong(), 4, 0.25f);
        this.noiseGen3 = new Gradient(this.rand.nextLong(), 4, 0.25f);
        this.noiseGen4 = new Gradient(this.rand.nextLong(), 2, 0.25f);
        this.noiseGen5 = new Gradient(this.rand.nextLong(), 1, 0.25f);
        this.noiseGen6 = new Gradient(this.rand.nextLong(), 1, 0.25f);
        this.noiseGen7 = new Gradient(this.rand.nextLong(), 1, 0.25f);
        this.noiseCraterGen = new Gradient(this.rand.nextLong(), 1, 0.25f);
    }

    public void generateTerrain(int chunkX, int chunkZ, Block[] idArray, byte[] metaArray) {
        this.noiseGen1.setFrequency(0.0125f);
        this.noiseGen2.setFrequency(0.015f);
        this.noiseGen3.setFrequency(0.01f);
        this.noiseGen4.setFrequency(0.02f);
        this.noiseGen5.setFrequency(0.01f);
        this.noiseGen6.setFrequency(0.001f);
        this.noiseGen7.setFrequency(0.005f);
        this.noiseCraterGen.setFrequency(0.02f);
        for (int x = 0; x < CHUNK_SIZE_X; ++x) {
            for (int z = 0; z < CHUNK_SIZE_Z; ++z) {
                double baseHeight = (double)this.noiseGen1.getNoise((float)(chunkX * 16 + x), (float)(chunkZ * 16 + z)) * TERRAIN_HEIGHT_MOD;
                double smallHillHeight = (double)this.noiseGen2.getNoise((float)(chunkX * 16 + x), (float)(chunkZ * 16 + z)) * SMALL_FEATURE_HEIGHT_MOD;
                double mountainHeight = Math.abs(this.noiseGen3.getNoise((float)(chunkX * 16 + x), (float)(chunkZ * 16 + z)));
                double valleyHeight = Math.abs(this.noiseGen4.getNoise((float)(chunkX * 16 + x), (float)(chunkZ * 16 + z)));
                double featureFilter = (double)this.noiseGen5.getNoise((float)(chunkX * 16 + x), (float)(chunkZ * 16 + z)) * MAIN_FEATURE_FILTER_MOD;
                double largeFilter = (double)this.noiseGen6.getNoise((float)(chunkX * 16 + x), (float)(chunkZ * 16 + z)) * LARGE_FEATURE_FILTER_MOD;
                double smallFilter = (double)this.noiseGen7.getNoise((float)(chunkX * 16 + x), (float)(chunkZ * 16 + z)) * SMALL_FEATURE_FILTER_MOD - 0.5;
                mountainHeight = this.lerp(smallHillHeight, mountainHeight * MOUNTAIN_HEIGHT_MOD, this.fade(this.clamp(mountainHeight * 2.0, 0.0, 1.0)));
                valleyHeight = this.lerp(smallHillHeight, valleyHeight * VALLEY_HEIGHT_MOD - VALLEY_HEIGHT_MOD + 9.0, this.fade(this.clamp((valleyHeight + 2.0) * 4.0, 0.0, 1.0)));
                double yDev = this.lerp(valleyHeight, mountainHeight, this.fade(largeFilter));
                yDev = this.lerp(smallHillHeight, yDev, smallFilter);
                yDev = this.lerp(baseHeight, yDev, featureFilter);
                for (int y = 0; y < CHUNK_SIZE_Y; ++y) {
                    if (!((double)y < (double)MID_HEIGHT + yDev)) continue;
                    idArray[this.getIndex((int)x, (int)y, (int)z)] = this.lowerBlockID;
                    metaArray[this.getIndex((int)x, (int)y, (int)z)] = this.lowerBlockMeta;
                }
            }
        }
    }

    private double lerp(double d1, double d2, double t) {
        if (t < 0.0) {
            return d1;
        }
        if (t > 1.0) {
            return d2;
        }
        return d1 + (d2 - d1) * t;
    }

    private double fade(double n) {
        return n * n * n * (n * (n * 6.0 - 15.0) + 10.0);
    }

    private double clamp(double x, double min, double max) {
        if (x < min) {
            return min;
        }
        if (x > max) {
            return max;
        }
        return x;
    }

    public void func_147422_a(int par1, int par2, Block[] arrayOfIDs, byte[] arrayOfMeta, BiomeGenBase[] par4ArrayOfBiomeGenBase) {
        int var5 = 20;
        for (int var8 = 0; var8 < 16; ++var8) {
            for (int var9 = 0; var9 < 16; ++var9) {
                int var12 = (int)((double)this.noiseGen4.getNoise((float)(par1 * 16 + var8), (float)(par2 * 16 + var9)) / 3.0 + 3.0 + this.rand.nextDouble() * 0.25);
                int var13 = -1;
                Block var14 = this.topBlockID;
                byte var14m = this.topBlockMeta;
                Block var15 = this.fillBlockID;
                byte var15m = this.fillBlockMeta;
                for (int var16 = CHUNK_SIZE_Y - 1; var16 >= 0; --var16) {
                    int index = this.getIndex(var8, var16, var9);
                    if (var16 <= 0 + this.rand.nextInt(5)) {
                        arrayOfIDs[index] = Blocks.field_150357_h;
                        continue;
                    }
                    Block var18 = arrayOfIDs[index];
                    if (Blocks.field_150350_a == var18) {
                        var13 = -1;
                        continue;
                    }
                    if (var18 != this.lowerBlockID) continue;
                    arrayOfMeta[index] = this.lowerBlockMeta;
                    if (var13 == -1) {
                        if (var12 <= 0) {
                            var14 = Blocks.field_150350_a;
                            var14m = 0;
                            var15 = this.lowerBlockID;
                            var15m = this.lowerBlockMeta;
                        } else if (var16 >= var5 - -16 && var16 <= var5 + 1) {
                            var14 = this.topBlockID;
                            var14m = this.topBlockMeta;
                            var14 = this.fillBlockID;
                            var14m = this.fillBlockMeta;
                        }
                        var13 = var12;
                        if (var16 >= var5 - 1) {
                            arrayOfIDs[index] = var14;
                            arrayOfMeta[index] = var14m;
                            continue;
                        }
                        arrayOfIDs[index] = var15;
                        arrayOfMeta[index] = var15m;
                        continue;
                    }
                    if (var13 <= 0) continue;
                    --var13;
                    arrayOfIDs[index] = var15;
                    arrayOfMeta[index] = var15m;
                }
            }
        }
    }

    public Chunk func_73154_d(int par1, int par2) {
        this.rand.setSeed((long)par1 * 341873128712L + (long)par2 * 132897987541L);
        Object[] ids = new Block[65536];
        byte[] meta = new byte[65536];
        Arrays.fill(ids, Blocks.field_150350_a);
        this.generateTerrain(par1, par2, (Block[])ids, meta);
        this.biomesForGeneration = this.worldObj.func_72959_q().func_76933_b(this.biomesForGeneration, par1 * 16, par2 * 16, 16, 16);
        this.createCraters(par1, par2, (Block[])ids, meta);
        this.func_147422_a(par1, par2, (Block[])ids, meta, this.biomesForGeneration);
        this.caveGenerator.generate((IChunkProvider)this, this.worldObj, par1, par2, (Block[])ids, meta);
        this.cavernGenerator.generate((IChunkProvider)this, this.worldObj, par1, par2, (Block[])ids, meta);
        this.ravineGenerator.func_151539_a((IChunkProvider)this, this.worldObj, par1, par2, (Block[])ids);
        this.dungeonGenerator.generateUsingArrays(this.worldObj, this.worldObj.func_72905_C(), par1 * 16, 30, par2 * 16, par1, par2, (Block[])ids, meta);
        Chunk var4 = new Chunk(this.worldObj, (Block[])ids, meta, par1, par2);
        byte[] var5 = var4.func_76605_m();
        for (int var6 = 0; var6 < var5.length; ++var6) {
            var5[var6] = (byte)this.biomesForGeneration[var6].field_76756_M;
        }
        var4.func_76603_b();
        return var4;
    }

    public void createCraters(int chunkX, int chunkZ, Block[] chunkArray, byte[] metaArray) {
        for (int cx = chunkX - 2; cx <= chunkX + 2; ++cx) {
            for (int cz = chunkZ - 2; cz <= chunkZ + 2; ++cz) {
                for (int x = 0; x < CHUNK_SIZE_X; ++x) {
                    for (int z = 0; z < CHUNK_SIZE_Z; ++z) {
                        if (!(Math.abs(this.randFromPoint(cx * 16 + x, (cz * 16 + z) * 1000)) < (double)(this.noiseCraterGen.getNoise((float)(x * CHUNK_SIZE_X + x), (float)(cz * CHUNK_SIZE_Z + z)) / (float)CRATER_PROB))) continue;
                        Random random = new Random(cx * 16 + x + (cz * 16 + z) * 5000);
                        EnumCraterSize cSize = EnumCraterSize.sizeArray[random.nextInt(EnumCraterSize.sizeArray.length)];
                        int size = random.nextInt(cSize.MAX_SIZE - cSize.MIN_SIZE) + cSize.MIN_SIZE;
                        this.makeCrater(cx * 16 + x, cz * 16 + z, chunkX * 16, chunkZ * 16, size, chunkArray, metaArray);
                    }
                }
            }
        }
    }

    public void makeCrater(int craterX, int craterZ, int chunkX, int chunkZ, int size, Block[] chunkArray, byte[] metaArray) {
        for (int x = 0; x < CHUNK_SIZE_X; ++x) {
            block1: for (int z = 0; z < CHUNK_SIZE_Z; ++z) {
                double xDev = craterX - (chunkX + x);
                double zDev = craterZ - (chunkZ + z);
                if (!(xDev * xDev + zDev * zDev < (double)(size * size))) continue;
                double sqrtY = (xDev /= (double)size) * xDev + (zDev /= (double)size) * zDev;
                double yDev = sqrtY * sqrtY * 6.0;
                yDev = 5.0 - yDev;
                int helper = 0;
                for (int y = 127; y > 0; --y) {
                    if (Blocks.field_150350_a != chunkArray[this.getIndex(x, y, z)] && (double)helper <= yDev) {
                        chunkArray[this.getIndex((int)x, (int)y, (int)z)] = Blocks.field_150350_a;
                        metaArray[this.getIndex((int)x, (int)y, (int)z)] = 0;
                        ++helper;
                    }
                    if ((double)helper > yDev) continue block1;
                }
            }
        }
    }

    private int getIndex(int x, int y, int z) {
        return (x * 16 + z) * 256 + y;
    }

    private double randFromPoint(int x, int z) {
        int n = x + z * 57;
        n = n << 13 ^ n;
        return 1.0 - (double)(n * (n * n * 15731 + 789221) + 1376312589 & Integer.MAX_VALUE) / 1.073741824E9;
    }

    public boolean func_73149_a(int par1, int par2) {
        return true;
    }

    public void decoratePlanet(World par1World, Random par2Random, int par3, int par4) {
        this.biomedecoratorplanet.decorate(par1World, par2Random, par3, par4);
    }

    public void func_73153_a(IChunkProvider chunk, int chunkX, int chunkZ) {
        int i;
        int i2;
        int z;
        int y;
        int x;
        BlockFalling.field_149832_M = true;
        int var4 = chunkX * 16;
        int var5 = chunkZ * 16;
        this.worldObj.func_72807_a(var4 + 16, var5 + 16);
        this.rand.setSeed(this.worldObj.func_72905_C());
        long var7 = this.rand.nextLong() / 2L * 2L + 1L;
        long var9 = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)chunkX * var7 + (long)chunkZ * var9 ^ this.worldObj.func_72905_C());
        this.dungeonGenerator.handleTileEntities(this.rand);
        this.decoratePlanet(this.worldObj, this.rand, var4, var5);
        for (int i3 = 0; i3 < 8; ++i3) {
            x = var4 + this.rand.nextInt(16) + 8;
            y = this.rand.nextInt(256);
            z = var5 + this.rand.nextInt(16) + 8;
            new WorldGenSpaceDungeons(NibiruBlocks.nibiru_ancient_chest, NibiruBlocks.nibiru_block, MPBlocks.space_mossy_cobblestone, 2).func_76484_a(this.worldObj, this.rand, x, y, z);
        }
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Pre(chunk, this.worldObj, this.rand, chunkX, chunkZ, false));
        boolean doGen = TerrainGen.populate((IChunkProvider)chunk, (World)this.worldObj, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.FIRE);
        for (i2 = 0; doGen && i2 < 2; ++i2) {
            if (this.rand.nextInt(5) != 0) continue;
            x = var4 + this.rand.nextInt(16) + 8;
            y = this.rand.nextInt(240) + 16;
            z = var5 + this.rand.nextInt(16) + 8;
            new WorldGenSplashBlock(NibiruBlocks.oil_rock, 0, NibiruBlocks.nibiru_block, 0).func_76484_a(this.worldObj, this.rand, x, y, z);
        }
        for (i2 = 0; doGen && i2 < 4; ++i2) {
            if (this.rand.nextInt(5) != 0) continue;
            x = var4 + this.rand.nextInt(16) + 8;
            y = this.rand.nextInt(240) + 16;
            z = var5 + this.rand.nextInt(16) + 8;
            new WorldGenSplashBlock(NibiruBlocks.infected_grass, 0, NibiruBlocks.nibiru_block, 0).func_76484_a(this.worldObj, this.rand, x, y, z);
        }
        for (i2 = 0; doGen && i2 < 4; ++i2) {
            if (this.rand.nextInt(5) != 0) continue;
            x = var4 + this.rand.nextInt(16) + 8;
            y = this.rand.nextInt(240) + 16;
            z = var5 + this.rand.nextInt(16) + 8;
            new WorldGenSplashBlock(NibiruBlocks.infected_dirt, 0, NibiruBlocks.nibiru_block, 0).func_76484_a(this.worldObj, this.rand, x, y, z);
        }
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Post(chunk, this.worldObj, this.rand, chunkX, chunkZ, false));
        boolean tree = TerrainGen.decorate((World)this.worldObj, (Random)this.rand, (int)chunkX, (int)chunkZ, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.TREE);
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Pre(this.worldObj, this.rand, chunkX, chunkZ));
        for (i = 0; tree && i < 100; ++i) {
            x = var4 + this.rand.nextInt(16) + 8;
            y = this.rand.nextInt(256);
            z = var5 + this.rand.nextInt(16) + 8;
            new WorldGenNibiruFruitTree(NibiruBlocks.nibiru_log, NibiruBlocks.ancient_dark_leaves, 0, true).func_76484_a(this.worldObj, this.rand, x, y, z);
        }
        for (i = 0; tree && i < 100; ++i) {
            x = var4 + this.rand.nextInt(16) + 8;
            y = this.rand.nextInt(256);
            z = var5 + this.rand.nextInt(16) + 8;
            new WorldGenNibiruFruitTree(NibiruBlocks.nibiru_log, NibiruBlocks.orange_leaves, 1, true).func_76484_a(this.worldObj, this.rand, x, y, z);
        }
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Post(this.worldObj, this.rand, chunkX, chunkZ));
        BlockFalling.field_149832_M = false;
    }

    public void func_82695_e(int par1, int par2) {
    }

    public boolean func_73151_a(boolean par1, IProgressUpdate par2IProgressUpdate) {
        return true;
    }

    public boolean func_73157_c() {
        return true;
    }

    public String func_73148_d() {
        return "NibiruLevelSource";
    }

    public List func_73155_a(EnumCreatureType par1EnumCreatureType, int i, int j, int k) {
        if (par1EnumCreatureType == EnumCreatureType.monster) {
            ArrayList<BiomeGenBase.SpawnListEntry> monsters = new ArrayList<BiomeGenBase.SpawnListEntry>();
            monsters.add(new BiomeGenBase.SpawnListEntry(EntityInfectedZombie.class, 100, 4, 4));
            monsters.add(new BiomeGenBase.SpawnListEntry(EntityEvolvedZombie.class, 100, 4, 4));
            monsters.add(new BiomeGenBase.SpawnListEntry(EntityEvolvedSpider.class, 100, 4, 4));
            monsters.add(new BiomeGenBase.SpawnListEntry(EntityEvolvedSkeleton.class, 100, 4, 4));
            monsters.add(new BiomeGenBase.SpawnListEntry(EntityEvolvedCreeper.class, 100, 4, 4));
            monsters.add(new BiomeGenBase.SpawnListEntry(EntityEvolvedEnderman.class, 10, 1, 4));
            monsters.add(new BiomeGenBase.SpawnListEntry(EntityEvolvedWitch.class, 5, 1, 1));
            monsters.add(new BiomeGenBase.SpawnListEntry(EntityGiantWorm.class, 100, 2, 4));
            return monsters;
        }
        return null;
    }
}

