/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.planets.nibiru.dimension;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import net.minecraft.util.MathHelper;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.chunk.IChunkProvider;
import stevekung.mods.moreplanets.core.MorePlanetsCore;
import stevekung.mods.moreplanets.core.dimension.WorldProviderMP;
import stevekung.mods.moreplanets.core.world.ILightningStorm;
import stevekung.mods.moreplanets.planets.nibiru.worldgen.ChunkProviderNibiru;
import stevekung.mods.moreplanets.planets.nibiru.worldgen.WorldChunkManagerNibiru;

public class WorldProviderNibiru
extends WorldProviderMP
implements ILightningStorm {
    public Vector3 getFogColor() {
        float f = 1.0f - this.getStarBrightness(1.0f);
        return new Vector3((double)(0.6392157f * f), (double)(0.35686275f * f), (double)(0.17254902f * f));
    }

    public Vector3 getSkyColor() {
        float f = 1.15f - this.getStarBrightness(1.0f);
        return new Vector3((double)(0.7647059f * f), (double)(0.43137255f * f), (double)(0.19607843f * f));
    }

    public long getDayLength() {
        return 120000L;
    }

    public Class<? extends IChunkProvider> getChunkProviderClass() {
        return ChunkProviderNibiru.class;
    }

    public Class<? extends WorldChunkManager> getWorldChunkManagerClass() {
        return WorldChunkManagerNibiru.class;
    }

    @SideOnly(value=Side.CLIENT)
    public float getStarBrightness(float bright) {
        float f1 = this.field_76579_a.func_72826_c(bright);
        float f2 = 1.0f - (MathHelper.func_76134_b((float)(f1 * (float)Math.PI * 2.0f)) * 2.0f + 0.25f);
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 0.95f;
        }
        return f2 * f2 * 0.6f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getSunBrightness(float bright) {
        float f1 = this.field_76579_a.func_72826_c(1.0f);
        float f2 = -0.7f - (MathHelper.func_76134_b((float)(f1 * (float)Math.PI * 2.0f)) * 2.0f + 0.2f);
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        f2 = 1.0f - f2;
        return f2 * 1.0f;
    }

    public double getSolarEnergyMultiplier() {
        return 0.8;
    }

    public float getGravity() {
        return 0.042f;
    }

    public double getMeteorFrequency() {
        return 4.0;
    }

    public boolean canSpaceshipTierPass(int tier) {
        return tier >= 6;
    }

    public float getFallDamageModifier() {
        return 0.58f;
    }

    public float getSoundVolReductionAmount() {
        return 5.0f;
    }

    public CelestialBody getCelestialBody() {
        return MorePlanetsCore.nibiru;
    }

    @Override
    public boolean hasBreathableAtmosphere() {
        return false;
    }

    public float getThermalLevelModifier() {
        if (this.isDaytime()) {
            return 2.5f;
        }
        return 1.0f;
    }

    public float getWindLevel() {
        return 0.4f;
    }

    @Override
    public double getUltraVioletEnergyMultiplie() {
        return 12.0;
    }

    @Override
    public double getLightningStormFrequency() {
        return 4.0;
    }
}

