/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.planets.nibiru.blocks;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.util.ForgeDirection;
import stevekung.mods.moreplanets.core.blocks.base.BlockBaseMP;
import stevekung.mods.moreplanets.core.event.MorePlanetEvents;
import stevekung.mods.moreplanets.planets.nibiru.blocks.NibiruBlocks;
import stevekung.mods.moreplanets.planets.nibiru.entities.EntityInfectedWorm;

public class BlockInfectedCavernousVine
extends BlockBaseMP
implements IShearable {
    public BlockInfectedCavernousVine(String name) {
        super(Material.field_151582_l);
        this.func_149715_a(1.0f);
        this.func_149675_a(true);
        this.func_149672_a(Block.field_149779_h);
        this.func_149663_c(name);
        this.func_149658_d("nibiru:infected_cavernous_vine");
    }

    public MovingObjectPosition func_149731_a(World world, int x, int y, int z, Vec3 vec3d, Vec3 vec3d1) {
        return super.func_149731_a(world, x, y, z, vec3d, vec3d1);
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        if (world.func_147468_f(x, y, z)) {
            int y2 = y - 1;
            while (world.func_147439_a(x, y2, z) == this) {
                world.func_147468_f(x, y2, z);
                --y2;
            }
            return true;
        }
        return false;
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        if (entity instanceof EntityLivingBase) {
            if (entity instanceof EntityPlayer && (((EntityPlayer)entity).field_71075_bZ.field_75098_d || ((EntityPlayer)entity).field_71075_bZ.field_75100_b)) {
                return;
            }
            entity.field_70181_x = 0.07f;
            if (!((EntityLivingBase)entity).func_70651_bq().contains(Potion.field_76436_u)) {
                ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, 5, 20, false));
            }
        }
        if (entity instanceof EntityPlayer && world.field_73012_v.nextInt(1000) == 0 && !world.field_72995_K) {
            EntityInfectedWorm worm = new EntityInfectedWorm(world);
            worm.func_70012_b((double)x + 0.5, y, (double)z + 0.5, 0.0f, 0.0f);
            world.func_72838_d((Entity)worm);
        }
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        return this.getVineLight(world, x, y, z);
    }

    public int func_149645_b() {
        return 1;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return null;
    }

    public boolean func_149707_d(World world, int x, int y, int z, int side) {
        return ForgeDirection.getOrientation((int)side) == ForgeDirection.DOWN && world.func_147439_a(x, y + 1, z).func_149688_o().func_76220_a();
    }

    public int getVineLength(IBlockAccess world, int x, int y, int z) {
        int vineCount = 0;
        int y2 = y;
        while (world.func_147439_a(x, y2, z) == NibiruBlocks.infected_cavernous_vine) {
            ++vineCount;
            ++y2;
        }
        return vineCount;
    }

    public int getVineLight(IBlockAccess world, int x, int y, int z) {
        int vineCount = 0;
        int y2 = y;
        while (world.func_147439_a(x, y2, z) == NibiruBlocks.infected_cavernous_vine) {
            vineCount += 4;
            --y2;
        }
        return Math.max(19 - vineCount, 0);
    }

    public int func_149738_a(World par1World) {
        return 50;
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        if (!world.field_72995_K) {
            for (int y2 = y - 1; y2 >= y - 2; --y2) {
                Block block = world.func_147439_a(x, y2, z);
                if (block != null && block.isAir((IBlockAccess)world, x, y, z)) continue;
                return;
            }
            world.func_147465_d(x, y - 1, z, (Block)this, 0, 2);
            world.func_147451_t(x, y, z);
        }
    }

    public Item func_149650_a(int par1, Random par2Random, int par3) {
        return Item.func_150898_a((Block)Blocks.field_150350_a);
    }

    public int func_149745_a(Random par1Random) {
        return 0;
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y + 1, z);
        return block == this || block.func_149688_o().func_76220_a();
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        super.func_149695_a(world, x, y, z, block);
        if (!this.func_149718_j(world, x, y, z)) {
            world.func_147468_f(x, y, z);
        }
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public ArrayList<ItemStack> onSheared(ItemStack item, IBlockAccess world, int x, int y, int z, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(new ItemStack((Block)this, 1, 0));
        return ret;
    }

    public boolean isLadder(IBlockAccess world, int x, int y, int z, EntityLivingBase entity) {
        return true;
    }

    public void func_149636_a(World world, EntityPlayer player, int x, int y, int z, int fortune) {
        super.func_149636_a(world, player, x, y, z, fortune);
        MorePlanetEvents.addInfectedGas(player);
    }
}

