/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.planets.mercury.blocks;

import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.oredict.OreDictionary;
import stevekung.mods.moreplanets.core.blocks.BlockStairsMP;
import stevekung.mods.moreplanets.planets.mercury.blocks.BlockBasicMercury;
import stevekung.mods.moreplanets.planets.mercury.blocks.BlockMercuryAncientChest;
import stevekung.mods.moreplanets.planets.mercury.blocks.BlockMercuryIce;
import stevekung.mods.moreplanets.planets.mercury.blocks.BlockMercuryTreasureChest;
import stevekung.mods.moreplanets.planets.mercury.blocks.BlockMetallicRock;
import stevekung.mods.moreplanets.planets.mercury.fluids.BlockFluidDirtyWater;
import stevekung.mods.moreplanets.planets.mercury.itemblocks.ItemBlockMercury;
import stevekung.mods.stevecore.RegisterHelper;

public class MercuryBlocks {
    public static Block mercury_block;
    public static Block mercury_ice;
    public static Block metallic_rock;
    public static Block mercury_ancient_chest;
    public static Block mercury_treasure_chest;
    public static Block mercury_cobblestone_stairs;
    public static Block mercury_dungeon_brick_stairs;
    public static Block dirty_water;
    public static Fluid dirty_water_fluid;

    public static void init() {
        MercuryBlocks.initBlocks();
        MercuryBlocks.setHarvestLevels();
        MercuryBlocks.registerBlocks();
    }

    private static void initBlocks() {
        mercury_block = new BlockBasicMercury("mercury_block");
        mercury_ice = new BlockMercuryIce("mercury_ice");
        metallic_rock = new BlockMetallicRock("metallic_rock");
        mercury_cobblestone_stairs = new BlockStairsMP("mercury_cobblestone_stairs", 2.5f, BlockStairsMP.StairsCategory.mercury_cobblestone, Blocks.field_150348_b);
        mercury_dungeon_brick_stairs = new BlockStairsMP("mercury_dungeon_brick_stairs", 4.0f, BlockStairsMP.StairsCategory.mercury_brick, Blocks.field_150348_b);
        mercury_ancient_chest = new BlockMercuryAncientChest("mercury_ancient_chest");
        mercury_treasure_chest = new BlockMercuryTreasureChest("mercury_treasure_chest");
        dirty_water_fluid = new Fluid("dirty_water_fluid").setBlock(dirty_water);
        FluidRegistry.registerFluid((Fluid)dirty_water_fluid);
        dirty_water = new BlockFluidDirtyWater("dirty_water_fluid");
    }

    private static void setHarvestLevels() {
        mercury_block.setHarvestLevel("pickaxe", 1);
        metallic_rock.setHarvestLevel("pickaxe", 1);
        mercury_cobblestone_stairs.setHarvestLevel("pickaxe", 1);
        mercury_dungeon_brick_stairs.setHarvestLevel("pickaxe", 1);
        mercury_ancient_chest.setHarvestLevel("axe", 0);
    }

    private static void registerBlocks() {
        RegisterHelper.registerBlock(mercury_block, ItemBlockMercury.class);
        RegisterHelper.registerBlock(metallic_rock);
        RegisterHelper.registerBlock(mercury_ice);
        RegisterHelper.registerBlock(mercury_cobblestone_stairs);
        RegisterHelper.registerBlock(mercury_dungeon_brick_stairs);
        RegisterHelper.registerBlock(mercury_ancient_chest);
        RegisterHelper.registerBlock(mercury_treasure_chest);
        RegisterHelper.registerBlock(dirty_water);
        OreDictionary.registerOre((String)"oreTin", (ItemStack)new ItemStack(mercury_block, 1, 4));
        OreDictionary.registerOre((String)"oreCopper", (ItemStack)new ItemStack(mercury_block, 1, 5));
        OreDictionary.registerOre((String)"oreAluminum", (ItemStack)new ItemStack(mercury_block, 1, 6));
        OreDictionary.registerOre((String)"oreAluminium", (ItemStack)new ItemStack(mercury_block, 1, 6));
        OreDictionary.registerOre((String)"oreIron", (ItemStack)new ItemStack(mercury_block, 1, 7));
        OreDictionary.registerOre((String)"oreMetalMeteor", (ItemStack)new ItemStack(mercury_block, 1, 8));
        OreDictionary.registerOre((String)"oreMetallic", (ItemStack)new ItemStack(metallic_rock, 1, 0));
        OreDictionary.registerOre((String)"blockMetalMeteor", (ItemStack)new ItemStack(mercury_block, 1, 10));
    }
}

