/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.planets.fronos.worldgen.biome;

import java.util.Random;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedCreeper;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSkeleton;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSpider;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedZombie;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.biome.BiomeGenBase;
import stevekung.mods.moreplanets.core.config.ConfigManagerMP;
import stevekung.mods.moreplanets.core.entities.EntityEvolvedWitch;
import stevekung.mods.moreplanets.core.world.biome.BiomeGenBaseMP;
import stevekung.mods.moreplanets.planets.diona.entities.EntityEvolvedEnderman;
import stevekung.mods.moreplanets.planets.fronos.blocks.FronosBlocks;
import stevekung.mods.moreplanets.planets.fronos.entities.EntityBearry;
import stevekung.mods.moreplanets.planets.fronos.entities.EntityBerry;
import stevekung.mods.moreplanets.planets.fronos.entities.EntityCreamCat;
import stevekung.mods.moreplanets.planets.fronos.entities.EntityCreamSlime;
import stevekung.mods.moreplanets.planets.fronos.entities.EntityGrappy;
import stevekung.mods.moreplanets.planets.fronos.entities.EntityJellySlime;
import stevekung.mods.moreplanets.planets.fronos.entities.EntityKiwi;
import stevekung.mods.moreplanets.planets.fronos.entities.EntityLemonDuck;
import stevekung.mods.moreplanets.planets.fronos.entities.EntityMarshmallow;
import stevekung.mods.moreplanets.planets.fronos.entities.EntityMelon;
import stevekung.mods.moreplanets.planets.fronos.entities.EntityMilkCow;
import stevekung.mods.moreplanets.planets.fronos.entities.EntityStarfish;
import stevekung.mods.moreplanets.planets.fronos.entities.EntityStrawberryChicken;
import stevekung.mods.moreplanets.planets.fronos.entities.EntityTomato;
import stevekung.mods.moreplanets.planets.fronos.worldgen.BiomeDecoratorFronos;
import stevekung.mods.moreplanets.planets.fronos.worldgen.biome.BiomeGenCandyLand;
import stevekung.mods.moreplanets.planets.fronos.worldgen.biome.BiomeGenCoconutForest;
import stevekung.mods.moreplanets.planets.fronos.worldgen.biome.BiomeGenGoldenField;
import stevekung.mods.moreplanets.planets.fronos.worldgen.biome.BiomeGenGrassyPlains;
import stevekung.mods.moreplanets.planets.fronos.worldgen.biome.BiomeGenMapleForest;
import stevekung.mods.moreplanets.planets.fronos.worldgen.biome.BiomeGenPurpleMapleForest;

public class BiomeGenBaseFronos
extends BiomeGenBaseMP {
    public static BiomeGenBase coconutForest = new BiomeGenCoconutForest().func_76735_a("Coconut Forest").func_76742_b().func_76732_a(0.8f, 0.9f).func_150570_a(new BiomeGenBase.Height(0.1f, 0.2f));
    public static BiomeGenBase goldenField = new BiomeGenGoldenField().func_76735_a("Golden Field").func_76742_b().func_76732_a(0.95f, 0.9f).func_150570_a(new BiomeGenBase.Height(0.125f, 0.05f));
    public static BiomeGenBase purpleMapleForest = new BiomeGenPurpleMapleForest().func_76735_a("Purple Maple Forest").func_76732_a(0.8f, 0.9f).func_150570_a(new BiomeGenBase.Height(0.1f, 0.2f));
    public static BiomeGenBase mapleForest = new BiomeGenMapleForest().func_76735_a("Maple Forest").func_76732_a(0.8f, 0.9f).func_150570_a(new BiomeGenBase.Height(0.1f, 0.2f));
    public static BiomeGenBase grassyPlains = new BiomeGenGrassyPlains().func_76735_a("Grassy Plains").func_76732_a(0.95f, 0.9f).func_150570_a(new BiomeGenBase.Height(0.125f, 0.05f));
    public static BiomeGenBase candyLand = new BiomeGenCandyLand().func_76735_a("Candy Land").func_76732_a(0.95f, 0.9f).func_150570_a(new BiomeGenBase.Height(0.125f, 0.05f));
    protected Block stoneBlock;
    protected byte topMeta;
    protected byte fillerMeta;
    protected byte stoneMeta;

    public BiomeGenBaseFronos(int id) {
        super(id);
        this.field_76765_S = true;
        this.field_76751_G = 0.5f;
        this.field_76750_F = 0.5f;
        this.field_76752_A = FronosBlocks.fronos_grass;
        this.field_76753_B = FronosBlocks.fronos_dirt;
        this.getBiomeDecorator().strawberryCloudPerChunk = 8;
        this.getBiomeDecorator().rainbowCloudPerChunk = 1;
        this.getBiomeDecorator().coralPerChunk = 36;
        this.getBiomeDecorator().dungeonSpawnerPerChunk = 32;
        this.getBiomeDecorator().spaceShellPerChunk = 128;
        this.field_76760_I.field_76832_z = -999;
        this.field_76760_I.field_76802_A = -999;
        this.field_76760_I.field_76803_B = -999;
        if (ConfigManagerMP.allowMobCreatureSpawningOnFronos) {
            this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityZombie.class, 100, 4, 4));
            this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntitySpider.class, 100, 4, 4));
            this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntitySkeleton.class, 100, 4, 4));
            this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityCreeper.class, 100, 4, 4));
            this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityEnderman.class, 10, 1, 4));
            this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityWitch.class, 5, 1, 1));
            this.field_76762_K.add(new BiomeGenBase.SpawnListEntry(EntitySheep.class, 12, 4, 4));
            this.field_76762_K.add(new BiomeGenBase.SpawnListEntry(EntityPig.class, 10, 4, 4));
            this.field_76762_K.add(new BiomeGenBase.SpawnListEntry(EntityChicken.class, 10, 4, 4));
            this.field_76762_K.add(new BiomeGenBase.SpawnListEntry(EntityCow.class, 8, 4, 4));
        } else {
            this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityEvolvedZombie.class, 100, 4, 4));
            this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityEvolvedSpider.class, 100, 4, 4));
            this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityEvolvedSkeleton.class, 100, 4, 4));
            this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityEvolvedCreeper.class, 100, 4, 4));
            this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityEvolvedEnderman.class, 10, 1, 4));
            this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityEvolvedWitch.class, 5, 1, 1));
        }
        this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityCreamSlime.class, 150, 1, 4));
        this.field_76761_J.add(new BiomeGenBase.SpawnListEntry(EntityJellySlime.class, 150, 1, 4));
        this.field_76755_L.add(new BiomeGenBase.SpawnListEntry(EntitySquid.class, 10, 4, 4));
        this.field_76762_K.add(new BiomeGenBase.SpawnListEntry(EntityBearry.class, 8, 4, 4));
        this.field_76762_K.add(new BiomeGenBase.SpawnListEntry(EntityBerry.class, 8, 4, 4));
        this.field_76762_K.add(new BiomeGenBase.SpawnListEntry(EntityMarshmallow.class, 8, 4, 4));
        this.field_76762_K.add(new BiomeGenBase.SpawnListEntry(EntityKiwi.class, 8, 4, 4));
        this.field_76762_K.add(new BiomeGenBase.SpawnListEntry(EntityLemonDuck.class, 8, 4, 4));
        this.field_76762_K.add(new BiomeGenBase.SpawnListEntry(EntityTomato.class, 8, 4, 4));
        this.field_76762_K.add(new BiomeGenBase.SpawnListEntry(EntityMelon.class, 8, 4, 4));
        this.field_76762_K.add(new BiomeGenBase.SpawnListEntry(EntityStarfish.class, 8, 4, 4));
        this.field_76762_K.add(new BiomeGenBase.SpawnListEntry(EntityStrawberryChicken.class, 10, 4, 4));
        this.field_76762_K.add(new BiomeGenBase.SpawnListEntry(EntityGrappy.class, 12, 4, 4));
        this.field_76762_K.add(new BiomeGenBase.SpawnListEntry(EntityCreamCat.class, 2, 2, 2));
        this.field_76762_K.add(new BiomeGenBase.SpawnListEntry(EntityMilkCow.class, 8, 4, 4));
        this.field_82914_M.add(new BiomeGenBase.SpawnListEntry(EntityBat.class, 10, 8, 8));
    }

    public BiomeDecorator func_76729_a() {
        return new BiomeDecoratorFronos();
    }

    protected BiomeDecoratorFronos getBiomeDecorator() {
        return (BiomeDecoratorFronos)this.field_76760_I;
    }

    public void func_150573_a(World world, Random rand, Block[] block, byte[] meta, int x, int z, double stoneNoise) {
        this.genFronosBiomeTerrain(world, rand, block, meta, x, z, stoneNoise);
    }

    public BiomeGenBase func_76732_a(float temperature, float rainfall) {
        if (temperature > 0.1f && temperature < 0.2f) {
            throw new IllegalArgumentException("Please avoid temperatures in the range 0.1 - 0.2 because of snow");
        }
        this.field_76750_F = temperature;
        this.field_76751_G = rainfall;
        return this;
    }

    public void genFronosBiomeTerrain(World world, Random rand, Block[] block, byte[] meta, int x, int z, double stoneNoise) {
        Block topBlock = this.field_76752_A;
        byte topMeta = this.topMeta;
        Block fillerBlock = this.field_76753_B;
        byte fillerMeta = this.fillerMeta;
        int currentFillerDepth = -1;
        int maxFillerDepth = (int)(stoneNoise / 3.0 + 3.0 + rand.nextDouble() * 0.25);
        int maskX = x & 0xF;
        int maskZ = z & 0xF;
        int worldHeight = block.length / 256;
        int seaLevel = 32;
        for (int y = 255; y >= 0; --y) {
            int index = (maskZ * 16 + maskX) * worldHeight + y;
            if (y <= 0 + rand.nextInt(5)) {
                block[index] = Blocks.field_150357_h;
                continue;
            }
            Block currentBlock = block[index];
            if (currentBlock == null || currentBlock.func_149688_o() == Material.field_151579_a || currentBlock != Blocks.field_150348_b) continue;
            if (this.stoneBlock != null) {
                block[index] = this.stoneBlock;
                meta[index] = this.stoneMeta;
            }
            if (currentFillerDepth == -1) {
                if (maxFillerDepth <= 0) {
                    topBlock = null;
                    topMeta = 0;
                    fillerBlock = FronosBlocks.fronos_block;
                    fillerMeta = 0;
                } else if (y >= seaLevel - 5 && y <= seaLevel) {
                    topBlock = this.field_76752_A;
                    topMeta = this.topMeta;
                    fillerBlock = this.field_76753_B;
                    fillerMeta = 0;
                }
                if (y < seaLevel - 1 && (topBlock == null || topBlock.func_149688_o() == Material.field_151579_a)) {
                    if (this.func_150564_a(x, y, z) < 0.15f) {
                        topBlock = Blocks.field_150432_aD;
                        topMeta = 0;
                    } else {
                        topBlock = Blocks.field_150355_j;
                        topMeta = 0;
                    }
                }
                currentFillerDepth = maxFillerDepth;
                if (y >= seaLevel - 2) {
                    block[index] = topBlock;
                    meta[index] = topMeta;
                    continue;
                }
                if (y < seaLevel - 8 - maxFillerDepth) {
                    topBlock = null;
                    fillerBlock = FronosBlocks.fronos_block;
                    fillerMeta = 0;
                    block[index] = Blocks.field_150351_n;
                    continue;
                }
                block[index] = fillerBlock;
                meta[index] = fillerMeta;
                continue;
            }
            if (currentFillerDepth <= 0) continue;
            block[index] = fillerBlock;
            meta[index] = fillerMeta;
            if (--currentFillerDepth != 0 || fillerBlock != Blocks.field_150354_m) continue;
            currentFillerDepth = rand.nextInt(4) + Math.max(0, y - (seaLevel - 1));
            fillerBlock = Blocks.field_150322_A;
            fillerMeta = 0;
        }
    }
}

