/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.planets.fronos.worldgen;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedCreeper;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSkeleton;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSpider;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedZombie;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.MapGenDungeon;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.init.Blocks;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.SpawnerAnimals;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderGenerate;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraftforge.common.util.ForgeDirection;
import stevekung.mods.moreplanets.core.config.ConfigManagerMP;
import stevekung.mods.moreplanets.core.entities.EntityEvolvedWitch;
import stevekung.mods.moreplanets.core.worldgen.dungeon.RoomEmptyMP;
import stevekung.mods.moreplanets.core.worldgen.feature.WorldGenSpaceDungeons;
import stevekung.mods.moreplanets.planets.diona.entities.EntityEvolvedEnderman;
import stevekung.mods.moreplanets.planets.fronos.blocks.FronosBlocks;
import stevekung.mods.moreplanets.planets.fronos.entities.EntityBearry;
import stevekung.mods.moreplanets.planets.fronos.entities.EntityBerry;
import stevekung.mods.moreplanets.planets.fronos.entities.EntityCreamCat;
import stevekung.mods.moreplanets.planets.fronos.entities.EntityCreamSlime;
import stevekung.mods.moreplanets.planets.fronos.entities.EntityGrappy;
import stevekung.mods.moreplanets.planets.fronos.entities.EntityJellySlime;
import stevekung.mods.moreplanets.planets.fronos.entities.EntityKiwi;
import stevekung.mods.moreplanets.planets.fronos.entities.EntityLemonDuck;
import stevekung.mods.moreplanets.planets.fronos.entities.EntityMarshmallow;
import stevekung.mods.moreplanets.planets.fronos.entities.EntityMelon;
import stevekung.mods.moreplanets.planets.fronos.entities.EntityMilkCow;
import stevekung.mods.moreplanets.planets.fronos.entities.EntityStarfish;
import stevekung.mods.moreplanets.planets.fronos.entities.EntityStrawberryChicken;
import stevekung.mods.moreplanets.planets.fronos.entities.EntityTomato;
import stevekung.mods.moreplanets.planets.fronos.worldgen.BiomeDecoratorFronosOre;
import stevekung.mods.moreplanets.planets.fronos.worldgen.MapGenCaveFronos;
import stevekung.mods.moreplanets.planets.fronos.worldgen.MapGenCavernFronos;
import stevekung.mods.moreplanets.planets.fronos.worldgen.MapGenFronosRavine;
import stevekung.mods.moreplanets.planets.fronos.worldgen.dungeon.RoomBossFronos;
import stevekung.mods.moreplanets.planets.fronos.worldgen.dungeon.RoomChestsFronos;
import stevekung.mods.moreplanets.planets.fronos.worldgen.dungeon.RoomSpawnerFronos;
import stevekung.mods.moreplanets.planets.fronos.worldgen.dungeon.RoomTreasureFronos;
import stevekung.mods.moreplanets.planets.fronos.worldgen.village.MapGenFronosVillage;

public class ChunkProviderFronos
extends ChunkProviderGenerate {
    private Random rand;
    private NoiseGeneratorOctaves noiseGen4;
    public NoiseGeneratorOctaves field_73214_a;
    public NoiseGeneratorOctaves field_73212_b;
    public NoiseGeneratorOctaves field_73213_c;
    private World worldObj;
    private double[] stoneNoise;
    private MapGenCaveFronos caveGenerator;
    private MapGenCavernFronos cavernGenerator;
    public BiomeDecoratorFronosOre biomedecoratorplanet = new BiomeDecoratorFronosOre();
    private MapGenFronosVillage villageGenerator = new MapGenFronosVillage();
    private MapGenFronosRavine ravineGenerator = new MapGenFronosRavine();
    private BiomeGenBase[] biomesForGeneration;
    double[] noise3;
    double[] noise1;
    double[] noise2;
    double[] noise5;
    double[] noise6;
    float[] squareTable;
    private NoiseGeneratorOctaves field_147431_j;
    private NoiseGeneratorOctaves field_147432_k;
    private NoiseGeneratorOctaves field_147429_l;
    private NoiseGeneratorPerlin field_147430_m;
    private double[] terrainCalcs;
    private float[] parabolicField;
    double[] field_147427_d;
    double[] field_147428_e;
    double[] field_147425_f;
    double[] field_147426_g;
    int[][] field_73219_j = new int[32][32];
    private MapGenDungeon dungeonGenerator = new MapGenDungeon(FronosBlocks.fronos_block, 14, 8, 24, 4);

    public ChunkProviderFronos(World world, long seed, boolean flag) {
        super(world, seed, flag);
        this.dungeonGenerator.otherRooms.add(new RoomEmptyMP(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.otherRooms.add(new RoomSpawnerFronos(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.otherRooms.add(new RoomSpawnerFronos(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.otherRooms.add(new RoomSpawnerFronos(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.otherRooms.add(new RoomSpawnerFronos(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.otherRooms.add(new RoomSpawnerFronos(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.otherRooms.add(new RoomSpawnerFronos(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.otherRooms.add(new RoomSpawnerFronos(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.otherRooms.add(new RoomSpawnerFronos(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.otherRooms.add(new RoomChestsFronos(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.otherRooms.add(new RoomChestsFronos(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.bossRooms.add(new RoomBossFronos(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.dungeonGenerator.treasureRooms.add(new RoomTreasureFronos(null, 0, 0, 0, ForgeDirection.UNKNOWN));
        this.stoneNoise = new double[256];
        this.caveGenerator = new MapGenCaveFronos();
        this.cavernGenerator = new MapGenCavernFronos();
        this.worldObj = world;
        this.rand = new Random(seed);
        this.noiseGen4 = new NoiseGeneratorOctaves(this.rand, 4);
        this.field_73214_a = new NoiseGeneratorOctaves(this.rand, 10);
        this.field_73212_b = new NoiseGeneratorOctaves(this.rand, 16);
        this.field_73213_c = new NoiseGeneratorOctaves(this.rand, 8);
        this.field_147431_j = new NoiseGeneratorOctaves(this.rand, 16);
        this.field_147432_k = new NoiseGeneratorOctaves(this.rand, 16);
        this.field_147429_l = new NoiseGeneratorOctaves(this.rand, 8);
        this.field_147430_m = new NoiseGeneratorPerlin(this.rand, 4);
        this.terrainCalcs = new double[825];
        this.parabolicField = new float[25];
        for (int j = -2; j <= 2; ++j) {
            for (int k = -2; k <= 2; ++k) {
                float f;
                this.parabolicField[j + 2 + (k + 2) * 5] = f = 10.0f / MathHelper.func_76129_c((float)((float)(j * j + k * k) + 0.2f));
            }
        }
    }

    public Chunk func_73154_d(int x, int z) {
        this.rand.setSeed((long)x * 341873128712L + (long)z * 132897987541L);
        Block[] blockStorage = new Block[65536];
        byte[] metaStorage = new byte[65536];
        this.generateTerrain(x, z, blockStorage);
        this.biomesForGeneration = this.worldObj.func_72959_q().func_76933_b(this.biomesForGeneration, x * 16, z * 16, 16, 16);
        this.func_147422_a(x, z, blockStorage, metaStorage, this.biomesForGeneration);
        this.caveGenerator.generate((IChunkProvider)this, this.worldObj, x, z, blockStorage, metaStorage);
        this.cavernGenerator.generate((IChunkProvider)this, this.worldObj, x, z, blockStorage, metaStorage);
        this.ravineGenerator.func_151539_a((IChunkProvider)this, this.worldObj, x, z, blockStorage);
        this.dungeonGenerator.generateUsingArrays(this.worldObj, this.worldObj.func_72905_C(), x * 16, 30, z * 16, x, z, blockStorage, metaStorage);
        Chunk chunk = new Chunk(this.worldObj, blockStorage, metaStorage, x, z);
        byte[] chunkBiomes = chunk.func_76605_m();
        for (int i = 0; i < chunkBiomes.length; ++i) {
            chunkBiomes[i] = (byte)this.biomesForGeneration[i].field_76756_M;
        }
        chunk.func_76603_b();
        return chunk;
    }

    public void generateTerrain(int chunkX, int chunkZ, Block[] blockStorage) {
        int seaLevel = 63;
        this.biomesForGeneration = this.worldObj.func_72959_q().func_76933_b(this.biomesForGeneration, chunkX * 4 - 2, chunkZ * 4 - 2, 10, 10);
        this.makeLandPerBiome2(chunkX * 4, 0, chunkZ * 4);
        for (int k = 0; k < 4; ++k) {
            int l = k * 5;
            int i1 = (k + 1) * 5;
            for (int j1 = 0; j1 < 4; ++j1) {
                int k1 = (l + j1) * 33;
                int l1 = (l + j1 + 1) * 33;
                int i2 = (i1 + j1) * 33;
                int j2 = (i1 + j1 + 1) * 33;
                for (int k2 = 0; k2 < 32; ++k2) {
                    double d0 = 0.125;
                    double d1 = this.terrainCalcs[k1 + k2];
                    double d2 = this.terrainCalcs[l1 + k2];
                    double d3 = this.terrainCalcs[i2 + k2];
                    double d4 = this.terrainCalcs[j2 + k2];
                    double d5 = (this.terrainCalcs[k1 + k2 + 1] - d1) * d0;
                    double d6 = (this.terrainCalcs[l1 + k2 + 1] - d2) * d0;
                    double d7 = (this.terrainCalcs[i2 + k2 + 1] - d3) * d0;
                    double d8 = (this.terrainCalcs[j2 + k2 + 1] - d4) * d0;
                    for (int l2 = 0; l2 < 8; ++l2) {
                        double d9 = 0.25;
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * d9;
                        double d13 = (d4 - d2) * d9;
                        for (int i3 = 0; i3 < 4; ++i3) {
                            int j3 = i3 + k * 4 << 12 | 0 + j1 * 4 << 8 | k2 * 8 + l2;
                            int short1 = 256;
                            j3 -= short1;
                            double d14 = 0.25;
                            double d16 = (d11 - d10) * d14;
                            double d15 = d10 - d16;
                            for (int k3 = 0; k3 < 4; ++k3) {
                                double d;
                                d15 += d16;
                                blockStorage[j3 += short1] = d > 0.0 ? Blocks.field_150348_b : (k2 * 8 + l2 < seaLevel ? Blocks.field_150355_j : null);
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    private void makeLandPerBiome2(int x, int zero, int z) {
        this.field_147426_g = this.field_73212_b.func_76305_a(this.field_147426_g, x, z, 5, 5, 200.0, 200.0, 0.5);
        this.field_147427_d = this.field_147429_l.func_76304_a(this.field_147427_d, x, zero, z, 5, 33, 5, 8.555150000000001, 4.277575000000001, 8.555150000000001);
        this.field_147428_e = this.field_147431_j.func_76304_a(this.field_147428_e, x, zero, z, 5, 33, 5, 684.412, 684.412, 684.412);
        this.field_147425_f = this.field_147432_k.func_76304_a(this.field_147425_f, x, zero, z, 5, 33, 5, 684.412, 684.412, 684.412);
        int terrainIndex = 0;
        int noiseIndex = 0;
        for (int ax = 0; ax < 5; ++ax) {
            for (int az = 0; az < 5; ++az) {
                float totalVariation = 0.0f;
                float totalHeight = 0.0f;
                float totalFactor = 0.0f;
                int two = 2;
                BiomeGenBase biomegenbase = this.biomesForGeneration[ax + 2 + (az + 2) * 10];
                for (int ox = -two; ox <= two; ++ox) {
                    for (int oz = -two; oz <= two; ++oz) {
                        BiomeGenBase biomegenbase1 = this.biomesForGeneration[ax + ox + 2 + (az + oz + 2) * 10];
                        float rootHeight = biomegenbase1.field_76748_D;
                        float heightVariation = biomegenbase1.field_76749_E;
                        float heightFactor = this.parabolicField[ox + 2 + (oz + 2) * 5] / (rootHeight + 2.0f);
                        if (biomegenbase1.field_76748_D > biomegenbase.field_76748_D) {
                            heightFactor /= 2.0f;
                        }
                        totalVariation += heightVariation * heightFactor;
                        totalHeight += rootHeight * heightFactor;
                        totalFactor += heightFactor;
                    }
                }
                totalVariation /= totalFactor;
                totalHeight /= totalFactor;
                totalVariation = totalVariation * 0.9f + 0.1f;
                totalHeight = (totalHeight * 4.0f - 1.0f) / 8.0f;
                double terrainNoise = this.field_147426_g[noiseIndex] / 8000.0;
                if (terrainNoise < 0.0) {
                    terrainNoise = -terrainNoise * 0.3;
                }
                if ((terrainNoise = terrainNoise * 3.0 - 2.0) < 0.0) {
                    if ((terrainNoise /= 2.0) < -1.0) {
                        terrainNoise = -1.0;
                    }
                    terrainNoise /= 1.4;
                    terrainNoise /= 2.0;
                } else {
                    if (terrainNoise > 1.0) {
                        terrainNoise = 1.0;
                    }
                    terrainNoise /= 8.0;
                }
                ++noiseIndex;
                double heightCalc = totalHeight;
                double variationCalc = totalVariation;
                heightCalc += terrainNoise * 0.2;
                heightCalc = heightCalc * 8.5 / 8.0;
                double d5 = 8.5 + heightCalc * 4.0;
                for (int ay = 0; ay < 33; ++ay) {
                    double d6 = ((double)ay - d5) * 12.0 * 128.0 / 256.0 / variationCalc;
                    if (d6 < 0.0) {
                        d6 *= 4.0;
                    }
                    double d7 = this.field_147428_e[terrainIndex] / 512.0;
                    double d8 = this.field_147425_f[terrainIndex] / 512.0;
                    double d9 = (this.field_147427_d[terrainIndex] / 10.0 + 1.0) / 2.0;
                    double terrainCalc = MathHelper.func_151238_b((double)d7, (double)d8, (double)d9) - d6;
                    if (ay > 29) {
                        double d11 = (float)(ay - 29) / 3.0f;
                        terrainCalc = terrainCalc * (1.0 - d11) + -10.0 * d11;
                    }
                    this.terrainCalcs[terrainIndex] = terrainCalc;
                    ++terrainIndex;
                }
            }
        }
    }

    public void func_147422_a(int chunkX, int chunkZ, Block[] blockStorage, byte[] metaStorage, BiomeGenBase[] biomes) {
        double d0 = 0.03125;
        this.stoneNoise = this.field_147430_m.func_151599_a(this.stoneNoise, (double)(chunkX * 16), (double)(chunkZ * 16), 16, 16, d0 * 2.0, d0 * 2.0, 1.0);
        for (int z = 0; z < 16; ++z) {
            for (int x = 0; x < 16; ++x) {
                BiomeGenBase biomegenbase = biomes[x + z * 16];
                biomegenbase.func_150573_a(this.worldObj, this.rand, blockStorage, metaStorage, chunkX * 16 + z, chunkZ * 16 + x, this.stoneNoise[x + z * 16]);
            }
        }
    }

    public Chunk func_73158_c(int x, int z) {
        return this.func_73154_d(x, z);
    }

    public boolean func_73149_a(int x, int z) {
        return true;
    }

    public void func_73153_a(IChunkProvider chunk, int x, int z) {
        BlockFalling.field_149832_M = true;
        int var4 = x * 16;
        int var5 = z * 16;
        BiomeGenBase biomeGen = this.worldObj.func_72807_a(var4 + 16, var5 + 16);
        this.worldObj.func_72807_a(var4 + 16, var5 + 16);
        this.rand.setSeed(this.worldObj.func_72905_C());
        long var7 = this.rand.nextLong() / 2L * 2L + 1L;
        long var9 = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)x * var7 + (long)z * var9 ^ this.worldObj.func_72905_C());
        this.dungeonGenerator.handleTileEntities(this.rand);
        biomeGen.func_76728_a(this.worldObj, this.rand, var4, var5);
        this.decoratePlanet(this.worldObj, this.rand, var4, var5);
        SpawnerAnimals.func_77191_a((World)this.worldObj, (BiomeGenBase)biomeGen, (int)(var4 + 8), (int)(var5 + 8), (int)16, (int)16, (Random)this.rand);
        this.villageGenerator.func_75051_a(this.worldObj, this.rand, x, z);
        for (int i = 0; i < 8; ++i) {
            int x1 = var4 + this.rand.nextInt(16) + 8;
            int y1 = this.rand.nextInt(256);
            int z1 = var5 + this.rand.nextInt(16) + 8;
            new WorldGenSpaceDungeons(FronosBlocks.fronos_ancient_chest, FronosBlocks.fronos_block, FronosBlocks.mossy_fronos_cobblestone, 1, 0).func_76484_a(this.worldObj, this.rand, x1, y1, z1);
        }
        BlockFalling.field_149832_M = false;
    }

    public void decoratePlanet(World world, Random rand, int x, int z) {
        this.biomedecoratorplanet.decorate(world, rand, x, z);
    }

    public boolean func_73151_a(boolean flag, IProgressUpdate progress) {
        return true;
    }

    public boolean func_73157_c() {
        return true;
    }

    public String func_73148_d() {
        return "FronosLevelSource";
    }

    public List func_73155_a(EnumCreatureType type, int x, int y, int z) {
        if (type == EnumCreatureType.monster) {
            ArrayList<BiomeGenBase.SpawnListEntry> monsters = new ArrayList<BiomeGenBase.SpawnListEntry>();
            if (ConfigManagerMP.allowMobCreatureSpawningOnFronos) {
                monsters.add(new BiomeGenBase.SpawnListEntry(EntityZombie.class, 100, 4, 4));
                monsters.add(new BiomeGenBase.SpawnListEntry(EntitySpider.class, 100, 4, 4));
                monsters.add(new BiomeGenBase.SpawnListEntry(EntitySkeleton.class, 100, 4, 4));
                monsters.add(new BiomeGenBase.SpawnListEntry(EntityCreeper.class, 100, 4, 4));
                monsters.add(new BiomeGenBase.SpawnListEntry(EntityEnderman.class, 100, 1, 4));
                monsters.add(new BiomeGenBase.SpawnListEntry(EntityWitch.class, 5, 1, 1));
            } else {
                monsters.add(new BiomeGenBase.SpawnListEntry(EntityEvolvedZombie.class, 100, 4, 4));
                monsters.add(new BiomeGenBase.SpawnListEntry(EntityEvolvedSpider.class, 100, 4, 4));
                monsters.add(new BiomeGenBase.SpawnListEntry(EntityEvolvedSkeleton.class, 100, 4, 4));
                monsters.add(new BiomeGenBase.SpawnListEntry(EntityEvolvedCreeper.class, 100, 4, 4));
                monsters.add(new BiomeGenBase.SpawnListEntry(EntityEvolvedEnderman.class, 10, 1, 4));
                monsters.add(new BiomeGenBase.SpawnListEntry(EntityEvolvedWitch.class, 5, 1, 1));
            }
            monsters.add(new BiomeGenBase.SpawnListEntry(EntityCreamSlime.class, 25, 2, 4));
            monsters.add(new BiomeGenBase.SpawnListEntry(EntityJellySlime.class, 25, 2, 4));
            return monsters;
        }
        if (type == EnumCreatureType.creature) {
            ArrayList<BiomeGenBase.SpawnListEntry> creatures = new ArrayList<BiomeGenBase.SpawnListEntry>();
            creatures.add(new BiomeGenBase.SpawnListEntry(EntityBearry.class, 8, 4, 4));
            creatures.add(new BiomeGenBase.SpawnListEntry(EntityBerry.class, 8, 4, 4));
            creatures.add(new BiomeGenBase.SpawnListEntry(EntityMarshmallow.class, 8, 4, 4));
            creatures.add(new BiomeGenBase.SpawnListEntry(EntityKiwi.class, 8, 4, 4));
            creatures.add(new BiomeGenBase.SpawnListEntry(EntityLemonDuck.class, 8, 4, 4));
            creatures.add(new BiomeGenBase.SpawnListEntry(EntityTomato.class, 8, 4, 4));
            creatures.add(new BiomeGenBase.SpawnListEntry(EntityMelon.class, 8, 4, 4));
            creatures.add(new BiomeGenBase.SpawnListEntry(EntityGrappy.class, 12, 4, 4));
            creatures.add(new BiomeGenBase.SpawnListEntry(EntityCreamCat.class, 2, 2, 2));
            creatures.add(new BiomeGenBase.SpawnListEntry(EntityStrawberryChicken.class, 10, 4, 4));
            creatures.add(new BiomeGenBase.SpawnListEntry(EntityStarfish.class, 8, 4, 4));
            creatures.add(new BiomeGenBase.SpawnListEntry(EntityMilkCow.class, 8, 4, 4));
            if (ConfigManagerMP.allowMobCreatureSpawningOnFronos) {
                creatures.add(new BiomeGenBase.SpawnListEntry(EntitySheep.class, 12, 4, 4));
                creatures.add(new BiomeGenBase.SpawnListEntry(EntityPig.class, 10, 4, 4));
                creatures.add(new BiomeGenBase.SpawnListEntry(EntityChicken.class, 10, 4, 4));
                creatures.add(new BiomeGenBase.SpawnListEntry(EntityCow.class, 8, 4, 4));
            }
            return creatures;
        }
        if (type == EnumCreatureType.waterCreature) {
            ArrayList<BiomeGenBase.SpawnListEntry> waterCreatures = new ArrayList<BiomeGenBase.SpawnListEntry>();
            waterCreatures.add(new BiomeGenBase.SpawnListEntry(EntitySquid.class, 10, 4, 4));
            return waterCreatures;
        }
        if (type == EnumCreatureType.ambient) {
            ArrayList<BiomeGenBase.SpawnListEntry> caveCreatures = new ArrayList<BiomeGenBase.SpawnListEntry>();
            caveCreatures.add(new BiomeGenBase.SpawnListEntry(EntityBat.class, 10, 8, 8));
            return caveCreatures;
        }
        return null;
    }

    public int func_73152_e() {
        return 0;
    }

    public void func_82695_e(int x, int z) {
        this.villageGenerator.func_151539_a((IChunkProvider)this, this.worldObj, x, z, null);
    }

    public boolean func_73156_b() {
        return false;
    }

    public void func_104112_b() {
    }

    public ChunkPosition func_147416_a(World world, String string, int x, int y, int z) {
        return null;
    }
}

