/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.planets.fronos.nei;

import codechicken.nei.ItemList;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import stevekung.mods.moreplanets.core.recipe.CandyExtractorRecipes;
import stevekung.mods.moreplanets.planets.fronos.gui.GuiCandyExtractor;
import stevekung.mods.moreplanets.planets.fronos.tileentities.TileEntityCandyExtractor;

public class CandyExtractorRecipeHandler
extends TemplateRecipeHandler {
    public static ArrayList<FuelPair> afuels;
    public static HashSet<Block> efuels;

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiCandyExtractor.class;
    }

    public String getRecipeName() {
        return EnumChatFormatting.DARK_BLUE + "Candy Extractor";
    }

    public TemplateRecipeHandler newInstance() {
        if (afuels == null) {
            CandyExtractorRecipeHandler.findFuels();
        }
        return super.newInstance();
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("smelting") && ((Object)((Object)this)).getClass() == CandyExtractorRecipeHandler.class) {
            Map recipes = CandyExtractorRecipes.extracting().getExtractingList();
            for (Map.Entry recipe : recipes.entrySet()) {
                this.arecipes.add(new SmeltingPair((ItemStack)recipe.getKey(), (ItemStack)recipe.getValue()));
            }
        }
        super.loadCraftingRecipes(outputId, results);
    }

    public void loadCraftingRecipes(ItemStack result) {
        Map recipes = CandyExtractorRecipes.extracting().getExtractingList();
        for (Map.Entry recipe : recipes.entrySet()) {
            if (!NEIServerUtils.areStacksSameType((ItemStack)((ItemStack)recipe.getValue()), (ItemStack)result)) continue;
            this.arecipes.add(new SmeltingPair((ItemStack)recipe.getKey(), (ItemStack)recipe.getValue()));
        }
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId.equals("fuel") && ((Object)((Object)this)).getClass() == CandyExtractorRecipeHandler.class) {
            this.loadCraftingRecipes("smelting", new Object[0]);
        }
        super.loadUsageRecipes(inputId, ingredients);
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        Map recipes = CandyExtractorRecipes.extracting().getExtractingList();
        for (Map.Entry recipe : recipes.entrySet()) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)((ItemStack)recipe.getKey()), (ItemStack)ingredient)) continue;
            SmeltingPair arecipe = new SmeltingPair((ItemStack)recipe.getKey(), (ItemStack)recipe.getValue());
            arecipe.setIngredientPermutation(Arrays.asList(arecipe.ingred), ingredient);
            this.arecipes.add(arecipe);
        }
    }

    public String getGuiTexture() {
        return "fronos:textures/gui/candy_extractor_nei.png";
    }

    public void drawExtras(int recipe) {
        this.drawProgressBar(51, 25, 176, 0, 14, 14, 48, 7);
        this.drawProgressBar(74, 23, 176, 14, 24, 16, 48, 0);
    }

    private static void findFuels() {
        afuels = new ArrayList();
        for (ItemStack item : ItemList.items) {
            int burnTime = TileEntityCandyExtractor.getItemExtractTime(item);
            if (burnTime <= 0) continue;
            afuels.add(new FuelPair(item.func_77946_l(), burnTime));
        }
    }

    public static class FuelPair {
        public PositionedStack stack;
        public int burnTime;

        public FuelPair(ItemStack ingred, int burnTime) {
            this.stack = new PositionedStack((Object)ingred, 51, 42, false);
            this.burnTime = burnTime;
        }
    }

    public class SmeltingPair
    extends TemplateRecipeHandler.CachedRecipe {
        PositionedStack ingred;
        PositionedStack result;

        public SmeltingPair(ItemStack ingred, ItemStack result) {
            super((TemplateRecipeHandler)CandyExtractorRecipeHandler.this);
            ingred.field_77994_a = 1;
            this.ingred = new PositionedStack((Object)ingred, 51, 6);
            this.result = new PositionedStack((Object)result, 111, 24);
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(CandyExtractorRecipeHandler.this.cycleticks / 48, Arrays.asList(this.ingred));
        }

        public PositionedStack getResult() {
            return this.result;
        }

        public PositionedStack getOtherStack() {
            return CandyExtractorRecipeHandler.afuels.get((int)(CandyExtractorRecipeHandler.this.cycleticks / 48 % CandyExtractorRecipeHandler.afuels.size())).stack;
        }
    }
}

