/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.planets.fronos.blocks;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IShearable;
import stevekung.mods.moreplanets.core.MorePlanetsCore;
import stevekung.mods.moreplanets.core.blocks.BlockFlowerMP;
import stevekung.mods.moreplanets.planets.fronos.blocks.FronosBlocks;
import stevekung.mods.moreplanets.planets.fronos.items.FronosItems;

public class BlockFronosTallGrass
extends BlockFlowerMP
implements IShearable {
    private static String[] fronosGrass = new String[]{"fronos_short_grass", "fronos_medium_grass", "fronos_tall_grass", "pink_short_grass", "pink_medium_grass", "pink_tall_grass", "purple_short_grass", "purple_medium_grass", "purple_tall_grass", "plains_short_grass", "plains_medium_grass", "plains_tall_grass", "golden_short_grass", "golden_medium_grass", "golden_tall_grass"};
    private IIcon[] textures;

    public BlockFronosTallGrass(String name) {
        super(Material.field_151585_k);
        this.func_149675_a(true);
        this.func_149672_a(Block.field_149779_h);
        this.func_149663_c(name);
    }

    @Override
    public CreativeTabs func_149708_J() {
        return MorePlanetsCore.mpBlocksTab;
    }

    public void func_149651_a(IIconRegister iconRegister) {
        this.textures = new IIcon[fronosGrass.length];
        for (int i = 0; i < fronosGrass.length; ++i) {
            this.textures[i] = iconRegister.func_94245_a("fronos:" + fronosGrass[i]);
        }
    }

    public IIcon func_149691_a(int side, int meta) {
        if (meta < 0 || meta >= this.textures.length) {
            meta = 0;
        }
        return this.textures[meta];
    }

    @Override
    public int func_149645_b() {
        return 1;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        if (world.func_72805_g(x, y, z) >= 12) {
            return 10;
        }
        return 0;
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        switch (meta) {
            case 0: 
            case 3: 
            case 6: 
            case 9: 
            case 12: {
                this.func_149676_a(0.1f, 0.0f, 0.1f, 0.9f, 0.5f, 0.9f);
                break;
            }
            default: {
                this.func_149676_a(0.1f, 0.0f, 0.1f, 0.9f, 0.8f, 0.9f);
            }
        }
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int meta, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ItemStack item = ForgeHooks.getGrassSeed((World)world);
        if (meta >= 12) {
            if (world.field_73012_v.nextInt(15) == 0) {
                ret.add(new ItemStack(FronosItems.golden_seeds, 1));
            }
        } else {
            if (world.field_73012_v.nextInt(8) != 0) {
                return ret;
            }
            if (item != null) {
                ret.add(item);
            }
        }
        return ret;
    }

    public void func_149666_a(Item block, CreativeTabs creativeTabs, List list) {
        for (int i = 0; i < fronosGrass.length; ++i) {
            list.add(new ItemStack((Block)this, 1, i));
        }
    }

    @Override
    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        this.isValidPosition(world, x, y, z, world.func_72805_g(x, y, z));
    }

    @Override
    public boolean isValidPosition(World world, int x, int y, int z, int meta) {
        Block block = world.func_147439_a(x, y - 1, z);
        if (meta >= 0 && meta <= 2) {
            return block == FronosBlocks.fronos_grass || block == FronosBlocks.fronos_dirt;
        }
        if (meta >= 3 && meta <= 5) {
            return block == FronosBlocks.pink_grass || block == FronosBlocks.fronos_dirt;
        }
        if (meta >= 5 && meta <= 8) {
            return block == FronosBlocks.purple_grass || block == FronosBlocks.fronos_dirt;
        }
        if (meta >= 8 && meta <= 11) {
            return block == FronosBlocks.plains_grass || block == FronosBlocks.fronos_dirt;
        }
        if (meta >= 12 || meta <= 14) {
            return block == FronosBlocks.golden_grass || block == FronosBlocks.fronos_dirt;
        }
        return false;
    }

    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        super.func_149734_b(world, x, y, z, rand);
        int meta = world.func_72805_g(x, y, z);
        if (meta >= 12 && rand.nextInt(1) == 0) {
            MorePlanetsCore.proxy.spawnParticle("goldSmoke", (float)x + rand.nextFloat(), (float)y + rand.nextFloat(), (float)z + rand.nextFloat());
        }
    }

    public int func_149643_k(World world, int x, int y, int z) {
        return world.func_72805_g(x, y, z);
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    public boolean isReplaceable(IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public ArrayList<ItemStack> onSheared(ItemStack item, IBlockAccess world, int x, int y, int z, int fortune) {
        ArrayList<ItemStack> itemStack = new ArrayList<ItemStack>();
        itemStack.add(new ItemStack((Block)this, 1, world.func_72805_g(x, y, z)));
        return itemStack;
    }
}

