/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.planets.fronos.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import stevekung.mods.moreplanets.core.MorePlanetsCore;
import stevekung.mods.moreplanets.core.blocks.base.BlockContainerMP;
import stevekung.mods.moreplanets.planets.fronos.blocks.FronosBlocks;
import stevekung.mods.moreplanets.planets.fronos.tileentities.TileEntityCandyExtractor;

public class BlockCandyExtractor
extends BlockContainerMP {
    private Random extractorRand = new Random();
    private boolean isActive;
    private static boolean keepExtractorInventory;
    private IIcon extractorSide;
    private IIcon extractorFace;
    private IIcon extractorTop;
    private IIcon extractorBottom;

    public BlockCandyExtractor(String name, boolean active) {
        super(Material.field_151576_e);
        this.isActive = active;
        this.func_149711_c(4.0f);
        this.func_149663_c(name);
        if (this.isActive) {
            this.func_149715_a(1.0f);
        }
    }

    public Item func_149650_a(int par1, Random par2Random, int par3) {
        return Item.func_150898_a((Block)FronosBlocks.candy_extractor_idle);
    }

    @Override
    public CreativeTabs func_149708_J() {
        if (!this.isActive) {
            return MorePlanetsCore.mpBlocksTab;
        }
        return null;
    }

    public void func_149726_b(World world, int par2, int par3, int par4) {
        super.func_149726_b(world, par2, par3, par4);
        this.setDefaultDirection(world, par2, par3, par4);
    }

    private void setDefaultDirection(World world, int par2, int par3, int par4) {
        if (!world.field_72995_K) {
            Block l = world.func_147439_a(par2, par3, par4 - 1);
            Block i1 = world.func_147439_a(par2, par3, par4 + 1);
            Block j1 = world.func_147439_a(par2 - 1, par3, par4);
            Block k1 = world.func_147439_a(par2 + 1, par3, par4);
            int b0 = 3;
            if (l.func_149730_j() && !i1.func_149730_j()) {
                b0 = 3;
            }
            if (i1.func_149730_j() && !l.func_149730_j()) {
                b0 = 2;
            }
            if (j1.func_149730_j() && !k1.func_149730_j()) {
                b0 = 5;
            }
            if (k1.func_149730_j() && !j1.func_149730_j()) {
                b0 = 4;
            }
            world.func_72921_c(par2, par3, par4, b0, 2);
        }
    }

    public void func_149651_a(IIconRegister iconRegister) {
        this.extractorBottom = iconRegister.func_94245_a("fronos:extractor_bottom");
        this.extractorTop = iconRegister.func_94245_a("fronos:extractor_top");
        this.extractorSide = iconRegister.func_94245_a("fronos:extractor_side");
        this.extractorFace = iconRegister.func_94245_a(this.isActive ? "fronos:extractor_front_on" : "fronos:extractor_front_off");
    }

    public boolean func_149727_a(World world, int par2, int par3, int par4, EntityPlayer par5EntityPlayer, int par6, float par7, float par8, float par9) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntityCandyExtractor tileentityfurnace = (TileEntityCandyExtractor)world.func_147438_o(par2, par3, par4);
        if (tileentityfurnace != null) {
            par5EntityPlayer.openGui((Object)MorePlanetsCore.instance, -1, world, par2, par3, par4);
        }
        return true;
    }

    public static void updateExtractorBlockState(boolean par0, World world, int par2, int par3, int par4) {
        int l = world.func_72805_g(par2, par3, par4);
        TileEntity tileentity = world.func_147438_o(par2, par3, par4);
        keepExtractorInventory = true;
        if (par0) {
            world.func_147449_b(par2, par3, par4, FronosBlocks.candy_extractor_active);
        } else {
            world.func_147449_b(par2, par3, par4, FronosBlocks.candy_extractor_idle);
        }
        keepExtractorInventory = false;
        world.func_72921_c(par2, par3, par4, l, 2);
        if (tileentity != null) {
            tileentity.func_145829_t();
            world.func_147455_a(par2, par3, par4, tileentity);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int par2, int par3, int par4, Random rand) {
        if (this.isActive) {
            int l = world.func_72805_g(par2, par3, par4);
            float f = (float)par2 + 0.5f;
            float f1 = (float)par3 + 0.0f + rand.nextFloat() * 6.0f / 16.0f;
            float f2 = (float)par4 + 0.5f;
            float f3 = 0.52f;
            float f4 = rand.nextFloat() * 0.6f - 0.3f;
            if (l == 4) {
                world.func_72869_a("smoke", (double)(f - f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
                MorePlanetsCore.proxy.spawnParticle("blueFlame", f - f3, f1, f2 + f4);
            } else if (l == 5) {
                world.func_72869_a("smoke", (double)(f + f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
                MorePlanetsCore.proxy.spawnParticle("blueFlame", f + f3, f1, f2 + f4);
            } else if (l == 2) {
                world.func_72869_a("smoke", (double)(f + f4), (double)f1, (double)(f2 - f3), 0.0, 0.0, 0.0);
                MorePlanetsCore.proxy.spawnParticle("blueFlame", f + f4, f1, f2 - f3);
            } else if (l == 3) {
                world.func_72869_a("smoke", (double)(f + f4), (double)f1, (double)(f2 + f3), 0.0, 0.0, 0.0);
                MorePlanetsCore.proxy.spawnParticle("blueFlame", f + f4, f1, f2 + f3);
            }
        }
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityCandyExtractor();
    }

    public void func_149689_a(World world, int par2, int par3, int par4, EntityLivingBase par5EntityLivingBase, ItemStack par6ItemStack) {
        int l = MathHelper.func_76128_c((double)((double)(par5EntityLivingBase.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (l == 0) {
            world.func_72921_c(par2, par3, par4, 2, 2);
        }
        if (l == 1) {
            world.func_72921_c(par2, par3, par4, 5, 2);
        }
        if (l == 2) {
            world.func_72921_c(par2, par3, par4, 3, 2);
        }
        if (l == 3) {
            world.func_72921_c(par2, par3, par4, 4, 2);
        }
        if (par6ItemStack.func_82837_s()) {
            ((TileEntityCandyExtractor)world.func_147438_o(par2, par3, par4)).setGuiDisplayName(par6ItemStack.func_82833_r());
        }
    }

    public void func_149749_a(World world, int par2, int par3, int par4, Block par5, int par6) {
        TileEntityCandyExtractor tileentityfurnace;
        if (!keepExtractorInventory && (tileentityfurnace = (TileEntityCandyExtractor)world.func_147438_o(par2, par3, par4)) != null) {
            for (int j1 = 0; j1 < tileentityfurnace.func_70302_i_(); ++j1) {
                ItemStack itemstack = tileentityfurnace.func_70301_a(j1);
                if (itemstack == null) continue;
                float f = this.extractorRand.nextFloat() * 0.8f + 0.1f;
                float f1 = this.extractorRand.nextFloat() * 0.8f + 0.1f;
                float f2 = this.extractorRand.nextFloat() * 0.8f + 0.1f;
                while (itemstack.field_77994_a > 0) {
                    int k1 = this.extractorRand.nextInt(21) + 10;
                    if (k1 > itemstack.field_77994_a) {
                        k1 = itemstack.field_77994_a;
                    }
                    itemstack.field_77994_a -= k1;
                    EntityItem entityitem = new EntityItem(world, (double)((float)par2 + f), (double)((float)par3 + f1), (double)((float)par4 + f2), new ItemStack(itemstack.func_77973_b(), k1, itemstack.func_77960_j()));
                    if (itemstack.func_77942_o()) {
                        entityitem.func_92059_d().func_77982_d((NBTTagCompound)itemstack.func_77978_p().func_74737_b());
                    }
                    float f3 = 0.05f;
                    entityitem.field_70159_w = (float)this.extractorRand.nextGaussian() * f3;
                    entityitem.field_70181_x = (float)this.extractorRand.nextGaussian() * f3 + 0.2f;
                    entityitem.field_70179_y = (float)this.extractorRand.nextGaussian() * f3;
                    world.func_72838_d((Entity)entityitem);
                }
            }
            world.func_147453_f(par2, par3, par4, par5);
        }
        super.func_149749_a(world, par2, par3, par4, par5, par6);
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_149736_g(World world, int par2, int par3, int par4, int par5) {
        return Container.func_94526_b((IInventory)((IInventory)world.func_147438_o(par2, par3, par4)));
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack getPickBlock(MovingObjectPosition mov, World world, int par2, int par3, int par4) {
        return new ItemStack(FronosBlocks.candy_extractor_idle, 1, 0);
    }

    public IIcon func_149691_a(int side, int metadata) {
        if (side == 0) {
            return this.extractorBottom;
        }
        if (side == 1) {
            return this.extractorTop;
        }
        if (metadata == 2 && side == 2 || metadata == 3 && side == 3 || metadata == 4 && side == 4 || metadata == 5 && side == 5 || metadata == 0 && side == 4) {
            return this.extractorFace;
        }
        return this.extractorSide;
    }
}

