/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.planets.fronos.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import stevekung.mods.moreplanets.core.blocks.base.BlockBaseMP;

public class BlockCandyCane
extends BlockBaseMP {
    private static String[] types = new String[]{"pink", "orange", "green", "yellow", "light_blue", "blue", "red", "purple"};
    private IIcon[] textures;
    private IIcon[] logHearts;
    private CandyCategory category;

    public BlockCandyCane(String name, CandyCategory cat) {
        super(Material.field_151580_n);
        this.category = cat;
        this.func_149711_c(1.0f);
        this.func_149752_b(3.0f);
        this.func_149672_a(Block.field_149775_l);
        this.func_149663_c(name);
    }

    public void func_149651_a(IIconRegister iconRegister) {
        this.textures = new IIcon[types.length];
        this.logHearts = new IIcon[types.length];
        for (int i = 0; i < types.length; ++i) {
            this.textures[i] = iconRegister.func_94245_a("fronos:candy_cane_" + types[i] + "_side");
            this.logHearts[i] = iconRegister.func_94245_a("fronos:candy_cane_" + types[i] + "_top");
        }
    }

    public IIcon func_149691_a(int side, int meta) {
        int pos = meta & 0xC;
        if (pos == 0 && (side == 1 || side == 0) || pos == 4 && (side == 5 || side == 4) || pos == 8 && (side == 2 || side == 3)) {
            return this.logHearts[(meta & 3) + this.category.ordinal() * 4];
        }
        return this.textures[(meta & 3) + this.category.ordinal() * 4];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item block, CreativeTabs creativeTabs, List list) {
        for (int i = 0; i < 4; ++i) {
            list.add(new ItemStack((Block)this, 1, i));
        }
    }

    public int func_149660_a(World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int meta) {
        int orientation = 0;
        switch (side) {
            case 0: 
            case 1: {
                orientation = 0;
                break;
            }
            case 2: 
            case 3: {
                orientation = 8;
                break;
            }
            case 4: 
            case 5: {
                orientation = 4;
            }
        }
        return meta & 3 | orientation;
    }

    public int func_149692_a(int meta) {
        return meta & 3;
    }

    protected ItemStack func_149644_j(int meta) {
        return new ItemStack((Block)this, 1, meta & 3);
    }

    public int func_149645_b() {
        return 31;
    }

    public String getCandyCaneType(int meta) {
        return types[(meta & 3) + this.category.ordinal() * 4];
    }

    public ItemStack getPickBlock(MovingObjectPosition moving, World world, int x, int y, int z) {
        return new ItemStack((Block)this, 1, world.func_72805_g(x, y, z) & 3);
    }

    public static enum CandyCategory {
        CAT1,
        CAT2,
        CAT3,
        CAT4;

    }
}

