/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.planets.diona.entities;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import micdoodle8.mods.galacticraft.api.entity.IEntityBreathable;
import micdoodle8.mods.galacticraft.core.items.GCItems;
import net.minecraft.block.Block;
import net.minecraft.block.BlockColored;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowOwner;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIOwnerHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITargetNonTamed;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import stevekung.mods.moreplanets.core.achievement.AchievementsMP;
import stevekung.mods.moreplanets.core.init.MPItems;
import stevekung.mods.moreplanets.planets.diona.blocks.DionaBlocks;
import stevekung.mods.moreplanets.planets.diona.entities.ai.EntityAISpaceWolfBeg;

public class EntitySpaceWolf
extends EntityTameable
implements IEntityBreathable {
    private float field_70926_e;
    private float field_70924_f;
    private boolean isShaking;
    private boolean field_70928_h;
    private float timeWolfIsShaking;
    private float prevTimeWolfIsShaking;

    public EntitySpaceWolf(World world) {
        super(world);
        this.func_70105_a(0.6f, 0.8f);
        this.func_70661_as().func_75491_a(true);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.field_70911_d);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.4f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIFollowOwner((EntityTameable)this, 1.0, 10.0f, 2.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAISpaceWolfBeg(this, 8.0f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIOwnerHurtByTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIOwnerHurtTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetNonTamed((EntityTameable)this, EntitySheep.class, 200, false));
        this.func_70903_f(false);
    }

    public boolean func_70601_bi() {
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        int j = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b);
        int k = MathHelper.func_76128_c((double)this.field_70161_v);
        Block block = this.field_70170_p.func_147439_a(i, j - 1, k);
        int meta = this.field_70170_p.func_72805_g(i, j - 1, k);
        return block == DionaBlocks.diona_block && meta == 0;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.300000011920929);
        if (this.func_70909_n()) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        }
    }

    public boolean func_70650_aV() {
        return true;
    }

    public void func_70624_b(EntityLivingBase living) {
        super.func_70624_b(living);
        if (living == null) {
            this.setAngry(false);
        } else if (!this.func_70909_n()) {
            this.setAngry(true);
        }
    }

    protected void func_70629_bd() {
        this.field_70180_af.func_75692_b(18, (Object)Float.valueOf(this.func_110143_aJ()));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(18, (Object)new Float(this.func_110143_aJ()));
        this.field_70180_af.func_75682_a(19, (Object)new Byte(0));
        this.field_70180_af.func_75682_a(20, (Object)new Byte((byte)BlockColored.func_150032_b((int)1)));
    }

    protected void func_145780_a(int x, int y, int z, Block block) {
        this.func_85030_a("mob.wolf.step", 0.15f, 1.0f);
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74757_a("Angry", this.isAngry());
        nbt.func_74774_a("CollarColor", (byte)this.getCollarColor());
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setAngry(nbt.func_74767_n("Angry"));
        if (nbt.func_150297_b("CollarColor", 99)) {
            this.setCollarColor(nbt.func_74771_c("CollarColor"));
        }
    }

    protected String func_70639_aQ() {
        if (this.isAngry()) {
            return "mob.wolf.growl";
        }
        if (this.field_70146_Z.nextInt(3) == 0) {
            if (this.func_70909_n() && this.field_70180_af.func_111145_d(18) < 10.0f) {
                return "mob.wolf.whine";
            }
            return "mob.wolf.panting";
        }
        return "mob.wolf.bark";
    }

    protected String func_70621_aR() {
        return "mob.wolf.hurt";
    }

    protected String func_70673_aS() {
        return "mob.wolf.death";
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    protected Item func_146068_u() {
        return Item.func_150898_a((Block)Blocks.field_150350_a);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.isShaking && !this.field_70928_h && !this.func_70781_l() && this.field_70122_E) {
            this.field_70928_h = true;
            this.timeWolfIsShaking = 0.0f;
            this.prevTimeWolfIsShaking = 0.0f;
            this.field_70170_p.func_72960_a((Entity)this, (byte)8);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.field_70924_f = this.field_70926_e;
        this.field_70926_e = this.func_70922_bv() ? (this.field_70926_e += (1.0f - this.field_70926_e) * 0.4f) : (this.field_70926_e += (0.0f - this.field_70926_e) * 0.4f);
        if (this.func_70922_bv()) {
            this.field_70700_bx = 10;
        }
        if (this.func_70026_G()) {
            this.isShaking = true;
            this.field_70928_h = false;
            this.timeWolfIsShaking = 0.0f;
            this.prevTimeWolfIsShaking = 0.0f;
        } else if ((this.isShaking || this.field_70928_h) && this.field_70928_h) {
            if (this.timeWolfIsShaking == 0.0f) {
                this.func_85030_a("mob.wolf.shake", this.func_70599_aP(), (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            }
            this.prevTimeWolfIsShaking = this.timeWolfIsShaking;
            this.timeWolfIsShaking += 0.05f;
            if (this.prevTimeWolfIsShaking >= 2.0f) {
                this.isShaking = false;
                this.field_70928_h = false;
                this.prevTimeWolfIsShaking = 0.0f;
                this.timeWolfIsShaking = 0.0f;
            }
            if (this.timeWolfIsShaking > 0.4f) {
                float f1 = (float)this.field_70121_D.field_72338_b;
                int i = (int)(MathHelper.func_76126_a((float)((this.timeWolfIsShaking - 0.4f) * 3.141593f)) * 7.0f);
                for (int j = 0; j < i; ++j) {
                    float f2 = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.field_70130_N * 0.5f;
                    float f3 = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.field_70130_N * 0.5f;
                    this.field_70170_p.func_72869_a("splash", this.field_70165_t + (double)f2, (double)(f1 + 0.8f), this.field_70161_v + (double)f3, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean getWolfShaking() {
        return this.isShaking;
    }

    @SideOnly(value=Side.CLIENT)
    public float getShadingWhileShaking(float par1) {
        return 0.75f + (this.prevTimeWolfIsShaking + (this.timeWolfIsShaking - this.prevTimeWolfIsShaking) * par1) / 2.0f * 0.25f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getShakeAngle(float par1, float par2) {
        float f = (this.prevTimeWolfIsShaking + (this.timeWolfIsShaking - this.prevTimeWolfIsShaking) * par1 + par2) / 1.8f;
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        return MathHelper.func_76126_a((float)(f * 3.141593f)) * MathHelper.func_76126_a((float)(f * 3.141593f * 11.0f)) * 0.15f * 3.141593f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getInterestedAngle(float par1) {
        return (this.field_70924_f + (this.field_70926_e - this.field_70924_f) * par1) * 0.15f * 3.141593f;
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.8f;
    }

    public int func_70646_bf() {
        if (this.func_70906_o()) {
            return 20;
        }
        return super.func_70646_bf();
    }

    public boolean func_70097_a(DamageSource source, float par2) {
        if (this.func_85032_ar()) {
            return false;
        }
        Entity localEntity = source.func_76346_g();
        this.field_70911_d.func_75270_a(false);
        if (localEntity != null && !(localEntity instanceof EntityPlayer) && !(localEntity instanceof EntityArrow)) {
            par2 = (par2 + 1.0f) / 2.0f;
        }
        return super.func_70097_a(source, par2);
    }

    public boolean func_70652_k(Entity entity) {
        int i = this.func_70909_n() ? 4 : 2;
        return entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)i);
    }

    public void func_70903_f(boolean tame) {
        super.func_70903_f(tame);
        if (tame) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        }
    }

    public boolean func_70085_c(EntityPlayer player) {
        ItemStack itemStack = player.field_71071_by.func_70448_g();
        if (this.func_70909_n()) {
            if (itemStack != null) {
                int i;
                if (itemStack.func_77973_b() instanceof ItemFood) {
                    ItemFood localItemFood = (ItemFood)itemStack.func_77973_b();
                    if (localItemFood.func_77845_h() && this.field_70180_af.func_111145_d(18) < 20.0f) {
                        if (!player.field_71075_bZ.field_75098_d) {
                            --itemStack.field_77994_a;
                        }
                        this.func_70691_i(localItemFood.func_150905_g(itemStack));
                        if (itemStack.field_77994_a <= 0) {
                            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                        }
                        return true;
                    }
                } else if (itemStack.func_77973_b() == Items.field_151100_aR && (i = BlockColored.func_150032_b((int)itemStack.func_77960_j())) != this.getCollarColor()) {
                    this.setCollarColor(i);
                    if (!player.field_71075_bZ.field_75098_d && --itemStack.field_77994_a <= 0) {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                    }
                    return true;
                }
            }
            if (this.func_152114_e((EntityLivingBase)player) && !this.field_70170_p.field_72995_K && !this.func_70877_b(itemStack)) {
                this.field_70911_d.func_75270_a(!this.func_70906_o());
                this.field_70703_bu = false;
                this.func_70778_a(null);
                this.func_70784_b(null);
                this.func_70624_b(null);
            }
        } else if (itemStack != null && itemStack.func_77973_b() == Items.field_151103_aS && !this.isAngry()) {
            if (!player.field_71075_bZ.field_75098_d) {
                --itemStack.field_77994_a;
            }
            if (itemStack.field_77994_a <= 0) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
            }
            if (!this.field_70170_p.field_72995_K) {
                if (this.field_70146_Z.nextInt(3) == 0) {
                    this.func_70903_f(true);
                    this.func_70778_a(null);
                    this.func_70624_b(null);
                    this.field_70911_d.func_75270_a(true);
                    this.func_70606_j(20.0f);
                    this.func_152115_b(player.func_110124_au().toString());
                    this.func_70908_e(true);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                    player.func_71029_a((StatBase)AchievementsMP.tameSpaceWolf);
                } else {
                    this.func_70908_e(false);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                }
            }
            return true;
        }
        if (itemStack != null && itemStack.func_77973_b() == MPItems.spawn_egg_mp && itemStack.func_77960_j() == 1000) {
            EntitySpaceWolf entityageable;
            if (!this.field_70170_p.field_72995_K && (entityageable = this.createChild((EntityAgeable)this)) != null) {
                entityageable.func_70873_a(-24000);
                entityageable.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0f, 0.0f);
                this.field_70170_p.func_72838_d((Entity)entityageable);
                if (itemStack.func_82837_s()) {
                    entityageable.func_94058_c(itemStack.func_82833_r());
                }
                if (!player.field_71075_bZ.field_75098_d) {
                    --itemStack.field_77994_a;
                    if (itemStack.field_77994_a <= 0) {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, (ItemStack)null);
                    }
                }
            }
            return true;
        }
        return super.func_70085_c(player);
    }

    public ItemStack getPickedResult(MovingObjectPosition target) {
        return new ItemStack(MPItems.spawn_egg_mp, 1, 1000);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte health) {
        if (health == 8) {
            this.field_70928_h = true;
            this.timeWolfIsShaking = 0.0f;
            this.prevTimeWolfIsShaking = 0.0f;
        } else {
            super.func_70103_a(health);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float getTailRotation() {
        if (this.isAngry()) {
            return 1.53938f;
        }
        if (this.func_70909_n()) {
            return (0.55f - (20.0f - this.field_70180_af.func_111145_d(18)) * 0.02f) * 3.141593f;
        }
        return 0.6283186f;
    }

    public boolean func_70877_b(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        if (!(itemStack.func_77973_b() instanceof ItemFood)) {
            return false;
        }
        return ((ItemFood)itemStack.func_77973_b()).func_77845_h();
    }

    public int func_70641_bl() {
        return 8;
    }

    public boolean isAngry() {
        return (this.field_70180_af.func_75683_a(16) & 2) != 0;
    }

    public void setAngry(boolean angry) {
        byte i = this.field_70180_af.func_75683_a(16);
        if (angry) {
            this.field_70180_af.func_75692_b(16, (Object)((byte)(i | 2)));
        } else {
            this.field_70180_af.func_75692_b(16, (Object)((byte)(i & 0xFFFFFFFD)));
        }
    }

    public int getCollarColor() {
        return this.field_70180_af.func_75683_a(20) & 0xF;
    }

    public void setCollarColor(int color) {
        this.field_70180_af.func_75692_b(20, (Object)((byte)(color & 0xF)));
    }

    public EntitySpaceWolf createChild(EntityAgeable entity) {
        EntitySpaceWolf localEntityWolf = new EntitySpaceWolf(this.field_70170_p);
        String str = this.func_152113_b();
        if (str != null && str.trim().length() > 0) {
            localEntityWolf.func_152115_b(str);
            localEntityWolf.func_70903_f(true);
        }
        return localEntityWolf;
    }

    public void func_70918_i(boolean par1) {
        if (par1) {
            this.field_70180_af.func_75692_b(19, (Object)1);
        } else {
            this.field_70180_af.func_75692_b(19, (Object)0);
        }
    }

    public boolean func_70878_b(EntityAnimal entity) {
        if (entity == this) {
            return false;
        }
        if (!this.func_70909_n()) {
            return false;
        }
        if (!(entity instanceof EntitySpaceWolf)) {
            return false;
        }
        EntitySpaceWolf localEntityWolf = (EntitySpaceWolf)entity;
        if (!localEntityWolf.func_70909_n()) {
            return false;
        }
        if (localEntityWolf.func_70906_o()) {
            return false;
        }
        return this.func_70880_s() && localEntityWolf.func_70880_s();
    }

    public boolean func_70922_bv() {
        return this.field_70180_af.func_75683_a(19) == 1;
    }

    protected boolean func_70692_ba() {
        return !this.func_70909_n() && this.field_70173_aa > 2400;
    }

    public boolean func_142018_a(EntityLivingBase living, EntityLivingBase living2) {
        EntitySpaceWolf localEntityWolf;
        if (living instanceof EntityCreeper || living instanceof EntityGhast) {
            return false;
        }
        if (living instanceof EntitySpaceWolf && (localEntityWolf = (EntitySpaceWolf)living).func_70909_n() && localEntityWolf.func_70902_q() == living2) {
            return false;
        }
        if (living instanceof EntityPlayer && living2 instanceof EntityPlayer && !((EntityPlayer)living2).func_96122_a((EntityPlayer)living)) {
            return false;
        }
        return !(living instanceof EntityHorse) || !((EntityHorse)living).func_110248_bS();
    }

    public boolean canBreath() {
        return true;
    }

    protected void func_70600_l(int par1) {
        switch (this.field_70146_Z.nextInt(10)) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                this.func_70099_a(new ItemStack(GCItems.oxTankMedium, 1, 901 + this.field_70146_Z.nextInt(900)), 0.0f);
                break;
            }
            case 8: {
                this.func_145779_a(Item.func_150898_a((Block)Blocks.field_150359_w), 1);
                break;
            }
            case 9: {
                this.func_145779_a(GCItems.oxygenGear, 1);
                break;
            }
            case 10: {
                this.func_145779_a(GCItems.oxMask, 1);
            }
        }
    }
}

