/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.core.util;

import cpw.mods.fml.common.FMLCommonHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S07PacketRespawn;
import net.minecraft.network.play.server.S1DPacketEntityEffect;
import net.minecraft.network.play.server.S1FPacketSetExperience;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import stevekung.mods.moreplanets.core.util.MPLog;

public class WorldUtilMP {
    public static boolean isSpaceWorld(World world, WorldProvider provider) {
        return world.field_73011_w.getClass() == provider.getClass();
    }

    public static Entity setHomePlanetDimension(Entity entity, int dimID, WorldServer world) {
        MinecraftServer mcServer;
        if (!world.field_72995_K && (mcServer = FMLCommonHandler.instance().getMinecraftServerInstance()) != null) {
            WorldServer worldServer = mcServer.func_71218_a(dimID);
            if (worldServer == null) {
                MPLog.error("Cannot Transfer Entity to Dimension: Could not get World for Dimension " + dimID);
                return null;
            }
            return WorldUtilMP.teleportEntity((World)worldServer, entity, dimID);
        }
        return null;
    }

    private static Entity teleportEntity(World worldNew, Entity entity, int dimID) {
        ChunkCoordinates chunkcoordinates = ((WorldServer)entity.field_70170_p).func_72861_E();
        chunkcoordinates.field_71572_b = ((WorldServer)worldNew).func_72825_h(chunkcoordinates.field_71574_a, chunkcoordinates.field_71573_c);
        boolean dimChange = entity.field_70170_p != worldNew;
        entity.field_70170_p.func_72866_a(entity, false);
        EntityPlayerMP player = null;
        int oldDimID = entity.field_70170_p.field_73011_w.field_76574_g;
        if (dimChange) {
            if (entity instanceof EntityPlayerMP) {
                player = (EntityPlayerMP)entity;
                World worldOld = player.field_70170_p;
                player.field_71093_bK = dimID;
                player.field_71135_a.func_147359_a((Packet)new S07PacketRespawn(dimID, player.field_70170_p.field_73013_u, player.field_70170_p.func_72912_H().func_76067_t(), player.field_71134_c.func_73081_b()));
                worldOld.field_73010_i.remove(player);
                worldOld.func_72854_c();
                if (player.field_70175_ag && worldOld.func_72863_F().func_73149_a(player.field_70176_ah, player.field_70164_aj)) {
                    Chunk chunkOld = worldOld.func_72964_e(player.field_70176_ah, player.field_70164_aj);
                    chunkOld.func_76622_b((Entity)player);
                    chunkOld.field_76643_l = true;
                }
                worldOld.field_72996_f.remove(player);
                worldOld.func_72847_b((Entity)player);
                worldNew.func_72838_d(entity);
                entity.func_70029_a(worldNew);
                ChunkCoordIntPair pair = worldNew.func_72964_e(chunkcoordinates.field_71574_a, chunkcoordinates.field_71573_c).func_76632_l();
                ((WorldServer)worldNew).field_73059_b.func_73158_c(pair.field_77276_a, pair.field_77275_b);
                worldNew.func_72866_a(entity, false);
                entity.func_70012_b((double)chunkcoordinates.field_71574_a, (double)chunkcoordinates.field_71572_b, (double)chunkcoordinates.field_71573_c, entity.field_70177_z, entity.field_70125_A);
                player.field_71133_b.func_71203_ab().func_72375_a(player, (WorldServer)worldNew);
                player.field_71135_a.func_147364_a((double)chunkcoordinates.field_71574_a, (double)chunkcoordinates.field_71572_b, (double)chunkcoordinates.field_71573_c, entity.field_70177_z, entity.field_70125_A);
                MPLog.info("Server attempting to transfer player " + player.func_146103_bH().getName() + " to dimension " + worldNew.field_73011_w.field_76574_g);
                player.field_71134_c.func_73080_a((WorldServer)worldNew);
                player.field_71133_b.func_71203_ab().func_72354_b(player, (WorldServer)worldNew);
                player.field_71133_b.func_71203_ab().func_72385_f(player);
                for (Object o : player.func_70651_bq()) {
                    PotionEffect potion = (PotionEffect)o;
                    player.field_71135_a.func_147359_a((Packet)new S1DPacketEntityEffect(player.func_145782_y(), potion));
                }
                player.field_71135_a.func_147359_a((Packet)new S1FPacketSetExperience(player.field_71106_cc, player.field_71067_cb, player.field_71068_ca));
            }
        } else if (entity instanceof EntityPlayerMP) {
            player = (EntityPlayerMP)entity;
            worldNew.func_72866_a(entity, false);
            player.field_71135_a.func_147364_a((double)chunkcoordinates.field_71574_a, (double)chunkcoordinates.field_71572_b, (double)chunkcoordinates.field_71573_c, entity.field_70177_z, entity.field_70125_A);
            entity.func_70012_b((double)chunkcoordinates.field_71574_a, (double)chunkcoordinates.field_71572_b, (double)chunkcoordinates.field_71573_c, entity.field_70177_z, entity.field_70125_A);
            worldNew.func_72866_a(entity, false);
            MPLog.info("Server attempting to transfer player " + player.func_146103_bH().getName() + " within same dimension " + worldNew.field_73011_w.field_76574_g);
        }
        if (entity instanceof EntityPlayerMP) {
            FMLCommonHandler.instance().firePlayerChangedDimensionEvent((EntityPlayer)((EntityPlayerMP)entity), oldDimID, dimID);
        }
        return entity;
    }
}

