/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.core.spacestation.mars;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.core.dimension.WorldProviderOrbit;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.client.IRenderHandler;
import stevekung.mods.moreplanets.core.MorePlanetsCore;
import stevekung.mods.moreplanets.core.spacestation.mars.ChunkProviderMarsOrbit;
import stevekung.mods.moreplanets.core.spacestation.mars.SkyProviderMarsOrbit;
import stevekung.mods.moreplanets.core.world.IUltraVioletLevel;

public class WorldProviderMarsOrbit
extends WorldProviderOrbit
implements IUltraVioletLevel {
    private float angularVelocityRadians = 0.0f;
    private float skyAngularVelocity = (float)((double)(this.angularVelocityRadians * 180.0f) / Math.PI);

    public long getDayLength() {
        return 0L;
    }

    public float func_76563_a(long par1, float par3) {
        return 0.1975f;
    }

    public CelestialBody getCelestialBody() {
        return MorePlanetsCore.marsSpaceStation;
    }

    public Class<? extends IChunkProvider> getChunkProviderClass() {
        return ChunkProviderMarsOrbit.class;
    }

    public String func_80007_l() {
        return "Space Station " + this.spaceStationDimensionID;
    }

    public String getPlanetToOrbit() {
        return "planet.mars";
    }

    public int getYCoordToTeleportToPlanet() {
        return 30;
    }

    public String getSaveFolder() {
        return "DIM_SPACESTATION" + this.spaceStationDimensionID;
    }

    public double getYCoordinateToTeleport() {
        return 1200.0;
    }

    public boolean canSpaceshipTierPass(int tier) {
        return tier > 2;
    }

    public float getFallDamageModifier() {
        return 0.4f;
    }

    public float getSoundVolReductionAmount() {
        return 50.0f;
    }

    public void setSpinRate(float angle) {
        super.setSpinRate(angle);
        this.angularVelocityRadians = angle;
        this.skyAngularVelocity = angle * 180.0f / (float)Math.PI;
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            this.updateSkyProviderSpinRate();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void updateSkyProviderSpinRate() {
        IRenderHandler sky = this.getSkyRenderer();
        if (sky instanceof SkyProviderMarsOrbit) {
            ((SkyProviderMarsOrbit)sky).spinDeltaPerTick = this.skyAngularVelocity;
        }
    }

    public void setSpinRate(float angle, boolean firing) {
        super.setSpinRate(angle, firing);
        this.angularVelocityRadians = angle;
        this.skyAngularVelocity = angle * 180.0f / (float)Math.PI;
        IRenderHandler sky = this.getSkyRenderer();
        if (sky instanceof SkyProviderMarsOrbit) {
            ((SkyProviderMarsOrbit)sky).spinDeltaPerTick = this.skyAngularVelocity;
        }
        this.thrustersFiring = firing;
    }

    public float getThermalLevelModifier() {
        return 0.0f;
    }

    public float getWindLevel() {
        return 0.1f;
    }

    @Override
    public double getUltraVioletEnergyMultiplie() {
        return 6.0;
    }
}

