/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.core.spacestation.jupiter;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.dimension.WorldProviderOrbit;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import net.minecraft.util.MathHelper;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.client.IRenderHandler;
import stevekung.mods.moreplanets.core.MorePlanetsCore;
import stevekung.mods.moreplanets.core.spacestation.jupiter.ChunkProviderJupiterOrbit;
import stevekung.mods.moreplanets.core.spacestation.jupiter.SkyProviderJupiterOrbit;
import stevekung.mods.moreplanets.core.world.IUltraVioletLevel;

public class WorldProviderJupiterOrbit
extends WorldProviderOrbit
implements IUltraVioletLevel {
    private float angularVelocityRadians = 0.0f;
    private float skyAngularVelocity = (float)((double)(this.angularVelocityRadians * 180.0f) / Math.PI);

    public CelestialBody getCelestialBody() {
        return MorePlanetsCore.jupiterSpaceStation;
    }

    public Vector3 getFogColor() {
        return new Vector3(0.0, 0.0, 0.0);
    }

    public Vector3 getSkyColor() {
        return new Vector3(0.0, 0.0, 0.0);
    }

    public boolean canRainOrSnow() {
        return false;
    }

    public boolean hasSunset() {
        return false;
    }

    public long getDayLength() {
        return 0L;
    }

    public float func_76563_a(long par1, float par3) {
        return 0.1975f;
    }

    public boolean shouldForceRespawn() {
        return !ConfigManagerCore.forceOverworldRespawn;
    }

    public Class<? extends IChunkProvider> getChunkProviderClass() {
        return ChunkProviderJupiterOrbit.class;
    }

    @SideOnly(value=Side.CLIENT)
    public float getSunBrightness(float par1) {
        float f1 = this.field_76579_a.func_72826_c(1.0f);
        float f2 = 0.45f - (MathHelper.func_76134_b((float)(f1 * (float)Math.PI * 2.0f)) * 2.0f + 0.2f);
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        f2 = 1.0f - f2;
        return f2 * 0.7f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getStarBrightness(float par1) {
        return 1.0f;
    }

    public boolean func_76561_g() {
        return false;
    }

    public double getHorizon() {
        return 44.0;
    }

    public int func_76557_i() {
        return 44;
    }

    public boolean func_76569_d() {
        return true;
    }

    public boolean func_76566_a(int x, int z) {
        return true;
    }

    public String func_80007_l() {
        return "Space Station " + this.spaceStationDimensionID;
    }

    public boolean canSnowAt(int x, int y, int z, boolean checkLight) {
        return false;
    }

    public float getGravity() {
        return 0.075f;
    }

    public boolean hasBreathableAtmosphere() {
        return false;
    }

    public double getMeteorFrequency() {
        return 0.0;
    }

    public double getFuelUsageMultiplier() {
        return 0.75;
    }

    public String getPlanetToOrbit() {
        return "planet.jupiter";
    }

    public int getYCoordToTeleportToPlanet() {
        return -1000;
    }

    public String getSaveFolder() {
        return "DIM_SPACESTATION" + this.spaceStationDimensionID;
    }

    public double getSolarEnergyMultiplier() {
        return ConfigManagerCore.spaceStationEnergyScalar - 1.0;
    }

    public double getYCoordinateToTeleport() {
        return 1200.0;
    }

    public boolean canSpaceshipTierPass(int tier) {
        return tier > 3;
    }

    public float getFallDamageModifier() {
        return 0.4f;
    }

    public float getSoundVolReductionAmount() {
        return 50.0f;
    }

    public void setSpinRate(float angle) {
        super.setSpinRate(angle);
        this.angularVelocityRadians = angle;
        this.skyAngularVelocity = angle * 180.0f / (float)Math.PI;
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            this.updateSkyProviderSpinRate();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void updateSkyProviderSpinRate() {
        IRenderHandler sky = this.getSkyRenderer();
        if (sky instanceof SkyProviderJupiterOrbit) {
            ((SkyProviderJupiterOrbit)sky).spinDeltaPerTick = this.skyAngularVelocity;
        }
    }

    public void setSpinRate(float angle, boolean firing) {
        super.setSpinRate(angle, firing);
        this.angularVelocityRadians = angle;
        this.skyAngularVelocity = angle * 180.0f / (float)Math.PI;
        IRenderHandler sky = this.getSkyRenderer();
        if (sky instanceof SkyProviderJupiterOrbit) {
            ((SkyProviderJupiterOrbit)sky).spinDeltaPerTick = this.skyAngularVelocity;
        }
        this.thrustersFiring = firing;
    }

    public float getThermalLevelModifier() {
        return 0.0f;
    }

    public float getWindLevel() {
        return 0.1f;
    }

    @Override
    public double getUltraVioletEnergyMultiplie() {
        return 2.0;
    }
}

