/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.core.nei;

import codechicken.nei.PositionedStack;
import codechicken.nei.api.API;
import codechicken.nei.api.IConfigureNEI;
import codechicken.nei.api.IHighlightHandler;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import micdoodle8.mods.galacticraft.core.items.GCItems;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import stevekung.mods.moreplanets.core.config.ConfigManagerMP;
import stevekung.mods.moreplanets.core.init.MPBlocks;
import stevekung.mods.moreplanets.core.init.MPItems;
import stevekung.mods.moreplanets.core.nei.CircuitFabricatorRecipeHandlerMP;
import stevekung.mods.moreplanets.core.nei.NEIHighlightHandlerMP;
import stevekung.mods.moreplanets.core.util.MPLog;
import stevekung.mods.moreplanets.planets.polongnius.items.PolongniusItems;

public class NEIMorePlanetsConfig
implements IConfigureNEI {
    private static HashMap<HashMap<Integer, PositionedStack>, PositionedStack> circuitFabricatorRecipes = new HashMap();

    public void loadConfig() {
        API.registerRecipeHandler((ICraftingHandler)new CircuitFabricatorRecipeHandlerMP());
        API.registerUsageHandler((IUsageHandler)new CircuitFabricatorRecipeHandlerMP());
        for (Block block : MPBlocks.highlightBlockList) {
            API.registerHighlightIdentifier((Block)block, (IHighlightHandler)new NEIHighlightHandlerMP());
            MPLog.debug("Register NEI Highlight %s [%s]", block.getClass().getSimpleName(), block.func_149739_a().substring(5));
        }
        this.registerRecipe();
    }

    public String getName() {
        return "More Planets NEI Plugin";
    }

    public String getVersion() {
        return "1.3.1";
    }

    public void registerCircuitFabricatorRecipe(HashMap<Integer, PositionedStack> input, PositionedStack output) {
        circuitFabricatorRecipes.put(input, output);
    }

    public static Set<Map.Entry<HashMap<Integer, PositionedStack>, PositionedStack>> getCircuitFabricatorRecipes() {
        return circuitFabricatorRecipes.entrySet();
    }

    public void registerRecipe() {
        this.addPurpleCrystalWaferRecipes();
        this.addPurpleCrystalSolarWaferRecipes();
        this.registerHideBlocks();
        this.registerHideItems();
    }

    private void addPurpleCrystalWaferRecipes() {
        HashMap<Integer, PositionedStack> input1 = new HashMap<Integer, PositionedStack>();
        int siliconCount = OreDictionary.getOres((String)ConfigManagerCore.otherModsSilicon).size();
        ItemStack[] silicons = new ItemStack[siliconCount + 1];
        silicons[0] = new ItemStack(GCItems.basicItem, 1, 2);
        for (int j = 0; j < siliconCount; ++j) {
            silicons[j + 1] = (ItemStack)OreDictionary.getOres((String)"itemSilicon").get(j);
        }
        input1.put(0, new PositionedStack((Object)new ItemStack(PolongniusItems.polongnius_item, 1, 1), 10, 22));
        input1.put(1, new PositionedStack((Object)silicons, 69, 51));
        input1.put(2, new PositionedStack((Object)silicons, 69, 69));
        input1.put(3, new PositionedStack((Object)new ItemStack(Items.field_151137_ax), 117, 51));
        input1.put(4, new PositionedStack((Object)new ItemStack(Items.field_151107_aW), 140, 25));
        this.registerCircuitFabricatorRecipe(input1, new PositionedStack((Object)new ItemStack(PolongniusItems.purple_crystal_solar_module, ConfigManagerCore.quickMode ? 2 : 1, 0), 147, 91));
    }

    private void addPurpleCrystalSolarWaferRecipes() {
        HashMap<Integer, PositionedStack> input1 = new HashMap<Integer, PositionedStack>();
        int siliconCount = OreDictionary.getOres((String)ConfigManagerCore.otherModsSilicon).size();
        ItemStack[] silicons = new ItemStack[siliconCount + 1];
        silicons[0] = new ItemStack(GCItems.basicItem, 1, 2);
        for (int j = 0; j < siliconCount; ++j) {
            silicons[j + 1] = (ItemStack)OreDictionary.getOres((String)"itemSilicon").get(j);
        }
        input1.put(0, new PositionedStack((Object)new ItemStack(Items.field_151045_i), 10, 22));
        input1.put(1, new PositionedStack((Object)silicons, 69, 51));
        input1.put(2, new PositionedStack((Object)silicons, 69, 69));
        input1.put(3, new PositionedStack((Object)new ItemStack(Items.field_151137_ax), 117, 51));
        input1.put(4, new PositionedStack((Object)new ItemStack(PolongniusItems.polongnius_item, 1, 1), 140, 25));
        this.registerCircuitFabricatorRecipe(input1, new PositionedStack((Object)new ItemStack(PolongniusItems.purple_crystal_solar_module, 9, 1), 147, 91));
    }

    private void registerHideBlocks() {
        for (Block block : MPBlocks.hideBlockList) {
            API.hideItem((ItemStack)new ItemStack(block, 1, Short.MAX_VALUE));
            MPLog.debug("Register NEI Hide Block %s [%s]", block.getClass().getSimpleName(), block.func_149739_a().substring(5));
        }
    }

    private void registerHideItems() {
        if (!ConfigManagerMP.enableThaiFlagAndCanvas) {
            API.hideItem((ItemStack)new ItemStack(MPItems.flag, 1, Short.MAX_VALUE));
            API.hideItem((ItemStack)new ItemStack(MPItems.achievement_temp, 1, Short.MAX_VALUE));
        }
    }
}

