/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.core.items.tools;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import cpw.mods.fml.common.versioning.ArtifactVersion;
import cpw.mods.fml.common.versioning.DefaultArtifactVersion;
import cpw.mods.fml.common.versioning.VersionParser;
import cpw.mods.fml.relauncher.FMLInjectionData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.IElectricItemManager;
import java.util.List;
import micdoodle8.mods.galacticraft.api.item.ElectricItemHelper;
import micdoodle8.mods.galacticraft.api.item.IItemElectric;
import micdoodle8.mods.galacticraft.core.energy.EnergyConfigHandler;
import micdoodle8.mods.galacticraft.core.energy.EnergyDisplayHelper;
import micdoodle8.mods.galacticraft.core.energy.item.ElectricItemManagerIC2;
import micdoodle8.mods.galacticraft.core.energy.item.ElectricItemManagerIC2_1710;
import micdoodle8.mods.galacticraft.core.items.ItemBatteryInfinite;
import micdoodle8.mods.galacticraft.core.proxy.ClientProxyCore;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import stevekung.mods.moreplanets.core.MorePlanetsCore;
import stevekung.mods.moreplanets.core.items.tools.IToolEffect;

public class ItemElectricAxeMP
extends ItemAxe
implements IItemElectric {
    private static Object itemManagerIC2;
    public float transferMax;
    private DefaultArtifactVersion mcVersion = null;
    private IToolEffect effect;
    private float maxPower;

    public ItemElectricAxeMP(String name, Item.ToolMaterial material, float maxPower, IToolEffect effect) {
        super(material);
        this.func_77656_e(100);
        this.setNoRepair();
        this.func_77655_b(name);
        this.transferMax = 200.0f;
        this.effect = effect;
        this.maxPower = maxPower;
        this.mcVersion = new DefaultArtifactVersion((String)FMLInjectionData.data()[4]);
        if (EnergyConfigHandler.isIndustrialCraft2Loaded()) {
            itemManagerIC2 = VersionParser.parseRange((String)"[1.7.2]").containsVersion((ArtifactVersion)this.mcVersion) ? new ElectricItemManagerIC2() : new ElectricItemManagerIC2_1710();
        }
    }

    public float getMaxElectricityStored(ItemStack itemStack) {
        return this.maxPower;
    }

    public float func_150893_a(ItemStack itemStack, Block block) {
        if (this.getElectricityStored(itemStack) == 0.0f) {
            return 0.0f;
        }
        return super.func_150893_a(itemStack, block);
    }

    public float getDigSpeed(ItemStack itemStack, Block block, int meta) {
        if (this.getElectricityStored(itemStack) == 0.0f) {
            return 0.5f;
        }
        return super.getDigSpeed(itemStack, block, meta);
    }

    public boolean func_77644_a(ItemStack itemStack, EntityLivingBase living, EntityLivingBase holder) {
        if (this.getElectricityStored(itemStack) != 0.0f) {
            this.setElectricity(itemStack, this.getElectricityStored(itemStack) - 10.5f);
            if (this.effect != null) {
                this.effect.addEffect(living);
            }
            return true;
        }
        return false;
    }

    public boolean func_150894_a(ItemStack itemStack, World world, Block block, int x, int y, int z, EntityLivingBase living) {
        if ((double)block.func_149712_f(world, x, y, z) != 0.0 && this.getElectricityStored(itemStack) != 0.0f) {
            this.setElectricity(itemStack, this.getElectricityStored(itemStack) - 10.0f);
        }
        return true;
    }

    public Multimap getAttributeModifiers(ItemStack itemStack) {
        if (this.getElectricityStored(itemStack) != 0.0f) {
            return super.getAttributeModifiers(itemStack);
        }
        return HashMultimap.create();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List list, boolean advanced) {
        EnumChatFormatting color = null;
        float joules = this.getElectricityStored(itemStack);
        color = joules <= this.getMaxElectricityStored(itemStack) / 3.0f ? EnumChatFormatting.DARK_RED : (joules > this.getMaxElectricityStored(itemStack) * 2.0f / 3.0f ? EnumChatFormatting.DARK_GREEN : EnumChatFormatting.GOLD);
        list.add(color + EnergyDisplayHelper.getEnergyDisplayS((float)joules) + "/" + EnergyDisplayHelper.getEnergyDisplayS((float)this.getMaxElectricityStored(itemStack)));
    }

    public void func_77622_d(ItemStack itemStack, World world, EntityPlayer player) {
        this.setElectricity(itemStack, 0.0f);
    }

    public float recharge(ItemStack itemStack, float energy, boolean doReceive) {
        float rejectedElectricity = Math.max(this.getElectricityStored(itemStack) + energy - this.getMaxElectricityStored(itemStack), 0.0f);
        float energyToReceive = energy - rejectedElectricity;
        if (energyToReceive > this.transferMax) {
            rejectedElectricity += energyToReceive - this.transferMax;
            energyToReceive = this.transferMax;
        }
        if (doReceive) {
            this.setElectricity(itemStack, this.getElectricityStored(itemStack) + energyToReceive);
        }
        return energyToReceive;
    }

    public float discharge(ItemStack itemStack, float energy, boolean doTransfer) {
        float energyToTransfer = Math.min(Math.min(this.getElectricityStored(itemStack), energy), this.transferMax);
        if (doTransfer) {
            this.setElectricity(itemStack, this.getElectricityStored(itemStack) - energyToTransfer);
        }
        return energyToTransfer;
    }

    public int getTierGC(ItemStack itemStack) {
        return 1;
    }

    public void setElectricity(ItemStack itemStack, float joules) {
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        float electricityStored = Math.max(Math.min(joules, this.getMaxElectricityStored(itemStack)), 0.0f);
        itemStack.func_77978_p().func_74776_a("electricity", electricityStored);
        itemStack.func_77964_b((int)(100.0f - electricityStored / this.getMaxElectricityStored(itemStack) * 100.0f));
    }

    public float getTransfer(ItemStack itemStack) {
        return Math.min(this.transferMax, this.getMaxElectricityStored(itemStack) - this.getElectricityStored(itemStack));
    }

    public float getElectricityStored(ItemStack itemStack) {
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        float energyStored = 0.0f;
        if (itemStack.func_77978_p().func_74764_b("electricity")) {
            NBTBase obj = itemStack.func_77978_p().func_74781_a("electricity");
            if (obj instanceof NBTTagDouble) {
                energyStored = ((NBTTagDouble)obj).func_150288_h();
            } else if (obj instanceof NBTTagFloat) {
                energyStored = ((NBTTagFloat)obj).func_150288_h();
            }
        }
        itemStack.func_77964_b((int)(100.0f - energyStored / this.getMaxElectricityStored(itemStack) * 100.0f));
        return energyStored;
    }

    public void func_150895_a(Item item, CreativeTabs creativeTabs, List list) {
        list.add(ElectricItemHelper.getWithCharge((ItemStack)new ItemStack((Item)this), (float)this.getMaxElectricityStored(new ItemStack((Item)this))));
    }

    public CreativeTabs func_77640_w() {
        return MorePlanetsCore.mpToolsTab;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack itemStack) {
        return ClientProxyCore.galacticraftItem;
    }

    public boolean func_82789_a(ItemStack itemStack, ItemStack itemStack2) {
        return false;
    }

    @Annotations.RuntimeInterface(clazz="mekanism.api.energy.IEnergizedItem", modID="Mekanism")
    public double getEnergy(ItemStack itemStack) {
        return this.getElectricityStored(itemStack) * EnergyConfigHandler.TO_MEKANISM_RATIO;
    }

    @Annotations.RuntimeInterface(clazz="mekanism.api.energy.IEnergizedItem", modID="Mekanism")
    public void setEnergy(ItemStack itemStack, double amount) {
        this.setElectricity(itemStack, (float)amount * EnergyConfigHandler.MEKANISM_RATIO);
    }

    @Annotations.RuntimeInterface(clazz="mekanism.api.energy.IEnergizedItem", modID="Mekanism")
    public double getMaxEnergy(ItemStack itemStack) {
        return this.getMaxElectricityStored(itemStack) * EnergyConfigHandler.TO_MEKANISM_RATIO;
    }

    @Annotations.RuntimeInterface(clazz="mekanism.api.energy.IEnergizedItem", modID="Mekanism")
    public double getMaxTransfer(ItemStack itemStack) {
        return this.transferMax * EnergyConfigHandler.TO_MEKANISM_RATIO;
    }

    @Annotations.RuntimeInterface(clazz="mekanism.api.energy.IEnergizedItem", modID="Mekanism")
    public boolean canReceive(ItemStack itemStack) {
        return itemStack != null && !(itemStack.func_77973_b() instanceof ItemBatteryInfinite);
    }

    @Annotations.RuntimeInterface(clazz="ic2.api.item.ISpecialElectricItem", modID="IC2")
    public IElectricItemManager getManager(ItemStack itemstack) {
        return (IElectricItemManager)itemManagerIC2;
    }

    @Annotations.RuntimeInterface(clazz="ic2.api.item.ISpecialElectricItem", modID="IC2")
    public boolean canProvideEnergy(ItemStack itemStack) {
        return true;
    }

    @Annotations.RuntimeInterface(clazz="ic2.api.item.ISpecialElectricItem", modID="IC2")
    public Item getChargedItem(ItemStack itemStack) {
        return itemStack.func_77973_b();
    }

    @Annotations.RuntimeInterface(clazz="ic2.api.item.ISpecialElectricItem", modID="IC2")
    public Item getEmptyItem(ItemStack itemStack) {
        return itemStack.func_77973_b();
    }

    @Annotations.RuntimeInterface(clazz="ic2.api.item.ISpecialElectricItem", modID="IC2")
    public int getTier(ItemStack itemStack) {
        return 1;
    }

    @Annotations.VersionSpecific(version="[1.7.10]")
    @Annotations.RuntimeInterface(clazz="ic2.api.item.ISpecialElectricItem", modID="IC2")
    public double getMaxCharge(ItemStack itemStack) {
        return this.getMaxElectricityStored(itemStack) / EnergyConfigHandler.IC2_RATIO;
    }

    @Annotations.AltForVersion(version="[1.7.2]")
    @Annotations.RuntimeInterface(clazz="ic2.api.item.ISpecialElectricItem", modID="IC2")
    public int getMaxChargeB(ItemStack itemStack) {
        return (int)(this.getMaxElectricityStored(itemStack) / EnergyConfigHandler.IC2_RATIO);
    }

    @Annotations.VersionSpecific(version="[1.7.10]")
    @Annotations.RuntimeInterface(clazz="ic2.api.item.ISpecialElectricItem", modID="IC2")
    public double getTransferLimit(ItemStack itemStack) {
        return this.transferMax * EnergyConfigHandler.TO_IC2_RATIO;
    }

    @Annotations.VersionSpecific(version="[1.7.2]")
    @Annotations.RuntimeInterface(clazz="ic2.api.item.ISpecialElectricItem", modID="IC2")
    public int getTransferLimitB(ItemStack itemStack) {
        return (int)(this.transferMax * EnergyConfigHandler.TO_IC2_RATIO);
    }

    @Annotations.RuntimeInterface(clazz="cofh.api.energy.IEnergyContainerItem", modID="")
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        return (int)(this.recharge(container, (float)maxReceive * EnergyConfigHandler.RF_RATIO, !simulate) / EnergyConfigHandler.RF_RATIO);
    }

    @Annotations.RuntimeInterface(clazz="cofh.api.energy.IEnergyContainerItem", modID="")
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        return (int)(this.discharge(container, (float)maxExtract / EnergyConfigHandler.TO_RF_RATIO, !simulate) * EnergyConfigHandler.TO_RF_RATIO);
    }

    @Annotations.RuntimeInterface(clazz="cofh.api.energy.IEnergyContainerItem", modID="")
    public int getEnergyStored(ItemStack container) {
        return (int)(this.getElectricityStored(container) * EnergyConfigHandler.TO_RF_RATIO);
    }

    @Annotations.RuntimeInterface(clazz="cofh.api.energy.IEnergyContainerItem", modID="")
    public int getMaxEnergyStored(ItemStack container) {
        return (int)(this.getMaxElectricityStored(container) * EnergyConfigHandler.TO_RF_RATIO);
    }
}

