/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.core.init;

import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Moon;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.galaxies.Satellite;
import micdoodle8.mods.galacticraft.api.galaxies.SolarSystem;
import micdoodle8.mods.galacticraft.api.galaxies.Star;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IAtmosphericGas;
import micdoodle8.mods.galacticraft.api.world.ITeleportType;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.planets.mars.MarsModule;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldProvider;
import stevekung.mods.moreplanets.asteroids.darkasteroids.dimension.TeleportTypeDarkAsteroids;
import stevekung.mods.moreplanets.asteroids.darkasteroids.dimension.WorldProviderDarkAsteroids;
import stevekung.mods.moreplanets.core.MorePlanetsCore;
import stevekung.mods.moreplanets.core.config.ConfigManagerMP;
import stevekung.mods.moreplanets.core.dimension.TeleportTypeMP;
import stevekung.mods.moreplanets.core.dimension.TeleportTypeOrbitMP;
import stevekung.mods.moreplanets.core.spacestation.jupiter.WorldProviderJupiterOrbit;
import stevekung.mods.moreplanets.core.spacestation.mars.WorldProviderMarsOrbit;
import stevekung.mods.moreplanets.core.world.WorldProviderNull;
import stevekung.mods.moreplanets.moons.deimos.dimension.WorldProviderDeimos;
import stevekung.mods.moreplanets.moons.koentus.dimension.WorldProviderKoentus;
import stevekung.mods.moreplanets.moons.phobos.dimension.WorldProviderPhobos;
import stevekung.mods.moreplanets.planets.diona.dimension.WorldProviderDiona;
import stevekung.mods.moreplanets.planets.fronos.dimension.WorldProviderFronos;
import stevekung.mods.moreplanets.planets.kapteynb.dimension.WorldProviderKapteynB;
import stevekung.mods.moreplanets.planets.mercury.dimension.WorldProviderMercury;
import stevekung.mods.moreplanets.planets.nibiru.dimension.WorldProviderNibiru;
import stevekung.mods.moreplanets.planets.pluto.dimension.WorldProviderPluto;
import stevekung.mods.moreplanets.planets.polongnius.dimension.WorldProviderPolongnius;
import stevekung.mods.moreplanets.planets.siriusb.dimension.WorldProviderSiriusB;
import stevekung.mods.moreplanets.planets.venus.dimension.WorldProviderVenus;

public class MPPlanets {
    public static void init() {
        TeleportTypeMP teleport = new TeleportTypeMP();
        MorePlanetsCore.siriusSolarSystem = new SolarSystem("sirius", "milkyWay").setMapPosition(new Vector3(1.25, 1.5, 0.0));
        MorePlanetsCore.sirius = MPPlanets.createStar("sirius", MorePlanetsCore.siriusSolarSystem, new ResourceLocation("mpcore:textures/gui/celestialbodies/sirius_celestial.png"));
        MorePlanetsCore.siriusSolarSystem.setMainStar(MorePlanetsCore.sirius);
        MorePlanetsCore.kapteynBSolarSystem = new SolarSystem("kapteyn", "milkyWay").setMapPosition(new Vector3(2.0, (double)1.8f, 0.0));
        MorePlanetsCore.kapteyn = MPPlanets.createStar("kapteyn", MorePlanetsCore.kapteynBSolarSystem, new ResourceLocation("kapteynb:textures/gui/celestialbodies/kapteyn_star_celestial.png"));
        MorePlanetsCore.kapteynBSolarSystem.setMainStar(MorePlanetsCore.kapteyn);
        MorePlanetsCore.darkSolarSystem = new SolarSystem("dark", "milkyWay").setMapPosition(new Vector3(-3.5, (double)2.2f, 0.0));
        MorePlanetsCore.darkStar = MPPlanets.createStar("dark", MorePlanetsCore.darkSolarSystem, new ResourceLocation("mpcore:textures/gui/celestialbodies/dark_star_celestial.png"));
        MorePlanetsCore.darkSolarSystem.setMainStar(MorePlanetsCore.darkStar);
        MorePlanetsCore.diona = MPPlanets.createPlanet("diona", MorePlanetsCore.siriusSolarSystem, 8.7446f, 5.0f, 13.7685f, 0.876f, 4, new ResourceLocation("diona:textures/gui/celestialbodies/diona.png"));
        MorePlanetsCore.diona.setDimensionInfo(ConfigManagerMP.idDimensionDiona, WorldProviderDiona.class);
        MorePlanetsCore.diona.atmosphereComponent(IAtmosphericGas.CO2);
        MorePlanetsCore.polongnius = MPPlanets.createPlanet("polongnius", MorePlanetsCore.siriusSolarSystem, 12.2478f, 4.25f, 76.4168f, 1.465f, 5, new ResourceLocation("polongnius:textures/gui/celestialbodies/polongnius.png"));
        MorePlanetsCore.polongnius.setDimensionInfo(ConfigManagerMP.idDimensionPolongnius, WorldProviderPolongnius.class);
        MorePlanetsCore.polongnius.atmosphereComponent(IAtmosphericGas.CO2).atmosphereComponent(IAtmosphericGas.ARGON);
        MorePlanetsCore.nibiru = MPPlanets.createPlanet("nibiru", MorePlanetsCore.siriusSolarSystem, 52.4341f, 3.75f, 71.6582f, 4.678f, 6, new ResourceLocation("nibiru:textures/gui/celestialbodies/nibiru.png"));
        MorePlanetsCore.nibiru.setDimensionInfo(ConfigManagerMP.idDimensionNibiru, WorldProviderNibiru.class);
        MorePlanetsCore.nibiru.atmosphereComponent(IAtmosphericGas.CO2).atmosphereComponent(IAtmosphericGas.ARGON).atmosphereComponent(IAtmosphericGas.HELIUM);
        MorePlanetsCore.fronos = MPPlanets.createPlanet("fronos", MorePlanetsCore.siriusSolarSystem, 1.2762f, 2.5f, 20.0f, 0.5316f, 7, new ResourceLocation("fronos:textures/gui/celestialbodies/fronos.png"));
        MorePlanetsCore.fronos.setDimensionInfo(ConfigManagerMP.idDimensionFronos, WorldProviderFronos.class);
        MorePlanetsCore.fronos.atmosphereComponent(IAtmosphericGas.OXYGEN).atmosphereComponent(IAtmosphericGas.WATER).atmosphereComponent(IAtmosphericGas.NITROGEN).atmosphereComponent(IAtmosphericGas.HYDROGEN);
        MorePlanetsCore.kapteynB = MPPlanets.createPlanet("kapteynB", MorePlanetsCore.kapteynBSolarSystem, 0.5f, 1.0f, 1.9746f, 3.7654f, 7, new ResourceLocation("kapteynb:textures/gui/celestialbodies/kapteyn_b.png"));
        MorePlanetsCore.kapteynB.setDimensionInfo(ConfigManagerMP.idDimensionKapteynB, WorldProviderKapteynB.class);
        MorePlanetsCore.kapteynB.atmosphereComponent(IAtmosphericGas.NITROGEN).atmosphereComponent(IAtmosphericGas.WATER).atmosphereComponent(IAtmosphericGas.HELIUM).atmosphereComponent(IAtmosphericGas.HYDROGEN);
        MorePlanetsCore.siriusB = MPPlanets.createPlanet("siriusB", MorePlanetsCore.siriusSolarSystem, 0.0f, 0.225f, Float.MAX_VALUE, 0.125f, 8, new ResourceLocation("siriusb:textures/gui/celestialbodies/sirius_b.png"));
        MorePlanetsCore.siriusB.setDimensionInfo(ConfigManagerMP.idDimensionSiriusB, WorldProviderSiriusB.class);
        MorePlanetsCore.siriusB.atmosphereComponent(IAtmosphericGas.CO2).atmosphereComponent(IAtmosphericGas.HELIUM);
        if (ConfigManagerMP.enableMercuryPlanet) {
            MorePlanetsCore.mercury = MPPlanets.createPlanet("mercury", GalacticraftCore.solarSystemSol, 1.45f, 0.5f, 0.24096386f, 0.5319f, 4, new ResourceLocation("galacticraftcore:textures/gui/celestialbodies/mercury.png"));
            MorePlanetsCore.mercury.setDimensionInfo(ConfigManagerMP.idDimensionMercury, WorldProviderMercury.class);
            MorePlanetsCore.mercury.atmosphereComponent(IAtmosphericGas.HELIUM).atmosphereComponent(IAtmosphericGas.HYDROGEN).atmosphereComponent(IAtmosphericGas.OXYGEN);
        }
        if (ConfigManagerMP.enableVenusPlanet) {
            MorePlanetsCore.venus = MPPlanets.createPlanet("venus", GalacticraftCore.solarSystemSol, 2.0f, 0.75f, 0.6152793f, 0.0f, 3, new ResourceLocation("galacticraftcore:textures/gui/celestialbodies/venus.png"));
            MorePlanetsCore.venus.setDimensionInfo(ConfigManagerMP.idDimensionVenus, WorldProviderVenus.class);
            MorePlanetsCore.venus.atmosphereComponent(IAtmosphericGas.CO2).atmosphereComponent(IAtmosphericGas.NITROGEN).atmosphereComponent(IAtmosphericGas.ARGON);
        }
        if (ConfigManagerMP.enableJupiterPlanet) {
            MorePlanetsCore.jupiter = MPPlanets.createPlanet("jupiter", GalacticraftCore.solarSystemSol, 2.3f, 1.5f, 11.861994f, 0.5319f, 1, new ResourceLocation("galacticraftcore:textures/gui/celestialbodies/jupiter.png"));
            WorldProviderNull.setName("Jupiter");
            MorePlanetsCore.jupiter.setDimensionInfo(ConfigManagerMP.idDimensionJupiter, WorldProviderPluto.class);
            MorePlanetsCore.jupiter.setBodyIcon(new ResourceLocation("galacticraftcore:textures/gui/celestialbodies/jupiter.png"));
        }
        if (ConfigManagerMP.enablePlutoPlanet) {
            MorePlanetsCore.pluto = MPPlanets.createPlanet("pluto", GalacticraftCore.solarSystemSol, 2.0f, 2.5f, 194.84119f, 0.0f, 5, new ResourceLocation("pluto:textures/gui/celestialbodies/pluto.png"));
            MorePlanetsCore.pluto.setDimensionInfo(ConfigManagerMP.idDimensionPluto, WorldProviderPluto.class);
            MorePlanetsCore.pluto.atmosphereComponent(IAtmosphericGas.CO2).atmosphereComponent(IAtmosphericGas.HELIUM).atmosphereComponent(IAtmosphericGas.NITROGEN);
        }
        MorePlanetsCore.darkAsteroids = MPPlanets.createPlanet("darkAsteroids", MorePlanetsCore.darkSolarSystem, (float)(Math.random() * (Math.PI * 2)), 1.375f, 45.0f, 0.0f, 5, new ResourceLocation("mpcore:textures/gui/celestialbodies/dark_asteroids.png"));
        MorePlanetsCore.darkAsteroids.setDimensionInfo(ConfigManagerMP.idDimensionDarkAsteroids, WorldProviderDarkAsteroids.class);
        MorePlanetsCore.koentus = MPPlanets.createMoon("koentus", MorePlanetsCore.diona, 2.436f, 9.5f, 100.0f, 0.3867f, 4, new ResourceLocation("koentus:textures/gui/celestialbodies/koentus.png"));
        MorePlanetsCore.koentus.setDimensionInfo(ConfigManagerMP.idDimensionKoentus, WorldProviderKoentus.class);
        MorePlanetsCore.koentus.atmosphereComponent(IAtmosphericGas.HYDROGEN).atmosphereComponent(IAtmosphericGas.NITROGEN).atmosphereComponent(IAtmosphericGas.HELIUM);
        if (ConfigManagerMP.enablePhobosMoon) {
            MorePlanetsCore.phobos = MPPlanets.createMoon("phobos", MarsModule.planetMars, 4.25f, 10.0f, 100.0f, 0.3867f, 2, new ResourceLocation("phobos:textures/gui/celestialbodies/phobos.png"));
            MorePlanetsCore.phobos.setDimensionInfo(ConfigManagerMP.idDimensionPhobos, WorldProviderPhobos.class);
        }
        if (ConfigManagerMP.enableDeimosMoon) {
            MorePlanetsCore.deimos = MPPlanets.createMoon("deimos", MarsModule.planetMars, 2.25f, 15.0f, 100.0f, 0.3867f, 2, new ResourceLocation("deimos:textures/gui/celestialbodies/deimos.png"));
            MorePlanetsCore.deimos.setDimensionInfo(ConfigManagerMP.idDimensionDeimos, WorldProviderDeimos.class);
        }
        if (ConfigManagerMP.enableJupiterSpaceStation) {
            MorePlanetsCore.jupiterSpaceStation = MPPlanets.createSatellite("jupiterMP", MorePlanetsCore.jupiter, 0.25f, 25.0f, 20.0f, 0.2667f, 4, new ResourceLocation("galacticraftcore:textures/gui/celestialbodies/spaceStation.png"));
            MorePlanetsCore.jupiterSpaceStation.setDimensionInfo(ConfigManagerMP.idDimensionJupiterSpaceStation, ConfigManagerMP.idDimensionStaticJupiterSpaceStation, WorldProviderJupiterOrbit.class);
        }
        if (ConfigManagerMP.enableMarsSpaceStation) {
            MorePlanetsCore.marsSpaceStation = MPPlanets.createSatellite("marsMP", MarsModule.planetMars, 0.25f, 12.5f, 20.0f, 0.2667f, 2, new ResourceLocation("galacticraftcore:textures/gui/celestialbodies/spaceStation.png"));
            MorePlanetsCore.marsSpaceStation.setDimensionInfo(ConfigManagerMP.idDimensionMarsSpaceStation, ConfigManagerMP.idDimensionStaticMarsSpaceStation, WorldProviderMarsOrbit.class);
        }
        GalaxyRegistry.registerSolarSystem((SolarSystem)MorePlanetsCore.siriusSolarSystem);
        GalaxyRegistry.registerSolarSystem((SolarSystem)MorePlanetsCore.kapteynBSolarSystem);
        GalaxyRegistry.registerSolarSystem((SolarSystem)MorePlanetsCore.darkSolarSystem);
        GalaxyRegistry.registerPlanet((Planet)MorePlanetsCore.diona);
        GalaxyRegistry.registerPlanet((Planet)MorePlanetsCore.polongnius);
        GalaxyRegistry.registerPlanet((Planet)MorePlanetsCore.nibiru);
        GalaxyRegistry.registerPlanet((Planet)MorePlanetsCore.fronos);
        GalaxyRegistry.registerPlanet((Planet)MorePlanetsCore.kapteynB);
        GalaxyRegistry.registerPlanet((Planet)MorePlanetsCore.siriusB);
        GalaxyRegistry.registerPlanet((Planet)MorePlanetsCore.darkAsteroids);
        GalaxyRegistry.registerMoon((Moon)MorePlanetsCore.koentus);
        if (ConfigManagerMP.enableJupiterSpaceStation) {
            GalaxyRegistry.registerSatellite((Satellite)MorePlanetsCore.jupiterSpaceStation);
        }
        if (ConfigManagerMP.enableMarsSpaceStation) {
            GalaxyRegistry.registerSatellite((Satellite)MorePlanetsCore.marsSpaceStation);
        }
        if (ConfigManagerMP.enableMercuryPlanet) {
            GalaxyRegistry.registerPlanet((Planet)MorePlanetsCore.mercury);
        }
        if (ConfigManagerMP.enableVenusPlanet) {
            GalaxyRegistry.registerPlanet((Planet)MorePlanetsCore.venus);
        }
        if (ConfigManagerMP.enablePlutoPlanet) {
            GalaxyRegistry.registerPlanet((Planet)MorePlanetsCore.pluto);
        }
        if (ConfigManagerMP.enableJupiterPlanet) {
            GalaxyRegistry.registerPlanet((Planet)MorePlanetsCore.jupiter);
        }
        if (ConfigManagerMP.enablePhobosMoon) {
            GalaxyRegistry.registerMoon((Moon)MorePlanetsCore.deimos);
        }
        if (ConfigManagerMP.enableDeimosMoon) {
            GalaxyRegistry.registerMoon((Moon)MorePlanetsCore.phobos);
        }
        if (ConfigManagerMP.enableJupiterSpaceStation) {
            MPPlanets.registerProvider(ConfigManagerMP.idDimensionJupiterSpaceStation, ConfigManagerMP.idDimensionStaticJupiterSpaceStation, WorldProviderJupiterOrbit.class);
        }
        if (ConfigManagerMP.enableMarsSpaceStation) {
            MPPlanets.registerProvider(ConfigManagerMP.idDimensionMarsSpaceStation, ConfigManagerMP.idDimensionStaticMarsSpaceStation, WorldProviderMarsOrbit.class);
        }
        GalacticraftRegistry.registerTeleportType(WorldProviderDiona.class, (ITeleportType)teleport);
        GalacticraftRegistry.registerTeleportType(WorldProviderPolongnius.class, (ITeleportType)teleport);
        GalacticraftRegistry.registerTeleportType(WorldProviderNibiru.class, (ITeleportType)teleport);
        GalacticraftRegistry.registerTeleportType(WorldProviderKoentus.class, (ITeleportType)teleport);
        GalacticraftRegistry.registerTeleportType(WorldProviderFronos.class, (ITeleportType)teleport);
        GalacticraftRegistry.registerTeleportType(WorldProviderKapteynB.class, (ITeleportType)teleport);
        GalacticraftRegistry.registerTeleportType(WorldProviderSiriusB.class, (ITeleportType)teleport);
        GalacticraftRegistry.registerTeleportType(WorldProviderMercury.class, (ITeleportType)teleport);
        GalacticraftRegistry.registerTeleportType(WorldProviderVenus.class, (ITeleportType)teleport);
        GalacticraftRegistry.registerTeleportType(WorldProviderPluto.class, (ITeleportType)teleport);
        GalacticraftRegistry.registerTeleportType(WorldProviderDeimos.class, (ITeleportType)teleport);
        GalacticraftRegistry.registerTeleportType(WorldProviderPhobos.class, (ITeleportType)teleport);
        GalacticraftRegistry.registerTeleportType(WorldProviderJupiterOrbit.class, (ITeleportType)new TeleportTypeOrbitMP());
        GalacticraftRegistry.registerTeleportType(WorldProviderMarsOrbit.class, (ITeleportType)new TeleportTypeOrbitMP());
        GalacticraftRegistry.registerTeleportType(WorldProviderDarkAsteroids.class, (ITeleportType)new TeleportTypeDarkAsteroids());
        GalacticraftRegistry.registerRocketGui(WorldProviderDiona.class, (ResourceLocation)new ResourceLocation("diona:textures/gui/diona_rocket_gui.png"));
        GalacticraftRegistry.registerRocketGui(WorldProviderPolongnius.class, (ResourceLocation)new ResourceLocation("polongnius:textures/gui/polongnius_rocket_gui.png"));
        GalacticraftRegistry.registerRocketGui(WorldProviderNibiru.class, (ResourceLocation)new ResourceLocation("nibiru:textures/gui/nibiru_rocket_gui.png"));
        GalacticraftRegistry.registerRocketGui(WorldProviderKoentus.class, (ResourceLocation)new ResourceLocation("koentus:textures/gui/koentus_rocket_gui.png"));
        GalacticraftRegistry.registerRocketGui(WorldProviderFronos.class, (ResourceLocation)new ResourceLocation("fronos:textures/gui/fronos_rocket_gui.png"));
        GalacticraftRegistry.registerRocketGui(WorldProviderKapteynB.class, (ResourceLocation)new ResourceLocation("kapteynb:textures/gui/kapteyn_b_rocket_gui.png"));
        GalacticraftRegistry.registerRocketGui(WorldProviderSiriusB.class, (ResourceLocation)new ResourceLocation("siriusb:textures/gui/sirius_b_rocket_gui.png"));
        GalacticraftRegistry.registerRocketGui(WorldProviderMercury.class, (ResourceLocation)new ResourceLocation("mercury:textures/gui/mercury_rocket_gui.png"));
        GalacticraftRegistry.registerRocketGui(WorldProviderVenus.class, (ResourceLocation)new ResourceLocation("venus:textures/gui/venus_rocket_gui.png"));
        GalacticraftRegistry.registerRocketGui(WorldProviderPluto.class, (ResourceLocation)new ResourceLocation("pluto:textures/gui/pluto_rocket_gui.png"));
        GalacticraftRegistry.registerRocketGui(WorldProviderDeimos.class, (ResourceLocation)new ResourceLocation("deimos:textures/gui/deimos_rocket_gui.png"));
        GalacticraftRegistry.registerRocketGui(WorldProviderPhobos.class, (ResourceLocation)new ResourceLocation("phobos:textures/gui/phobos_rocket_gui.png"));
    }

    public static Planet createPlanet(String name, SolarSystem solar, float phaseShift, float distance, float orbitTime, float size, int tier, ResourceLocation resource) {
        Planet planet = new Planet(name).setParentSolarSystem(solar);
        planet.setPhaseShift(phaseShift);
        planet.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(distance, distance));
        planet.setRelativeOrbitTime(orbitTime);
        planet.setRelativeSize(size);
        planet.setTierRequired(tier);
        planet.setBodyIcon(resource);
        return planet;
    }

    public static Moon createMoon(String name, Planet planet, float phaseShift, float distance, float orbitTime, float size, int tier, ResourceLocation resource) {
        Moon moon = new Moon(name).setParentPlanet(planet);
        moon.setPhaseShift(phaseShift);
        moon.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(distance, distance));
        moon.setRelativeOrbitTime(orbitTime);
        moon.setRelativeSize(size);
        moon.setTierRequired(tier);
        moon.setBodyIcon(resource);
        return moon;
    }

    public static Satellite createSatellite(String name, Planet planet, float phaseShift, float distance, float orbitTime, float size, int tier, ResourceLocation resource) {
        Satellite satellite = new Satellite(name).setParentBody(planet);
        satellite.setPhaseShift(phaseShift);
        satellite.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(distance, distance));
        satellite.setRelativeOrbitTime(orbitTime);
        satellite.setRelativeSize(size);
        satellite.setTierRequired(tier);
        satellite.setBodyIcon(resource);
        return satellite;
    }

    public static Star createStar(String name, SolarSystem solar, ResourceLocation resource) {
        Star star = new Star(name).setParentSolarSystem(solar);
        star.setTierRequired(-1);
        star.setBodyIcon(resource);
        return star;
    }

    public static void registerProvider(int id, int staticId, Class<? extends WorldProvider> provider) {
        GalacticraftRegistry.registerProvider((int)id, provider, (boolean)false, (int)0);
        GalacticraftRegistry.registerProvider((int)staticId, provider, (boolean)true, (int)0);
    }
}

