/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.core.event;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.event.client.CelestialBodyRenderEvent;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.Moon;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.inventory.AccessInventoryGC;
import micdoodle8.mods.galacticraft.api.inventory.IInventoryGC;
import micdoodle8.mods.galacticraft.api.recipe.SchematicEvent;
import micdoodle8.mods.galacticraft.api.recipe.SchematicRegistry;
import micdoodle8.mods.galacticraft.core.client.gui.screen.GuiCelestialSelection;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedCreeper;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSkeleton;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSpider;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedZombie;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerHandler;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.util.OxygenUtil;
import micdoodle8.mods.galacticraft.planets.asteroids.items.AsteroidsItems;
import micdoodle8.mods.galacticraft.planets.mars.dimension.WorldProviderMars;
import net.minecraft.block.Block;
import net.minecraft.block.BlockColored;
import net.minecraft.block.BlockSapling;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.common.IExtendedEntityProperties;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.ZombieEvent;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import org.lwjgl.Sys;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector3f;
import stevekung.mods.moreplanets.asteroids.darkasteroids.blocks.DarkAsteroidsBlocks;
import stevekung.mods.moreplanets.asteroids.darkasteroids.dimension.WorldProviderDarkAsteroids;
import stevekung.mods.moreplanets.asteroids.darkasteroids.entities.EntityDarkAsteroid;
import stevekung.mods.moreplanets.core.MorePlanetsCore;
import stevekung.mods.moreplanets.core.achievement.AchievementsMP;
import stevekung.mods.moreplanets.core.config.ConfigManagerMP;
import stevekung.mods.moreplanets.core.entities.EntityEvolvedWitch;
import stevekung.mods.moreplanets.core.entities.IEntityLivingPlanet;
import stevekung.mods.moreplanets.core.init.MPItems;
import stevekung.mods.moreplanets.core.init.MPPotions;
import stevekung.mods.moreplanets.core.player.MPPlayerStats;
import stevekung.mods.moreplanets.core.todo.PacketUpdateJetpack;
import stevekung.mods.moreplanets.core.util.MPLog;
import stevekung.mods.moreplanets.core.world.ILightningStorm;
import stevekung.mods.moreplanets.core.world.IMeteorType;
import stevekung.mods.moreplanets.moons.europa.blocks.EuropaBlocks;
import stevekung.mods.moreplanets.moons.europa.items.EuropaItems;
import stevekung.mods.moreplanets.moons.io.blocks.IoBlocks;
import stevekung.mods.moreplanets.moons.io.items.IoItems;
import stevekung.mods.moreplanets.moons.koentus.blocks.KoentusBlocks;
import stevekung.mods.moreplanets.moons.koentus.dimension.WorldProviderKoentus;
import stevekung.mods.moreplanets.moons.koentus.entities.EntityKoentusMeteor;
import stevekung.mods.moreplanets.planets.diona.blocks.DionaBlocks;
import stevekung.mods.moreplanets.planets.diona.entities.EntityEvolvedEnderman;
import stevekung.mods.moreplanets.planets.diona.items.DionaItems;
import stevekung.mods.moreplanets.planets.diona.items.tools.DionaToolsItems;
import stevekung.mods.moreplanets.planets.fronos.blocks.FronosBlocks;
import stevekung.mods.moreplanets.planets.fronos.entities.EntityGrappy;
import stevekung.mods.moreplanets.planets.fronos.items.FronosItems;
import stevekung.mods.moreplanets.planets.fronos.items.ItemCandyBow;
import stevekung.mods.moreplanets.planets.fronos.items.tools.FronosToolsItems;
import stevekung.mods.moreplanets.planets.kapteynb.blocks.KapteynBBlocks;
import stevekung.mods.moreplanets.planets.kapteynb.entities.EntityIceCrystalMeteor;
import stevekung.mods.moreplanets.planets.kapteynb.items.KapteynBItems;
import stevekung.mods.moreplanets.planets.kapteynb.items.armor.KapteynBArmorItems;
import stevekung.mods.moreplanets.planets.mercury.blocks.MercuryBlocks;
import stevekung.mods.moreplanets.planets.mercury.items.MercuryItems;
import stevekung.mods.moreplanets.planets.nibiru.blocks.NibiruBlocks;
import stevekung.mods.moreplanets.planets.nibiru.dimension.WorldProviderNibiru;
import stevekung.mods.moreplanets.planets.nibiru.entities.EntityInfectedZombie;
import stevekung.mods.moreplanets.planets.pluto.blocks.PlutoBlocks;
import stevekung.mods.moreplanets.planets.pluto.dimension.WorldProviderPluto;
import stevekung.mods.moreplanets.planets.pluto.items.PlutoItems;
import stevekung.mods.moreplanets.planets.polongnius.blocks.PolongniusBlocks;
import stevekung.mods.moreplanets.planets.polongnius.entities.EntityPolongniusMeteor;
import stevekung.mods.moreplanets.planets.polongnius.items.PolongniusItems;
import stevekung.mods.moreplanets.planets.siriusb.blocks.SiriusBBlocks;
import stevekung.mods.moreplanets.planets.siriusb.dimension.WorldProviderSiriusB;
import stevekung.mods.moreplanets.planets.siriusb.items.SiriusBItems;
import stevekung.mods.moreplanets.planets.venus.items.ItemJetpack;
import stevekung.mods.moreplanets.planets.venus.items.VenusItems;

public class MorePlanetEvents {
    @SubscribeEvent
    public void onSchematicUnlocked(SchematicEvent.Unlock event) {
        GCPlayerStats stats = GCPlayerStats.get((EntityPlayerMP)event.player);
        if (stats.unlockedSchematics.contains(SchematicRegistry.getMatchingRecipeForID((int)ConfigManagerMP.idSchematicTier4RocketNoFlag))) {
            event.player.func_71029_a((StatBase)AchievementsMP.getTier4Schematic);
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent event) {
        if (event.modID.equals("MorePlanet")) {
            ConfigManagerMP.syncConfig(false);
        }
    }

    @SubscribeEvent
    public void onEntityConstructing(EntityEvent.EntityConstructing event) {
        if (event.entity instanceof EntityPlayerMP && MPPlayerStats.get((EntityPlayerMP)event.entity) == null) {
            ((EntityPlayerMP)event.entity).registerExtendedProperties(MPPlayerStats.MP_PLAYER_PROPERTY, (IExtendedEntityProperties)new MPPlayerStats());
        }
    }

    @SubscribeEvent
    public void onZombieSummonAid(ZombieEvent.SummonAidEvent event) {
        if (event.entity instanceof EntityInfectedZombie) {
            event.customSummonedAid = new EntityInfectedZombie(event.world);
            if ((double)((EntityLivingBase)event.entity).func_70681_au().nextFloat() < ((EntityInfectedZombie)event.entity).func_110148_a(((EntityInfectedZombie)event.entity).getReinforcementsAttribute()).func_111126_e()) {
                event.setResult(Event.Result.ALLOW);
            }
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onThermalArmorEvent(GCPlayerHandler.ThermalArmorEvent event) {
        if (event.armorStack == null) {
            event.setArmorAddResult(GCPlayerHandler.ThermalArmorEvent.ArmorAddResult.REMOVE);
            return;
        }
        if (event.armorStack.func_77973_b() == AsteroidsItems.thermalPadding && event.armorStack.func_77960_j() == event.armorIndex) {
            event.setArmorAddResult(GCPlayerHandler.ThermalArmorEvent.ArmorAddResult.ADD);
            return;
        }
        if (event.armorStack.func_77973_b() == MPItems.tier_2_thermal_padding && event.armorStack.func_77960_j() == event.armorIndex) {
            event.setArmorAddResult(GCPlayerHandler.ThermalArmorEvent.ArmorAddResult.ADD);
            return;
        }
        if (event.armorStack.func_77973_b() == MPItems.tier_3_thermal_padding && event.armorStack.func_77960_j() == event.armorIndex) {
            event.setArmorAddResult(GCPlayerHandler.ThermalArmorEvent.ArmorAddResult.ADD);
            return;
        }
        event.setArmorAddResult(GCPlayerHandler.ThermalArmorEvent.ArmorAddResult.NOTHING);
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        if (event.entityLiving.func_70644_a(MPPotions.icy_poison) && event.entityLiving.field_70170_p.func_147437_c((int)event.entityLiving.field_70165_t, (int)event.entityLiving.field_70163_u, (int)event.entityLiving.field_70161_v) && KapteynBBlocks.icy_poison_crystal.func_149742_c(event.entityLiving.field_70170_p, (int)event.entityLiving.field_70165_t, (int)event.entityLiving.field_70163_u, (int)event.entityLiving.field_70161_v) && event.entityLiving.field_70170_p.field_73012_v.nextInt(50) == 0) {
            event.entityLiving.field_70170_p.func_147449_b((int)event.entityLiving.field_70165_t, (int)event.entityLiving.field_70163_u, (int)event.entityLiving.field_70161_v, KapteynBBlocks.icy_poison_crystal);
        }
    }

    @SubscribeEvent
    public void onLivingJump(LivingEvent.LivingJumpEvent event) {
        if (event.entityLiving.func_70644_a(MPPotions.electro_magnetic_pulse)) {
            event.entityLiving.field_70181_x -= 1.0;
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onBodyRender(CelestialBodyRenderEvent.Pre renderEvent) {
        if (renderEvent.celestialBody == MorePlanetsCore.darkAsteroids) {
            GL11.glRotatef((float)((float)Sys.getTime() / 10.0f % 360.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onRingRender(CelestialBodyRenderEvent.CelestialRingRenderEvent.Pre event) {
        if (event.celestialBody == MorePlanetsCore.darkAsteroids) {
            this.renderRing(event, event.celestialBody, 0.1f, 0.1f, 0.1f, 1.0f, 0.5f);
        } else if (event.celestialBody == MorePlanetsCore.siriusB) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onClientTick(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        WorldClient world = mc.field_71441_e;
        EntityClientPlayerMP player = mc.field_71439_g;
        if (event.phase == TickEvent.Phase.START && player != null && world != null && player.field_71071_by.func_70440_f(2) != null && player.field_71071_by.func_70440_f(2).func_77973_b() == VenusItems.jetpack) {
            ItemJetpack jetpack = (ItemJetpack)player.field_71071_by.func_70440_f(2).func_77973_b();
            ItemStack itemStack = player.field_71071_by.func_70440_f(2);
            boolean flag = player.field_71075_bZ.field_75098_d;
            if (!flag && jetpack.getElectricityStored(itemStack) != 0.0f) {
                boolean pressed = false;
                float power = 0.0f;
                if (mc.field_71474_y.field_74314_A.func_151470_d()) {
                    jetpack.setJetpackKeyDown(true);
                    player.field_70181_x = 0.5;
                    world.func_72869_a("largesmoke", player.field_70165_t, player.field_70163_u - 1.0, player.field_70161_v, 0.0, -1.0, 0.0);
                    power = 1000.0f;
                    pressed = true;
                } else if (!mc.field_71474_y.field_74314_A.func_151470_d()) {
                    jetpack.setJetpackKeyDown(false);
                }
                if (!player.field_70122_E) {
                    if (mc.field_71474_y.field_74311_E.func_151470_d()) {
                        player.field_70181_x *= 0.85;
                        world.func_72869_a("largesmoke", player.field_70165_t, player.field_70163_u - 1.0, player.field_70161_v, 0.0, -2.0, 0.0);
                        jetpack.setJetpackKeySneak(true);
                        pressed = true;
                        power = 500.0f;
                    } else if (!mc.field_71474_y.field_74311_E.func_151470_d()) {
                        jetpack.setJetpackKeySneak(false);
                    }
                } else {
                    jetpack.setJetpackKeySneak(false);
                }
                if (pressed) {
                    MorePlanetsCore.packetPipeline.sendToServer(new PacketUpdateJetpack(power));
                }
            }
            if (flag) {
                if (mc.field_71474_y.field_74314_A.func_151470_d()) {
                    player.field_70181_x = 0.5;
                    world.func_72869_a("largesmoke", player.field_70165_t, player.field_70163_u - 1.0, player.field_70161_v, 0.0, -1.0, 0.0);
                }
                if (!player.field_70122_E && mc.field_71474_y.field_74311_E.func_151470_d()) {
                    player.field_70181_x *= 0.85;
                    world.func_72869_a("largesmoke", player.field_70165_t, player.field_70163_u - 1.0, player.field_70161_v, 0.0, -2.0, 0.0);
                }
            }
        }
    }

    @SubscribeEvent
    public void onLivingFall(LivingFallEvent event) {
        World world = event.entityLiving.field_70170_p;
        if (event.entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entityLiving;
            if (player.field_71071_by.field_70460_b[2] != null && player.field_71071_by.field_70460_b[2].func_77973_b() == VenusItems.jetpack) {
                event.distance = 0.0f;
                event.setCanceled(true);
                return;
            }
            if (player.field_71071_by.field_70460_b[0] != null && player.field_71071_by.field_70460_b[0].func_77973_b() == PlutoItems.gravity_boots) {
                if (world.field_73011_w instanceof WorldProviderKoentus || world.field_73011_w instanceof WorldProviderPluto) {
                    event.distance *= 0.1f;
                } else if (world.field_73011_w instanceof WorldProviderSiriusB) {
                    event.distance *= 0.45f;
                }
                event.distance *= 0.4f;
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onFOVUpdate(FOVUpdateEvent event) {
        if (event.entity.func_71039_bw() && event.entity.func_71011_bu().func_77973_b() instanceof ItemCandyBow) {
            int i = event.entity.func_71057_bx();
            float f = (float)i / 20.0f;
            f = f > 1.0f ? 1.0f : (f *= f);
            event.newfov *= 1.0f - f * 0.15f;
        }
    }

    @SubscribeEvent
    public void onRenderPlanet(CelestialBodyRenderEvent.Post event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71462_r instanceof GuiCelestialSelection && event.celestialBody == MorePlanetsCore.polongnius) {
            mc.field_71446_o.func_110577_a(new ResourceLocation("polongnius:textures/gui/celestialbodies/polongnius_ring.png"));
            float size = (float)GuiCelestialSelection.getWidthForCelestialBodyStatic((CelestialBody)event.celestialBody) / 6.0f;
            ((GuiCelestialSelection)mc.field_71462_r).drawTexturedModalRect(-7.5f * size, -1.75f * size, 15.0f * size, 3.5f * size, 0.0f, 0.0f, 30.0f, 7.0f, false, false, 30.0f, 7.0f);
        }
    }

    @SubscribeEvent
    public void onPickupItem(PlayerEvent.ItemPickupEvent event) {
        ItemStack itemStack = event.pickedUp.func_92059_d();
        Item item = itemStack.func_77973_b();
        Block block = Block.func_149634_a((Item)item);
        int meta = itemStack.func_77960_j();
        if (block == KoentusBlocks.crystal_log || block == NibiruBlocks.nibiru_log || block == FronosBlocks.fronos_log || block == EuropaBlocks.europa_log || block == DarkAsteroidsBlocks.alien_log) {
            event.player.func_71029_a((StatBase)AchievementList.field_76005_g);
        }
        if (item == Item.func_150898_a((Block)DionaBlocks.diona_block) && (meta == 4 || meta == 5)) {
            event.player.func_71029_a((StatBase)AchievementsMP.mineDionaOre);
        }
    }

    @SubscribeEvent
    public void onChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (event.toDim == ConfigManagerMP.idDimensionDiona) {
            event.player.func_71029_a((StatBase)AchievementsMP.reachDiona);
        }
    }

    @SubscribeEvent
    public void onCraftItem(PlayerEvent.ItemCraftedEvent event) {
        Item item = event.crafting.func_77973_b();
        if (item == DionaToolsItems.quontonium_pickaxe || item == DionaToolsItems.fronisium_pickaxe) {
            event.player.func_71029_a((StatBase)AchievementsMP.getSpacePick);
        }
        if (item == DionaItems.laser_gun) {
            event.player.func_71029_a((StatBase)AchievementsMP.laserGun);
        }
        if (item == FronosToolsItems.fronos_rock_pickaxe) {
            event.player.func_71029_a((StatBase)AchievementList.field_76012_o);
        }
    }

    @SubscribeEvent
    public void onUseBonemeal(BonemealEvent event) {
        World world = event.world;
        Random rand = world.field_73012_v;
        int x = event.x;
        int z = event.z;
        this.glowSapling(event, world, NibiruBlocks.nibiru_sapling);
        this.glowSapling(event, world, (Block)KoentusBlocks.crystal_sapling);
        this.glowSapling(event, world, (Block)FronosBlocks.fronos_sapling);
        this.glowSapling(event, world, (Block)DarkAsteroidsBlocks.alien_sapling);
        this.glowTallGrass(event, rand, x, z, FronosBlocks.fronos_grass, FronosBlocks.fronos_tall_grass, 3, 0, true);
        this.glowTallGrass(event, rand, x, z, FronosBlocks.pink_grass, FronosBlocks.fronos_tall_grass, 3, 3, true);
        this.glowTallGrass(event, rand, x, z, FronosBlocks.purple_grass, FronosBlocks.fronos_tall_grass, 3, 6, true);
        this.glowTallGrass(event, rand, x, z, FronosBlocks.plains_grass, FronosBlocks.fronos_tall_grass, 3, 9, true);
        this.glowTallGrass(event, rand, x, z, FronosBlocks.golden_grass, FronosBlocks.fronos_tall_grass, 3, 12, true);
        this.glowTallGrass(event, rand, x, z, FronosBlocks.frosted_cake, FronosBlocks.candy_flower, 8, 0, true);
        if (event.block == FronosBlocks.glass_gem_corn1) {
            int y = event.y;
            if (world.func_147439_a(x, y + 1, z).isAir((IBlockAccess)world, x, y + 1, z) && world.func_147439_a(x, y + 2, z).isAir((IBlockAccess)world, x, y + 2, z)) {
                event.setResult(Event.Result.ALLOW);
                if (!event.world.field_72995_K && rand.nextInt(3) == 0) {
                    event.world.func_147465_d(x, y, z, FronosBlocks.glass_gem_corn1, 1, 2);
                    event.world.func_147465_d(x, y + 1, z, FronosBlocks.glass_gem_corn2, rand.nextInt(3) + 1, 2);
                    event.world.func_147465_d(x, y + 2, z, FronosBlocks.glass_gem_corn3, 0, 2);
                }
            }
        } else if (event.block == FronosBlocks.glass_gem_corn2) {
            int y = event.y;
            if (event.world.func_147439_a(x, y + 1, z).isAir((IBlockAccess)event.world, x, y + 1, z)) {
                event.setResult(Event.Result.ALLOW);
                if (!event.world.field_72995_K && event.block == FronosBlocks.glass_gem_corn2 && event.world.func_72805_g(x, y, z) == 0 && rand.nextInt(2) == 0) {
                    event.world.func_147465_d(x, y, z, FronosBlocks.glass_gem_corn2, 1, 2);
                    event.world.func_147465_d(x, y + 1, z, FronosBlocks.glass_gem_corn3, 0, 2);
                }
            }
            if (event.block == FronosBlocks.glass_gem_corn2 && event.world.func_72805_g(x, y, z) == 1) {
                event.setResult(Event.Result.ALLOW);
                if (!event.world.field_72995_K && rand.nextInt(2) == 0) {
                    event.world.func_147465_d(x, y, z, FronosBlocks.glass_gem_corn2, rand.nextInt(2) + 1, 2);
                }
            }
            if (event.block == FronosBlocks.glass_gem_corn2 && event.world.func_72805_g(x, y, z) == 2) {
                event.setResult(Event.Result.ALLOW);
                if (!event.world.field_72995_K && rand.nextInt(2) == 0) {
                    event.world.func_147465_d(x, y, z, FronosBlocks.glass_gem_corn2, 3, 2);
                }
            }
        } else if (event.block == FronosBlocks.dandelion) {
            int y = event.y;
            if (event.block == FronosBlocks.dandelion && event.world.func_72805_g(x, y, z) == 0) {
                event.setResult(Event.Result.ALLOW);
                if (!event.world.field_72995_K && rand.nextInt(2) == 0) {
                    event.world.func_147465_d(x, y, z, FronosBlocks.dandelion, 3, 2);
                }
            }
            if (event.block == FronosBlocks.dandelion && event.world.func_72805_g(x, y, z) == 1) {
                event.setResult(Event.Result.ALLOW);
                if (!event.world.field_72995_K && rand.nextInt(2) == 0) {
                    event.world.func_147465_d(x, y, z, FronosBlocks.dandelion, 4, 2);
                }
            }
            if (event.block == FronosBlocks.dandelion && event.world.func_72805_g(x, y, z) == 2) {
                event.setResult(Event.Result.ALLOW);
                if (!event.world.field_72995_K && rand.nextInt(2) == 0) {
                    event.world.func_147465_d(x, y, z, FronosBlocks.dandelion, 5, 2);
                }
            }
        }
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase living = event.entityLiving;
        World world = living.field_70170_p;
        if (living instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)living;
            this.spawnFeces(world, player);
            this.spawnDarkAsteroids(world, player);
            this.removeIcyPoison(player);
            if (world.field_73011_w instanceof IMeteorType) {
                this.spawnMeteor(world, player, (IMeteorType)world.field_73011_w);
            } else if (world.field_73011_w instanceof ILightningStorm) {
                this.spawnLightningBolt(world, player);
            }
            if ((player.func_82165_m(MPPotions.infected_gas.field_76415_H) || player.func_82165_m(MPPotions.icy_poison.field_76415_H)) && MorePlanetEvents.getTier3ThermalArmor(player)) {
                player.func_82170_o(MPPotions.infected_gas.field_76415_H);
                player.func_82170_o(MPPotions.icy_poison.field_76415_H);
            }
        }
        this.doSiriusFire(world, living);
        this.doInfectedGasForEntity(world, living);
    }

    @SubscribeEvent
    public void onBucketFill(FillBucketEvent event) {
        World world = event.world;
        MovingObjectPosition pos = event.target;
        Block block = world.func_147439_a(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
        MorePlanetEvents.registerBucket(event, world, pos, KapteynBBlocks.frozen_water, 0, new ItemStack(KapteynBItems.frozen_water_bucket), false);
        MorePlanetEvents.registerBucket(event, world, pos, PolongniusBlocks.cheese_of_milk, 0, new ItemStack(PolongniusItems.cheese_of_milk_bucket), false);
        MorePlanetEvents.registerBucket(event, world, pos, FronosBlocks.coconut_milk, 0, new ItemStack(FronosItems.fronos_bucket, 1, 0), false);
        MorePlanetEvents.registerBucket(event, world, pos, FronosBlocks.mineral_water, 0, new ItemStack(FronosItems.fronos_bucket, 1, 1), false);
        MorePlanetEvents.registerBucket(event, world, pos, FronosBlocks.ovantine, 0, new ItemStack(FronosItems.fronos_bucket, 1, 2), false);
        MorePlanetEvents.registerBucket(event, world, pos, FronosBlocks.tea, 0, new ItemStack(FronosItems.fronos_bucket, 1, 3), false);
        MorePlanetEvents.registerBucket(event, world, pos, FronosBlocks.caramel, 3, new ItemStack(FronosItems.fronos_bucket, 1, 4), false);
        MorePlanetEvents.registerBucket(event, world, pos, SiriusBBlocks.sirius_lava, 0, new ItemStack(SiriusBItems.sirius_lava_bucket), true);
        MorePlanetEvents.registerBucket(event, world, pos, IoBlocks.io_lava, 0, new ItemStack(IoItems.io_lava_bucket), true);
        MorePlanetEvents.registerBucket(event, world, pos, IoBlocks.liquid_red_sulfur, 0, new ItemStack(IoItems.liquid_red_sulfur_bucket), true);
        MorePlanetEvents.registerBucket(event, world, pos, IoBlocks.liquid_yellow_sulfur, 0, new ItemStack(IoItems.liquid_yellow_sulfur_bucket), true);
        MorePlanetEvents.registerBucket(event, world, pos, IoBlocks.liquid_orange_sulfur, 0, new ItemStack(IoItems.liquid_orange_sulfur_bucket), true);
        MorePlanetEvents.registerBucket(event, world, pos, IoBlocks.liquid_brown_sulfur, 0, new ItemStack(IoItems.liquid_brown_sulfur_bucket), true);
        MorePlanetEvents.registerBucket(event, world, pos, IoBlocks.io_black_lava, 0, new ItemStack(IoItems.io_black_lava_bucket), true);
        MorePlanetEvents.registerBucket(event, world, pos, MercuryBlocks.dirty_water, 0, new ItemStack(MercuryItems.dirty_water_bucket), false);
        MorePlanetEvents.registerBucket(event, world, pos, EuropaBlocks.europa_water, 0, new ItemStack(EuropaItems.europa_water_bucket), false);
        if (block == PlutoBlocks.liquid_methane) {
            if (event.current.func_77973_b() == Items.field_151133_ar) {
                event.setCanceled(true);
            }
        } else if (block == PlutoBlocks.liquid_nitrogen && event.current.func_77973_b() == Items.field_151133_ar) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void interactEntityWithDye(EntityInteractEvent event) {
        ItemStack itemstack = event.entityPlayer.func_71045_bC();
        Entity entity = event.target;
        if (itemstack != null) {
            int meta = itemstack.func_77960_j() & 0xF;
            if (itemstack.func_77973_b() == Items.field_151100_aR && meta >= 0) {
                int color = BlockColored.func_150032_b((int)meta);
                if (entity instanceof EntityGrappy) {
                    EntityGrappy grappy = (EntityGrappy)entity;
                    if (!grappy.getSheared() && grappy.getFleeceColor() != color) {
                        grappy.setFleeceColor(color);
                        if (!event.entityPlayer.field_71075_bZ.field_75098_d) {
                            --itemstack.field_77994_a;
                        }
                    }
                    event.setResult(Event.Result.ALLOW);
                }
            }
        }
    }

    private void spawnFeces(World world, EntityPlayerMP player) {
        if (world.field_73011_w instanceof WorldProviderMars) {
            EntityItem item;
            if (world.func_72820_D() == 7000L) {
                item = new EntityItem(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, new ItemStack(MPItems.feces));
                item.field_145804_b = 10;
                world.func_72956_a((Entity)player, "mob.chicken.plop", 0.75f, (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f + 0.6f);
                world.func_72838_d((Entity)item);
            }
            if (world.func_72820_D() == 12000L) {
                item = new EntityItem(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, new ItemStack(MPItems.feces));
                item.field_145804_b = 10;
                world.func_72956_a((Entity)player, "mob.chicken.plop", 0.75f, (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f + 0.6f);
                world.func_72838_d((Entity)item);
            }
        }
    }

    private void spawnMeteor(World world, EntityPlayerMP player, IMeteorType type) {
        Object meteor = null;
        if (FMLCommonHandler.instance().getEffectiveSide() != Side.CLIENT && ((IMeteorType)world.field_73011_w).getMeteorSpawnFrequency() > 0.0) {
            double motZ;
            double motX;
            int z;
            int y;
            int x;
            EntityPlayer closestPlayer;
            int f = (int)(((IMeteorType)world.field_73011_w).getMeteorSpawnFrequency() * 1000.0);
            if (world.field_73012_v.nextInt(f) == 0 && ((closestPlayer = world.func_72890_a((Entity)player, 100.0)) == null || closestPlayer.func_145782_y() <= player.func_145782_y())) {
                x = world.field_73012_v.nextInt(20) - 10;
                y = world.field_73012_v.nextInt(20) + 200;
                z = world.field_73012_v.nextInt(20) - 10;
                motX = world.field_73012_v.nextDouble() * 5.0;
                motZ = world.field_73012_v.nextDouble() * 5.0;
                switch (type.getMeteorEventType()) {
                    case 0: {
                        meteor = new EntityPolongniusMeteor(world, player.field_70165_t + (double)x, player.field_70163_u + (double)y, player.field_70161_v + (double)z, motX - 2.5, 0.0, motZ - 2.5, 1);
                        break;
                    }
                    case 1: {
                        meteor = new EntityKoentusMeteor(world, player.field_70165_t + (double)x, player.field_70163_u + (double)y, player.field_70161_v + (double)z, motX - 2.5, 0.0, motZ - 2.5, 1);
                        break;
                    }
                    case 2: {
                        meteor = new EntityIceCrystalMeteor(world, player.field_70165_t + (double)x, player.field_70163_u + (double)y, player.field_70161_v + (double)z, motX - 2.5, 0.0, motZ - 2.5, 1);
                    }
                }
                if (!world.field_72995_K) {
                    world.func_72838_d(meteor);
                    MPLog.debug("Spawn %s at %s %s %s", meteor.getClass().getSimpleName(), (int)((Entity)meteor).field_70165_t, (int)((Entity)meteor).field_70163_u, (int)((Entity)meteor).field_70161_v);
                }
            }
            if (world.field_73012_v.nextInt(f * 3) == 0 && ((closestPlayer = world.func_72890_a((Entity)player, 100.0)) == null || closestPlayer.func_145782_y() <= player.func_145782_y())) {
                x = world.field_73012_v.nextInt(20) - 10;
                y = world.field_73012_v.nextInt(20) + 200;
                z = world.field_73012_v.nextInt(20) - 10;
                motX = world.field_73012_v.nextDouble() * 5.0;
                motZ = world.field_73012_v.nextDouble() * 5.0;
                switch (type.getMeteorEventType()) {
                    case 0: {
                        meteor = new EntityPolongniusMeteor(world, player.field_70165_t + (double)x, player.field_70163_u + (double)y, player.field_70161_v + (double)z, motX - 2.5, 0.0, motZ - 2.5, 1);
                        break;
                    }
                    case 1: {
                        meteor = new EntityKoentusMeteor(world, player.field_70165_t + (double)x, player.field_70163_u + (double)y, player.field_70161_v + (double)z, motX - 2.5, 0.0, motZ - 2.5, 1);
                        break;
                    }
                    case 2: {
                        meteor = new EntityIceCrystalMeteor(world, player.field_70165_t + (double)x, player.field_70163_u + (double)y, player.field_70161_v + (double)z, motX - 2.5, 0.0, motZ - 2.5, 1);
                    }
                }
                if (!world.field_72995_K) {
                    world.func_72838_d(meteor);
                    MPLog.debug("Spawn %s at %s %s %s", meteor.getClass().getSimpleName(), (int)((Entity)meteor).field_70165_t, (int)((Entity)meteor).field_70163_u, (int)((Entity)meteor).field_70161_v);
                }
            }
        }
    }

    private void spawnLightningBolt(World world, EntityPlayerMP player) {
        if (FMLCommonHandler.instance().getEffectiveSide() != Side.CLIENT && ((ILightningStorm)world.field_73011_w).getLightningStormFrequency() > 0.0) {
            EntityLightningBolt lightning;
            double z;
            double y;
            double x;
            EntityPlayer closestPlayer;
            int f = (int)(((ILightningStorm)world.field_73011_w).getLightningStormFrequency() * 1000.0);
            if (world.field_73012_v.nextInt(f) == 0 && ((closestPlayer = world.func_72890_a((Entity)player, 100.0)) == null || closestPlayer.func_145782_y() <= player.func_145782_y())) {
                x = player.field_70165_t + (double)world.field_73012_v.nextInt(25) - 5.0;
                y = player.field_70163_u + (double)world.field_73012_v.nextInt(10);
                z = player.field_70161_v + (double)world.field_73012_v.nextInt(25) - 5.0;
                lightning = new EntityLightningBolt(world, x, y, z);
                if (!world.field_72995_K) {
                    world.func_72838_d((Entity)lightning);
                    MPLog.debug("Spawn Bolt at %s %s %s", (int)lightning.field_70165_t, (int)lightning.field_70163_u, (int)lightning.field_70161_v);
                }
            }
            if (world.field_73012_v.nextInt(f * 3) == 0 && ((closestPlayer = world.func_72890_a((Entity)player, 100.0)) == null || closestPlayer.func_145782_y() <= player.func_145782_y())) {
                x = player.field_70165_t + (double)world.field_73012_v.nextInt(25) - 5.0;
                y = player.field_70163_u + (double)world.field_73012_v.nextInt(10);
                z = player.field_70161_v + (double)world.field_73012_v.nextInt(25) - 5.0;
                lightning = new EntityLightningBolt(world, x, y, z);
                if (!world.field_72995_K) {
                    for (int i = 0; i < 3; ++i) {
                        world.func_72838_d((Entity)lightning);
                        MPLog.debug("Spawn Bolt at %s %s %s", (int)lightning.field_70165_t, (int)lightning.field_70163_u, (int)lightning.field_70161_v);
                    }
                }
            }
        }
    }

    private void spawnDarkAsteroids(World world, EntityPlayerMP player) {
        EntityPlayer closestPlayer;
        int f;
        if (!world.field_72995_K && world.field_73011_w instanceof WorldProviderDarkAsteroids && world.field_73012_v.nextInt(f = 50) == 0 && player.field_70163_u < 260.0 && ((closestPlayer = world.func_72890_a((Entity)player, 100.0)) == null || closestPlayer.func_145782_y() <= player.func_145782_y())) {
            double r = (double)world.field_73012_v.nextInt(60) + 30.0;
            double theta = Math.PI * 2 * world.field_73012_v.nextDouble();
            double x = player.field_70165_t + Math.cos(theta) * r;
            double y = player.field_70163_u + (double)world.field_73012_v.nextInt(5);
            double z = player.field_70161_v + Math.sin(theta) * r;
            double motX = (player.field_70165_t - x + (world.field_73012_v.nextDouble() - 0.5) * 40.0) / 400.0;
            double motY = (world.field_73012_v.nextDouble() - 0.5) * 0.4;
            double motZ = (player.field_70161_v - z + (world.field_73012_v.nextDouble() - 0.5) * 40.0) / 400.0;
            EntityDarkAsteroid smallAsteroid = new EntityDarkAsteroid(world);
            smallAsteroid.func_70107_b(x, y, z);
            smallAsteroid.field_70159_w = motX;
            smallAsteroid.field_70181_x = motY;
            smallAsteroid.field_70179_y = motZ;
            smallAsteroid.spinYaw = world.field_73012_v.nextFloat() * 4.0f;
            smallAsteroid.spinPitch = world.field_73012_v.nextFloat() * 2.0f;
            world.func_72838_d((Entity)smallAsteroid);
            MPLog.debug("Spawn Dark Asteroid at %s %s %s", (int)smallAsteroid.field_70165_t, (int)smallAsteroid.field_70163_u, (int)smallAsteroid.field_70161_v);
        }
    }

    private void doInfectedGasForEntity(World world, EntityLivingBase living) {
        if (world.field_73011_w instanceof WorldProviderNibiru && living.field_70163_u <= 1000.0) {
            if (!(living instanceof EntityPlayer)) {
                if (!(living.field_70173_aa % 100 != 0 || living instanceof IEntityLivingPlanet && world.field_73011_w.field_76574_g == ((IEntityLivingPlanet)living).canLivingInDimension().dimID || living.getClass() == EntityEvolvedZombie.class || living.getClass() == EntityEvolvedSpider.class || living.getClass() == EntityEvolvedSkeleton.class || living.getClass() == EntityEvolvedCreeper.class || living.getClass() == EntityEvolvedEnderman.class || living.getClass() == EntityEvolvedWitch.class)) {
                    living.func_70690_d(new PotionEffect(MPPotions.infected_gas.field_76415_H, 80));
                }
            } else if (living instanceof EntityPlayerMP) {
                EntityPlayerMP player = (EntityPlayerMP)living;
                if (player.func_82165_m(MPPotions.infected_gas.field_76415_H) && player.field_70173_aa % 2000 == 0 && !player.field_71075_bZ.field_75098_d) {
                    player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + StatCollector.func_74838_a((String)"message.warning.infected.gas")));
                }
                if (ConfigManagerMP.disableInfectedGas) {
                    if (player.func_82165_m(MPPotions.infected_gas.field_76415_H) && MorePlanetEvents.getTier2ThermalArmor(player)) {
                        player.func_82170_o(MPPotions.infected_gas.field_76415_H);
                    }
                } else if (!(player.field_70173_aa % 200 != 0 || player.field_71075_bZ.field_75098_d || MorePlanetEvents.getTier2ThermalArmor(player) || OxygenUtil.inOxygenBubble((World)world, (double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v) || OxygenUtil.isAABBInBreathableAirBlock((EntityLivingBase)player))) {
                    player.func_70690_d(new PotionEffect(MPPotions.infected_gas.field_76415_H, 80));
                } else if (MorePlanetEvents.getTier2ThermalArmor(player) || OxygenUtil.inOxygenBubble((World)world, (double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v) || OxygenUtil.isAABBInBreathableAirBlock((EntityLivingBase)player)) {
                    player.func_82170_o(MPPotions.infected_gas.field_76415_H);
                }
            }
        }
    }

    private void doSiriusFire(World world, EntityLivingBase living) {
        if (!(!(world.field_73011_w instanceof WorldProviderSiriusB) || living instanceof EntityPlayer || living.field_70173_aa % 100 != 0 || living instanceof IEntityLivingPlanet && world.field_73011_w.field_76574_g == ((IEntityLivingPlanet)living).canLivingInDimension().dimID)) {
            living.func_70015_d(8);
        }
    }

    private void removeIcyPoison(EntityPlayerMP player) {
        boolean fullArmor;
        InventoryPlayer inventory = player.field_71071_by;
        boolean armor1 = inventory.field_70460_b[0] != null && inventory.field_70460_b[0].func_77973_b() == KapteynBArmorItems.ice_crystal_boots;
        boolean armor2 = inventory.field_70460_b[1] != null && inventory.field_70460_b[1].func_77973_b() == KapteynBArmorItems.ice_crystal_leggings;
        boolean armor3 = inventory.field_70460_b[2] != null && inventory.field_70460_b[2].func_77973_b() == KapteynBArmorItems.ice_crystal_chestplate;
        boolean armor4 = inventory.field_70460_b[3] != null && inventory.field_70460_b[3].func_77973_b() == KapteynBArmorItems.ice_crystal_helmet || inventory.field_70460_b[3] != null && inventory.field_70460_b[3].func_77973_b() == KapteynBArmorItems.breathable_ice_crystal_helmet;
        boolean bl = fullArmor = armor1 && armor2 && armor3 && armor4;
        if (fullArmor && player.func_82165_m(MPPotions.icy_poison.field_76415_H)) {
            player.func_82170_o(MPPotions.icy_poison.field_76415_H);
        }
    }

    private void glowSapling(BonemealEvent event, World world, Block block) {
        if (event.block == block) {
            event.setResult(Event.Result.ALLOW);
            if (!world.field_72995_K && (double)world.field_73012_v.nextFloat() < 0.45) {
                ((BlockSapling)block).func_149878_d(world, event.x, event.y, event.z, world.field_73012_v);
            }
        }
    }

    private void glowTallGrass(BonemealEvent event, Random rand, int x, int z, Block grass, Block tallGrass, int meta, int randMeta, boolean useRand) {
        if (event.block == grass) {
            int y = event.y + 1;
            for (int i1 = 0; i1 < 128; ++i1) {
                for (int i2 = 0; i2 < i1 / 16; ++i2) {
                    x += event.world.field_73012_v.nextInt(3) - 1;
                    y += (event.world.field_73012_v.nextInt(3) - 1) * event.world.field_73012_v.nextInt(3) / 2;
                    z += event.world.field_73012_v.nextInt(3) - 1;
                }
                if (!event.world.func_147439_a(x, y, z).isAir((IBlockAccess)event.world, x, y, z)) continue;
                if (!useRand) {
                    if (!tallGrass.func_149705_a(event.world, x, y, z, 0, new ItemStack(tallGrass, 1, meta))) continue;
                    event.setResult(Event.Result.ALLOW);
                    if (event.world.field_72995_K) continue;
                    event.world.func_147465_d(x, y, z, tallGrass, meta, 2);
                    continue;
                }
                if (!tallGrass.func_149705_a(event.world, x, y, z, 0, new ItemStack(tallGrass, 1, rand.nextInt(meta) + randMeta))) continue;
                event.setResult(Event.Result.ALLOW);
                if (event.world.field_72995_K) continue;
                event.world.func_147465_d(x, y, z, tallGrass, rand.nextInt(meta) + randMeta, 2);
            }
        }
    }

    private void renderRing(CelestialBodyRenderEvent.CelestialRingRenderEvent.Pre event, CelestialBody celestial, float r, float g, float b, float outerAlpha, float innerAlpha) {
        float temp;
        int i;
        Vector3f mapPos = event.parentOffset;
        float xOffset = mapPos.x;
        float yOffset = mapPos.y;
        if (FMLClientHandler.instance().getClient().field_71462_r instanceof GuiCelestialSelection) {
            GL11.glColor4f((float)r, (float)g, (float)b, (float)outerAlpha);
        }
        event.setCanceled(true);
        GL11.glBegin((int)2);
        float theta = 0.06981317f;
        float cos = (float)Math.cos(theta);
        float sin = (float)Math.sin(theta);
        float min = 0.0f;
        float max = 0.0f;
        if (celestial instanceof Planet) {
            min = 72.0f;
            max = 78.0f;
        } else if (celestial instanceof Moon) {
            max = 0.6666667f;
            min = 0.5263158f;
        }
        float x = max * celestial.getRelativeDistanceFromCenter().unScaledDistance;
        float y = 0.0f;
        for (i = 0; i < 90; ++i) {
            GL11.glVertex2f((float)(x + xOffset), (float)(y + yOffset));
            temp = x;
            x = cos * x - sin * y;
            y = sin * temp + cos * y;
        }
        GL11.glEnd();
        GL11.glBegin((int)2);
        x = min * celestial.getRelativeDistanceFromCenter().unScaledDistance;
        y = 0.0f;
        for (i = 0; i < 90; ++i) {
            GL11.glVertex2f((float)(x + xOffset), (float)(y + yOffset));
            temp = x;
            x = cos * x - sin * y;
            y = sin * temp + cos * y;
        }
        GL11.glEnd();
        GL11.glColor4f((float)r, (float)g, (float)b, (float)innerAlpha);
        GL11.glBegin((int)7);
        x = min * celestial.getRelativeDistanceFromCenter().unScaledDistance;
        y = 0.0f;
        float x2 = max * celestial.getRelativeDistanceFromCenter().unScaledDistance;
        float y2 = 0.0f;
        for (int i2 = 0; i2 < 90; ++i2) {
            GL11.glVertex2f((float)(x2 + xOffset), (float)(y2 + yOffset));
            GL11.glVertex2f((float)(x + xOffset), (float)(y + yOffset));
            temp = x;
            x = cos * x - sin * y;
            y = sin * temp + cos * y;
            temp = x2;
            x2 = cos * x2 - sin * y2;
            y2 = sin * temp + cos * y2;
            GL11.glVertex2f((float)(x + xOffset), (float)(y + yOffset));
            GL11.glVertex2f((float)(x2 + xOffset), (float)(y2 + yOffset));
        }
        GL11.glEnd();
    }

    public static void addInfectedGas(EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            EntityPlayerMP playerMP = (EntityPlayerMP)player;
            if (ConfigManagerMP.disableInfectedGas && !MorePlanetEvents.getTier2ThermalArmor(playerMP)) {
                playerMP.func_70690_d(new PotionEffect(MPPotions.infected_gas.field_76415_H, 80));
            }
        }
    }

    public static boolean getTier2ThermalArmor(EntityPlayerMP player) {
        IInventoryGC inv = AccessInventoryGC.getGCInventoryForPlayer((EntityPlayerMP)player);
        boolean armor1 = inv.func_70301_a(6) != null && inv.func_70301_a(6).func_77973_b() == MPItems.tier_2_thermal_padding && inv.func_70301_a(6).func_77960_j() == 0;
        boolean armor2 = inv.func_70301_a(7) != null && inv.func_70301_a(7).func_77973_b() == MPItems.tier_2_thermal_padding && inv.func_70301_a(7).func_77960_j() == 1;
        boolean armor3 = inv.func_70301_a(8) != null && inv.func_70301_a(8).func_77973_b() == MPItems.tier_2_thermal_padding && inv.func_70301_a(8).func_77960_j() == 2;
        boolean armor4 = inv.func_70301_a(9) != null && inv.func_70301_a(9).func_77973_b() == MPItems.tier_2_thermal_padding && inv.func_70301_a(9).func_77960_j() == 3;
        return armor1 && armor2 && armor3 && armor4;
    }

    public static boolean getTier3ThermalArmor(EntityPlayerMP player) {
        IInventoryGC inv = AccessInventoryGC.getGCInventoryForPlayer((EntityPlayerMP)player);
        boolean armor1 = inv.func_70301_a(6) != null && inv.func_70301_a(6).func_77973_b() == MPItems.tier_3_thermal_padding && inv.func_70301_a(6).func_77960_j() == 0;
        boolean armor2 = inv.func_70301_a(7) != null && inv.func_70301_a(7).func_77973_b() == MPItems.tier_3_thermal_padding && inv.func_70301_a(7).func_77960_j() == 1;
        boolean armor3 = inv.func_70301_a(8) != null && inv.func_70301_a(8).func_77973_b() == MPItems.tier_3_thermal_padding && inv.func_70301_a(8).func_77960_j() == 2;
        boolean armor4 = inv.func_70301_a(9) != null && inv.func_70301_a(9).func_77973_b() == MPItems.tier_3_thermal_padding && inv.func_70301_a(9).func_77960_j() == 3;
        return armor1 && armor2 && armor3 && armor4;
    }

    public static boolean getIceCrystalArmor(EntityPlayerMP player) {
        InventoryPlayer inventory = player.field_71071_by;
        boolean armor1 = inventory.field_70460_b[0] != null && inventory.field_70460_b[0].func_77973_b() == KapteynBArmorItems.ice_crystal_boots;
        boolean armor2 = inventory.field_70460_b[1] != null && inventory.field_70460_b[1].func_77973_b() == KapteynBArmorItems.ice_crystal_leggings;
        boolean armor3 = inventory.field_70460_b[2] != null && inventory.field_70460_b[2].func_77973_b() == KapteynBArmorItems.ice_crystal_chestplate;
        boolean armor4 = inventory.field_70460_b[3] != null && inventory.field_70460_b[3].func_77973_b() == KapteynBArmorItems.ice_crystal_helmet || inventory.field_70460_b[3] != null && inventory.field_70460_b[3].func_77973_b() == KapteynBArmorItems.breathable_ice_crystal_helmet;
        return armor1 && armor2 && armor3 && armor4;
    }

    private static void registerBucket(FillBucketEvent event, World world, MovingObjectPosition pos, Block block, int meta, ItemStack itemStack, boolean cancelBucket) {
        if (world.func_147439_a(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d) == block && world.func_72805_g(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d) == meta) {
            if (cancelBucket) {
                if (event.current.func_77973_b() == Items.field_151133_ar) {
                    event.setCanceled(true);
                }
            } else {
                world.func_147468_f(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
                event.result = itemStack;
                event.setResult(Event.Result.ALLOW);
            }
        }
    }
}

