/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.core.blocks;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import stevekung.mods.moreplanets.core.MorePlanetsCore;
import stevekung.mods.moreplanets.core.init.MPBlocks;

public class BlockSlabMP
extends BlockSlab {
    private static String[] woodTypes = new String[]{"diona", "quonBrick", "chiseledQuon", "polongnius", "nibiru", "koentus", "koentusStone", "koentusBrick", "fronos", "fronosBrick", "fronosCrackBrick", "kapteyn", "sirius", "mercury", "venus", "pluto"};
    private static String[] rockTypes = new String[]{"ancientDarkWood", "orangeWood", "coconutWood", "redMapleWood", "crystalWood", "europaWood", "alienWood"};
    private IIcon[] textures;
    protected boolean isDoubleSlab;
    private SlabCategory category;

    public BlockSlabMP(String name, boolean isDoubleSlab, Material material, SlabCategory cat) {
        super(isDoubleSlab, material);
        this.isDoubleSlab = isDoubleSlab;
        this.category = cat;
        this.func_149663_c(name);
        if (material == Material.field_151575_d) {
            this.func_149711_c(2.0f);
            this.func_149752_b(5.0f);
            this.func_149672_a(Block.field_149766_f);
        }
        this.field_149783_u = true;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        if (this.category == SlabCategory.WOOD2) {
            if (meta == 4 || meta == 12) {
                return 15;
            }
            if (this.isDoubleSlab && (meta == 4 || meta == 12)) {
                return 15;
            }
        }
        return 0;
    }

    public void func_149651_a(IIconRegister par1IconRegister) {
        if (this.category == SlabCategory.STONE) {
            this.textures = new IIcon[8];
            this.textures[0] = par1IconRegister.func_94245_a("nibiru:ancient_dark_wood_planks");
            this.textures[1] = par1IconRegister.func_94245_a("nibiru:orange_wood_planks");
            this.textures[2] = par1IconRegister.func_94245_a("fronos:coconut_wood_planks");
            this.textures[3] = par1IconRegister.func_94245_a("fronos:maple_wood_planks");
            this.textures[4] = par1IconRegister.func_94245_a("koentus:crystal_planks");
            this.textures[5] = par1IconRegister.func_94245_a("europa:europa_planks");
            this.textures[6] = par1IconRegister.func_94245_a("mpcore:darkasteroids/alien_wood_planks");
        } else if (this.category == SlabCategory.WOOD2) {
            this.textures = new IIcon[8];
            this.textures[0] = par1IconRegister.func_94245_a("fronos:fronos_cobblestone");
            this.textures[1] = par1IconRegister.func_94245_a("fronos:fronos_stone_brick");
            this.textures[2] = par1IconRegister.func_94245_a("fronos:cracked_fronos_stone_brick");
            this.textures[3] = par1IconRegister.func_94245_a("kapteynb:kapteyn_b_cobblestone");
            this.textures[4] = par1IconRegister.func_94245_a("siriusb:sirius_b_carbon_cobblestone");
            this.textures[5] = par1IconRegister.func_94245_a("mercury:mercury_cobblestone");
            this.textures[6] = par1IconRegister.func_94245_a("venus:venus_cobblestone");
            this.textures[7] = par1IconRegister.func_94245_a("pluto:pluto_cobblestone");
        } else {
            this.textures = new IIcon[8];
            this.textures[0] = par1IconRegister.func_94245_a("diona:diona_cobblestone");
            this.textures[1] = par1IconRegister.func_94245_a("diona:quontonium_brick");
            this.textures[2] = par1IconRegister.func_94245_a("diona:chiseled_quontonium");
            this.textures[3] = par1IconRegister.func_94245_a("polongnius:polongnius_cobblestone");
            this.textures[4] = par1IconRegister.func_94245_a("nibiru:nibiru_cobblestone");
            this.textures[5] = par1IconRegister.func_94245_a("koentus:koentus_cobblestone");
            this.textures[6] = par1IconRegister.func_94245_a("koentus:koentus_ancient_stone");
            this.textures[7] = par1IconRegister.func_94245_a("koentus:ancient_koentus_brick");
        }
    }

    public IIcon func_149691_a(int side, int meta) {
        if (this.category == SlabCategory.STONE) {
            return this.textures[meta & 7];
        }
        if (this.category == SlabCategory.WOOD1) {
            return this.textures[meta & 7];
        }
        if (this.category == SlabCategory.WOOD2) {
            return this.textures[meta & 7];
        }
        return this.field_149761_L;
    }

    public void func_149666_a(Item block, CreativeTabs creativeTabs, List list) {
        int max = 0;
        if (this.category == SlabCategory.WOOD1) {
            max = 8;
        } else if (this.category == SlabCategory.WOOD2) {
            max = 8;
        } else if (this.category == SlabCategory.STONE) {
            max = 7;
        }
        for (int i = 0; i < max; ++i) {
            list.add(new ItemStack(block, 1, i));
        }
    }

    public String func_150002_b(int meta) {
        if (this.category == SlabCategory.STONE) {
            return rockTypes[this.getTypeFromMeta(meta)] + "";
        }
        return woodTypes[this.getWoodType(meta)] + "";
    }

    public int func_149692_a(int meta) {
        return meta & 7;
    }

    public Item func_149650_a(int meta, Random par2Random, int par3) {
        if (this.isDoubleSlab) {
            if (this == MPBlocks.stone_slab_full) {
                return Item.func_150898_a((Block)MPBlocks.stone_slab_half);
            }
            if (this == MPBlocks.wooden_slab_full) {
                return Item.func_150898_a((Block)MPBlocks.wooden_slab_half);
            }
            return Item.func_150898_a((Block)MPBlocks.stone_slab_half2);
        }
        return Item.func_150898_a((Block)this);
    }

    public CreativeTabs func_149708_J() {
        if (!this.isDoubleSlab) {
            return MorePlanetsCore.mpBlocksTab;
        }
        return null;
    }

    public float func_149712_f(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        float hardness = this.field_149782_v;
        if (this.category == SlabCategory.WOOD1) {
            switch (meta & 7) {
                case 0: 
                case 6: 
                case 7: {
                    hardness = 2.5f;
                    break;
                }
                case 1: 
                case 2: 
                case 5: {
                    hardness = 3.25f;
                    break;
                }
                case 3: {
                    hardness = 3.0f;
                    break;
                }
                case 4: {
                    hardness = 4.25f;
                    break;
                }
                default: {
                    hardness = 2.0f;
                    break;
                }
            }
        } else if (this.category == SlabCategory.WOOD2) {
            switch (meta & 7) {
                case 0: {
                    hardness = 1.75f;
                    break;
                }
                case 1: 
                case 2: {
                    hardness = 2.25f;
                    break;
                }
                case 3: {
                    hardness = 3.25f;
                    break;
                }
                case 4: {
                    hardness = 4.5f;
                }
            }
        }
        return hardness;
    }

    public float getExplosionResistance(Entity par1Entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        return super.func_149712_f(world, x, y, z);
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (block == MPBlocks.stone_slab_full) {
            return new ItemStack(MPBlocks.stone_slab_half, 1, meta);
        }
        if (block == MPBlocks.stone_slab_full2) {
            return new ItemStack(MPBlocks.stone_slab_half2, 1, meta);
        }
        if (block == MPBlocks.wooden_slab_full) {
            return new ItemStack(MPBlocks.wooden_slab_half, 1, meta);
        }
        if (block == MPBlocks.dungeon_brick_slab_full) {
            return new ItemStack(MPBlocks.dungeon_brick_slab_half, 1, meta);
        }
        return new ItemStack((Block)this, 1, meta & 7);
    }

    protected ItemStack func_149644_j(int par1) {
        return new ItemStack((Block)this, 2, par1);
    }

    private int getWoodType(int meta) {
        if ((meta = this.getTypeFromMeta(meta) + this.category.ordinal() * 8) < woodTypes.length) {
            return meta;
        }
        return 0;
    }

    private int getTypeFromMeta(int meta) {
        return meta & 7;
    }

    public static enum SlabCategory {
        WOOD1,
        WOOD2,
        STONE;

    }
}

