/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.core.blocks;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import stevekung.mods.moreplanets.core.MorePlanetsCore;
import stevekung.mods.moreplanets.core.init.MPBlocks;

public class BlockDungeonBrickSlab
extends BlockSlab {
    private IIcon[] textures;
    private boolean isDoubleSlab;
    private DungeonSlabCategory category;

    public BlockDungeonBrickSlab(String name, boolean par2, Material material, DungeonSlabCategory cat) {
        super(par2, material);
        this.isDoubleSlab = par2;
        this.category = cat;
        this.func_149663_c(name);
        this.field_149783_u = true;
    }

    public void func_149651_a(IIconRegister par1IconRegister) {
        this.textures = new IIcon[8];
        this.textures[0] = par1IconRegister.func_94245_a("diona:diona_dungeon_brick");
        this.textures[1] = par1IconRegister.func_94245_a("polongnius:polongnius_dungeon_brick");
        this.textures[2] = par1IconRegister.func_94245_a("nibiru:nibiru_dungeon_brick");
        this.textures[3] = par1IconRegister.func_94245_a("koentus:koentus_dungeon_brick");
        this.textures[4] = par1IconRegister.func_94245_a("fronos:fronos_dungeon_brick");
        this.textures[5] = par1IconRegister.func_94245_a("kapteynb:kapteyn_b_dungeon_brick");
        this.textures[6] = par1IconRegister.func_94245_a("siriusb:sirius_b_dungeon_brick");
        this.textures[7] = par1IconRegister.func_94245_a("mercury:mercury_dungeon_brick");
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        if (this.category == DungeonSlabCategory.WOOD1) {
            if (meta == 6 || meta == 14) {
                return 15;
            }
            if (this.isDoubleSlab && (meta == 6 || meta == 14)) {
                return 15;
            }
        }
        return 0;
    }

    public IIcon func_149691_a(int side, int meta) {
        if (this.category == DungeonSlabCategory.STONE) {
            return this.textures[meta & 7];
        }
        if (this.category == DungeonSlabCategory.WOOD1) {
            return this.textures[meta & 7];
        }
        if (this.category == DungeonSlabCategory.WOOD2) {
            return this.textures[meta & 7];
        }
        return this.field_149761_L;
    }

    public void func_149666_a(Item block, CreativeTabs creativeTabs, List list) {
        int max = 0;
        if (this.category == DungeonSlabCategory.WOOD1) {
            max = 8;
        } else if (this.category == DungeonSlabCategory.WOOD2) {
            max = 1;
        } else if (this.category == DungeonSlabCategory.STONE) {
            max = 3;
        }
        for (int i = 0; i < max; ++i) {
            list.add(new ItemStack(block, 1, i));
        }
    }

    public String func_150002_b(int meta) {
        return this.getTypes()[this.getWoodType(meta)] + "";
    }

    public int func_149692_a(int meta) {
        return meta & 7;
    }

    public Item func_149650_a(int meta, Random par2Random, int par3) {
        if (this == MPBlocks.dungeon_brick_slab_full) {
            return Item.func_150898_a((Block)MPBlocks.dungeon_brick_slab_half);
        }
        return Item.func_150898_a((Block)this);
    }

    public CreativeTabs func_149708_J() {
        if (!this.isDoubleSlab) {
            return MorePlanetsCore.mpBlocksTab;
        }
        return null;
    }

    public float func_149712_f(World world, int x, int y, int z) {
        return 4.0f;
    }

    public float getExplosionResistance(Entity par1Entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        return 6.0f;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (block == MPBlocks.dungeon_brick_slab_full) {
            return new ItemStack(MPBlocks.dungeon_brick_slab_half, 1, meta);
        }
        return new ItemStack((Block)this, 1, meta & 7);
    }

    protected ItemStack func_149644_j(int par1) {
        return new ItemStack((Block)this, 2, par1);
    }

    private int getWoodType(int meta) {
        if ((meta &= 7 + this.category.ordinal() * 8) < this.getTypes().length) {
            return meta;
        }
        return 0;
    }

    private String[] getTypes() {
        return new String[]{"dionaBrick", "polongniusBrick", "nibiruBrick", "koentusBrick", "fronosBrick", "kapteynBrick", "siriusBrick", "mercury"};
    }

    public static enum DungeonSlabCategory {
        WOOD1,
        WOOD2,
        STONE;

    }
}

