/*
 * Decompiled with CFR 0.152.
 */
package stevekung.mods.moreplanets.asteroids.darkasteroids.world.gen;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedCreeper;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSkeleton;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSpider;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedZombie;
import micdoodle8.mods.galacticraft.core.perlin.NoiseModule;
import micdoodle8.mods.galacticraft.core.perlin.generator.Billowed;
import micdoodle8.mods.galacticraft.core.perlin.generator.Gradient;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.planets.asteroids.blocks.AsteroidBlocks;
import micdoodle8.mods.galacticraft.planets.asteroids.world.gen.SpecialAsteroidBlock;
import micdoodle8.mods.galacticraft.planets.asteroids.world.gen.SpecialAsteroidBlockHandler;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockFalling;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraft.world.gen.ChunkProviderGenerate;
import net.minecraft.world.gen.feature.WorldGenFlowers;
import net.minecraft.world.gen.feature.WorldGenLakes;
import stevekung.mods.moreplanets.asteroids.darkasteroids.blocks.DarkAsteroidsBlocks;
import stevekung.mods.moreplanets.asteroids.darkasteroids.dimension.WorldProviderDarkAsteroids;
import stevekung.mods.moreplanets.asteroids.darkasteroids.world.gen.BiomeDecoratorDarkAsteroids;
import stevekung.mods.moreplanets.asteroids.darkasteroids.world.gen.BiomeGenBaseDarkAsteroids;
import stevekung.mods.moreplanets.core.entities.EntityEvolvedWitch;
import stevekung.mods.moreplanets.core.worldgen.feature.WorldGenLiquidLakes;
import stevekung.mods.moreplanets.core.worldgen.feature.WorldGenTreeMP;
import stevekung.mods.moreplanets.moons.io.blocks.IoBlocks;
import stevekung.mods.moreplanets.planets.diona.entities.EntityEvolvedEnderman;
import stevekung.mods.moreplanets.planets.mercury.blocks.MercuryBlocks;

public class ChunkProviderDarkAsteroids
extends ChunkProviderGenerate {
    Block ASTEROID_STONE = DarkAsteroidsBlocks.dark_asteroid_block;
    byte ASTEROID_STONE_META_0 = 0;
    byte ASTEROID_STONE_META_1 = 1;
    byte ASTEROID_STONE_META_2 = (byte)2;
    Block DIRT = DarkAsteroidsBlocks.alien_dirt;
    byte DIRT_META = 0;
    Block GRASS = DarkAsteroidsBlocks.alien_grass;
    byte GRASS_META = 0;
    Block LIGHT = DarkAsteroidsBlocks.alien_glowstone;
    byte LIGHT_META = 0;
    Block FLOWER = Blocks.field_150328_O;
    Block LAVA = IoBlocks.io_black_lava;
    byte LAVA_META = 0;
    Block WATER = MercuryBlocks.dirty_water;
    byte WATER_META = 0;
    private Random rand;
    private World worldObj;
    private NoiseModule asteroidDensity;
    private NoiseModule asteroidTurbulance;
    private NoiseModule asteroidSkewX;
    private NoiseModule asteroidSkewY;
    private NoiseModule asteroidSkewZ;
    private SpecialAsteroidBlockHandler coreHandler;
    private SpecialAsteroidBlockHandler shellHandler;
    private static int CHUNK_SIZE_X = 16;
    private static int CHUNK_SIZE_Y = 256;
    private static int CHUNK_SIZE_Z = 16;
    private static int MAX_ASTEROID_RADIUS = 25;
    private static int MIN_ASTEROID_RADIUS = 10;
    private static int MAX_ASTEROID_SKEW = 12;
    private static int MIN_ASTEROID_Y = 32;
    private static int MAX_ASTEROID_Y = CHUNK_SIZE_Y - 32;
    private static int ASTEROID_CHANCE = 600;
    private static int ASTEROID_SHELL_CHANCE = 1;
    private static int MIN_BLOCKS_PER_CHUNK = 100;
    private static int MAX_BLOCKS_PER_CHUNK = 250;
    private static int ALUMINUM_CHANCE = 250;
    private static int ILMENITE_CHANCE = 400;
    private static int IRON_CHANCE = 300;
    private static int METEORIC_IRON_CHANCE = 450;
    private static int NOISE_OFFSET_SIZE = 256;
    private static float MIN_HOLLOW_SIZE = 0.8f;
    private static float MAX_HOLLOW_SIZE = 0.1f;
    private static int HOLLOW_CHANCE = 4;
    private static int MIN_RADIUS_FOR_HOLLOW = 20;
    private static int TREE_CHANCE = 1;
    private static int FLOWER_CHANCE = 2;
    private static int WATER_CHANCE = 2;
    private static int LAVA_CHANCE = 2;
    private static int GLOWSTONE_CHANCE = 20;
    private ArrayList<AsteroidData> largeAsteroids = new ArrayList();
    private static HashSet<BlockVec3> chunksDone = new HashSet();
    private int largeAsteroidsLastChunkX;
    private int largeAsteroidsLastChunkZ;
    public BiomeDecoratorDarkAsteroids biomedecoratorplanet = new BiomeDecoratorDarkAsteroids();

    public ChunkProviderDarkAsteroids(World world, long seed, boolean genFeature) {
        super(world, seed, genFeature);
        this.worldObj = world;
        this.rand = new Random(seed);
        this.asteroidDensity = new Billowed(this.rand.nextLong(), 2, 0.25f);
        this.asteroidDensity.setFrequency(0.009f);
        this.asteroidDensity.amplitude = 0.6f;
        this.asteroidTurbulance = new Gradient(this.rand.nextLong(), 1, 0.2f);
        this.asteroidTurbulance.setFrequency(0.08f);
        this.asteroidTurbulance.amplitude = 0.5f;
        this.asteroidSkewX = new Gradient(this.rand.nextLong(), 1, 1.0f);
        this.asteroidSkewX.amplitude = MAX_ASTEROID_SKEW;
        this.asteroidSkewX.frequencyX = 0.005f;
        this.asteroidSkewY = new Gradient(this.rand.nextLong(), 1, 1.0f);
        this.asteroidSkewY.amplitude = MAX_ASTEROID_SKEW;
        this.asteroidSkewY.frequencyY = 0.005f;
        this.asteroidSkewZ = new Gradient(this.rand.nextLong(), 1, 1.0f);
        this.asteroidSkewZ.amplitude = MAX_ASTEROID_SKEW;
        this.asteroidSkewZ.frequencyZ = 0.005f;
        this.coreHandler = new SpecialAsteroidBlockHandler();
        this.coreHandler.addBlock(new SpecialAsteroidBlock(this.ASTEROID_STONE, this.ASTEROID_STONE_META_2, 5, 0.3));
        this.coreHandler.addBlock(new SpecialAsteroidBlock(this.ASTEROID_STONE, this.ASTEROID_STONE_META_1, 7, 0.3));
        this.coreHandler.addBlock(new SpecialAsteroidBlock(this.ASTEROID_STONE, this.ASTEROID_STONE_META_0, 11, 0.25));
        this.coreHandler.addBlock(new SpecialAsteroidBlock(this.ASTEROID_STONE, 3, 5, 0.2));
        this.coreHandler.addBlock(new SpecialAsteroidBlock(this.ASTEROID_STONE, 4, 4, 0.15));
        this.coreHandler.addBlock(new SpecialAsteroidBlock(this.ASTEROID_STONE, 5, 3, 0.2));
        this.coreHandler.addBlock(new SpecialAsteroidBlock(this.ASTEROID_STONE, 7, 2, 0.15));
        this.coreHandler.addBlock(new SpecialAsteroidBlock(this.ASTEROID_STONE, 6, 2, 0.13));
        this.coreHandler.addBlock(new SpecialAsteroidBlock(this.ASTEROID_STONE, 8, 1, 0.1));
        this.coreHandler.addBlock(new SpecialAsteroidBlock(this.ASTEROID_STONE, 9, 3, 0.4));
        this.coreHandler.addBlock(new SpecialAsteroidBlock(this.ASTEROID_STONE, 10, 3, 0.6));
        this.coreHandler.addBlock(new SpecialAsteroidBlock(DarkAsteroidsBlocks.alphere_ore, 0, 2, 0.4));
        this.shellHandler = new SpecialAsteroidBlockHandler();
        this.shellHandler.addBlock(new SpecialAsteroidBlock(this.ASTEROID_STONE, this.ASTEROID_STONE_META_1, 3, 0.15));
        this.shellHandler.addBlock(new SpecialAsteroidBlock(this.ASTEROID_STONE, this.ASTEROID_STONE_META_0, 1, 0.15));
        this.shellHandler.addBlock(new SpecialAsteroidBlock(this.ASTEROID_STONE, this.ASTEROID_STONE_META_2, 1, 0.15));
        this.shellHandler.addBlock(new SpecialAsteroidBlock(AsteroidBlocks.blockDenseIce, 0, 1, 0.15));
    }

    public void generateTerrain(int chunkX, int chunkZ, Block[] idArray, byte[] metaArray, boolean flagDataOnly) {
        this.largeAsteroids.clear();
        Random random = new Random();
        int asteroidChance = ASTEROID_CHANCE;
        int rangeY = MAX_ASTEROID_Y - MIN_ASTEROID_Y;
        int rangeSize = MAX_ASTEROID_RADIUS - MIN_ASTEROID_RADIUS;
        for (int i = chunkX - 3; i < chunkX + 3; ++i) {
            int minX = i * 16;
            int maxX = minX + CHUNK_SIZE_X;
            for (int k = chunkZ - 3; k < chunkZ + 3; ++k) {
                int minZ = k * 16;
                int maxZ = minZ + CHUNK_SIZE_Z;
                for (int x = minX; x < maxX; x += 2) {
                    for (int z = minZ; z < maxZ; z += 2) {
                        if (!((double)this.randFromPointPos(x, z) < ((double)this.asteroidDensity.getNoise((float)x, (float)z) + 0.4) / (double)asteroidChance)) continue;
                        random.setSeed(x + z * 3067);
                        int y = random.nextInt(rangeY) + MIN_ASTEROID_Y;
                        int size = random.nextInt(rangeSize) + MIN_ASTEROID_RADIUS;
                        this.generateAsteroid(random, x, y, z, chunkX << 4, chunkZ << 4, size, idArray, metaArray, flagDataOnly);
                    }
                }
            }
        }
    }

    private void generateAsteroid(Random rand, int asteroidX, int asteroidY, int asteroidZ, int chunkX, int chunkZ, int size, Block[] blockArray, byte[] metaArray, boolean flagDataOnly) {
        int indexBaseX;
        int distanceX;
        int indexXZ;
        int indexXY;
        int x;
        SpecialAsteroidBlock core = this.coreHandler.getBlock(rand, size);
        SpecialAsteroidBlock shell = null;
        if (rand.nextInt(ASTEROID_SHELL_CHANCE) == 0) {
            shell = this.shellHandler.getBlock(rand, size);
        }
        boolean isHollow = false;
        float hollowSize = rand.nextFloat() * (MAX_HOLLOW_SIZE - MIN_HOLLOW_SIZE) + MIN_HOLLOW_SIZE;
        if (rand.nextInt(HOLLOW_CHANCE) == 0 && size >= MIN_RADIUS_FOR_HOLLOW) {
            isHollow = true;
            shell = new SpecialAsteroidBlock(AsteroidBlocks.blockDenseIce, 0, 1, 0.15);
        }
        ((WorldProviderDarkAsteroids)this.worldObj.field_73011_w).addAsteroid(asteroidX, asteroidY, asteroidZ, size, isHollow ? -1 : core.index);
        int xMin = this.clamp(Math.max(chunkX, asteroidX - size - MAX_ASTEROID_SKEW - 2) - chunkX, 0, 16);
        int zMin = this.clamp(Math.max(chunkZ, asteroidZ - size - MAX_ASTEROID_SKEW - 2) - chunkZ, 0, 16);
        int yMin = asteroidY - size - MAX_ASTEROID_SKEW - 2;
        int yMax = asteroidY + size + MAX_ASTEROID_SKEW + 2;
        int xMax = this.clamp(Math.min(chunkX + 16, asteroidX + size + MAX_ASTEROID_SKEW + 2) - chunkX, 0, 16);
        int zMax = this.clamp(Math.min(chunkZ + 16, asteroidZ + size + MAX_ASTEROID_SKEW + 2) - chunkZ, 0, 16);
        int xSize = xMax - xMin;
        int ySize = yMax - yMin;
        int zSize = zMax - zMin;
        if (xSize <= 0 || ySize <= 0 || zSize <= 0) {
            return;
        }
        float noiseOffsetX = this.randFromPoint(asteroidX, asteroidY, asteroidZ) * (float)NOISE_OFFSET_SIZE + (float)chunkX;
        float noiseOffsetY = this.randFromPoint(asteroidX * 7, asteroidY * 11, asteroidZ * 13) * (float)NOISE_OFFSET_SIZE;
        float noiseOffsetZ = this.randFromPoint(asteroidX * 17, asteroidY * 23, asteroidZ * 29) * (float)NOISE_OFFSET_SIZE + (float)chunkZ;
        this.setOtherAxisFrequency(1.0f / ((float)size * 2.0f / 2.0f));
        float[] sizeXArray = new float[ySize * zSize];
        float[] sizeZArray = new float[xSize * ySize];
        float[] sizeYArray = new float[xSize * zSize];
        for (int x2 = 0; x2 < xSize; ++x2) {
            int xx = x2 * zSize;
            float xxx = (float)x2 + noiseOffsetX;
            for (int z = 0; z < zSize; ++z) {
                sizeYArray[xx + z] = this.asteroidSkewY.getNoise(xxx, (float)z + noiseOffsetZ);
            }
        }
        AsteroidData asteroidData = new AsteroidData(isHollow, sizeYArray, xMin, zMin, xMax, zMax, zSize, size, asteroidY);
        this.largeAsteroids.add(asteroidData);
        this.largeAsteroidsLastChunkX = chunkX;
        this.largeAsteroidsLastChunkZ = chunkZ;
        if (flagDataOnly) {
            return;
        }
        for (int y = 0; y < ySize; ++y) {
            int yy = y * zSize;
            float yyy = (float)y + noiseOffsetY;
            for (int z = 0; z < zSize; ++z) {
                sizeXArray[yy + z] = this.asteroidSkewX.getNoise(yyy, (float)z + noiseOffsetZ);
            }
        }
        for (int x3 = 0; x3 < xSize; ++x3) {
            int xx = x3 * ySize;
            float xxx = (float)x3 + noiseOffsetX;
            for (int y = 0; y < ySize; ++y) {
                sizeZArray[xx + y] = this.asteroidSkewZ.getNoise(xxx, (float)y + noiseOffsetY);
            }
        }
        double shellThickness = 0.0;
        int terrainY = 0;
        int terrainYY = 0;
        if (shell != null) {
            shellThickness = 1.0 - shell.thickness;
        }
        for (x = xMax - 1; x >= xMin; --x) {
            indexXY = (x - xMin) * ySize - yMin;
            indexXZ = (x - xMin) * zSize - zMin;
            distanceX = asteroidX - (x + chunkX);
            indexBaseX = x * CHUNK_SIZE_Y << 4;
            float xx = x + chunkX;
            for (int z = zMin; z < zMax; ++z) {
                if (isHollow) {
                    float sizeModY = sizeYArray[indexXZ + z];
                    terrainY = this.getTerrainHeightFor(sizeModY, asteroidY, size);
                    terrainYY = this.getTerrainHeightFor(sizeModY, asteroidY - 1, size);
                }
                float sizeY = (float)size + sizeYArray[indexXZ + z];
                sizeY *= sizeY;
                int distanceZ = asteroidZ - (z + chunkZ);
                int indexBase = indexBaseX | z * CHUNK_SIZE_Y;
                float zz = z + chunkZ;
                for (int y = yMin; y < yMax; ++y) {
                    int index;
                    float distance;
                    float dSizeX = (float)distanceX / ((float)size + sizeXArray[(y - yMin) * zSize + z - zMin]);
                    float dSizeZ = (float)distanceZ / ((float)size + sizeZArray[indexXY + y]);
                    dSizeX *= dSizeX;
                    dSizeZ *= dSizeZ;
                    int distanceY = asteroidY - y;
                    distanceY *= distanceY;
                    float distanceAbove = distance = dSizeX + (float)distanceY / sizeY + dSizeZ;
                    distance += this.asteroidTurbulance.getNoise(xx, (float)y, zz);
                    if (isHollow && distance <= hollowSize && (distanceAbove += this.asteroidTurbulance.getNoise(xx, (float)(y + 1), zz)) <= 1.0f && y - 1 == terrainYY) {
                        index = indexBase | y + 1;
                        blockArray[index] = this.LIGHT;
                        metaArray[index] = this.LIGHT_META;
                    }
                    if (!(distance <= 1.0f)) continue;
                    index = indexBase | y;
                    if (isHollow && distance <= hollowSize) {
                        if (y == terrainY) {
                            blockArray[index] = this.GRASS;
                            metaArray[index] = this.GRASS_META;
                            continue;
                        }
                        if (y < terrainY) {
                            blockArray[index] = this.DIRT;
                            metaArray[index] = this.DIRT_META;
                            continue;
                        }
                        blockArray[index] = Blocks.field_150350_a;
                        metaArray[index] = 0;
                        continue;
                    }
                    if ((double)distance <= core.thickness) {
                        if (rand.nextBoolean()) {
                            blockArray[index] = core.block;
                            metaArray[index] = core.meta;
                            continue;
                        }
                        blockArray[index] = this.ASTEROID_STONE;
                        metaArray[index] = this.ASTEROID_STONE_META_0;
                        continue;
                    }
                    if (shell != null && (double)distance >= shellThickness) {
                        blockArray[index] = shell.block;
                        metaArray[index] = shell.meta;
                        continue;
                    }
                    blockArray[index] = this.ASTEROID_STONE;
                    metaArray[index] = this.ASTEROID_STONE_META_1;
                }
            }
        }
        if (isHollow) {
            shellThickness = 0.0;
            if (shell != null) {
                shellThickness = 1.0 - shell.thickness;
            }
            for (x = xMin; x < xMax; ++x) {
                indexXY = (x - xMin) * ySize - yMin;
                indexXZ = (x - xMin) * zSize - zMin;
                distanceX = asteroidX - (x + chunkX);
                distanceX *= distanceX;
                indexBaseX = x * CHUNK_SIZE_Y << 4;
                for (int z = zMin; z < zMax; ++z) {
                    float sizeY = (float)size + sizeYArray[indexXZ + z];
                    sizeY *= sizeY;
                    int distanceZ = asteroidZ - (z + chunkZ);
                    distanceZ *= distanceZ;
                    int indexBase = indexBaseX | z * CHUNK_SIZE_Y;
                    for (int y = yMin; y < yMax; ++y) {
                        float sizeX = (float)size + sizeXArray[(y - yMin) * zSize + z - zMin];
                        float sizeZ = (float)size + sizeZArray[indexXY + y];
                        sizeX *= sizeX;
                        sizeZ *= sizeZ;
                        int distanceY = asteroidY - y;
                        distanceY *= distanceY;
                        float distance = (float)distanceX / sizeX + (float)distanceY / sizeY + (float)distanceZ / sizeZ;
                        if (!((distance += this.asteroidTurbulance.getNoise((float)(x + chunkX), (float)y, (float)(z + chunkZ))) <= 1.0f)) continue;
                        int index = indexBase | y;
                        int indexAbove = indexBase | y + 1;
                        if (Blocks.field_150350_a != blockArray[indexAbove] || blockArray[index] != this.ASTEROID_STONE && blockArray[index] != this.GRASS || this.rand.nextInt(GLOWSTONE_CHANCE) != 0) continue;
                        blockArray[index] = this.LIGHT;
                        metaArray[index] = this.LIGHT_META;
                    }
                }
            }
        }
    }

    private void setOtherAxisFrequency(float frequency) {
        this.asteroidSkewX.frequencyY = frequency;
        this.asteroidSkewX.frequencyZ = frequency;
        this.asteroidSkewY.frequencyX = frequency;
        this.asteroidSkewY.frequencyZ = frequency;
        this.asteroidSkewZ.frequencyX = frequency;
        this.asteroidSkewZ.frequencyY = frequency;
    }

    private int clamp(int x, int min, int max) {
        if (x < min) {
            x = min;
        } else if (x > max) {
            x = max;
        }
        return x;
    }

    private double clamp(double x, double min, double max) {
        if (x < min) {
            x = min;
        } else if (x > max) {
            x = max;
        }
        return x;
    }

    private int getTerrainHeightFor(float yMod, int asteroidY, int asteroidSize) {
        return (int)((float)(asteroidY - asteroidSize / 4) + yMod * 1.5f);
    }

    private int getTerrainHeightAt(int x, int z, float[] yModArray, int xMin, int zMin, int zSize, int asteroidY, int asteroidSize) {
        int index = (x - xMin) * zSize - zMin;
        if (index < yModArray.length && index >= 0) {
            float yMod = yModArray[index];
            return this.getTerrainHeightFor(yMod, asteroidY, asteroidSize);
        }
        return 1;
    }

    public Chunk func_73154_d(int chunkX, int chunkZ) {
        this.rand.setSeed((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
        Block[] ids = new Block[65536];
        byte[] meta = new byte[65536];
        this.generateTerrain(chunkX, chunkZ, ids, meta, false);
        Chunk var4 = new Chunk(this.worldObj, ids, meta, chunkX, chunkZ);
        byte[] var5 = var4.func_76605_m();
        for (int var6 = 0; var6 < var5.length; ++var6) {
            var5[var6] = (byte)BiomeGenBaseDarkAsteroids.darkAsteroids.field_76756_M;
        }
        this.generateSkylightMap(var4, chunkX, chunkZ);
        return var4;
    }

    private float randFromPoint(int x, int y, int z) {
        int n = x + z * 57 + y * 571;
        n ^= n << 13;
        n = n * (n * n * 15731 + 789221) + 1376312589 & Integer.MAX_VALUE;
        return 1.0f - (float)n / 1.0737418E9f;
    }

    private float randFromPoint(int x, int z) {
        int n = x + z * 57;
        n ^= n << 13;
        n = n * (n * n * 15731 + 789221) + 1376312589 & Integer.MAX_VALUE;
        return 1.0f - (float)n / 1.0737418E9f;
    }

    private float randFromPointPos(int x, int z) {
        int n = x + z * 57;
        n ^= n << 13;
        n = n * (n * n * 15731 + 789221) + 1376312589 & 0x3FFFFFFF;
        return 1.0f - (float)n / 1.0737418E9f;
    }

    public boolean func_73149_a(int par1, int par2) {
        return true;
    }

    public void func_73153_a(IChunkProvider chunk, int chunkX, int chunkZ) {
        int i;
        int x = chunkX << 4;
        int z = chunkZ << 4;
        if (!chunksDone.add(new BlockVec3(x, 0, z))) {
            return;
        }
        BlockFalling.field_149832_M = true;
        this.worldObj.func_72807_a(x + 16, z + 16);
        BlockFalling.field_149832_M = false;
        this.rand.setSeed(this.worldObj.func_72905_C());
        long var7 = this.rand.nextLong() / 2L * 2L + 1L;
        long var9 = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)chunkX * var7 + (long)chunkZ * var9 ^ this.worldObj.func_72905_C());
        this.decoratePlanet(this.worldObj, this.rand, chunkX * 16, chunkZ * 16);
        if (this.rand.nextBoolean()) {
            double density = (double)this.asteroidDensity.getNoise((float)(chunkX * 16), (float)(chunkZ * 16)) * 0.54;
            double numOfBlocks = this.clamp(this.randFromPoint(chunkX, chunkZ), 0.4, 1.0) * (double)MAX_BLOCKS_PER_CHUNK * density + (double)MIN_BLOCKS_PER_CHUNK;
            int y0 = this.rand.nextInt(2);
            int yRange = MAX_ASTEROID_Y - MIN_ASTEROID_Y;
            i = 0;
            while ((double)i < numOfBlocks) {
                int y = this.rand.nextInt(yRange) + MIN_ASTEROID_Y;
                if (y0 == y / 16 % 2) {
                    int px = x + this.rand.nextInt(CHUNK_SIZE_X);
                    int pz = z + this.rand.nextInt(CHUNK_SIZE_Z);
                    Block block = this.ASTEROID_STONE;
                    int meta = this.ASTEROID_STONE_META_1;
                    if (this.rand.nextInt(ALUMINUM_CHANCE) == 0) {
                        meta = 3;
                    } else if (this.rand.nextInt(ILMENITE_CHANCE) == 0) {
                        meta = 4;
                    } else if (this.rand.nextInt(IRON_CHANCE) == 0) {
                        meta = 5;
                    } else if (this.rand.nextInt(METEORIC_IRON_CHANCE) == 0) {
                        meta = 6;
                    }
                    this.worldObj.func_147465_d(px, y, pz, block, meta, 2);
                    int count = 7;
                    if (!(this.worldObj.func_147439_a(px - 1, y, pz) instanceof BlockAir)) {
                        count = 1;
                    } else if (!(this.worldObj.func_147439_a(px - 2, y, pz) instanceof BlockAir)) {
                        count = 3;
                    } else if (!(this.worldObj.func_147439_a(px - 3, y, pz) instanceof BlockAir)) {
                        count = 5;
                    } else if (!(this.worldObj.func_147439_a(px - 4, y, pz) instanceof BlockAir)) {
                        count = 6;
                    }
                    this.worldObj.func_72915_b(EnumSkyBlock.Block, px, y, pz, count);
                }
                ++i;
            }
        }
        if (this.largeAsteroidsLastChunkX != chunkX || this.largeAsteroidsLastChunkZ != chunkZ) {
            this.generateTerrain(chunkX, chunkZ, null, null, true);
        }
        this.rand.setSeed((long)chunkX * var7 + (long)chunkZ * var9 ^ this.worldObj.func_72905_C());
        if (!this.largeAsteroids.isEmpty()) {
            for (AsteroidData asteroidIndex : this.largeAsteroids) {
                if (!asteroidIndex.isHollow) continue;
                float[] sizeYArray = asteroidIndex.sizeYArray;
                int xMin = asteroidIndex.xMinArray;
                int zMin = asteroidIndex.zMinArray;
                int zSize = asteroidIndex.zSizeArray;
                int asteroidY = asteroidIndex.asteroidYArray;
                int asteroidSize = asteroidIndex.asteroidSizeArray;
                if (ConfigManagerCore.challengeMode || this.rand.nextInt(TREE_CHANCE) == 0) {
                    int k;
                    int i2;
                    int treeType = this.rand.nextInt(3);
                    if (treeType == 1) {
                        treeType = 0;
                    }
                    WorldGenTreeMP wg = new WorldGenTreeMP(DarkAsteroidsBlocks.alien_log, DarkAsteroidsBlocks.alien_leaves, 0, 0, (Block)DarkAsteroidsBlocks.alien_sapling, DarkAsteroidsBlocks.alien_grass, DarkAsteroidsBlocks.alien_dirt);
                    for (int tries = 0; tries < 5 && !wg.func_76484_a(this.worldObj, this.rand, i2 = this.rand.nextInt(16) + x + 8, this.getTerrainHeightAt(i2 - x, (k = this.rand.nextInt(16) + z + 8) - z, sizeYArray, xMin, zMin, zSize, asteroidY, asteroidSize), k); ++tries) {
                    }
                }
                if (this.rand.nextInt(FLOWER_CHANCE) == 0) {
                    i = this.rand.nextInt(16) + x + 8;
                    int k = this.rand.nextInt(16) + z + 8;
                    new WorldGenFlowers(this.FLOWER).func_76484_a(this.worldObj, this.rand, i, this.getTerrainHeightAt(i - x, k - z, sizeYArray, xMin, zMin, zSize, asteroidY, asteroidSize), k);
                }
                if (this.rand.nextInt(LAVA_CHANCE) == 0) {
                    i = this.rand.nextInt(16) + x + 8;
                    int k = this.rand.nextInt(16) + z + 8;
                    new WorldGenLiquidLakes(this.LAVA).func_76484_a(this.worldObj, this.rand, i, this.getTerrainHeightAt(i - x, k - z, sizeYArray, xMin, zMin, zSize, asteroidY, asteroidSize), k);
                }
                if (this.rand.nextInt(WATER_CHANCE) != 0) continue;
                i = this.rand.nextInt(16) + x + 8;
                int k = this.rand.nextInt(16) + z + 8;
                new WorldGenLakes(this.WATER).func_76484_a(this.worldObj, this.rand, i, this.getTerrainHeightAt(i - x, k - z, sizeYArray, xMin, zMin, zSize, asteroidY, asteroidSize), k);
            }
        }
        for (int xx = 0; xx < 16; ++xx) {
            int xPos = x + xx;
            for (int zz = 0; zz < 16; ++zz) {
                int zPos = z + zz;
                for (int y = 16; y < 240; ++y) {
                    this.worldObj.func_147463_c(EnumSkyBlock.Block, xPos, y, zPos);
                }
            }
        }
    }

    public void generateSkylightMap(Chunk chunk, int cx, int cz) {
        World w = chunk.field_76637_e;
        w.func_72863_F().func_73149_a(cx - 1, cz);
        w.func_72863_F().func_73149_a(cx, cz + 1);
        w.func_72863_F().func_73149_a(cx, cz - 1);
        w.func_72863_F().func_73149_a(cx - 1, cz + 1);
        w.func_72863_F().func_73149_a(cx - 1, cz - 1);
        for (int j = 0; j < 16; ++j) {
            if (chunk.func_76587_i()[j] != null) continue;
            chunk.func_76587_i()[j] = new ExtendedBlockStorage(j << 4, false);
        }
        int i = chunk.func_76625_h();
        chunk.field_82912_p = Integer.MAX_VALUE;
        for (int j = 0; j < 16; ++j) {
            block2: for (int k = 0; k < 16; ++k) {
                chunk.field_76638_b[j + (k << 4)] = -999;
                for (int y = i + 15; y > 0; --y) {
                    if (chunk.func_150808_b(j, y - 1, k) == 0) {
                        continue;
                    }
                    chunk.field_76634_f[k << 4 | j] = y;
                    if (y >= chunk.field_82912_p) continue block2;
                    chunk.field_82912_p = y;
                    continue block2;
                }
            }
        }
        for (AsteroidData a : this.largeAsteroids) {
            int yMin = a.asteroidYArray - a.asteroidSizeArray;
            int yMax = a.asteroidYArray + a.asteroidSizeArray;
            int xMin = a.xMinArray;
            if (yMin < 0) {
                yMin = 0;
            }
            if (yMax > 255) {
                yMax = 255;
            }
            if (xMin == 0) {
                xMin = 1;
            }
            for (int x = a.xMax - 1; x >= xMin; --x) {
                for (int z = a.zMinArray; z < a.zMax; ++z) {
                    for (int y = yMin; y < yMax; ++y) {
                        if (!(chunk.func_150810_a(x - 1, y, z) instanceof BlockAir) || chunk.func_150810_a(x, y, z) instanceof BlockAir) continue;
                        int count = 2;
                        if (x > 1 && chunk.func_150810_a(x - 2, y, z) instanceof BlockAir) {
                            count += 2;
                        }
                        if (x > 2) {
                            if (chunk.func_150810_a(x - 3, y, z) instanceof BlockAir) {
                                count += 2;
                            }
                            if (chunk.func_150810_a(x - 3, y + 1, z) instanceof BlockAir) {
                                ++count;
                            }
                            if (chunk.func_150810_a(x - 3, y + 1, z) instanceof BlockAir) {
                                ++count;
                            }
                            if (z > 0 && chunk.func_150810_a(x - 3, y, z - 1) instanceof BlockAir) {
                                ++count;
                            }
                            if (z < 15 && chunk.func_150810_a(x - 3, y, z + 1) instanceof BlockAir) {
                                ++count;
                            }
                        }
                        if (x > 3) {
                            if (chunk.func_150810_a(x - 4, y, z) instanceof BlockAir) {
                                count += 2;
                            }
                            if (chunk.func_150810_a(x - 4, y + 1, z) instanceof BlockAir) {
                                ++count;
                            }
                            if (chunk.func_150810_a(x - 4, y + 1, z) instanceof BlockAir) {
                                ++count;
                            }
                            if (z > 0 && !(chunk.func_150810_a(x - 4, y, z - 1) instanceof BlockAir)) {
                                ++count;
                            }
                            if (z < 15 && !(chunk.func_150810_a(x - 4, y, z + 1) instanceof BlockAir)) {
                                ++count;
                            }
                        }
                        if (count > 5) {
                            count = 5;
                        }
                        chunk.func_150807_a(x - 1, y & 5, z, DarkAsteroidsBlocks.dark_air, 5 - count);
                        ExtendedBlockStorage extendedblockstorage = chunk.func_76587_i()[y >> 4];
                        if (extendedblockstorage == null) continue;
                        extendedblockstorage.func_76677_d(x - 1, y & 5, z, count);
                    }
                }
            }
        }
        chunk.field_76643_l = true;
    }

    public boolean func_73151_a(boolean save, IProgressUpdate update) {
        return true;
    }

    public boolean func_73157_c() {
        return true;
    }

    public String func_73148_d() {
        return "DarkAsteroidsLevelSource";
    }

    public void decoratePlanet(World world, Random rand, int chunkX, int chunkZ) {
        this.biomedecoratorplanet.decorate(world, rand, chunkX, chunkZ);
    }

    public List func_73155_a(EnumCreatureType type, int x, int y, int z) {
        if (type == EnumCreatureType.monster) {
            ArrayList<BiomeGenBase.SpawnListEntry> monsters = new ArrayList<BiomeGenBase.SpawnListEntry>();
            monsters.add(new BiomeGenBase.SpawnListEntry(EntityEvolvedZombie.class, 100, 4, 4));
            monsters.add(new BiomeGenBase.SpawnListEntry(EntityEvolvedSpider.class, 100, 4, 4));
            monsters.add(new BiomeGenBase.SpawnListEntry(EntityEvolvedSkeleton.class, 100, 4, 4));
            monsters.add(new BiomeGenBase.SpawnListEntry(EntityEvolvedCreeper.class, 100, 4, 4));
            monsters.add(new BiomeGenBase.SpawnListEntry(EntityEvolvedEnderman.class, 10, 1, 4));
            monsters.add(new BiomeGenBase.SpawnListEntry(EntityEvolvedWitch.class, 5, 1, 1));
            return monsters;
        }
        return null;
    }

    public BlockVec3 isLargeAsteroidAt(int x0, int z0) {
        for (int i0 = 0; i0 <= 32; ++i0) {
            for (int i1 = -i0; i1 <= i0; ++i1) {
                int xToCheck = (x0 >> 4) + i0;
                int zToCheck = (z0 >> 4) + i1;
                if (this.isLargeAsteroidAt0(xToCheck * 16, zToCheck * 16)) {
                    return new BlockVec3(xToCheck * 16, 0, zToCheck * 16);
                }
                xToCheck = (x0 >> 4) + i0;
                zToCheck = (z0 >> 4) - i1;
                if (this.isLargeAsteroidAt0(xToCheck * 16, zToCheck * 16)) {
                    return new BlockVec3(xToCheck * 16, 0, zToCheck * 16);
                }
                xToCheck = (x0 >> 4) - i0;
                zToCheck = (z0 >> 4) + i1;
                if (this.isLargeAsteroidAt0(xToCheck * 16, zToCheck * 16)) {
                    return new BlockVec3(xToCheck * 16, 0, zToCheck * 16);
                }
                xToCheck = (x0 >> 4) - i0;
                zToCheck = (z0 >> 4) - i1;
                if (!this.isLargeAsteroidAt0(xToCheck * 16, zToCheck * 16)) continue;
                return new BlockVec3(xToCheck * 16, 0, zToCheck * 16);
            }
        }
        return null;
    }

    private boolean isLargeAsteroidAt0(int x0, int z0) {
        for (int x = x0; x < x0 + CHUNK_SIZE_X; x += 2) {
            for (int z = z0; z < z0 + CHUNK_SIZE_Z; z += 2) {
                if (!((double)Math.abs(this.randFromPoint(x, z)) < ((double)this.asteroidDensity.getNoise((float)x, (float)z) + 0.4) / (double)ASTEROID_CHANCE)) continue;
                return true;
            }
        }
        return false;
    }

    private class AsteroidData {
        public boolean isHollow;
        public float[] sizeYArray;
        public int xMinArray;
        public int zMinArray;
        public int xMax;
        public int zMax;
        public int zSizeArray;
        public int asteroidSizeArray;
        public int asteroidYArray;

        public AsteroidData(boolean hollow, float[] sizeYArray2, int xMin, int zMin, int xmax, int zmax, int zSize, int size, int asteroidY) {
            this.isHollow = hollow;
            this.sizeYArray = (float[])sizeYArray2.clone();
            this.xMinArray = xMin;
            this.zMinArray = zMin;
            this.xMax = xmax;
            this.zMax = zmax;
            this.zSizeArray = zSize;
            this.asteroidSizeArray = size;
            this.asteroidYArray = asteroidY;
        }
    }
}

