/*
 * Decompiled with CFR 0.152.
 */
package de.shittyco.morematerials;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import de.shittyco.morematerials.BlockBackslashWoodenFrame;
import de.shittyco.morematerials.BlockBrickWall;
import de.shittyco.morematerials.BlockCrossWoodenFrame;
import de.shittyco.morematerials.BlockGenericWall;
import de.shittyco.morematerials.BlockHardenedClayWall;
import de.shittyco.morematerials.BlockSlashWoodenFrame;
import de.shittyco.morematerials.BlockStainedBrickSlab;
import de.shittyco.morematerials.BlockStainedBrickStairs;
import de.shittyco.morematerials.BlockStainedBrickWall;
import de.shittyco.morematerials.BlockStainedBricks;
import de.shittyco.morematerials.BlockStainedHardenedClayWall;
import de.shittyco.morematerials.BlockWoodenFrame;
import de.shittyco.morematerials.ItemBlockStainedBrickSlab;
import de.shittyco.morematerials.ItemBlockStainedBricks;
import de.shittyco.morematerials.ItemBlockWoodenFrame;
import de.shittyco.morematerials.ItemBrickClay;
import de.shittyco.morematerials.ItemDaub;
import de.shittyco.morematerials.ItemPaintbrush;
import de.shittyco.morematerials.ItemStainedBrick;
import de.shittyco.morematerials.ItemStainedBrickClay;
import de.shittyco.morematerials.WoodUtility;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSlab;
import net.minecraft.item.ItemStack;

@Mod(modid="morematerials", version="0.9.20150214.0")
public class MoreMaterialsMod {
    public static final String MODID = "morematerials";
    public static final String VERSION = "0.9.20150214.0";
    private static ItemBrickClay brickClay;
    private static ItemPaintbrush paintbrush;
    private static ItemStainedBrickClay stainedBrickClay;
    private static ItemStainedBrick stainedBrick;
    private static BlockStainedBricks stainedBrickBlocks;
    private static BlockStainedBrickSlab[] stainedBrickSlabBlocks;
    private static ItemSlab[] stainedBrickSlabItemBlocks;
    private static BlockStainedBrickWall[] stainedBrickWallBlocks;
    private static BlockBrickWall brickWall;
    private static BlockHardenedClayWall hardenedClayWall;
    private static BlockStainedHardenedClayWall[] stainedHardenedClayWallBlocks;
    private static ItemDaub daub;
    private static BlockWoodenFrame woodenFrame;
    private static BlockCrossWoodenFrame crossWoodenFrame;
    private static BlockSlashWoodenFrame slashWoodenFrame;
    private static BlockBackslashWoodenFrame backslashWoodenFrame;
    private static final float SMELTINGXP = 0.1f;
    private static final int STAIRS_QUANTITY = 4;
    private static final int WALL_QUANTITY = 6;
    private static final int SLAB_QUANTITY = 6;
    private static final int BRICK_QUANTITY = 8;
    private static final int DAUB_QUANTITY = 5;
    private static final int WOODEN_FRAME_QUANTITY = 8;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
    }

    @Mod.EventHandler
    public final void init(FMLInitializationEvent event) {
        this.initTools();
        this.initBricks();
        this.initWattleAndDaub();
        this.initHardenedClay();
    }

    private static void addSlabRecipes(BlockSlab result, int resultMetadata, Block source, int sourceMetadata) {
        ItemStack resultStack = new ItemStack((Block)result, 6, resultMetadata);
        ItemStack sourceStack = new ItemStack(source, 1, sourceMetadata);
        GameRegistry.addRecipe((ItemStack)resultStack, (Object[])new Object[]{"xxx", "   ", "   ", Character.valueOf('x'), sourceStack});
        GameRegistry.addRecipe((ItemStack)resultStack, (Object[])new Object[]{"   ", "xxx", "   ", Character.valueOf('x'), sourceStack});
        GameRegistry.addRecipe((ItemStack)resultStack, (Object[])new Object[]{"   ", "   ", "xxx", Character.valueOf('x'), sourceStack});
    }

    private static void addStairsRecipes(BlockStairs result, int resultMetadata, Block source, int sourceMetadata) {
        ItemStack resultStack = new ItemStack((Block)result, 4, resultMetadata);
        ItemStack sourceStack = new ItemStack(source, 1, sourceMetadata);
        GameRegistry.addRecipe((ItemStack)resultStack, (Object[])new Object[]{"x  ", "xx ", "xxx", Character.valueOf('x'), sourceStack});
        GameRegistry.addRecipe((ItemStack)resultStack, (Object[])new Object[]{"  x", " xx", "xxx", Character.valueOf('x'), sourceStack});
    }

    private static void addWallRecipe(BlockGenericWall result, int resultMetadata, Block source, int sourceMetadata) {
        ItemStack resultStack = new ItemStack((Block)result, 6, resultMetadata);
        ItemStack sourceStack = new ItemStack(source, 1, sourceMetadata);
        GameRegistry.addRecipe((ItemStack)resultStack, (Object[])new Object[]{"xxx", "xxx", "   ", Character.valueOf('x'), sourceStack});
        GameRegistry.addRecipe((ItemStack)resultStack, (Object[])new Object[]{"   ", "xxx", "xxx", Character.valueOf('x'), sourceStack});
    }

    private void initTools() {
        paintbrush = new ItemPaintbrush();
        GameRegistry.registerItem((Item)paintbrush, (String)"paintbrush");
    }

    private void initBricks() {
        brickClay = new ItemBrickClay();
        stainedBrickClay = new ItemStainedBrickClay();
        stainedBrick = new ItemStainedBrick();
        stainedBrickBlocks = new BlockStainedBricks();
        stainedBrickSlabBlocks = new BlockStainedBrickSlab[32];
        stainedBrickSlabItemBlocks = new ItemSlab[32];
        stainedBrickWallBlocks = new BlockStainedBrickWall[16];
        GameRegistry.registerItem((Item)brickClay, (String)"brickclay");
        GameRegistry.registerItem((Item)stainedBrickClay, (String)"stained_brickclay");
        GameRegistry.registerItem((Item)stainedBrick, (String)"stained_brick");
        GameRegistry.registerBlock((Block)stainedBrickBlocks, ItemBlockStainedBricks.class, (String)"stained_bricks_block");
        brickWall = new BlockBrickWall();
        GameRegistry.registerBlock((Block)brickWall, (String)"brick_wall");
        MoreMaterialsMod.addWallRecipe(brickWall, 0, Blocks.field_150336_V, 0);
        for (int i = 0; i < 16; ++i) {
            BlockStainedBrickWall wall;
            BlockStainedBrickSlab slab = new BlockStainedBrickSlab(false, i);
            BlockStainedBrickSlab doubleSlab = new BlockStainedBrickSlab(true, i);
            ItemSlab itemSlab = new ItemSlab((Block)slab, (BlockSlab)slab, (BlockSlab)doubleSlab, false);
            ItemSlab itemDoubleSlab = new ItemSlab((Block)doubleSlab, (BlockSlab)slab, (BlockSlab)doubleSlab, true);
            MoreMaterialsMod.stainedBrickSlabBlocks[2 * i] = slab;
            MoreMaterialsMod.stainedBrickSlabBlocks[2 * i + 1] = doubleSlab;
            MoreMaterialsMod.stainedBrickSlabItemBlocks[2 * i] = itemSlab;
            MoreMaterialsMod.stainedBrickSlabItemBlocks[2 * i + 1] = itemDoubleSlab;
            GameRegistry.registerBlock((Block)slab, ItemBlockStainedBrickSlab.class, (String)slab.getId(), (Object[])new Object[]{slab, doubleSlab, false});
            GameRegistry.registerBlock((Block)doubleSlab, ItemBlockStainedBrickSlab.class, (String)doubleSlab.getId(), (Object[])new Object[]{slab, doubleSlab, true});
            BlockStainedBrickStairs stairs = new BlockStainedBrickStairs(stainedBrickBlocks, i);
            GameRegistry.registerBlock((Block)stairs, (String)stairs.getId());
            MoreMaterialsMod.addSlabRecipes(slab, 0, stainedBrickBlocks, i);
            MoreMaterialsMod.addStairsRecipes(stairs, 0, stainedBrickBlocks, i);
            MoreMaterialsMod.stainedBrickWallBlocks[i] = wall = new BlockStainedBrickWall(stainedBrickBlocks, i);
            GameRegistry.registerBlock((Block)wall, (String)wall.getId());
            MoreMaterialsMod.addWallRecipe(wall, 0, stainedBrickBlocks, i);
        }
        ItemStack clayStack = new ItemStack(Items.field_151119_aD);
        ItemStack dirtStack = new ItemStack(Blocks.field_150346_d);
        ItemStack sandStack = new ItemStack((Block)Blocks.field_150354_m);
        ItemStack woolStack = new ItemStack(Blocks.field_150325_L);
        ItemStack stickStack = new ItemStack(Items.field_151055_y);
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)brickClay, 8), (Object[])new Object[]{"xy", "zx", Character.valueOf('x'), clayStack, Character.valueOf('y'), dirtStack, Character.valueOf('z'), sandStack});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)paintbrush), (Object[])new Object[]{"x ", "y ", Character.valueOf('x'), woolStack, Character.valueOf('y'), stickStack});
        GameRegistry.addSmelting((Item)brickClay, (ItemStack)new ItemStack(Items.field_151118_aC), (float)0.1f);
        for (int i = 0; i < 16; ++i) {
            ItemStack dye = new ItemStack(Items.field_151100_aR, 1, i);
            ItemStack brickClayStack = new ItemStack((Item)brickClay, 1);
            GameRegistry.addRecipe((ItemStack)new ItemStack((Item)stainedBrickClay, 8, i), (Object[])new Object[]{"xxx", "xyx", "xxx", Character.valueOf('x'), brickClayStack, Character.valueOf('y'), dye});
            ItemStack stainedBrickStack = new ItemStack((Item)stainedBrick, 1, i);
            ItemStack stainedBrickClayStack = new ItemStack((Item)stainedBrickClay, 1, i);
            GameRegistry.addSmelting((ItemStack)stainedBrickClayStack, (ItemStack)stainedBrickStack, (float)0.1f);
            ItemStack stainedBrickBlock = new ItemStack((Block)stainedBrickBlocks, 1, i);
            GameRegistry.addRecipe((ItemStack)stainedBrickBlock, (Object[])new Object[]{"xx", "xx", Character.valueOf('x'), stainedBrickStack});
        }
    }

    private void initWattleAndDaub() {
        daub = new ItemDaub();
        GameRegistry.registerItem((Item)daub, (String)"daub");
        woodenFrame = new BlockWoodenFrame();
        GameRegistry.registerBlock((Block)woodenFrame, ItemBlockWoodenFrame.class, (String)"wooden_frame_block");
        crossWoodenFrame = new BlockCrossWoodenFrame();
        GameRegistry.registerBlock((Block)crossWoodenFrame, ItemBlockWoodenFrame.class, (String)"cross_wooden_frame_block");
        slashWoodenFrame = new BlockSlashWoodenFrame();
        GameRegistry.registerBlock((Block)slashWoodenFrame, ItemBlockWoodenFrame.class, (String)"slash_wooden_frame_block");
        backslashWoodenFrame = new BlockBackslashWoodenFrame();
        GameRegistry.registerBlock((Block)backslashWoodenFrame, ItemBlockWoodenFrame.class, (String)"backslash_wooden_frame_block");
        ItemStack clayStack = new ItemStack(Items.field_151119_aD);
        ItemStack dirtStack = new ItemStack(Blocks.field_150346_d);
        ItemStack sandStack = new ItemStack((Block)Blocks.field_150354_m);
        ItemStack strawStack = new ItemStack(Items.field_151015_O);
        ItemStack stickStack = new ItemStack(Items.field_151055_y);
        Object[] fiberObjects = new Object[]{new ItemStack(Items.field_151015_O), new ItemStack(Items.field_151120_aE), Blocks.field_150345_g, new ItemStack((Block)Blocks.field_150329_H, 1, 1), new ItemStack((Block)Blocks.field_150398_cm, 1, 2)};
        ItemStack daubStack = new ItemStack((Item)daub, 5);
        ItemStack singleDaubStack = new ItemStack((Item)daub);
        for (Object fiberObject : fiberObjects) {
            GameRegistry.addRecipe((ItemStack)daubStack, (Object[])new Object[]{"wx", "yz", Character.valueOf('w'), clayStack, Character.valueOf('x'), dirtStack, Character.valueOf('y'), sandStack, Character.valueOf('z'), fiberObject});
        }
        for (int i = 0; i < WoodUtility.WOOD_TYPE_COUNT; ++i) {
            ItemStack woodenFrameStack = new ItemStack((Block)woodenFrame, 8, i);
            ItemStack woodStack = new ItemStack(Blocks.field_150344_f, 1, i);
            GameRegistry.addRecipe((ItemStack)woodenFrameStack, (Object[])new Object[]{"xyx", "yzy", "xyx", Character.valueOf('x'), stickStack, Character.valueOf('y'), woodStack, Character.valueOf('z'), singleDaubStack});
            ItemStack sourceWoodenFrameStack = new ItemStack((Block)woodenFrame, 1, i);
            ItemStack crossWoodenFrameStack = new ItemStack((Block)crossWoodenFrame, 1, i);
            GameRegistry.addRecipe((ItemStack)crossWoodenFrameStack, (Object[])new Object[]{"x x", " y ", "x x", Character.valueOf('x'), stickStack, Character.valueOf('y'), sourceWoodenFrameStack});
            ItemStack slashWoodenFrameStack = new ItemStack((Block)slashWoodenFrame, 1, i);
            GameRegistry.addRecipe((ItemStack)slashWoodenFrameStack, (Object[])new Object[]{"  x", " x ", "y  ", Character.valueOf('x'), stickStack, Character.valueOf('y'), sourceWoodenFrameStack});
            ItemStack backslashWoodenFrameStack = new ItemStack((Block)backslashWoodenFrame, 1, i);
            GameRegistry.addRecipe((ItemStack)backslashWoodenFrameStack, (Object[])new Object[]{"y  ", " x ", "  x", Character.valueOf('x'), stickStack, Character.valueOf('y'), sourceWoodenFrameStack});
        }
    }

    private void initHardenedClay() {
        hardenedClayWall = new BlockHardenedClayWall();
        GameRegistry.registerBlock((Block)hardenedClayWall, (String)"hardened_clay_wall");
        MoreMaterialsMod.addWallRecipe(hardenedClayWall, 0, Blocks.field_150405_ch, 0);
        stainedHardenedClayWallBlocks = new BlockStainedHardenedClayWall[16];
        for (int i = 0; i < 16; ++i) {
            BlockStainedHardenedClayWall block;
            MoreMaterialsMod.stainedHardenedClayWallBlocks[i] = block = new BlockStainedHardenedClayWall(i);
            GameRegistry.registerBlock((Block)block, (String)block.getId());
            MoreMaterialsMod.addWallRecipe(block, 0, Blocks.field_150406_ce, 16 - i - 1);
        }
    }
}

