/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import logisticspipes.items.LogisticsItem;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.pipes.signs.CraftingPipeSign;
import logisticspipes.pipes.signs.IPipeSign;
import logisticspipes.pipes.signs.ItemAmountPipeSign;
import logisticspipes.proxy.MainProxy;
import logisticspipes.utils.string.StringUtils;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemPipeSignCreator
extends LogisticsItem {
    public static final List<Class<? extends IPipeSign>> signTypes = new ArrayList<Class<? extends IPipeSign>>();
    private IIcon[] itemIcon = new IIcon[2];

    public ItemPipeSignCreator() {
        this.func_77625_d(1);
        this.func_77656_e(250);
    }

    public boolean onItemUseFirst(ItemStack itemStack, EntityPlayer player, World world, int x, int y, int z, int sideinput, float hitX, float hitY, float hitZ) {
        if (MainProxy.isClient(world)) {
            return false;
        }
        if (itemStack.func_77960_j() > this.func_77612_l() || itemStack.field_77994_a == 0) {
            return false;
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        if (!(tile instanceof LogisticsTileGenericPipe)) {
            return false;
        }
        if (!itemStack.func_77942_o()) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        itemStack.func_77978_p().func_74768_a("PipeClicked", 0);
        int mode = itemStack.func_77978_p().func_74762_e("CreatorMode");
        ForgeDirection dir = ForgeDirection.getOrientation((int)sideinput);
        if (dir == ForgeDirection.UNKNOWN) {
            return false;
        }
        if (!(((LogisticsTileGenericPipe)tile).pipe instanceof CoreRoutedPipe)) {
            return false;
        }
        CoreRoutedPipe pipe = (CoreRoutedPipe)((LogisticsTileGenericPipe)tile).pipe;
        if (pipe == null) {
            return false;
        }
        if (!player.func_70093_af()) {
            if (pipe.hasPipeSign(dir)) {
                pipe.activatePipeSign(dir, player);
                return true;
            }
            if (mode >= 0 && mode < signTypes.size()) {
                Class<? extends IPipeSign> signClass = signTypes.get(mode);
                try {
                    IPipeSign sign = signClass.newInstance();
                    if (sign.isAllowedFor(pipe)) {
                        itemStack.func_77972_a(1, (EntityLivingBase)player);
                        sign.addSignTo(pipe, dir, player);
                        return true;
                    }
                    return false;
                }
                catch (InstantiationException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
            return false;
        }
        if (pipe.hasPipeSign(dir)) {
            pipe.removePipeSign(dir, player);
            itemStack.func_77972_a(-1, (EntityLivingBase)player);
        }
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
        super.func_94581_a(par1IconRegister);
        for (int i = 0; i < signTypes.size(); ++i) {
            this.itemIcon[i] = par1IconRegister.func_94245_a("logisticspipes:" + this.func_77658_a().replace("item.", "") + "." + i);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77650_f(ItemStack stack) {
        int mode;
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if ((mode = stack.func_77978_p().func_74762_e("CreatorMode")) < signTypes.size()) {
            return this.itemIcon[mode];
        }
        return super.func_77650_f(stack);
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        int mode;
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if ((mode = stack.func_77978_p().func_74762_e("CreatorMode")) < signTypes.size()) {
            return this.itemIcon[mode];
        }
        return super.getIcon(stack, pass);
    }

    @Override
    public String func_77653_i(ItemStack itemstack) {
        if (!itemstack.func_77942_o()) {
            itemstack.func_77982_d(new NBTTagCompound());
        }
        int mode = itemstack.func_77978_p().func_74762_e("CreatorMode");
        return StringUtils.translate(this.func_77667_c(itemstack) + "." + mode);
    }

    public CreativeTabs func_77640_w() {
        return CreativeTabs.field_78040_i;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (MainProxy.isClient(world)) {
            return stack;
        }
        if (player.func_70093_af()) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            if (!stack.func_77978_p().func_74764_b("PipeClicked")) {
                int mode = stack.func_77978_p().func_74762_e("CreatorMode");
                if (++mode >= signTypes.size()) {
                    mode = 0;
                }
                stack.func_77978_p().func_74768_a("CreatorMode", mode);
            }
        }
        if (stack.func_77942_o()) {
            stack.func_77978_p().func_82580_o("PipeClicked");
        }
        return stack;
    }

    public static void registerPipeSignTypes() {
        signTypes.add(CraftingPipeSign.class);
        signTypes.add(ItemAmountPipeSign.class);
    }
}

