/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.resource;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import wanion.unidict.Config;
import wanion.unidict.MetaItem;
import wanion.unidict.UniOreDictionary;
import wanion.unidict.common.SpecificKindItemStackComparator;
import wanion.unidict.common.Util;
import wanion.unidict.helper.NEIHelper;
import wanion.unidict.resource.ResourceHandler;
import wanion.unidict.resource.UniResourceHandler;

public final class UniResourceContainer {
    public final String name;
    public final long kind;
    private final int id;
    private final List<ItemStack> entries;
    private final int initialSize;
    private boolean sort = false;
    private boolean updated = false;
    private Item mainEntryItem;
    private int mainEntryMeta;
    private int[] hashes;

    public UniResourceContainer(@Nonnull String name, long kind) {
        this.name = name;
        this.id = UniOreDictionary.getId(this.name);
        this.entries = UniOreDictionary.get(this.id);
        if (this.entries == null) {
            throw new RuntimeException("Something may have broken the Ore Dictionary!");
        }
        this.kind = kind;
        this.initialSize = this.entries.size();
    }

    public UniResourceContainer(@Nonnull String name, long kind, boolean sort) {
        this(name, kind);
        this.setSort(sort);
    }

    public ItemStack getMainEntry() {
        return new ItemStack(this.mainEntryItem, 1, this.mainEntryMeta);
    }

    public ItemStack getMainEntry(int size) {
        return new ItemStack(this.mainEntryItem, size, this.mainEntryMeta);
    }

    public List<ItemStack> getEntries() {
        return UniOreDictionary.getUn(this.id);
    }

    boolean updateEntries() {
        if (this.entries.isEmpty()) {
            return false;
        }
        if (this.updated) {
            return true;
        }
        if (this.sort && this.initialSize != this.entries.size()) {
            this.sort();
        }
        ItemStack mainEntry = this.entries.get(0);
        this.mainEntryItem = mainEntry.func_77973_b();
        this.mainEntryMeta = this.mainEntryItem.getDamage(mainEntry);
        if (this.sort) {
            this.hashes = MetaItem.getArray(this.entries);
            if (Config.autoHideInNEI) {
                this.removeBadEntriesFromNEI();
            }
            if (Config.keepOneEntry) {
                this.keepOneEntry();
            }
        }
        this.updated = true;
        return true;
    }

    int[] getHashes() {
        return this.hashes;
    }

    private void keepOneEntry() {
        if (this.entries.size() == 1) {
            return;
        }
        Set<ItemStack> keepOneEntryBlackSet = ResourceHandler.keepOneEntryBlackSet;
        if (!keepOneEntryBlackSet.isEmpty()) {
            Iterator<ItemStack> keepOneEntryIterator = this.entries.subList(1, this.entries.size()).iterator();
            while (keepOneEntryIterator.hasNext()) {
                if (keepOneEntryBlackSet.contains(keepOneEntryIterator.next())) continue;
                keepOneEntryIterator.remove();
            }
        } else {
            this.entries.subList(1, this.entries.size()).clear();
        }
    }

    private void removeBadEntriesFromNEI() {
        if (this.entries.size() > 1) {
            if (Config.keepOneEntry) {
                this.entries.subList(1, this.entries.size()).forEach(NEIHelper::hide);
            } else if (!UniResourceHandler.getKindBlackSet().contains(this.kind)) {
                this.entries.subList(1, this.entries.size()).forEach(NEIHelper::hide);
            }
        }
    }

    public Comparator<ItemStack> getComparator() {
        return Config.enableSpecificKindSort ? SpecificKindItemStackComparator.getComparatorFor(this.kind) : Util.itemStackComparatorByModName;
    }

    void setSort(boolean sort) {
        this.sort = sort;
        if (this.sort) {
            this.sort();
        }
    }

    public void sort() {
        Comparator<ItemStack> itemStackComparator = this.getComparator();
        if (itemStackComparator != null) {
            Collections.sort(this.entries, itemStackComparator);
        }
    }

    public String toString() {
        return this.name;
    }
}

