/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.integration;

import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import k4unl.minecraft.Hydraulicraft.api.recipes.FluidShapelessOreRecipe;
import k4unl.minecraft.Hydraulicraft.api.recipes.IFluidRecipe;
import k4unl.minecraft.Hydraulicraft.lib.recipes.HydraulicRecipes;
import net.minecraft.item.ItemStack;
import wanion.unidict.UniDict;
import wanion.unidict.UniOreDictionary;
import wanion.unidict.common.FixedSizeList;
import wanion.unidict.helper.ResourceHelper;
import wanion.unidict.integration.AbstractIntegrationThread;
import wanion.unidict.resource.Resource;

final class HydraulicraftIntegration
extends AbstractIntegrationThread {
    private final ResourceHelper resourceHelper = UniDict.getDependencies().get(ResourceHelper.class);
    private final UniOreDictionary uniOreDictionary = UniDict.getDependencies().get(UniOreDictionary.class);
    private final long ore = Resource.getKindOfName("ore");
    private final long chunk = Resource.getKindOfName("chunk");
    private final long dust = Resource.getKindOfName("dust");

    HydraulicraftIntegration() {
        super("Hydraulicraft");
        try {
            if (this.ore > 0L) {
                this.resourceHelper.prepare(this.ore);
            }
            if (this.chunk > 0L) {
                this.resourceHelper.prepare(this.chunk);
            }
            if (this.dust > 0L) {
                this.resourceHelper.prepare(this.dust);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String call() {
        try {
            this.fixHydrulicraftRecipes(HydraulicRecipes.getCrusherRecipes(), false);
            this.fixHydrulicraftRecipes(HydraulicRecipes.getWasherRecipes(), true);
        }
        catch (Exception e) {
            UniDict.getLogger().error(this.threadName + e);
        }
        return this.threadName + "All this pressure...";
    }

    private void fixHydrulicraftRecipes(@Nonnull List<IFluidRecipe> hydrauliCraftRecipeList, boolean onlyOutputItemStack) {
        FixedSizeList<FluidShapelessOreRecipe> newRecipes = new FixedSizeList<FluidShapelessOreRecipe>(hydrauliCraftRecipeList.size());
        Iterator<IFluidRecipe> fluidRecipeIterator = hydrauliCraftRecipeList.iterator();
        while (fluidRecipeIterator.hasNext()) {
            IFluidRecipe fluidRecipe = fluidRecipeIterator.next();
            if (!(fluidRecipe instanceof FluidShapelessOreRecipe)) continue;
            ItemStack correctOutput = this.resourceHandler.getMainItemStack(fluidRecipe.func_77571_b());
            Object[] inputArray = fluidRecipe.getInputItems();
            Object input = inputArray[0];
            long inputKind = this.resourceHelper.get(input);
            long outputKind = this.resourceHelper.get(correctOutput);
            if (inputKind == this.ore && outputKind == this.chunk) {
                correctOutput.field_77994_a = 1;
            } else if (inputKind == this.chunk && outputKind == this.dust) {
                correctOutput.field_77994_a = 2;
            }
            if (!onlyOutputItemStack) {
                newRecipes.add(new FluidShapelessOreRecipe(correctOutput, new Object[]{input instanceof List ? this.uniOreDictionary.getName(input) : (this.resourceHandler.exists((ItemStack)input) ? this.resourceHandler.getContainerName((ItemStack)input) : input)}).setPressure(fluidRecipe.getPressure()).setCraftingTime(fluidRecipe.getCraftingTime()));
            } else {
                newRecipes.add(new FluidShapelessOreRecipe(correctOutput, new Object[]{input instanceof List ? this.resourceHandler.getMainItemStack((ItemStack)((List)input).get(0)) : this.resourceHandler.getMainItemStack((ItemStack)input)}).setPressure(fluidRecipe.getPressure()).setCraftingTime(fluidRecipe.getCraftingTime()));
            }
            fluidRecipeIterator.remove();
        }
        hydrauliCraftRecipeList.addAll(newRecipes);
    }
}

