/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.api.alchemy.energy;

import WayofTime.alchemicalWizardry.api.alchemy.energy.IReagentContainer;
import WayofTime.alchemicalWizardry.api.alchemy.energy.Reagent;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentContainerInfo;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentStack;
import net.minecraft.nbt.NBTTagCompound;

public class ReagentContainer
implements IReagentContainer {
    protected ReagentStack reagentStack;
    protected int capacity;

    public ReagentContainer(int capacity) {
        this(null, capacity);
    }

    public ReagentContainer(ReagentStack stack, int capacity) {
        this.reagentStack = stack;
        this.capacity = capacity;
    }

    public ReagentContainer(Reagent reagent, int amount, int capacity) {
        this(new ReagentStack(reagent, amount), capacity);
    }

    public static ReagentContainer readFromNBT(NBTTagCompound nbt) {
        ReagentStack reagent = ReagentStack.loadReagentStackFromNBT(nbt);
        int capacity = nbt.func_74762_e("capacity");
        if (reagent != null) {
            return new ReagentContainer(reagent, capacity);
        }
        return new ReagentContainer(null, capacity);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        if (this.reagentStack != null) {
            this.reagentStack.writeToNBT(nbt);
        }
        nbt.func_74768_a("capacity", this.capacity);
        return nbt;
    }

    @Override
    public ReagentStack getReagent() {
        return this.reagentStack;
    }

    @Override
    public int getReagentStackAmount() {
        if (this.reagentStack == null) {
            return 0;
        }
        return this.reagentStack.amount;
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public int fill(ReagentStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        if (!doFill) {
            if (this.reagentStack == null) {
                return Math.min(this.capacity, resource.amount);
            }
            if (!this.reagentStack.isReagentEqual(resource)) {
                return 0;
            }
            return Math.min(this.capacity - this.reagentStack.amount, resource.amount);
        }
        if (this.reagentStack == null) {
            this.reagentStack = new ReagentStack(resource, Math.min(this.capacity, resource.amount));
            return this.reagentStack.amount;
        }
        if (!this.reagentStack.isReagentEqual(resource)) {
            return 0;
        }
        int filled = this.capacity - this.reagentStack.amount;
        if (resource.amount < filled) {
            this.reagentStack.amount += resource.amount;
            filled = resource.amount;
        } else {
            this.reagentStack.amount = this.capacity;
        }
        return filled;
    }

    @Override
    public ReagentStack drain(int maxDrain, boolean doDrain) {
        if (this.reagentStack == null) {
            return null;
        }
        int drained = maxDrain;
        if (this.reagentStack.amount < drained) {
            drained = this.reagentStack.amount;
        }
        ReagentStack stack = new ReagentStack(this.reagentStack, drained);
        if (doDrain) {
            this.reagentStack.amount -= drained;
            if (this.reagentStack.amount <= 0) {
                this.reagentStack = null;
            }
        }
        return stack;
    }

    @Override
    public ReagentContainerInfo getInfo() {
        return new ReagentContainerInfo(this);
    }
}

