/*
 * Decompiled with CFR 0.152.
 */
package chococraft.common.network.clientSide;

import chococraft.common.entities.EntityAnimalChocobo;
import chococraft.common.network.PacketHelper;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;

public class ChocoboTamed
implements IMessage {
    public int entityID;
    public boolean isTamed;
    public String ownerName;
    public int dimensionId;

    public ChocoboTamed() {
    }

    public ChocoboTamed(EntityAnimalChocobo chocobo) {
        this.entityID = chocobo.func_145782_y();
        this.isTamed = chocobo.func_70909_n();
        this.ownerName = chocobo.getOwner().getDisplayName();
        this.dimensionId = chocobo.field_70170_p.field_73011_w.field_76574_g;
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.entityID);
        buffer.writeBoolean(this.isTamed);
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.ownerName);
        buffer.writeInt(this.dimensionId);
    }

    public void fromBytes(ByteBuf buffer) {
        this.entityID = buffer.readInt();
        this.isTamed = buffer.readBoolean();
        this.ownerName = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this.dimensionId = buffer.readInt();
    }

    public static class Handler
    implements IMessageHandler<ChocoboTamed, IMessage> {
        public IMessage onMessage(ChocoboTamed message, MessageContext ctx) {
            EntityAnimalChocobo chicobo = PacketHelper.getChocoboByID(message.entityID, message.dimensionId);
            if (chicobo != null) {
                chicobo.func_70903_f(message.isTamed);
                chicobo.func_152115_b(message.ownerName);
            }
            return null;
        }
    }
}

