/*
 * Decompiled with CFR 0.152.
 */
package chococraft.common.gui;

import chococraft.common.ModChocoCraft;
import chococraft.common.entities.EntityAnimalChocobo;
import chococraft.common.entities.EntityChocoboRideable;
import chococraft.common.gui.ChocopediaPages;
import chococraft.common.gui.GuiChocopediaButtonNextPage;
import chococraft.common.gui.GuiNameChocobo;
import chococraft.common.gui.GuiSelectNewOwner;
import chococraft.common.helper.ChocoboEntityHelper;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiChocopedia
extends GuiScreen {
    private static int BUTTON_ID_RENAME = 0;
    private static int BUTTON_ID_CONFIRM = 1;
    private static int BUTTON_ID_HIDENAME = 2;
    private static int BUTTON_ID_FOLLOWING = 3;
    private static int BUTTON_ID_REMOVESADDLE = 4;
    private static int BUTTON_ID_CHANGEOWNER = 5;
    private static int BUTTON_ID_BOOK_DONE = 6;
    private static int BUTTON_ID_BOOK_PREV = 7;
    private static int BUTTON_ID_BOOK_NEXT = 8;
    private EntityAnimalChocobo chocobo;
    private EntityPlayer player;
    private GuiScreen parentGuiScreen;
    private GuiButton hideNameButton;
    private GuiButton followingButton;
    private GuiButton removeSaddleButton;
    private GuiButton renameButton;
    private GuiButton confirmButton;
    private GuiButton changeOwnerButton;
    private String bookTitle = "The Chocopedia";
    private String bookAuthor = "by Clienthax";
    private int bookImageWidth = 192;
    private int bookImageHeight = 192;
    private GuiChocopediaButtonNextPage buttonNextPage;
    private GuiChocopediaButtonNextPage buttonPreviousPage;
    private GuiButton buttonDone;
    private int currPage = 0;
    private ResourceLocation resourceLocation = new ResourceLocation("textures/gui/book.png");

    public GuiChocopedia(GuiScreen guiscreen, EntityAnimalChocobo entitychocobo, EntityPlayer thePlayer) {
        this.chocobo = entitychocobo;
        this.player = thePlayer;
        this.parentGuiScreen = guiscreen;
    }

    public void func_73876_c() {
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73866_w_() {
        if (null != this.chocobo) {
            EntityChocoboRideable chocoboRideable;
            Keyboard.enableRepeatEvents((boolean)true);
            this.field_146292_n.clear();
            int yPos = 24;
            int xPos = this.field_146294_l / 2 - 100;
            this.renameButton = this.createGuiButton(BUTTON_ID_RENAME, xPos, yPos += 24, "Rename");
            this.checkButtonOwner(this.player, this.chocobo.getOwner(), this.renameButton);
            this.field_146292_n.add(this.renameButton);
            String lblNameShown = this.chocobo.isHidename() ? "Name Hidden" : "Name Shown";
            this.hideNameButton = this.createGuiButton(BUTTON_ID_HIDENAME, xPos, yPos += 24, lblNameShown);
            this.checkButtonOwner(this.player, this.chocobo.getOwner(), this.hideNameButton);
            this.field_146292_n.add(this.hideNameButton);
            String lblFollowing = this.getFollowStatus();
            this.followingButton = this.createGuiButton(BUTTON_ID_FOLLOWING, xPos, yPos += 24, lblFollowing);
            this.checkButtonOwner(this.player, this.chocobo.getOwner(), this.followingButton);
            this.field_146292_n.add(this.followingButton);
            this.confirmButton = this.createGuiButton(BUTTON_ID_CONFIRM, xPos, yPos += 24, "Confirm");
            this.checkButtonOwner(this.player, this.chocobo.getOwner(), this.confirmButton);
            this.field_146292_n.add(this.confirmButton);
            if (ModChocoCraft.isRemoteClient) {
                this.changeOwnerButton = this.createGuiButton(BUTTON_ID_CHANGEOWNER, xPos, yPos += 30, "change owner");
                this.checkButtonOwner(this.player, this.chocobo.getOwner(), this.changeOwnerButton);
                this.field_146292_n.add(this.changeOwnerButton);
            }
            if (this.chocobo instanceof EntityChocoboRideable && null == this.chocobo.field_70153_n && ((chocoboRideable = (EntityChocoboRideable)this.chocobo).isSaddled() || chocoboRideable.isPackBagged().booleanValue())) {
                String lblRemoveSaddle = "Drop Gear";
                this.removeSaddleButton = this.createGuiButton(BUTTON_ID_REMOVESADDLE, xPos, yPos += 24, lblRemoveSaddle);
                this.checkButtonOwner(this.player, this.chocobo.getOwner(), this.removeSaddleButton);
                this.field_146292_n.add(this.removeSaddleButton);
            }
        } else {
            this.buttonDone = new GuiButton(BUTTON_ID_BOOK_DONE, this.field_146294_l / 2 - 100, 4 + this.bookImageHeight, 200, 20, StatCollector.func_74838_a((String)"gui.done"));
            this.field_146292_n.add(this.buttonDone);
            int i = (this.field_146294_l - this.bookImageWidth) / 2;
            this.buttonNextPage = new GuiChocopediaButtonNextPage(BUTTON_ID_BOOK_NEXT, i + 120, 156, true);
            this.field_146292_n.add(this.buttonNextPage);
            this.buttonPreviousPage = new GuiChocopediaButtonNextPage(BUTTON_ID_BOOK_PREV, i + 38, 156, false);
            this.field_146292_n.add(this.buttonPreviousPage);
            this.updateButtons();
        }
    }

    private void updateButtons() {
        this.buttonNextPage.field_146124_l = this.currPage < ChocopediaPages.Instance().getNPages() - 1;
        this.buttonPreviousPage.field_146124_l = this.currPage > 0;
        this.buttonDone.field_146124_l = true;
    }

    protected GuiButton createGuiButton(int id, int xPos, int yPos, String label) {
        return new GuiButton(id, xPos, yPos, 90, 20, label);
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    protected void func_146284_a(GuiButton guibutton) {
        if (!guibutton.field_146124_l) {
            return;
        }
        if (guibutton.field_146127_k == BUTTON_ID_CONFIRM) {
            this.field_146297_k.func_147108_a(this.parentGuiScreen);
        } else if (guibutton.field_146127_k == BUTTON_ID_HIDENAME) {
            this.chocobo.setHidename(!this.chocobo.isHidename());
            this.hideNameButton.field_146126_j = this.chocobo.isHidename() ? "Name Hidden" : "Name Shown";
        } else if (guibutton.field_146127_k == BUTTON_ID_FOLLOWING) {
            this.chocobo.toggleFollowWanderStay();
            this.followingButton.field_146126_j = this.getFollowStatus();
        } else if (guibutton.field_146127_k == BUTTON_ID_RENAME) {
            FMLClientHandler.instance().getClient().func_147108_a((GuiScreen)new GuiNameChocobo(this, this.chocobo));
        } else if (guibutton.field_146127_k == BUTTON_ID_REMOVESADDLE) {
            if (this.chocobo instanceof EntityChocoboRideable && null == this.chocobo.field_70153_n) {
                ((EntityChocoboRideable)this.chocobo).sendDropSaddleAndBags();
            }
            this.field_146297_k.func_147108_a(this.parentGuiScreen);
        } else if (guibutton.field_146127_k == BUTTON_ID_CHANGEOWNER) {
            FMLClientHandler.instance().getClient().func_147108_a((GuiScreen)new GuiSelectNewOwner(this, this.chocobo));
        } else if (guibutton.field_146127_k == BUTTON_ID_BOOK_DONE) {
            this.field_146297_k.func_147108_a(this.parentGuiScreen);
        } else if (guibutton.field_146127_k == BUTTON_ID_BOOK_NEXT) {
            if (this.currPage < ChocopediaPages.Instance().getNPages() - 1) {
                ++this.currPage;
                this.updateButtons();
            }
        } else if (guibutton.field_146127_k == BUTTON_ID_BOOK_PREV && this.currPage > 0) {
            --this.currPage;
            this.updateButtons();
        }
    }

    protected void func_73864_a(int i, int j, int k) {
        super.func_73864_a(i, j, k);
    }

    public void func_73863_a(int i, int j, float f) {
        if (null != this.chocobo) {
            this.func_146276_q_();
            String breedStatus = "";
            String gender = this.chocobo.getGender();
            String ownerName = "owner: " + this.chocobo.func_152113_b();
            String hungry = this.chocobo.isHungry() ? " (hungry)" : "";
            String health = "health: " + this.chocobo.func_110143_aJ() + "/" + this.chocobo.func_110138_aP() + hungry;
            breedStatus = this.chocobo.func_70874_b() > 0 || this.chocobo.func_70631_g_() ? "cannot breed" : "can breed";
            this.func_73732_a(this.field_146297_k.field_71466_p, this.chocobo.getName(), this.field_146294_l / 2, this.field_146295_m / 4 - 60 + 20, 0xFFFFFF);
            int posY = 24;
            int posX = this.field_146294_l / 2 + 10;
            int fontColour = 0xA0A0A0;
            this.func_73731_b(this.field_146297_k.field_71466_p, ownerName, posX, posY += 24, fontColour);
            this.func_73731_b(this.field_146297_k.field_71466_p, health, posX, posY += 24, fontColour);
            this.func_73731_b(this.field_146297_k.field_71466_p, gender + " (" + breedStatus + ")", posX, posY += 24, fontColour);
            if (this.chocobo.func_152113_b().equals("Torojima") || this.chocobo.func_152113_b().equals("clienthax")) {
                int debugLineHeight = 13;
                int amountWildChocobos = ChocoboEntityHelper.countWildChocobos(this.chocobo.field_70170_p);
                int amountChocobos = ChocoboEntityHelper.countEntities(EntityAnimalChocobo.class, this.chocobo.field_70170_p);
                int debugFontColour = 0x11A0A0;
                String biomeName = this.chocobo.field_70170_p.func_72807_a((int)((int)this.chocobo.field_70165_t), (int)((int)this.chocobo.field_70161_v)).field_76791_y;
                String biomeDisplayString = "Biome: " + biomeName;
                String chocoAmountString = "Chocos: " + amountChocobos + " wild: " + amountWildChocobos;
                this.func_73731_b(this.field_146297_k.field_71466_p, chocoAmountString, posX, posY += debugLineHeight, debugFontColour);
                this.func_73731_b(this.field_146297_k.field_71466_p, biomeDisplayString, posX, posY += debugLineHeight, debugFontColour);
                this.func_73731_b(this.field_146297_k.field_71466_p, "Spawn: " + ModChocoCraft.spawnDbStatus, posX, posY += debugLineHeight, debugFontColour);
                long spawnTimeDelay = this.chocobo.field_70170_p.func_82737_E() - ModChocoCraft.spawnDbTimeDelay;
                String spawnTimeDelayString = "Spawn Time: " + spawnTimeDelay;
                this.func_73731_b(this.field_146297_k.field_71466_p, spawnTimeDelayString, posX, posY += debugLineHeight, debugFontColour);
                String statusRemoteClient = "Remote Cient: " + Boolean.toString(ModChocoCraft.isRemoteClient);
                this.func_73731_b(this.field_146297_k.field_71466_p, statusRemoteClient, posX, posY += debugLineHeight, debugFontColour);
            }
        } else {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146297_k.func_110434_K().func_110577_a(this.resourceLocation);
            int xCenter = (this.field_146294_l - this.bookImageWidth) / 2;
            this.func_73729_b(xCenter, 2, 0, 0, this.bookImageWidth, this.bookImageHeight);
            if (this.currPage == 0) {
                int posY = 50;
                int titelWidth = this.field_146297_k.field_71466_p.func_78256_a(this.bookTitle);
                this.field_146297_k.field_71466_p.func_78276_b(EnumChatFormatting.GOLD + this.bookTitle, xCenter + 36 + (116 - titelWidth) / 2, posY, 0);
                int authorWidth = this.field_146297_k.field_71466_p.func_78256_a(this.bookAuthor);
                this.field_146297_k.field_71466_p.func_78276_b(EnumChatFormatting.DARK_GRAY + this.bookAuthor, xCenter + 36 + (116 - authorWidth) / 2, posY += 10, 0);
                if (this.player.getDisplayName().equals("Torojima") || this.player.getDisplayName().equals("clienthax")) {
                    String biomeDisplayString = "Biome: " + this.player.field_70170_p.func_72807_a((int)((int)this.player.field_70165_t), (int)((int)this.player.field_70161_v)).field_76791_y;
                    String spawnStatus = "Spawn: " + ModChocoCraft.spawnDbStatus;
                    int amountWildChocobos = ChocoboEntityHelper.countWildChocobos(this.player.field_70170_p);
                    int amountChocobos = ChocoboEntityHelper.countEntities(EntityAnimalChocobo.class, this.player.field_70170_p);
                    String chocoAmountString = "Chocos: " + amountChocobos + " wild: " + amountWildChocobos;
                    String statusRemoteClient = "Remote: " + Boolean.toString(ModChocoCraft.isRemoteClient);
                    this.field_146297_k.field_71466_p.func_78276_b(biomeDisplayString, xCenter + 36, posY += 30, 0);
                    this.field_146297_k.field_71466_p.func_78276_b(spawnStatus, xCenter + 36, posY += 10, 0);
                    this.field_146297_k.field_71466_p.func_78276_b(chocoAmountString, xCenter + 36, posY += 10, 0);
                    this.field_146297_k.field_71466_p.func_78276_b(statusRemoteClient, xCenter + 36, posY += 10, 0);
                }
            } else {
                ChocopediaPages pages = ChocopediaPages.Instance();
                String pageContent = "";
                if (this.currPage > 1) {
                    int indicatorCurrentPage = this.currPage - 1;
                    int indicatorAmountPages = ChocopediaPages.Instance().getNPages() - 2;
                    String pageIndicator = String.format(StatCollector.func_74838_a((String)"book.pageIndicator"), indicatorCurrentPage, indicatorAmountPages);
                    int pageIndicatorWidth = this.field_146297_k.field_71466_p.func_78256_a(pageIndicator);
                    this.field_146297_k.field_71466_p.func_78276_b(pageIndicator, xCenter - pageIndicatorWidth + this.bookImageWidth - 44, 18, 0);
                }
                if (this.currPage >= 0 && this.currPage < pages.getNPages()) {
                    pageContent = pages.getPage(this.currPage);
                }
                this.field_146297_k.field_71466_p.func_78279_b(pageContent, xCenter + 36, 34, 116, 0);
            }
        }
        super.func_73863_a(i, j, f);
    }

    private void checkButtonOwner(EntityPlayer player, EntityPlayer owner, GuiButton button) {
        if (!player.equals((Object)owner)) {
            button.field_146124_l = false;
        }
    }

    private String getFollowStatus() {
        if (this.chocobo.isFollowing().booleanValue() && !this.chocobo.isWander()) {
            return "follow";
        }
        if (!this.chocobo.isFollowing().booleanValue() && this.chocobo.isWander()) {
            return "wander";
        }
        if (!this.chocobo.isFollowing().booleanValue() && !this.chocobo.isWander()) {
            return "stay";
        }
        return "";
    }
}

