/*
 * Decompiled with CFR 0.152.
 */
package chococraft.common.entities;

import chococraft.common.ModChocoCraft;
import chococraft.common.bags.ChocoBagInventory;
import chococraft.common.bags.ChocoPackBagInventory;
import chococraft.common.bags.ChocoSaddleBagInventory;
import chococraft.common.config.ChocoCraftItems;
import chococraft.common.config.Constants;
import chococraft.common.entities.ChocoboRiderList;
import chococraft.common.entities.EntityAnimalChocobo;
import chococraft.common.entities.RiderActionState;
import chococraft.common.network.PacketRegistry;
import chococraft.common.network.serverSide.ChocoboDropGear;
import chococraft.common.network.serverSide.ChocoboMount;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public abstract class EntityChocoboRideable
extends EntityAnimalChocobo {
    protected double prevMotionX;
    protected double prevMotionZ;
    protected boolean shouldSteer;
    protected boolean flying;
    protected boolean isHighJumping;
    public RiderActionState riderActionState;
    protected ChocoBagInventory bagsInventory;
    protected ChocoboRiderList riderList;

    public EntityChocoboRideable(World world) {
        super(world);
        this.field_70158_ak = true;
        this.riderList = new ChocoboRiderList();
        this.riderActionState = new RiderActionState();
    }

    public abstract void setStepHeight(boolean var1);

    public abstract void setLandSpeedFactor(boolean var1);

    public abstract void setJumpHigh(boolean var1);

    public abstract void setRiderAbilities(boolean var1);

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(Constants.DW_ID_ECR_FLAGS, (Object)0);
    }

    @Override
    public boolean func_70650_aV() {
        return this.field_70153_n == null;
    }

    @Override
    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74757_a("Saddle", this.isSaddled());
        nbttagcompound.func_74757_a("SaddleBag", this.isSaddleBagged().booleanValue());
        nbttagcompound.func_74757_a("PackBag", this.isPackBagged().booleanValue());
        if (null != this.bagsInventory) {
            nbttagcompound.func_74782_a("SaddleBagInventory", this.bagsInventory.writeToNBT(new NBTTagList()));
        }
        if (null != this.riderList) {
            nbttagcompound.func_74782_a("riderList", this.riderList.writeToNBT(new NBTTagList()));
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.setSaddled(nbttagcompound.func_74767_n("Saddle"));
        this.setSaddleBagged(nbttagcompound.func_74767_n("SaddleBag"));
        this.setPackBagged(nbttagcompound.func_74767_n("PackBag"));
        this.setWander(this.isFollowing() == false && !this.isSaddled() && this.isPackBagged() == false);
        if (nbttagcompound.func_74764_b("SaddleBagInventory") && null != this.bagsInventory) {
            this.bagsInventory.readFromNBT((NBTTagList)nbttagcompound.func_74781_a("SaddleBagInventory"));
        }
        if (nbttagcompound.func_74764_b("riderList") && null != this.riderList) {
            this.riderList.readFromNBT((NBTTagList)nbttagcompound.func_74781_a("riderList"));
        }
    }

    @Override
    public void writeSpawnData(ByteBuf data) {
        super.writeSpawnData(data);
        data.writeBoolean(this.isSaddled());
        data.writeBoolean(this.isSaddleBagged().booleanValue());
        data.writeBoolean(this.isPackBagged().booleanValue());
    }

    @Override
    public void readSpawnData(ByteBuf data) {
        super.readSpawnData(data);
        this.setSaddled(data.readBoolean());
        this.setSaddleBagged(data.readBoolean());
        this.setPackBagged(data.readBoolean());
    }

    public void setRiderActionState(RiderActionState ras) {
        this.riderActionState.setMoveStrafe(ras.getMoveStrafe());
        this.riderActionState.setMoveForward(ras.getMoveForward());
        this.riderActionState.setJump(ras.isJump());
        this.riderActionState.setSneak(ras.isSneak());
    }

    @Override
    public void func_70636_d() {
        if (this.field_70153_n != null) {
            ModChocoCraft.proxy.updateRiderActionState(this, this.field_70153_n);
            this.setRotationYawAndPitch();
            this.setRiderAbilities(true);
        }
        super.func_70636_d();
    }

    public boolean func_70104_M() {
        return true;
    }

    public void func_70645_a(DamageSource damageSource) {
        if (this.isServer()) {
            if (this.isSaddled()) {
                this.func_145779_a(ChocoCraftItems.chocoboSaddleItem, 1);
            }
            if (this.isSaddleBagged().booleanValue()) {
                this.func_145779_a(ChocoCraftItems.chocoboSaddleBagsItem, 1);
                this.bagsInventory.dropAllItems();
            }
            if (this.isPackBagged().booleanValue()) {
                this.func_145779_a(ChocoCraftItems.chocoboPackBagsItem, 1);
                this.bagsInventory.dropAllItems();
            }
        }
        super.func_70645_a(damageSource);
    }

    @Override
    public boolean func_70085_c(EntityPlayer entityplayer) {
        boolean interacted = super.func_70085_c(entityplayer);
        if (!interacted) {
            if (entityplayer.func_70093_af() && (this.isSaddleBagged().booleanValue() || this.isPackBagged().booleanValue())) {
                return this.onOpenSaddlePackBagInteraction(entityplayer);
            }
            ItemStack itemstack = entityplayer.field_71071_by.func_70448_g();
            if (itemstack != null) {
                if (itemstack.func_77973_b().equals(ChocoCraftItems.chocoboSaddleItem)) {
                    this.onSaddleUse(entityplayer);
                    interacted = true;
                } else if (itemstack.func_77973_b().equals(ChocoCraftItems.chocoboSaddleBagsItem)) {
                    this.onSaddleBagsUse(entityplayer);
                    interacted = true;
                } else if (itemstack.func_77973_b().equals(ChocoCraftItems.chocoboPackBagsItem)) {
                    this.onPackBagsUse(entityplayer);
                    interacted = true;
                } else if (itemstack.func_77973_b().equals(ChocoCraftItems.chocoboWhistleItem)) {
                    this.onWhistleUse();
                    interacted = true;
                }
            }
        }
        return interacted;
    }

    public void onSaddleUse(EntityPlayer entityplayer) {
        if (this.func_70909_n() && !this.isSaddled() && !this.isPackBagged().booleanValue()) {
            this.setSaddled(true);
            this.setWander(false);
            this.setFollowing(false);
            this.useItem(entityplayer);
        }
    }

    public void onPackBagsUse(EntityPlayer entityplayer) {
        if (this.func_70909_n() && !this.isSaddled() && !this.isPackBagged().booleanValue()) {
            this.setPackBagged(true);
            this.setWander(false);
            this.setFollowing(true);
            this.useItem(entityplayer);
        }
    }

    public void onSaddleBagsUse(EntityPlayer entityplayer) {
        if (this.func_70909_n() && this.isSaddled() && !this.isSaddleBagged().booleanValue()) {
            this.setSaddleBagged(true);
            this.useItem(entityplayer);
        }
    }

    public void onWhistleUse() {
    }

    protected boolean onOpenSaddlePackBagInteraction(EntityPlayer entityplayer) {
        boolean interacted = false;
        if (entityplayer.func_70093_af() && this.isSaddleBagged().booleanValue()) {
            entityplayer.openGui((Object)ModChocoCraft.instance, 0, this.field_70170_p, this.func_145782_y(), 0, 0);
            interacted = true;
        } else if (entityplayer.func_70093_af() && this.isPackBagged().booleanValue()) {
            entityplayer.openGui((Object)ModChocoCraft.instance, 0, this.field_70170_p, this.func_145782_y(), 1, 0);
            interacted = true;
        }
        return interacted;
    }

    @Override
    protected boolean onEmptyHandInteraction(EntityPlayer entityplayer) {
        boolean interacted = super.onEmptyHandInteraction(entityplayer);
        if (this.isSaddled() && (this.field_70153_n == null || this.field_70153_n == entityplayer)) {
            if (this.isClient()) {
                this.sendMountUpdate();
                if (this.field_70153_n == null) {
                    this.mountChocobo(entityplayer);
                }
            }
            interacted = true;
        }
        return interacted;
    }

    protected void setRotationYawAndPitch() {
        if (this.field_70153_n != null && this.field_70153_n instanceof EntityPlayer && this.isServer()) {
            this.field_70125_A = 0.0f;
            EntityPlayer rider = (EntityPlayer)this.field_70153_n;
            this.field_70177_z = rider.field_70177_z;
            this.field_70126_B = rider.field_70177_z;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
        }
    }

    public void func_70091_d(double moveX, double moveY, double moveZ) {
        if (this.field_70153_n instanceof EntityPlayer) {
            if (this.riderActionState.isJump()) {
                if (this.canFly) {
                    this.field_70181_x = 0.5;
                    this.setFlying(true);
                } else if (this.canJumpHigh && !this.isHighJumping) {
                    this.field_70181_x += 0.4;
                    this.isHighJumping = true;
                }
            } else {
                this.field_70181_x = -0.1;
            }
            if (this.field_70153_n.func_70093_af()) {
                if (this.canFly) {
                    this.field_70181_x = -0.5;
                }
                if (this.field_70171_ac && this.func_70648_aU()) {
                    this.field_70181_x -= 0.15;
                }
            }
        }
        super.func_70091_d(moveX, moveY, moveZ);
    }

    public void setFlying(Boolean flying) {
        this.flying = flying;
    }

    public Boolean isFlying() {
        return this.flying;
    }

    public void func_70043_V() {
        if (this.field_70153_n != null) {
            double deltaPosX = MathHelper.func_76134_b((float)((this.field_70177_z - 90.0f) * (float)Math.PI / 180.0f)) * 0.4f;
            double deltaPosZ = MathHelper.func_76126_a((float)((this.field_70177_z - 90.0f) * (float)Math.PI / 180.0f)) * 0.4f;
            this.field_70153_n.func_70107_b(this.field_70165_t + deltaPosX, this.field_70163_u + this.func_70042_X() + this.field_70153_n.func_70033_W(), this.field_70161_v + deltaPosZ);
        }
    }

    public double func_70042_X() {
        return 1.65;
    }

    public boolean isSaddled() {
        return (this.field_70180_af.func_75683_a(Constants.DW_ID_ECR_FLAGS) & Constants.DW_VAL_ECR_SADDLED_ON) != 0;
    }

    public void setSaddled(boolean saddled) {
        byte ecrFlags = this.field_70180_af.func_75683_a(Constants.DW_ID_ECR_FLAGS);
        if (saddled) {
            this.field_70180_af.func_75692_b(Constants.DW_ID_ECR_FLAGS, (Object)((byte)(ecrFlags | Constants.DW_VAL_ECR_SADDLED_ON)));
        } else {
            this.field_70180_af.func_75692_b(Constants.DW_ID_ECR_FLAGS, (Object)((byte)(ecrFlags & Constants.DW_VAL_ECR_SADDLED_OFF)));
        }
    }

    @Override
    public void toggleFollowWanderStay() {
        if (!ModChocoCraft.saddledCanWander && (this.isSaddled() || this.isPackBagged().booleanValue())) {
            this.toggleFollowStay();
        } else {
            super.toggleFollowWanderStay();
        }
    }

    public IInventory getIInventory() {
        return this.bagsInventory;
    }

    public ChocoBagInventory getChocoBagInventory() {
        return this.bagsInventory;
    }

    public void injectInventory(ChocoBagInventory inventory) {
        if (inventory != null) {
            this.bagsInventory = inventory;
        }
    }

    public Boolean isSaddleBagged() {
        return (this.field_70180_af.func_75683_a(Constants.DW_ID_ECR_FLAGS) & Constants.DW_VAL_ECR_SADDLEBAGGED_ON) != 0;
    }

    public void setSaddleBagged(boolean saddleBags) {
        if (saddleBags != this.isSaddleBagged() || this.bagsInventory == null) {
            byte ecrFlags = this.field_70180_af.func_75683_a(Constants.DW_ID_ECR_FLAGS);
            if (saddleBags) {
                this.bagsInventory = new ChocoSaddleBagInventory(this);
                this.field_70180_af.func_75692_b(Constants.DW_ID_ECR_FLAGS, (Object)((byte)(ecrFlags | Constants.DW_VAL_ECR_SADDLEBAGGED_ON)));
            } else {
                this.bagsInventory = null;
                this.field_70180_af.func_75692_b(Constants.DW_ID_ECR_FLAGS, (Object)((byte)(ecrFlags & Constants.DW_VAL_ECR_SADDLEBAGGED_OFF)));
            }
        }
    }

    public Boolean isPackBagged() {
        return (this.field_70180_af.func_75683_a(Constants.DW_ID_ECR_FLAGS) & Constants.DW_VAL_ECR_PACKBAGGED_ON) != 0;
    }

    public void setPackBagged(boolean packBagged) {
        if (packBagged != this.isPackBagged() || this.bagsInventory == null) {
            byte ecrFlags = this.field_70180_af.func_75683_a(Constants.DW_ID_ECR_FLAGS);
            if (packBagged) {
                this.bagsInventory = new ChocoPackBagInventory(this);
                this.field_70180_af.func_75692_b(Constants.DW_ID_ECR_FLAGS, (Object)((byte)(ecrFlags | Constants.DW_VAL_ECR_PACKBAGGED_ON)));
            } else {
                this.bagsInventory = null;
                this.field_70180_af.func_75692_b(Constants.DW_ID_ECR_FLAGS, (Object)((byte)(ecrFlags & Constants.DW_VAL_ECR_PACKBAGGED_OFF)));
            }
        }
    }

    @Override
    protected boolean func_70692_ba() {
        return super.func_70692_ba() && !this.isSaddled();
    }

    public void mountChocobo(EntityPlayer player) {
        player.func_70031_b(false);
        this.setStepHeight(true);
        this.setJumpHigh(true);
        this.setLandSpeedFactor(true);
        player.func_70078_a((Entity)this);
    }

    public void dismountChocobo(EntityPlayer player) {
        this.field_70703_bu = false;
        this.setStepHeight(false);
        this.setJumpHigh(false);
        this.setLandSpeedFactor(false);
        player.func_70078_a(null);
    }

    public void sendMountUpdate() {
        if (this.isClient()) {
            ChocoboMount packet = new ChocoboMount(this);
            PacketRegistry.INSTANCE.sendToServer((IMessage)packet);
        }
    }

    public void sendDropSaddleAndBags() {
        if (this.isClient()) {
            ChocoboDropGear packet = new ChocoboDropGear(this);
            PacketRegistry.INSTANCE.sendToServer((IMessage)packet);
            this.setSaddleBagged(false);
            this.setSaddled(false);
            this.setPackBagged(false);
        }
    }

    public boolean shouldRiderFaceForward(EntityPlayer player) {
        return true;
    }
}

