/*
 * Decompiled with CFR 0.152.
 */
package chococraft.common.entities;

import chococraft.common.ModChocoCraft;
import chococraft.common.config.ChocoCraftItems;
import chococraft.common.config.Constants;
import chococraft.common.entities.EntityAnimalChocobo;
import chococraft.common.entities.EntityChicobo;
import chococraft.common.entities.EntityChocoboRideable;
import chococraft.common.entities.ai.ChocoboAIMate;
import chococraft.common.entities.colours.EntityChocoboPurple;
import chococraft.common.helper.ChocoboMathHelper;
import chococraft.common.helper.ChocoboParticleHelper;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public abstract class EntityChocobo
extends EntityChocoboRideable {
    public float wingRotation = 0.0f;
    public float destPos = 0.0f;
    public float wingRotDelta = 1.0f;
    public int timeUntilNextFeather;
    public boolean fedGold;

    public EntityChocobo(World world) {
        super(world);
        this.func_70105_a(ModChocoCraft.chocoboWidth, ModChocoCraft.chocoboHeight);
        this.timeUntilNextFeather = this.field_70146_Z.nextInt(ModChocoCraft.featherDelayRandom) + ModChocoCraft.featherDelayStatic;
        this.field_70714_bg.func_75776_a(this.taskNumber++, (EntityAIBase)new ChocoboAIMate(this, 1.0));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(Constants.DW_ID_CHOC_FLAGS, (Object)0);
    }

    protected abstract float getChocoboMaxHealth();

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)this.getChocoboMaxHealth());
    }

    @Override
    public void writeSpawnData(ByteBuf data) {
        super.writeSpawnData(data);
    }

    @Override
    public void readSpawnData(ByteBuf data) {
        super.readSpawnData(data);
    }

    @Override
    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
    }

    @Override
    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
    }

    @Override
    protected void func_70069_a(float fallHeight) {
        super.func_70069_a(fallHeight);
    }

    public abstract String getEntityColourTexture();

    @Override
    public String getEntityTexture() {
        String s = Constants.CHOCOBO_ENTITY_TEXTURES;
        s = this.isPackBagged() != false ? s + Constants.CHOCOBO_ETXT_PACKBAGGED : (this.isSaddleBagged() != false ? s + Constants.CHOCOBO_ETXT_SADDLEBAGGED : (this.isSaddled() ? s + Constants.CHOCOBO_ETXT_SADDLED : (this.func_70909_n() ? s + Constants.CHOCOBO_ETXT_TAMED : s + Constants.CHOCOBO_ETXT_UNTAMED)));
        s = this.isMale() ? s + Constants.CHOCOBO_ETXT_MALE : s + Constants.CHOCOBO_ETXT_FEMALE;
        s = s + this.getEntityColourTexture();
        return s;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70153_n == null && this.isFlying().booleanValue() && !this.field_70122_E) {
            this.field_70181_x -= 0.25;
        }
        if (this.isFlying().booleanValue() && this.field_70122_E) {
            this.setFlying(false);
        }
        if (this.isHighJumping && this.field_70122_E) {
            this.isHighJumping = false;
        }
        if (this.func_70090_H() && this.canCrossWater) {
            this.field_70181_x += 0.04;
            this.field_70171_ac = false;
        }
    }

    public float func_70689_ay() {
        if (this.field_70153_n != null && this.field_70122_E) {
            return (float)this.landSpeedFactor / 100.0f;
        }
        return super.func_70689_ay();
    }

    public void func_70612_e(float strafe, float forward) {
        if (this.field_70153_n != null) {
            strafe = ((EntityLivingBase)this.field_70153_n).field_70702_br * 0.5f;
            forward = ((EntityLivingBase)this.field_70153_n).field_70701_bs;
            if (!this.field_70170_p.field_72995_K) {
                if (this.field_70160_al) {
                    this.field_70747_aH = (float)this.airbornSpeedFactor / 100.0f;
                } else if (this.func_70090_H()) {
                    this.field_70747_aH = (float)this.waterSpeedFactor / 100.0f;
                }
                this.func_70659_e(forward);
                super.func_70612_e(strafe, forward);
            }
        } else {
            super.func_70612_e(strafe, forward);
        }
        this.field_70722_aY = this.field_70721_aZ;
        double d0 = this.field_70165_t - this.field_70169_q;
        double d1 = this.field_70161_v - this.field_70166_s;
        float f4 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1)) * 4.0f;
        if (f4 > 1.0f) {
            f4 = 1.0f;
        }
        this.field_70721_aZ += (f4 - this.field_70721_aZ) * 0.4f;
        this.field_70754_ba += this.field_70721_aZ;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70880_s() && this.field_70789_a != null) {
            EntityAnimalChocobo otherChoco;
            if (this.isClient()) {
                ChocoboParticleHelper.showParticleAroundEntityFx(Constants.PARTICLE_HEART, (Entity)this);
            }
            if (this.field_70789_a instanceof EntityAnimalChocobo && !(otherChoco = (EntityAnimalChocobo)this.field_70789_a).func_70880_s()) {
                this.field_70789_a = null;
                this.hasMate = false;
            }
        }
        if (this.isClient()) {
            this.destPos = (float)((double)this.destPos + (double)(this.field_70122_E ? -1 : 4) * 0.3);
            this.destPos = ChocoboMathHelper.clamp(this.destPos, 0.0f, 1.0f);
            if (!this.field_70122_E) {
                this.wingRotDelta = ChocoboMathHelper.minLimit(this.wingRotDelta, 1.0f);
            }
            this.wingRotDelta = (float)((double)this.wingRotDelta * 0.9);
            if (!this.field_70122_E && this.field_70181_x < 0.0) {
                this.field_70181_x *= 0.8;
            }
            this.wingRotation += this.wingRotDelta * 2.0f;
        }
        if (this.isServer() && --this.timeUntilNextFeather <= 0) {
            int d100 = this.field_70146_Z.nextInt(100);
            if (d100 < ModChocoCraft.featherDropChance) {
                this.dropFeather();
            }
            this.timeUntilNextFeather = this.field_70146_Z.nextInt(ModChocoCraft.featherDelayRandom) + ModChocoCraft.featherDelayStatic;
        }
    }

    protected String func_70639_aQ() {
        if (ModChocoCraft.livingSoundProb != 0 && this.field_70146_Z.nextInt(4) == 0 && this.field_70146_Z.nextInt(100) < ModChocoCraft.livingSoundProb) {
            return "chococraft:choco_kweh";
        }
        return null;
    }

    protected String func_70621_aR() {
        return "chococraft:choco_kweh";
    }

    protected String func_70673_aS() {
        return "chococraft:choco_kweh";
    }

    @Override
    public boolean func_70085_c(EntityPlayer entityplayer) {
        boolean interacted = super.func_70085_c(entityplayer);
        if (!interacted) {
            ItemStack itemstack = entityplayer.field_71071_by.func_70448_g();
            if (itemstack == null || itemstack.field_77994_a == 0) {
                interacted = this.onOpenSaddlePackBagInteraction(entityplayer);
            } else if (itemstack.func_77973_b().equals(ChocoCraftItems.gysahlPinkItem)) {
                this.onPaint(entityplayer, true);
                interacted = true;
            } else if (itemstack.func_77973_b().equals(ChocoCraftItems.gysahlRedItem)) {
                this.onPaint(entityplayer, false);
                interacted = true;
            } else if (this.isLoverlyGysahl(itemstack) || this.isGoldenGysahl(itemstack)) {
                this.onBreedGysahlUse(entityplayer, this.isGoldenGysahl(itemstack));
                interacted = true;
            } else if (itemstack.func_77973_b().equals(ChocoCraftItems.chocoboFeatherItem)) {
                this.onFeatherUse(entityplayer);
                interacted = true;
            } else if (itemstack.func_77973_b().equals(Items.field_151007_F)) {
                this.onSilkUse(entityplayer);
                interacted = true;
            }
        }
        if (!interacted) {
            interacted = this.onOpenSaddlePackBagInteraction(entityplayer);
        }
        if (!interacted) {
            this.onEmptyHandInteraction(entityplayer);
        }
        if (!interacted && entityplayer.func_70093_af()) {
            interacted = true;
        }
        return interacted;
    }

    @Override
    protected boolean onEmptyHandInteraction(EntityPlayer entityplayer) {
        return super.onEmptyHandInteraction(entityplayer);
    }

    public void onBreedGysahlUse(EntityPlayer player, boolean fedGold) {
        if (this.func_70909_n() && this.func_70874_b() == 0 && this.isOwner(player)) {
            this.fedGold = fedGold;
            this.useItem(player);
            this.setInLove(true);
            this.field_70789_a = null;
            this.showAmountHeartsOrSmokeFx(true, 7);
        } else {
            this.showAmountHeartsOrSmokeFx(false, 7);
        }
    }

    protected void onPaint(EntityPlayer entityplayer, boolean isPink) {
        this.showAmountHeartsOrSmokeFx(false, 7);
    }

    public void onFeatherUse(EntityPlayer player) {
        if (this.func_70909_n() && this.isOwner(player)) {
            this.toggleFollowWanderStay();
        } else {
            this.showAmountHeartsOrSmokeFx(false, 7);
        }
    }

    public void onSilkUse(EntityPlayer player) {
        if (this.func_70909_n() && this.isOwner(player)) {
            this.toggleFollowStay();
        } else {
            this.showAmountHeartsOrSmokeFx(false, 7);
        }
    }

    public void dropFeather() {
        if (this.isServer()) {
            this.func_70099_a(new ItemStack(ChocoCraftItems.chocoboFeatherItem, 1), 0.0f);
        }
    }

    protected void func_70628_a(boolean par1, int par2) {
        if (this.isServer()) {
            super.func_70628_a(par1, par2);
        }
    }

    protected Item func_146068_u() {
        if (this.func_70027_ad()) {
            return ChocoCraftItems.chocoboLegCookedItem;
        }
        return ChocoCraftItems.chocoboLegRawItem;
    }

    @Override
    public void func_70626_be() {
        if (this instanceof EntityChocoboPurple) {
            this.func_70066_B();
            this.field_70174_ab = 100;
        }
        if (!this.field_70170_p.field_73010_i.isEmpty()) {
            if (this.field_70153_n != null && this.field_70153_n instanceof EntityPlayer) {
                List list;
                if (this instanceof EntityChocoboPurple) {
                    this.field_70153_n.func_70066_B();
                    this.field_70153_n.field_70174_ab = 100;
                }
                this.field_70126_B = this.field_70177_z = this.field_70153_n.field_70177_z;
                this.field_70125_A = 0.0f;
                this.field_70127_C = 0.0f;
                this.func_70637_d(this.riderActionState.isJump());
                double d = Math.abs(Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
                if (d > 0.375) {
                    double d1 = 0.375 / d;
                    this.field_70159_w *= d1;
                    this.field_70179_y *= d1;
                }
                if ((list = this.field_70170_p.func_72839_b(this.field_70153_n, this.field_70121_D.func_72314_b(1.0, 1.0, 1.0))) != null) {
                    for (Object aList : list) {
                        Entity entity = (Entity)aList;
                        if (entity.field_70128_L || !(this.field_70153_n instanceof EntityPlayer)) continue;
                        entity.func_70100_b_((EntityPlayer)this.field_70153_n);
                    }
                }
                return;
            }
            if (!this.field_70787_b && !this.func_70781_l() && this.isFollowing().booleanValue() && this.func_70909_n()) {
                EntityPlayer owner = this.getOwner();
                if (owner != null) {
                    if (owner.field_70128_L) {
                        this.setFollowing(false);
                        this.setWander(false);
                        this.setStepHeight(false);
                        return;
                    }
                    float distanceToOwner = owner.func_70032_d((Entity)this);
                    if (distanceToOwner > 10.0f) {
                        this.getPathOrWalkableBlock((Entity)owner, distanceToOwner);
                    } else {
                        super.func_70626_be();
                    }
                }
            } else if (!this.isSaddled() || this.isFollowing().booleanValue() || this.func_70880_s()) {
                super.func_70626_be();
            }
        }
    }

    @Override
    public void func_70645_a(DamageSource damageSource) {
        int randFeatherAmount = new Random().nextInt(3);
        for (int i = 0; i <= randFeatherAmount; ++i) {
            this.dropFeather();
        }
        super.func_70645_a(damageSource);
    }

    public boolean func_70878_b(EntityAnimal otherEntity) {
        if (otherEntity != this && otherEntity instanceof EntityChocobo) {
            EntityChocobo otherChocobo = (EntityChocobo)otherEntity;
            return this.isMale() != otherChocobo.isMale() && this.func_70880_s() && otherChocobo.func_70880_s();
        }
        return false;
    }

    public abstract EntityAnimalChocobo.chocoboColor getBabyAnimalColor(EntityAgeable var1);

    public EntityAgeable func_90011_a(EntityAgeable otherAnimalParent) {
        EntityAnimalChocobo.chocoboColor chicoboColor = this.getBabyAnimalColor(otherAnimalParent);
        EntityChicobo childChicobo = new EntityChicobo(this.field_70170_p);
        childChicobo.setColor(chicoboColor);
        return childChicobo;
    }
}

